/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.adapters.supersonicads.SupersonicConfig;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.LoadWhileShowSupportState;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.metadata.MetaDataUtils;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InternalOfferwallListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.OfferwallAdapterApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceAdInstanceBuilder;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.data.ISNEnums;
import com.ironsource.sdk.data.ISNError;
import com.ironsource.sdk.listeners.OnBannerListener;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.listeners.OnNetworkSDKInitListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceAdapter
extends AbstractAdapter
implements OfferwallAdapterApi,
OnOfferWallListener,
ContextProvider.ContextLifeCycleListener {
    private static final String VERSION = "7.1.0";
    private static final int IS_LOAD_EXCEPTION = 1000;
    private static final int IS_SHOW_EXCEPTION = 1001;
    private static final int RV_LOAD_EXCEPTION = 1002;
    private static final int RV_SHOW_EXCEPTION = 1003;
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private final String SESSION_ID = "sessionid";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    private final String CUSTOM_SEGMENT = "custom_Segment";
    private final String ADM_KEY = "adm";
    private final String DEMAND_SOURCE_NAME = "demandSourceName";
    private final String OW_PLACEMENT_ID = "placementId";
    private final String OW_CLIENT_SIDE_CALLBACKS = "useClientSideCallbacks";
    private InternalOfferwallListener mOfferwallListener;
    private final String LWS_SUPPORT_STATE = "isSupportedLWS";
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToISAd;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mDemandSourceToRvSmash;
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToRvAd;
    private ConcurrentHashMap<String, InterstitialSmashListener> mDemandSourceToISSmash;
    private ConcurrentHashMap<String, BannerSmashListener> mDemandSourceToBNSmash;
    private static ISNAdView mIsnAdView;
    private boolean mIsAlreadyShowing;
    private static AtomicBoolean mDidInitSdk;
    private static String mediationSegment;

    public static IronSourceAdapter startAdapter(String providerName) {
        return new IronSourceAdapter(providerName);
    }

    private IronSourceAdapter(String providerName) {
        super(providerName);
        IronLog.INTERNAL.verbose(providerName + ": new instance");
        this.mDemandSourceToRvAd = new ConcurrentHashMap();
        this.mDemandSourceToRvSmash = new ConcurrentHashMap();
        this.mDemandSourceToISAd = new ConcurrentHashMap();
        this.mDemandSourceToISSmash = new ConcurrentHashMap();
        this.mDemandSourceToBNSmash = new ConcurrentHashMap();
        mediationSegment = null;
        ContextProvider.getInstance().registerLifeCycleListener(this);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onPause(Activity activity) {
        IronLog.ADAPTER_API.verbose("IronSourceNetwork.onPause");
        IronSourceNetwork.onPause(activity);
    }

    @Override
    public void onResume(Activity activity) {
        IronLog.ADAPTER_API.verbose("IronSourceNetwork.onResume");
        IronSourceNetwork.onResume(activity);
    }

    @Override
    protected void setConsent(boolean consent) {
        IronLog.ADAPTER_API.verbose("(" + (consent ? "true" : "false") + ")");
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("consent", (Object)(consent ? "1" : "0"));
        }
        catch (JSONException e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            return;
        }
        IronSourceNetwork.updateMetadata(consentParams);
    }

    @Override
    public void setMediationSegment(String segment) {
        mediationSegment = segment;
    }

    private HashMap<String, String> getInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        String pluginType = this.getPluginType();
        if (!TextUtils.isEmpty((CharSequence)pluginType)) {
            params.put("SDKPluginType", pluginType);
        }
        if (!TextUtils.isEmpty((CharSequence)mediationSegment)) {
            params.put("custom_Segment", mediationSegment);
        }
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getSessionId())) {
            params.put("sessionid", IronSourceObject.getInstance().getSessionId());
        }
        return params;
    }

    @Override
    public JSONObject getPlayerBiddingData() {
        IronLog.ADAPTER_API.verbose("");
        JSONObject biddingData = new JSONObject();
        JSONObject token = null;
        try {
            token = IronSourceNetwork.getRawToken(ContextProvider.getInstance().getApplicationContext());
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("getRawToken exception: " + e2.getLocalizedMessage());
        }
        if (token != null) {
            biddingData = token;
        } else {
            IronLog.ADAPTER_API.error("Player's bidding token is null");
        }
        return biddingData;
    }

    @Override
    public void earlyInit(String appKey, String userId, JSONObject config) {
        if (appKey != null) {
            IronSourceUtils.sendAutomationLog(this.getDemandSourceName(config) + ": earlyInit");
            this.initSDK(appKey, config);
        } else {
            IronLog.ADAPTER_API.error("Appkey is null for early init");
        }
    }

    private void initSDK(String appKey, JSONObject config) {
        if (mDidInitSdk.compareAndSet(false, true)) {
            String userId = IronSourceUtils.getMediationUserId();
            int logLevel = config.optInt("debugMode", 0);
            if (this.isAdaptersDebugEnabled()) {
                logLevel = 3;
            }
            IronLog.ADAPTER_API.verbose("setting debug mode to " + logLevel);
            SDKUtils.setDebugMode(logLevel);
            SDKUtils.setControllerUrl(config.optString("controllerUrl"));
            IronLog.ADAPTER_API.verbose("IronSourceNetwork setting controller url to  " + config.optString("controllerUrl"));
            SDKUtils.setControllerConfig(config.optString("controllerConfig"));
            IronLog.ADAPTER_API.verbose("IronSourceNetwork setting controller config to  " + config.optString("controllerConfig"));
            HashMap<String, String> initParams = this.getInitParams();
            IronLog.ADAPTER_API.verbose("with appKey=" + appKey + " userId=" + userId + " parameters " + initParams);
            IronSourceNetwork.setInitListener(new OnNetworkSDKInitListener(){

                @Override
                public void onSuccess() {
                    IronLog.ADAPTER_API.verbose("OnNetworkSDKInitListener success");
                }

                @Override
                public void onFail(ISNError error) {
                    IronLog.ADAPTER_API.verbose("OnNetworkSDKInitListener fail - code:" + error.getCode() + " message:" + error.getMessage());
                }
            });
            IronSourceNetwork.initSDK(ContextProvider.getInstance().getCurrentActiveActivity(), appKey, userId, initParams);
        }
    }

    @Override
    public Map<String, Object> getRewardedVideoBiddingData(JSONObject config) {
        IronLog.ADAPTER_API.verbose("getRewardedVideoBiddingData");
        HashMap<String, Object> biddingData = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(ContextProvider.getInstance().getApplicationContext());
        if (token != null) {
            biddingData.put("token", token);
        } else {
            IronLog.ADAPTER_API.error("RV bidding token is null");
            biddingData.put("token", "");
        }
        return biddingData;
    }

    @Override
    public void initRewardedVideoForBidding(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(appKey, config, listener, demandSourceName);
        listener.onRewardedVideoInitSuccess();
    }

    @Override
    public void initRewardedVideoForDemandOnly(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(appKey, config, listener, demandSourceName);
    }

    @Override
    public void initRewardedVideo(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(appKey, config, listener, demandSourceName);
        this.fetchRewardedVideoForAutomaticLoad(config, listener);
    }

    private void initRewardedVideoInternal(String appKey, JSONObject config, RewardedVideoSmashListener listener, String demandSourceName) {
        this.initSDK(appKey, config);
        this.mDemandSourceToRvSmash.put(demandSourceName, listener);
    }

    @Override
    public void fetchRewardedVideoForAutomaticLoad(JSONObject config, RewardedVideoSmashListener listener) {
        block2: {
            String demandSourceName = this.getDemandSourceName(config);
            IronLog.ADAPTER_API.verbose(demandSourceName);
            try {
                this.loadAdInternal(demandSourceName, null, false, false, true);
            }
            catch (Exception e2) {
                IronLog.ADAPTER_API.error("exception " + e2.getMessage());
                listener = this.mDemandSourceToRvSmash.get(demandSourceName);
                if (listener == null) break block2;
                IronLog.ADAPTER_API.error("exception " + e2.getMessage());
                listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
                listener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    @Override
    public void loadRewardedVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), null, true, false, true);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadRewardedVideoForDemandOnlyForBidding(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, true, true, true);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadRewardedVideoForBidding(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, false, true, true);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
            listener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
            this.showAdInternal(adInstance, 1);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoAdShowFailed(new IronSourceError(1003, e2.getMessage()));
        }
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    @Override
    public Map<String, Object> getInterstitialBiddingData(JSONObject config) {
        IronLog.ADAPTER_API.verbose("");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(ContextProvider.getInstance().getApplicationContext());
        if (token != null) {
            ret.put("token", token);
        } else {
            IronLog.ADAPTER_API.error("IS bidding token is null");
            ret.put("token", "");
        }
        return ret;
    }

    @Override
    public void initInterstitialForBidding(String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initInterstitialInternal(appKey, config, listener, demandSourceName);
    }

    @Override
    public void initInterstitial(String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initInterstitialInternal(appKey, config, listener, demandSourceName);
    }

    private void initInterstitialInternal(String appKey, JSONObject config, InterstitialSmashListener listener, String demandSourceName) {
        this.initSDK(appKey, config);
        this.mDemandSourceToISSmash.put(demandSourceName, listener);
        listener.onInterstitialInitSuccess();
    }

    @Override
    public void loadInterstitialForBidding(JSONObject config, InterstitialSmashListener listener, String serverData) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, false, true, false);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("for bidding exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), null, false, false, false);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
            this.showAdInternal(adInstance, 2);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onInterstitialAdShowFailed(new IronSourceError(1001, e2.getMessage()));
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    @Override
    public void setInternalOfferwallListener(InternalOfferwallListener listener) {
        this.mOfferwallListener = listener;
    }

    @Override
    public void showOfferwall(String placementId, JSONObject config) {
        IronLog.ADAPTER_API.verbose(this.getProviderName() + " showOfferWall");
        try {
            HashMap<String, String> extraParams = this.getOfferwallExtraParams();
            extraParams.put("placementId", placementId);
            IronSourceNetwork.showOfferWall(extraParams);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
        }
    }

    private HashMap<String, String> getOfferwallExtraParams() {
        HashMap<String, String> owExtraParams = this.getInitParams();
        boolean clientSideCallbacks = SupersonicConfig.getConfigObj().getClientSideCallbacks();
        owExtraParams.put("useClientSideCallbacks", String.valueOf(clientSideCallbacks));
        Map<String, String> customParams = SupersonicConfig.getConfigObj().getOfferwallCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            owExtraParams.putAll(customParams);
        }
        return owExtraParams;
    }

    @Override
    public boolean isOfferwallAvailable() {
        return true;
    }

    @Override
    public void getOfferwallCredits() {
        IronLog.ADAPTER_API.verbose(this.getProviderName() + " getOfferwallCredits");
        try {
            IronSourceNetwork.getOfferWallCredits(this);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
        }
    }

    @Override
    public void initOfferwall(String appKey, String userId, JSONObject config) {
        this.initSDK(appKey, config);
        IronLog.ADAPTER_API.verbose(":initOfferwall");
        this.postOnUIThread(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap offerwallExtraParams = IronSourceAdapter.this.getOfferwallExtraParams();
                    IronSourceNetwork.initOfferWall(offerwallExtraParams, IronSourceAdapter.this);
                }
                catch (Exception e2) {
                    IronLog.ADAPTER_API.error(IronSourceAdapter.this.getProviderName() + ":initOfferwall " + e2);
                    IronSourceAdapter.this.mOfferwallListener.onOfferwallAvailable(false, ErrorBuilder.buildInitFailedError("Adapter initialization failure - " + IronSourceAdapter.this.getProviderName() + " - " + e2.getMessage(), "Offerwall"));
                }
            }
        });
    }

    @Override
    public void initBanners(String appKey, String userId, JSONObject config, BannerSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.ADAPTER_API.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initSDK(appKey, config);
        this.mDemandSourceToBNSmash.put(demandSourceName, listener);
        try {
            IronSourceNetwork.initBanner(demandSourceName, this.getInitParams(), new IronSourceBannerListener(listener, demandSourceName));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            listener.onBannerInitFailed(ErrorBuilder.buildInitFailedError(e2.getMessage(), "Banner"));
        }
    }

    @Override
    public void loadBanner(IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.ADAPTER_API.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        if (!this.mIsAlreadyShowing) {
            this.destroyBannerInternal();
        }
        if (!this.mIsAlreadyShowing) {
            mIsnAdView = this.createBanner(banner.getActivity(), banner.getSize(), listener);
        }
        this.loadBannerInternal(mIsnAdView, listener);
    }

    @Override
    public void reloadBanner(IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.ADAPTER_API.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.loadBannerInternal(mIsnAdView, listener);
    }

    @Override
    public void destroyBanner(JSONObject config) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.ADAPTER_API.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.mIsAlreadyShowing = false;
        this.destroyBannerInternal();
    }

    private void destroyBannerInternal() {
        if (mIsnAdView != null) {
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " bannerView.performCleanup");
            mIsnAdView.performCleanup();
            mIsnAdView = null;
        }
    }

    @Override
    public boolean shouldBindBannerViewOnReload() {
        return true;
    }

    private void loadBannerInternal(ISNAdView bannerView, BannerSmashListener listener) {
        try {
            JSONObject loadParams = new JSONObject();
            loadParams.put("demandSourceName", (Object)this.getProviderName());
            loadParams.put("productType", (Object)ISNEnums.ProductType.Banner);
            try {
                if (bannerView != null) {
                    IronLog.ADAPTER_API.verbose("bannerView.loadAd");
                    bannerView.loadAd(loadParams);
                }
            }
            catch (Exception e2) {
                String errorString = "Banner Load Fail, " + this.getProviderName() + " - " + e2.getMessage();
                IronSourceError error = ErrorBuilder.buildLoadFailedError(errorString);
                listener.onBannerAdLoadFailed(error);
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    private void loadAdInternal(String demandSourceName, String serverData, boolean isDemandOnlyForRv, boolean isBidder, boolean isRewarded) throws Exception {
        HashMap<String, String> loadConfig = new HashMap<String, String>();
        if (serverData != null) {
            loadConfig.put("adm", AuctionDataUtils.getInstance().getAdmFromServerData(serverData));
            Map<String, String> auctionResponseServerDataParams = AuctionDataUtils.getInstance().getAuctionResponseServerDataParams(serverData);
            loadConfig.putAll(auctionResponseServerDataParams);
        }
        IronSourceAdInstance adInstance = this.getAdInstance(demandSourceName, isDemandOnlyForRv, isBidder, isRewarded);
        this.printInstanceExtraParams(loadConfig);
        IronLog.ADAPTER_API.verbose("demandSourceName=" + adInstance.getName());
        IronSourceNetwork.loadAd(adInstance, loadConfig);
    }

    private void showAdInternal(IronSourceAdInstance adInstance, int adUnit) throws Exception {
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(adUnit);
        HashMap<String, String> showParams = new HashMap<String, String>();
        showParams.put("sessionDepth", String.valueOf(sessionDepth));
        IronLog.ADAPTER_API.verbose("demandSourceName=" + adInstance.getName() + " showParams=" + showParams);
        IronSourceNetwork.showAd(adInstance, showParams);
    }

    private IronSourceAdInstance getAdInstance(String demandSourceName, boolean isDemandOnlyForRv, boolean isBidder, boolean isRewarded) {
        IronSourceAdInstance adInstance;
        IronSourceAdInstance ironSourceAdInstance = adInstance = isRewarded ? this.mDemandSourceToRvAd.get(demandSourceName) : this.mDemandSourceToISAd.get(demandSourceName);
        if (adInstance == null) {
            IronSourceAdInstanceBuilder builder;
            IronLog.ADAPTER_API.verbose("creating ad instance for " + demandSourceName + " isDemandOnlyForRv=" + isDemandOnlyForRv + " isBidder=" + isBidder + " isRewarded=" + isRewarded);
            if (isRewarded) {
                builder = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceRewardedVideoListener(this.mDemandSourceToRvSmash.get(demandSourceName), demandSourceName, isDemandOnlyForRv)).setExtraParams(this.getInitParams());
                builder.setRewarded();
            } else {
                builder = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceInterstitialListener(this.mDemandSourceToISSmash.get(demandSourceName), demandSourceName)).setExtraParams(this.getInitParams());
            }
            if (isBidder) {
                builder.setInAppBidding();
            }
            adInstance = builder.build();
            if (isRewarded) {
                this.mDemandSourceToRvAd.put(demandSourceName, adInstance);
            } else {
                this.mDemandSourceToISAd.put(demandSourceName, adInstance);
            }
        }
        return adInstance;
    }

    private ISNAdView createBanner(Activity activity, ISBannerSize bannerSize, BannerSmashListener listener) {
        ISNAdView adView = null;
        String BANNER = "BANNER";
        String LARGE = "LARGE";
        String RECTANGLE = "RECTANGLE";
        String SMART = "SMART";
        String CUSTOM = "CUSTOM";
        int STANDARD_SCREEN_BANNER_WIDTH = 320;
        int STANDARD_BANNER_SIZE_HEIGHT = 50;
        int LARGE_SCREEN_BANNER_WIDTH = 728;
        int LARGE_BANNER_SIZE_HEIGHT = 90;
        String sizeLabel = bannerSize.getDescription();
        int widthDp = 320;
        int heightDp = 50;
        switch (sizeLabel) {
            case "BANNER": {
                widthDp = 320;
                heightDp = 50;
                break;
            }
            case "LARGE": {
                widthDp = 320;
                heightDp = 90;
                break;
            }
            case "SMART": {
                boolean isLargeScreen = AdapterUtils.isLargeScreen(activity);
                widthDp = isLargeScreen ? 728 : 320;
                heightDp = isLargeScreen ? 90 : 50;
                break;
            }
            case "CUSTOM": {
                widthDp = 320;
                heightDp = bannerSize.getHeight();
                if (heightDp == 50 || heightDp == 90) break;
                if (listener != null) {
                    listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize(this.getProviderName()));
                }
                return null;
            }
            default: {
                if (listener != null) {
                    listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize(this.getProviderName()));
                }
                return null;
            }
        }
        int widthPixels = AdapterUtils.dpToPixels(activity, widthDp);
        int heightPixels = AdapterUtils.dpToPixels(activity, heightDp);
        ISAdSize bannerAdSize = new ISAdSize(widthPixels, heightPixels, sizeLabel);
        try {
            adView = IronSourceNetwork.createBanner(activity, bannerAdSize);
        }
        catch (Exception e2) {
            String errorString = "Banner Load Fail, " + this.getProviderName() + " - " + e2.getMessage();
            IronSourceError error = ErrorBuilder.buildLoadFailedError(errorString);
            listener.onBannerAdLoadFailed(error);
        }
        return adView;
    }

    @Override
    public void onOWShowSuccess(String placementId) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName() + ":onOWShowSuccess(placementId:" + placementId + ")");
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallOpened();
        }
    }

    @Override
    public void onOWShowFail(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            IronSourceError ise = ErrorBuilder.buildGenericError(description);
            this.mOfferwallListener.onOfferwallShowFailed(ise);
        }
    }

    @Override
    public boolean onOWAdCredited(int credits, int totalCredits, boolean totalCreditsFlag) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        return this.mOfferwallListener != null && this.mOfferwallListener.onOfferwallAdCredited(credits, totalCredits, totalCreditsFlag);
    }

    @Override
    public void onGetOWCreditsFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            IronSourceError ise = ErrorBuilder.buildGenericError(description);
            this.mOfferwallListener.onGetOfferwallCreditsFailed(ise);
        }
    }

    @Override
    public void onOWAdClosed() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallClosed();
        }
    }

    @Override
    public void onOfferwallInitSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallAvailable(true);
        }
    }

    @Override
    public void onOfferwallInitFail(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            IronSourceError ise = ErrorBuilder.buildGenericError(description);
            this.mOfferwallListener.onOfferwallAvailable(false, ise);
        }
    }

    @Override
    public void onOfferwallEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        }
    }

    private String getDemandSourceName(JSONObject config) {
        if (!TextUtils.isEmpty((CharSequence)config.optString("demandSourceName"))) {
            return config.optString("demandSourceName");
        }
        return this.getProviderName();
    }

    private boolean isValidMetaData(String key, String value) {
        if (key.equals("do_not_sell")) {
            return MetaDataUtils.isValidCCPAMetaData(key, value);
        }
        return true;
    }

    @Override
    protected void setMetaData(String key, String value) {
        if (!mDidInitSdk.get()) {
            IronLog.ADAPTER_API.verbose("key=" + key + ", value=" + value);
            if (!this.isValidMetaData(key, value)) {
                IronLog.ADAPTER_API.verbose("MetaData not valid");
                return;
            }
            JSONObject metaDataJson = new JSONObject();
            try {
                metaDataJson.put(key, (Object)value);
                IronSourceNetwork.updateMetadata(metaDataJson);
            }
            catch (JSONException e2) {
                IronLog.ADAPTER_API.error("error - " + (Object)((Object)e2));
                e2.printStackTrace();
            }
        }
    }

    private void printInstanceExtraParams(Map<String, String> params) {
        if (params != null && params.size() > 0) {
            IronLog.ADAPTER_API.verbose("instance extra params:");
            for (String key : params.keySet()) {
                IronLog.ADAPTER_API.verbose(key + "=" + params.get(key));
            }
        }
    }

    @Override
    public LoadWhileShowSupportState getLoadWhileShowSupportState(JSONObject mAdUnitSettings) {
        boolean isSupportedLWS;
        LoadWhileShowSupportState loadWhileShowSupportState = this.mLWSSupportState;
        if (mAdUnitSettings != null && (isSupportedLWS = mAdUnitSettings.optBoolean("isSupportedLWS"))) {
            loadWhileShowSupportState = LoadWhileShowSupportState.LOAD_WHILE_SHOW_BY_INSTANCE;
        }
        return loadWhileShowSupportState;
    }

    static {
        mDidInitSdk = new AtomicBoolean(false);
    }

    private class IronSourceBannerListener
    implements OnBannerListener {
        private String mDemandSourceName;
        private BannerSmashListener mListener;

        IronSourceBannerListener(BannerSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
        }

        @Override
        public void onBannerInitSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " bannerListener");
            this.mListener.onBannerInitSuccess();
        }

        @Override
        public void onBannerInitFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " bannerListener");
            this.mListener.onBannerInitFailed(new IronSourceError(612, description));
        }

        @Override
        public void onBannerClick() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " bannerListener");
            this.mListener.onBannerAdClicked();
        }

        @Override
        public void onBannerLoadSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " bannerListener");
            IronSourceAdapter.this.mIsAlreadyShowing = true;
            if (mIsnAdView != null && mIsnAdView.getAdViewSize() != null) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(mIsnAdView.getAdViewSize().getWidth(), mIsnAdView.getAdViewSize().getHeight());
                layoutParams.gravity = 17;
                this.mListener.onBannerAdLoaded((View)mIsnAdView, layoutParams);
            }
        }

        @Override
        public void onBannerLoadFail(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " bannerListener");
            this.mListener.onBannerAdLoadFailed(ErrorBuilder.buildLoadFailedError(IronSourceAdapter.this.getProviderName() + " load failed - error = " + description));
        }
    }

    private class IronSourceInterstitialListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        private InterstitialSmashListener mListener;

        IronSourceInterstitialListener(InterstitialSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdReady();
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener " + description);
            this.mListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
        }

        @Override
        public void onInterstitialOpen() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener demandSourceId=" + demandSourceId + " amount=" + amount);
        }

        @Override
        public void onInterstitialClose() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdShowSucceeded();
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener " + description);
            this.mListener.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", description));
        }

        @Override
        public void onInterstitialClick() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener eventName=" + eventName);
            this.mListener.onInterstitialAdVisible();
        }
    }

    private class IronSourceRewardedVideoListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        RewardedVideoSmashListener mListener;
        boolean mIsRvDemandOnly;

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = false;
        }

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName, boolean isDemandOnly) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = isDemandOnly;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            if (this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoLoadSuccess();
            } else {
                this.mListener.onRewardedVideoAvailabilityChanged(true);
            }
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener " + description);
            this.mListener.onRewardedVideoLoadFailed(ErrorBuilder.buildLoadFailedError(description));
            if (!this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        @Override
        public void onInterstitialOpen() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            this.mListener.onRewardedVideoAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener demandSourceId=" + demandSourceId + " amount=" + amount);
            this.mListener.onRewardedVideoAdRewarded();
        }

        @Override
        public void onInterstitialClose() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            this.mListener.onRewardedVideoAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            if (!this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + "rewardedVideoListener " + description);
            this.mListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildShowFailedError("Rewarded Video", description));
        }

        @Override
        public void onInterstitialClick() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            this.mListener.onRewardedVideoAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener eventName=" + eventName);
            this.mListener.onRewardedVideoAdVisible();
        }
    }
}

