/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.eventsTracker.EventsConfiguration;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.ISNEventsUtils;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceNetworkAPI;
import com.ironsource.sdk.agent.IronSourceAdsPublisherAgent;
import com.ironsource.sdk.listeners.OnBannerListener;
import com.ironsource.sdk.listeners.OnNetworkSDKInitListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.service.TokenService;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.Map;
import org.json.JSONObject;

public class IronSourceNetwork {
    static final String TAG = "IronSourceNetwork";
    private static IronSourceNetworkAPI ironSourceNetwork;
    private static OnNetworkSDKInitListener initSDKListener;
    private static JSONObject mConsentParams;

    public static synchronized void initSDK(Activity activity, String applicationKey, String userId, Map<String, String> initParams) {
        if (TextUtils.isEmpty((CharSequence)applicationKey)) {
            Logger.e(TAG, "applicationKey is NULL");
            return;
        }
        if (ironSourceNetwork == null) {
            SDKUtils.setInitSDKParams(initParams);
            JSONObject supplySideConfiguration = SDKUtils.getNetworkConfiguration();
            try {
                JSONObject featureNativeEventsConfiguration = supplySideConfiguration.optJSONObject("events");
                if (featureNativeEventsConfiguration != null) {
                    IronSourceNetwork.initSDK5EventTracker(activity, featureNativeEventsConfiguration, userId, applicationKey, initParams);
                }
            }
            catch (Exception ex) {
                Logger.e(TAG, "Failed to init event tracker: " + ex.getMessage());
            }
            ironSourceNetwork = IronSourceAdsPublisherAgent.createInstance(activity, applicationKey, userId);
            IronSourceNetwork.applyConsentInfo(mConsentParams);
        }
    }

    public static synchronized void setInitListener(OnNetworkSDKInitListener initListener) {
        initSDKListener = initListener;
    }

    public static OnNetworkSDKInitListener getInitListener() {
        return initSDKListener;
    }

    private static void initSDK5EventTracker(Activity activity, JSONObject nativeEventsConfiguration, String userId, String applicationKey, Map<String, String> initParams) throws Exception {
        EventsConfiguration configuration = ISNEventsUtils.createConfigurations(nativeEventsConfiguration);
        if (configuration.areEventsEnabled()) {
            ISNEventsTracker.init(configuration, ISNEventsUtils.createEventsBaseData(activity, userId, applicationKey, initParams));
        }
    }

    private static synchronized void validateInitSDK() throws Exception {
        if (ironSourceNetwork == null) {
            throw new NullPointerException("Call initSDK first");
        }
    }

    public static synchronized void loadAd(IronSourceAdInstance adInstance, Map<String, String> loadParams) throws Exception {
        IronSourceNetwork.validateInitSDK();
        ironSourceNetwork.loadAd(adInstance, loadParams);
    }

    public static String getVersion() {
        return SDKUtils.getSDKVersion();
    }

    public static synchronized void loadAd(IronSourceAdInstance adInstance) throws Exception {
        IronSourceNetwork.loadAd(adInstance, null);
    }

    public static synchronized void showAd(IronSourceAdInstance adInstance, Map<String, String> showParams) throws Exception {
        IronSourceNetwork.validateInitSDK();
        ironSourceNetwork.showAd(adInstance, showParams);
    }

    public static synchronized void showAd(IronSourceAdInstance adInstance) throws Exception {
        IronSourceNetwork.showAd(adInstance, null);
    }

    public static synchronized boolean isAdAvailableForInstance(IronSourceAdInstance adInstance) {
        if (ironSourceNetwork == null) {
            return false;
        }
        return ironSourceNetwork.isAdAvailable(adInstance);
    }

    public static synchronized void onPause(Activity activity) {
        if (ironSourceNetwork == null) {
            return;
        }
        ironSourceNetwork.onPause(activity);
    }

    public static synchronized void onResume(Activity activity) {
        if (ironSourceNetwork == null) {
            return;
        }
        ironSourceNetwork.onResume(activity);
    }

    public static synchronized void updateConsentInfo(JSONObject consentParams) {
        mConsentParams = consentParams;
        IronSourceNetwork.applyConsentInfo(consentParams);
    }

    public static synchronized void applyConsentInfo(JSONObject consentParams) {
        if (ironSourceNetwork == null) {
            return;
        }
        if (consentParams == null) {
            return;
        }
        ironSourceNetwork.updateConsentInfo(consentParams);
    }

    public static synchronized void updateMetadata(JSONObject metadata) {
        TokenService.getInstance().updateMetaData(metadata);
    }

    public static synchronized void release(Activity activity) {
        if (ironSourceNetwork == null) {
            return;
        }
        ironSourceNetwork.release(activity);
    }

    public static synchronized String getToken(Context context) {
        return TokenService.getInstance().getToken(context);
    }

    public static synchronized JSONObject getRawToken(Context context) {
        return TokenService.getInstance().getRawToken(context);
    }

    public static synchronized void initOfferWall(Map<String, String> initParams, OnOfferWallListener listener) throws Exception {
        IronSourceNetwork.validateInitSDK();
        ironSourceNetwork.initOfferWall(initParams, listener);
    }

    public static synchronized void showOfferWall(Map<String, String> showParams) throws Exception {
        IronSourceNetwork.validateInitSDK();
        ironSourceNetwork.showOfferWall(showParams);
    }

    public static synchronized void getOfferWallCredits(OnOfferWallListener listener) throws Exception {
        IronSourceNetwork.validateInitSDK();
        ironSourceNetwork.getOfferWallCredits(listener);
    }

    public static synchronized void initBanner(String demandSourceName, Map<String, String> initParams, OnBannerListener listener) throws Exception {
        IronSourceNetwork.validateInitSDK();
        ironSourceNetwork.initBanner(demandSourceName, initParams, listener);
    }

    public static synchronized void loadBanner(JSONObject loadParams) throws Exception {
        IronSourceNetwork.validateInitSDK();
        ironSourceNetwork.loadBanner(loadParams);
    }

    public static synchronized ISNAdView createBanner(Activity activity, ISAdSize bannerSize) throws Exception {
        IronSourceNetwork.validateInitSDK();
        return ironSourceNetwork.createBanner(activity, bannerSize);
    }
}

