/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.BannerData;
import com.ironsource.mediationsdk.BannerUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgBannerManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.timer.BannerTimeoutTimer;
import com.ironsource.mediationsdk.utils.DurationMeasurement;
import java.util.Map;
import org.json.JSONObject;

public class ProgBannerSmash
extends ProgSmash
implements BannerSmashListener,
BannerTimeoutTimer.TimeoutInterface {
    private BannerData mData;
    private BannerTimeoutTimer mTimer;
    private BannerSmashState mState;
    private ProgBannerManagerListener mListener;
    private IronSourceBannerLayout mBannerLayout;
    private String mAuctionId;
    private JSONObject mGenericParams;
    private int mAuctionTrial;
    private String mAuctionFallback;
    private BannerPlacement mPlacement;
    private final Object mStateLock = new Object();
    private DurationMeasurement mLoadDuration;
    private boolean mIsReload;

    ProgBannerSmash(BannerData bannerData, ProgBannerManagerListener listener, ProviderSettings settings, AbstractAdapter adapter, int sessionDepth, boolean isReload) {
        this(bannerData, listener, settings, adapter, sessionDepth, "", null, 0, "", isReload);
    }

    ProgBannerSmash(BannerData bannerData, ProgBannerManagerListener listener, ProviderSettings settings, AbstractAdapter adapter, int sessionDepth, String auctionId, JSONObject genericParams, int auctionTrial, String auctionFallback, boolean isReload) {
        super(new AdapterConfig(settings, settings.getBannerSettings()), adapter);
        this.mState = BannerSmashState.NONE;
        this.mData = bannerData;
        this.mTimer = new BannerTimeoutTimer(bannerData.getBannerLoadTimeOutInMillis());
        this.mListener = listener;
        this.mSessionDepth = sessionDepth;
        this.mAuctionId = auctionId;
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFallback = auctionFallback;
        this.mGenericParams = genericParams;
        this.mIsReload = isReload;
        this.mAdapter.addBannerListener(this);
        if (this.isBidder()) {
            this.init();
        }
    }

    public String getName() {
        if (this.mAdapterConfig.getProviderSettings().isMultipleInstances()) {
            return this.mAdapterConfig.getProviderSettings().getProviderTypeForReflection();
        }
        return this.mAdapterConfig.getProviderSettings().getProviderName();
    }

    public String getAdSourceNameForEvents() {
        if (!TextUtils.isEmpty((CharSequence)this.mAdapterConfig.getProviderSettings().getAdSourceNameForEvents())) {
            return this.mAdapterConfig.getProviderSettings().getAdSourceNameForEvents();
        }
        return this.getName();
    }

    public String getSubProviderId() {
        return this.mAdapterConfig.getSubProviderId();
    }

    public AbstractAdapter getAdapter() {
        return this.mAdapter;
    }

    private void init() {
        IronLog.INTERNAL.verbose(this.getLogPrefix() + "isBidder = " + this.isBidder());
        this.setState(BannerSmashState.INIT_IN_PROGRESS);
        this.setCustomParams();
        try {
            if (this.isBidder()) {
                this.mAdapter.initBannerForBidding(this.mData.getAppKey(), this.mData.getUserId(), this.mAdUnitSettings, this);
            } else {
                this.mAdapter.initBanners(this.mData.getAppKey(), this.mData.getUserId(), this.mAdUnitSettings, this);
            }
        }
        catch (Throwable t) {
            IronLog.INTERNAL.error("exception = " + t.getLocalizedMessage());
            this.onBannerInitFailed(new IronSourceError(612, t.getLocalizedMessage()));
        }
    }

    public void loadBanner(IronSourceBannerLayout bannerLayout, BannerPlacement placement, String serverData) {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        this.mPlacement = placement;
        if (!BannerUtils.isBannerLayoutReady(bannerLayout)) {
            String errorMessage = bannerLayout == null ? "banner is null" : "banner is destroyed";
            IronLog.INTERNAL.verbose(errorMessage);
            this.mListener.onBannerLoadFailed(new IronSourceError(610, errorMessage), this, false);
            return;
        }
        if (this.mAdapter == null) {
            String errorMessage = "mAdapter is null";
            IronLog.INTERNAL.verbose(errorMessage);
            this.mListener.onBannerLoadFailed(new IronSourceError(611, errorMessage), this, false);
            return;
        }
        this.mBannerLayout = bannerLayout;
        this.mTimer.startTimeoutTimer(this);
        try {
            if (this.isBidder()) {
                this.loadBannerInternal(serverData);
            } else {
                this.init();
            }
        }
        catch (Throwable t) {
            IronLog.INTERNAL.error("exception = " + t.getLocalizedMessage());
            t.printStackTrace();
        }
    }

    private void loadBannerInternal(String serverData) {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        if (this.compareStateAndSetIfTrue(BannerSmashState.READY_TO_LOAD, BannerSmashState.LOADING)) {
            this.mLoadDuration = new DurationMeasurement();
            this.sendProviderEvent(this.mIsReload ? 3012 : 3002);
            if (this.isBidder()) {
                this.mAdapter.loadBannerForBidding(this.mBannerLayout, this.mAdUnitSettings, this, serverData);
            } else {
                this.mAdapter.loadBanner(this.mBannerLayout, this.mAdUnitSettings, this);
            }
        } else {
            IronLog.INTERNAL.error("wrong state - state = " + (Object)((Object)this.mState));
        }
    }

    public void destroyBanner() {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        this.setState(BannerSmashState.DESTROYED);
        if (this.mAdapter == null) {
            IronLog.INTERNAL.warning("mAdapter == null");
            return;
        }
        this.mAdapter.destroyBanner(this.mAdapterConfig.getProviderSettings().getBannerSettings());
        this.sendProviderEvent(3305);
    }

    private void setCustomParams() {
        if (this.mAdapter == null) {
            return;
        }
        try {
            String pluginType;
            String segment = IronSourceObject.getInstance().getMediationSegment();
            if (!TextUtils.isEmpty((CharSequence)segment)) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
        }
        catch (Exception e2) {
            IronLog.INTERNAL.verbose("exception - " + e2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareStateAndSetIfTrue(BannerSmashState expectedState, BannerSmashState stateToSet) {
        boolean stateWasAsExpected = false;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == expectedState) {
                IronLog.INTERNAL.verbose(this.getLogPrefix() + "set state from '" + (Object)((Object)this.mState) + "' to '" + (Object)((Object)stateToSet) + "'");
                stateWasAsExpected = true;
                this.mState = stateToSet;
            }
        }
        return stateWasAsExpected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(BannerSmashState state) {
        IronLog.INTERNAL.verbose(this.getLogPrefix() + "state = " + state.name());
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = state;
        }
    }

    @Override
    public void onTimeout() {
        IronSourceError ironSourceError;
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        if (this.compareStateAndSetIfTrue(BannerSmashState.INIT_IN_PROGRESS, BannerSmashState.LOAD_FAILED)) {
            IronLog.INTERNAL.verbose("init timed out");
            ironSourceError = new IronSourceError(607, "Timed out");
        } else if (this.compareStateAndSetIfTrue(BannerSmashState.LOADING, BannerSmashState.LOAD_FAILED)) {
            IronLog.INTERNAL.verbose("load timed out");
            ironSourceError = new IronSourceError(608, "Timed out");
        } else {
            IronLog.INTERNAL.error("unexpected state - " + (Object)((Object)this.mState));
            return;
        }
        this.handleLoadFailed(ironSourceError);
    }

    @Override
    public void onBannerInitSuccess() {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        if (this.compareStateAndSetIfTrue(BannerSmashState.INIT_IN_PROGRESS, BannerSmashState.READY_TO_LOAD) && !this.isBidder()) {
            if (!BannerUtils.isBannerLayoutReady(this.mBannerLayout)) {
                String errorMessage = this.mBannerLayout == null ? "banner is null" : "banner is destroyed";
                this.mListener.onBannerLoadFailed(new IronSourceError(605, errorMessage), this, false);
            } else {
                this.loadBannerInternal(null);
            }
        }
    }

    @Override
    public void onBannerInitFailed(IronSourceError error) {
        IronLog.INTERNAL.verbose(this.getLogPrefix() + "error = " + error);
        this.mTimer.stopTimeoutTimer();
        if (this.compareStateAndSetIfTrue(BannerSmashState.INIT_IN_PROGRESS, BannerSmashState.NONE)) {
            if (this.mListener != null) {
                this.mListener.onBannerLoadFailed(new IronSourceError(612, "Banner init failed"), this, false);
            }
        } else {
            IronLog.INTERNAL.warning("wrong state - mState = " + (Object)((Object)this.mState));
        }
    }

    @Override
    public void onBannerAdLoaded(View adView, FrameLayout.LayoutParams frameLayoutParams) {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        this.mTimer.stopTimeoutTimer();
        if (this.compareStateAndSetIfTrue(BannerSmashState.LOADING, BannerSmashState.LOADED)) {
            this.sendProviderEvent(this.mIsReload ? 3015 : 3005, new Object[][]{{"duration", DurationMeasurement.getMeasuredDuration(this.mLoadDuration)}});
            if (this.mListener != null) {
                this.mListener.onBannerLoadSuccess(this, adView, frameLayoutParams);
            }
        } else {
            this.sendProviderEvent(this.mIsReload ? 3017 : 3007);
        }
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error) {
        IronLog.INTERNAL.verbose(this.getLogPrefix() + "error = " + error);
        this.mTimer.stopTimeoutTimer();
        if (this.compareStateAndSetIfTrue(BannerSmashState.LOADING, BannerSmashState.LOAD_FAILED)) {
            this.handleLoadFailed(error);
        }
    }

    @Override
    public void onBannerAdClicked() {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        this.sendProviderEvent(3008);
        if (this.mListener != null) {
            this.mListener.onBannerClicked(this);
        }
    }

    @Override
    public void onBannerAdScreenPresented() {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        this.sendProviderEvent(3302);
        if (this.mListener != null) {
            this.mListener.onBannerScreenPresented(this);
        }
    }

    @Override
    public void onBannerAdScreenDismissed() {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        this.sendProviderEvent(3303);
        if (this.mListener != null) {
            this.mListener.onBannerScreenDismissed(this);
        }
    }

    @Override
    public void onBannerAdLeftApplication() {
        IronLog.INTERNAL.verbose(this.getInstanceSignature());
        this.sendProviderEvent(3304);
        if (this.mListener != null) {
            this.mListener.onBannerLeftApplication(this);
        }
    }

    public String getAuctionId() {
        return this.mAuctionId;
    }

    public Map<String, Object> getBiddingData() {
        try {
            return this.isBidder() ? this.mAdapter.getBannerBiddingData(this.mAdUnitSettings) : null;
        }
        catch (Throwable t) {
            IronLog.INTERNAL.error("getBiddingData exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            return null;
        }
    }

    public String getInstanceSignature() {
        return String.format("%s %s", this.getName(), this.hashCode());
    }

    public String getLogPrefix() {
        return String.format("%s - ", this.getInstanceSignature());
    }

    private boolean isBannerLayoutDestroyed() {
        return this.mBannerLayout == null || this.mBannerLayout.isDestroyed();
    }

    private void handleLoadFailed(IronSourceError error) {
        boolean isNoFillError;
        boolean bl = isNoFillError = error.getErrorCode() == 606;
        if (isNoFillError) {
            this.sendProviderEvent(3306, new Object[][]{{"duration", DurationMeasurement.getMeasuredDuration(this.mLoadDuration)}});
        } else {
            this.sendProviderEvent(this.mIsReload ? 3301 : 3300, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", DurationMeasurement.getMeasuredDuration(this.mLoadDuration)}});
        }
        if (this.mListener != null) {
            this.mListener.onBannerLoadFailed(error, this, isNoFillError);
        }
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 3005 || eventId == 3002 || eventId == 3008 || eventId == 3305 || eventId == 3300 || eventId == 3302 || eventId == 3303 || eventId == 3304;
    }

    private void addEventSizeFields(Map<String, Object> sizeData, ISBannerSize size) {
        try {
            switch (size.getDescription()) {
                case "BANNER": {
                    sizeData.put("bannerAdSize", 1);
                    break;
                }
                case "LARGE": {
                    sizeData.put("bannerAdSize", 2);
                    break;
                }
                case "RECTANGLE": {
                    sizeData.put("bannerAdSize", 3);
                    break;
                }
                case "SMART": {
                    sizeData.put("bannerAdSize", 5);
                    break;
                }
                case "CUSTOM": {
                    sizeData.put("bannerAdSize", 6);
                    sizeData.put("custom_banner_size", size.getWidth() + "x" + size.getHeight());
                }
            }
        }
        catch (Exception e2) {
            IronLog.INTERNAL.error(Log.getStackTraceString((Throwable)e2));
        }
    }

    public void sendProviderEvent(int eventId) {
        this.sendProviderEvent(eventId, null);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals) {
        Map<String, Object> data = this.getProviderEventData();
        if (this.isBannerLayoutDestroyed()) {
            data.put("reason", "banner is destroyed");
        } else {
            Object[][] size = this.mBannerLayout.getSize();
            this.addEventSizeFields(data, (ISBannerSize)size);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAuctionId)) {
            data.put("auctionId", this.mAuctionId);
        }
        if (this.mGenericParams != null && this.mGenericParams.length() > 0) {
            data.put("genericParams", this.mGenericParams);
        }
        if (this.mPlacement != null) {
            data.put("placement", this.mPlacement.getPlacementName());
        }
        if (this.shouldAddAuctionParams(eventId)) {
            InterstitialEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFallback);
        }
        data.put("sessionDepth", this.mSessionDepth);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronLog.INTERNAL.error(this.getInstanceName() + " smash: BN sendMediationEvent " + Log.getStackTraceString((Throwable)e2));
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    protected static enum BannerSmashState {
        NONE,
        INIT_IN_PROGRESS,
        READY_TO_LOAD,
        LOADING,
        LOADED,
        LOAD_FAILED,
        DESTROYED;

    }
}

