/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.lifecycle;

import com.ironsource.lifecycle.IronsourceLifecycleListener;
import com.ironsource.lifecycle.IronsourceLifecycleManager;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;

public class LifecycleSensitiveTimer
implements IronsourceLifecycleListener {
    private String TAG = "INTERNAL";
    private Timer timer;
    private boolean started;
    private Long fireTimestamp;
    private long timeIntervalInMs;
    private Runnable timerTask;

    public LifecycleSensitiveTimer(long timeIntervalInMs, Runnable timerTask, boolean startNow) {
        this.timeIntervalInMs = timeIntervalInMs;
        this.timerTask = timerTask;
        this.started = false;
        this.fireTimestamp = null;
        if (startNow) {
            this.startNow();
        }
    }

    public void startNow() {
        if (this.started) {
            return;
        }
        this.started = true;
        IronsourceLifecycleManager.getInstance().addObserver(this);
        this.fireTimestamp = System.currentTimeMillis() + this.timeIntervalInMs;
        if (!IronsourceLifecycleManager.getInstance().isAppInBackground()) {
            this.startTimer();
        }
    }

    public void invalidate() {
        this.invalidateTimer();
        this.started = false;
        this.fireTimestamp = null;
        IronsourceLifecycleManager.getInstance().removeObserver(this);
    }

    @Override
    public void appStarted() {
        if (this.timer != null) {
            return;
        }
        if (this.fireTimestamp != null) {
            this.timeIntervalInMs = this.fireTimestamp - System.currentTimeMillis();
            if (this.timeIntervalInMs <= 0L) {
                this.invalidate();
                this.timerTask.run();
            } else {
                this.startTimer();
            }
        }
    }

    @Override
    public void appStopped() {
        if (this.timer != null) {
            this.invalidateTimer();
        }
    }

    @Override
    public void appResumed() {
    }

    @Override
    public void appPaused() {
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LifecycleSensitiveTimer.this.timerTask.run();
                }
            }, this.timeIntervalInMs);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(this.fireTimestamp);
        }
    }

    private void invalidateTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

