/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.service;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.iab.omid.library.ironsrc.Omid;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.sdk.service.DeviceData;
import com.ironsource.sdk.service.Gibberish;
import com.ironsource.sdk.utils.IronSourceQaProperties;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenService {
    private JSONObject tokenData = new JSONObject();
    private static TokenService mInstance = null;

    public static synchronized TokenService getInstance() {
        if (mInstance == null) {
            mInstance = new TokenService();
        }
        return mInstance;
    }

    private TokenService() {
    }

    public void collectOmidParameters() {
        HashMap<String, String> omidParameters = new HashMap<String, String>();
        omidParameters.put("omidVersion", Omid.getVersion());
        omidParameters.put("omidPartnerVersion", "6");
        mInstance.collectDataFromExternalParams(omidParameters);
    }

    public void collectQaParameters() {
        if (IronSourceQaProperties.isInitialized()) {
            mInstance.collectDataFromExternalParams(IronSourceQaProperties.getInstance().getParameters());
        }
    }

    synchronized void put(String key, Object value) {
        try {
            this.tokenData.put(key, value);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    public void collectApplicationUserId(String userId) {
        if (userId != null) {
            this.put("applicationUserId", SDKUtils.encodeString(userId));
        }
    }

    public void collectApplicationKey(String applicationKey) {
        if (applicationKey != null) {
            this.put("applicationKey", SDKUtils.encodeString(applicationKey));
        }
    }

    public void collectDataFromActivity(Activity activity) {
        if (activity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.put(SDKUtils.encodeString("immersiveMode"), DeviceStatus.isImmersiveSupported(activity));
        }
        this.put("appOrientation", SDKUtils.translateRequestedOrientation(DeviceStatus.getActivityRequestedOrientation((Context)activity)));
    }

    public void collectAdvertisingID(final Activity activity) {
        if (activity == null) {
            return;
        }
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TokenService.this.updateData(DeviceData.fetchAdvertiserIdData((Context)activity));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void collectDataFromDevice(Context context) {
        if (context == null) {
            return;
        }
        this.updateData(DeviceData.fetchPermanentData(context));
        this.updateData(DeviceData.fetchMutableData(context));
    }

    public void collectDataFromExternalParams(Map<String, String> params) {
        if (params == null) {
            Log.d((String)"TokenService", (String)"collectDataFromExternalParams params=null");
            return;
        }
        Set<String> keys = params.keySet();
        for (String key : keys) {
            this.put(key, SDKUtils.encodeString(params.get(key)));
        }
    }

    public void collectDataFromControllerConfig(String controllerConfig) {
        if (TextUtils.isEmpty((CharSequence)controllerConfig)) {
            return;
        }
        try {
            JSONObject config = new JSONObject(controllerConfig);
            this.put("chinaCDN", config.opt("chinaCDN"));
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    public void updateData(JSONObject data) {
        Iterator keys = data.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.put(key, data.opt(key));
        }
    }

    public void updateMetaData(JSONObject metadata) {
        Iterator keys = metadata.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.put("metadata_" + key, metadata.opt(key));
        }
    }

    public String getToken(Context context) {
        try {
            return Gibberish.encode(this.getRawToken(context).toString());
        }
        catch (Exception ex) {
            JSONObject empty = new JSONObject();
            return Gibberish.encode(empty.toString());
        }
    }

    public JSONObject getRawToken(Context context) {
        this.fetchIndependentData();
        this.collectDataFromDevice(context);
        try {
            return new JSONObject(this.tokenData.toString());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return new JSONObject();
        }
    }

    public void fetchDependentData(Activity activity, String applicationKey, String userId) {
        this.collectAdvertisingID(activity);
        this.collectDataFromActivity(activity);
        this.collectDataFromDevice((Context)activity);
        this.collectApplicationUserId(userId);
        this.collectApplicationKey(applicationKey);
    }

    public void fetchIndependentData() {
        this.collectDataFromControllerConfig(SDKUtils.getControllerConfig());
        this.collectDataFromExternalParams(SDKUtils.getInitSDKParams());
        this.collectQaParameters();
        this.collectOmidParameters();
    }
}

