/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.service.Connectivity;

import android.content.Context;
import android.os.Build;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.sdk.service.Connectivity.BroadcastReceiverStrategy;
import com.ironsource.sdk.service.Connectivity.IConnectivity;
import com.ironsource.sdk.service.Connectivity.IConnectivityStatus;
import com.ironsource.sdk.service.Connectivity.NetworkCallbackStrategy;
import com.ironsource.sdk.utils.Logger;
import org.json.JSONObject;

public abstract class ConnectivityAdapter
implements IConnectivityStatus {
    private IConnectivity currentStrategy;

    protected ConnectivityAdapter(JSONObject supplyConfig, Context context) {
        this.currentStrategy = this.decideStrategy(supplyConfig, context);
        Logger.i(ConnectivityAdapter.class.getSimpleName(), "created ConnectivityAdapter with strategy " + this.currentStrategy.getClass().getSimpleName());
    }

    public void startListenToNetworkChanges(Context context) {
        this.currentStrategy.startListenToNetworkChanges(context);
    }

    public void stopListenToNetworkChanges(Context context) {
        this.currentStrategy.stopListenToNetworkChanges(context);
    }

    public JSONObject getConnectivityData(Context context) {
        return this.currentStrategy.getConnectivityInfo(context);
    }

    public void release() {
        this.currentStrategy.release();
    }

    @Override
    public void onConnected(String connectionType, JSONObject connectionInfo) {
    }

    @Override
    public void onDisconnected() {
    }

    @Override
    public void onStatusChanged(String connectionType, JSONObject connectionInfo) {
    }

    private IConnectivity decideStrategy(JSONObject supplyConfig, Context context) {
        boolean kStrategyBroadcastReceiver = true;
        int kSupportingVersionForNetworkCallback = 23;
        if (supplyConfig.optInt("connectivityStrategy") == 1) {
            return new BroadcastReceiverStrategy(this);
        }
        boolean canAccessNetworkState = ApplicationContext.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE");
        if (Build.VERSION.SDK_INT < 23 || !canAccessNetworkState) {
            return new BroadcastReceiverStrategy(this);
        }
        return new NetworkCallbackStrategy(this);
    }
}

