/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import java.util.ArrayList;

public class CommandExecutor {
    private CommandExecutorState mCommandExecutorState = CommandExecutorState.NOT_READY;
    private ArrayList mCommandExecutorQueue = new ArrayList();
    private String mName;

    public CommandExecutor(String name) {
        this.mName = name;
    }

    public synchronized void setReady() {
        this.mCommandExecutorState = CommandExecutorState.READY;
    }

    public synchronized void executeCommand(Runnable runnable) {
        if (this.mCommandExecutorState != CommandExecutorState.READY) {
            this.mCommandExecutorQueue.add(runnable);
            return;
        }
        runnable.run();
    }

    public synchronized void purgeDelayedCommands() {
        Object[] commands = this.mCommandExecutorQueue.toArray();
        for (int index = 0; index < commands.length; ++index) {
            Runnable runnable = (Runnable)commands[index];
            runnable.run();
            commands[index] = null;
        }
        this.mCommandExecutorQueue.clear();
    }

    static enum CommandExecutorState {
        NOT_READY,
        READY;

    }
}

