/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.events;

import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.events.BaseEventsManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;

public class RewardedVideoEventsManager
extends BaseEventsManager {
    private static RewardedVideoEventsManager sInstance;
    private String mCurrentOWPlacement;

    private RewardedVideoEventsManager() {
        this.mFormatterType = "outcome";
        this.mAdUnitType = 3;
        this.mEventType = "RV";
        this.mCurrentOWPlacement = "";
    }

    public static synchronized RewardedVideoEventsManager getInstance() {
        if (sInstance == null) {
            sInstance = new RewardedVideoEventsManager();
            sInstance.initState();
        }
        return sInstance;
    }

    @Override
    protected boolean shouldExtractCurrentPlacement(EventData event) {
        return false;
    }

    @Override
    protected boolean shouldIncludeCurrentPlacement(EventData event) {
        return event.getEventId() == 305;
    }

    @Override
    protected boolean isTriggerEvent(EventData currentEvent) {
        int eventId = currentEvent.getEventId();
        return eventId == 14 || eventId == 514 || eventId == 305 || eventId == 1003 || eventId == 1005 || eventId == 1203 || eventId == 1010 || eventId == 1301 || eventId == 1302;
    }

    @Override
    protected int getSessionDepth(EventData event) {
        if (event.getEventId() == 15 || event.getEventId() >= 300 && event.getEventId() < 400) {
            return SessionDepthManager.getInstance().getSessionDepth(0);
        }
        return SessionDepthManager.getInstance().getSessionDepth(1);
    }

    @Override
    protected void setCurrentPlacement(EventData event) {
        if (event.getEventId() == 15 || event.getEventId() >= 300 && event.getEventId() < 400) {
            this.mCurrentOWPlacement = event.getAdditionalDataJSON().optString("placement");
        }
    }

    @Override
    protected String getCurrentPlacement(int eventId) {
        if (eventId == 15 || eventId >= 300 && eventId < 400) {
            return this.mCurrentOWPlacement;
        }
        return "";
    }

    @Override
    protected void initConnectivitySensitiveEventsSet() {
        this.mConnectivitySensitiveEventsSet.add(1000);
        this.mConnectivitySensitiveEventsSet.add(1001);
        this.mConnectivitySensitiveEventsSet.add(1002);
        this.mConnectivitySensitiveEventsSet.add(1003);
        this.mConnectivitySensitiveEventsSet.add(1200);
        this.mConnectivitySensitiveEventsSet.add(1209);
        this.mConnectivitySensitiveEventsSet.add(1210);
        this.mConnectivitySensitiveEventsSet.add(1211);
        this.mConnectivitySensitiveEventsSet.add(1212);
    }
}

