/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.environment.StringUtils;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.IronsourceObjectPublisherDataHolder;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

class TokenDataService {
    private JSONObject tokenData = new JSONObject();
    private static TokenDataService mInstance = null;

    public static synchronized TokenDataService getInstance() {
        if (mInstance == null) {
            mInstance = new TokenDataService();
        }
        return mInstance;
    }

    private TokenDataService() {
    }

    JSONObject getTokenData() {
        this.collectDataFromDevice();
        return this.tokenData;
    }

    synchronized void add(String key, Object value) {
        try {
            this.tokenData.put(key, value);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    private void updateTokenData(JSONObject data) {
        Iterator keys = data.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.add(key, data.opt(key));
        }
    }

    private void collectDataFromDevice() {
        this.updateTokenData(this.fetchPermanentData());
        this.updateTokenData(this.fetchMutableData());
    }

    void collectAdvertisingData() {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TokenDataService.this.updateTokenData(TokenDataService.this.fetchAdvertisingId());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JSONObject fetchAdvertisingId() {
        JSONObject jsonObject = new JSONObject();
        Context context = ContextProvider.getInstance().getApplicationContext();
        if (context != null) {
            String advertisingId = "";
            String advertisingIdType = "";
            boolean isLimitAdTrackingEnabled = false;
            try {
                String[] advertisingIdInfo = DeviceStatus.getAdvertisingIdInfo(context);
                if (advertisingIdInfo != null && advertisingIdInfo.length == 2) {
                    if (!TextUtils.isEmpty((CharSequence)advertisingIdInfo[0])) {
                        advertisingId = advertisingIdInfo[0];
                    }
                    isLimitAdTrackingEnabled = Boolean.valueOf(advertisingIdInfo[1]);
                }
            }
            catch (Exception e2) {
                IronLog.INTERNAL.error("got the following error " + e2.getMessage());
            }
            if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
                advertisingIdType = "GAID";
            } else {
                advertisingId = DeviceStatus.getOrGenerateOnceUniqueIdentifier(context);
                if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
                    advertisingIdType = "UUID";
                }
            }
            try {
                jsonObject.put("advId", (Object)advertisingId);
                jsonObject.put("advType", (Object)advertisingIdType);
                jsonObject.put("isLAT", isLimitAdTrackingEnabled);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return jsonObject;
    }

    JSONObject fetchMutableData() {
        JSONObject jsonObject = new JSONObject();
        Context context = ContextProvider.getInstance().getApplicationContext();
        int width = DeviceStatus.getDisplayWidth();
        int height = DeviceStatus.getDisplayHeight();
        float deviceScale = DeviceStatus.getDeviceDensity();
        if (context != null) {
            try {
                ConcurrentHashMap<String, List<String>> metaDataMap = AdapterRepository.getInstance().getMetaData();
                metaDataMap.putAll(IronsourceObjectPublisherDataHolder.getInstance().getMediationMetaData());
                JSONObject metaDataJson = new JSONObject();
                for (Map.Entry param : metaDataMap.entrySet()) {
                    metaDataJson.put((String)param.getKey(), param.getValue());
                }
                Boolean consent = IronSourceObject.getInstance().getConsent();
                if (consent != null) {
                    jsonObject.put("consent", consent.booleanValue());
                }
                jsonObject.put("connT", (Object)IronSourceUtils.getConnectionType(context));
                jsonObject.put("dVol", (double)DeviceStatus.getSystemVolumePercent(context));
                jsonObject.put("root", DeviceStatus.isRootedDevice());
                jsonObject.put("bat", DeviceStatus.getBatteryLevel(context));
                jsonObject.put("diskFS", DeviceStatus.getAvailableInternalMemorySizeInMegaBytes());
                jsonObject.put("MD", (Object)metaDataJson);
                jsonObject.put("cTime", new Date().getTime());
                jsonObject.put("dWidth", width);
                jsonObject.put("dHeight", height);
                jsonObject.put("dScrenScle", (Object)String.valueOf(deviceScale));
                jsonObject.put("sDepIS", SessionDepthManager.getInstance().getSessionDepth(2));
                jsonObject.put("sDepRV", SessionDepthManager.getInstance().getSessionDepth(1));
            }
            catch (JSONException e2) {
                IronLog.INTERNAL.error("got the following error " + e2.getMessage());
                e2.printStackTrace();
            }
        }
        return jsonObject;
    }

    JSONObject fetchPermanentData() {
        JSONObject jsonObject = new JSONObject();
        Context context = ContextProvider.getInstance().getApplicationContext();
        if (context != null) {
            try {
                String deviceOSVersionFull;
                String pluginType;
                String deviceLanguage = context.getResources().getConfiguration().locale.getLanguage();
                if (!TextUtils.isEmpty((CharSequence)deviceLanguage)) {
                    jsonObject.put("dLang", (Object)StringUtils.toUpperCase(deviceLanguage));
                }
                if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                    jsonObject.put("plType", (Object)pluginType);
                }
                if ((deviceOSVersionFull = DeviceStatus.getAndroidOsVersion()) != null) {
                    jsonObject.put("dOSVF", (Object)deviceOSVersionFull);
                    String deviceOSVersion = deviceOSVersionFull.replaceAll("[^0-9/.]", "");
                    jsonObject.put("dOSV", (Object)deviceOSVersion);
                }
                jsonObject.put("sId", (Object)IronSourceUtils.getSessionId());
                jsonObject.put("appKey", (Object)IronSourceObject.getInstance().getIronSourceAppKey());
                jsonObject.put("mCar", (Object)DeviceStatus.getMobileCarrier(context));
                jsonObject.put("medV", (Object)IronSourceUtils.getSDKVersion());
                jsonObject.put("dModel", (Object)Build.MODEL);
                jsonObject.put("dOS", (Object)"android");
                jsonObject.put("dMake", (Object)Build.MANUFACTURER);
                jsonObject.put("dAPI", (Object)String.valueOf(Build.VERSION.SDK_INT));
                jsonObject.put("bId", (Object)context.getPackageName());
                jsonObject.put("appV", (Object)ApplicationContext.getPublisherApplicationVersion(context, context.getPackageName()));
                jsonObject.put("usId", (Object)IronSourceObject.getInstance().getIronSourceUserId());
            }
            catch (JSONException e2) {
                IronLog.INTERNAL.error("got the following error " + e2.getMessage());
                e2.printStackTrace();
            }
        }
        return jsonObject;
    }
}

