/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.ProgBannerSmash;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ContextProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BannerUtils {
    static boolean isBannerLayoutReady(IronSourceBannerLayout banner) {
        return banner != null && !banner.isDestroyed();
    }

    static void verifyLoadBanner(IronSourceBannerLayout banner, BannerPlacement placement, VerifyBannerListener verifyBannerListener) {
        String errorMessage = null;
        if (!BannerUtils.isBannerLayoutReady(banner)) {
            errorMessage = String.format("can't load banner - %s", banner == null ? "banner is null" : "banner is destroyed");
        }
        if (placement == null || TextUtils.isEmpty((CharSequence)placement.getPlacementName())) {
            errorMessage = String.format("can't load banner - %s", placement == null ? "placement is null" : "placement name is empty");
        }
        if (!TextUtils.isEmpty(errorMessage)) {
            IronLog.INTERNAL.error(errorMessage);
            verifyBannerListener.failed(errorMessage);
        } else {
            verifyBannerListener.success();
        }
    }

    static void verifyDestroyBanner(IronSourceBannerLayout banner, VerifyBannerListener verifyBannerListener) {
        if (banner == null || banner.isDestroyed()) {
            String errorMessage = String.format("can't destroy banner - %s", banner == null ? "banner is null" : "banner is destroyed");
            verifyBannerListener.failed(errorMessage);
        } else {
            verifyBannerListener.success();
        }
    }

    static long getTimeToWaitBeforeFirstAuction(long managerInitTime, long timeToWaitBeforeFirstAction) {
        long timeSinceManagerInit = new Date().getTime() - managerInitTime;
        return timeToWaitBeforeFirstAction - timeSinceManagerInit;
    }

    static void createAuctionCandidates(String placementName, ConcurrentHashMap<String, ProgBannerSmash> smashCollection, CreateCandidatesListener createCandidatesListener) {
        HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
        ArrayList<String> noBidderCandidates = new ArrayList<String>();
        StringBuilder waterfallString = new StringBuilder();
        if (!CappingManager.isBnPlacementCapped((Context)ContextProvider.getInstance().getCurrentActiveActivity(), placementName)) {
            for (ProgBannerSmash smash : smashCollection.values()) {
                if (smash.isBidder()) {
                    Map<String, Object> biddingData = smash.getBiddingData();
                    if (biddingData == null) continue;
                    bidderCandidates.put(smash.getInstanceName(), biddingData);
                    waterfallString.append("2" + smash.getInstanceName() + ",");
                    continue;
                }
                if (smash.isBidder()) continue;
                noBidderCandidates.add(smash.getInstanceName());
                waterfallString.append("1" + smash.getInstanceName() + ",");
            }
        }
        createCandidatesListener.onFinish(bidderCandidates, noBidderCandidates, waterfallString);
    }

    static interface CreateCandidatesListener {
        public void onFinish(Map<String, Object> var1, List<String> var2, StringBuilder var3);
    }

    static interface VerifyBannerListener {
        public void success();

        public void failed(String var1);
    }
}

