/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.os.AsyncTask;
import android.os.SystemClock;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.AuctionEventListener;
import com.ironsource.mediationsdk.AuctionHistory;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.IronSourceAES;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class AuctionHandler {
    private static final int SERVER_REQUEST_TIMEOUT = 15000;
    private final String AUCTION_INTERNAL_ERROR_LOSS_CODE = "1";
    private final String AUCTION_NOT_HIGHEST_RTB_BIDDER_LOSS_CODE = "102";
    private final String AUCTION_LOST_TO_NON_BIDDER_LOSS_CODE = "103";
    private final String GENERIC_NOTIFICATIONS_DEFAULT_LOSS_CODE = "102";
    private String mAdUnit;
    private String mSessionId;
    private AuctionSettings mSettings;
    private AuctionEventListener mAuctionListener;
    private ISBannerSize mBannerSize;

    public AuctionHandler(String adUnit, AuctionSettings auctionSettings, AuctionEventListener listener) {
        this.mAdUnit = adUnit;
        this.mSettings = auctionSettings;
        this.mAuctionListener = listener;
        this.mSessionId = IronSourceUtils.getSessionId();
    }

    public void executeAuction(Context context, Map<String, Object> bidders, List<String> nonBidders, AuctionHistory auctionHistory, int sessionDepth, ISBannerSize size) {
        this.mBannerSize = size;
        this.executeAuction(context, bidders, nonBidders, auctionHistory, sessionDepth);
    }

    public void executeAuction(Context context, Map<String, Object> bidders, List<String> nonBidders, AuctionHistory auctionHistory, int sessionDepth) {
        try {
            boolean isEncryptedResponse = IronSourceUtils.getSerr() == 1;
            JSONObject requestData = this.generateRequest(context, bidders, nonBidders, auctionHistory, sessionDepth, isEncryptedResponse);
            AuctionHttpRequestTask task = new AuctionHttpRequestTask(this.mAuctionListener);
            task.execute(new Object[]{this.mSettings.getUrl(), requestData, isEncryptedResponse, this.mSettings.getNumOfMaxTrials(), this.mSettings.getTrialsInterval()});
        }
        catch (Exception e2) {
            this.mAuctionListener.onAuctionFailed(1000, e2.getMessage(), 0, "other", 0L);
        }
    }

    public void reportImpression(AuctionResponseItem responseItem, int instanceType, AuctionResponseItem genericNotifications, String placementName) {
        String modifiedURL;
        for (String url : responseItem.getBurls()) {
            modifiedURL = AuctionDataUtils.getInstance().enrichNotificationURL(url, instanceType, responseItem, "", "", placementName);
            AuctionDataUtils.getInstance().sendResponse(modifiedURL);
        }
        if (genericNotifications != null) {
            for (String url : genericNotifications.getBurls()) {
                modifiedURL = AuctionDataUtils.getInstance().enrichNotificationURL(url, instanceType, responseItem, "", "102", placementName);
                AuctionDataUtils.getInstance().sendResponse(modifiedURL);
            }
        }
    }

    public void reportLoadSuccess(AuctionResponseItem responseItem, int instanceType, AuctionResponseItem genericNotifications) {
        String modifiedURL;
        for (String url : responseItem.getNurls()) {
            modifiedURL = AuctionDataUtils.getInstance().enrichNotificationURL(url, instanceType, responseItem, "", "", "");
            AuctionDataUtils.getInstance().sendResponse(modifiedURL);
        }
        if (genericNotifications != null) {
            for (String url : genericNotifications.getNurls()) {
                modifiedURL = AuctionDataUtils.getInstance().enrichNotificationURL(url, instanceType, responseItem, "", "102", "");
                AuctionDataUtils.getInstance().sendResponse(modifiedURL);
            }
        }
    }

    public void reportAuctionLose(CopyOnWriteArrayList<ProgSmash> waterfall, ConcurrentHashMap<String, AuctionResponseItem> waterfallServerData, int instanceType, AuctionResponseItem genericNotifications, AuctionResponseItem winnerInstance) {
        boolean reachedWinningInstanceOnWaterfall = false;
        boolean isWinnerBidder = false;
        for (ProgSmash smash : waterfall) {
            String smashInstanceName = smash.getInstanceName();
            if (smashInstanceName.equals(winnerInstance.getInstanceName())) {
                reachedWinningInstanceOnWaterfall = true;
                isWinnerBidder = smash.isBidder();
                continue;
            }
            AuctionResponseItem instance = waterfallServerData.get(smashInstanceName);
            String bidPrice = instance.getPrice();
            String loseReasonCode = reachedWinningInstanceOnWaterfall ? (isWinnerBidder ? "102" : "103") : "1";
            for (String url : instance.getLurls()) {
                String modifiedURL = AuctionDataUtils.getInstance().enrichNotificationURL(url, instanceType, winnerInstance, bidPrice, loseReasonCode, "");
                AuctionDataUtils.getInstance().sendResponse(modifiedURL);
            }
        }
        if (genericNotifications != null) {
            for (String url : genericNotifications.getLurls()) {
                String modifiedURL = AuctionDataUtils.getInstance().enrichNotificationURL(url, instanceType, winnerInstance, "", "102", "");
                AuctionDataUtils.getInstance().sendResponse(modifiedURL);
            }
        }
    }

    private JSONObject generateRequest(Context context, Map<String, Object> bidders, List<String> nonBidders, AuctionHistory auctionHistory, int sessionDepth, boolean isEncryptedResponse) throws JSONException {
        JSONObject ret = new JSONObject();
        ret = AuctionDataUtils.getInstance().enrichToken(context, bidders, nonBidders, auctionHistory, sessionDepth, this.mSessionId, this.mSettings, this.mBannerSize);
        ret.put("adUnit", (Object)this.mAdUnit);
        ret.put("doNotEncryptResponse", (Object)(isEncryptedResponse ? "false" : "true"));
        return ret;
    }

    static class AuctionHttpRequestTask
    extends AsyncTask<Object, Void, Boolean> {
        private WeakReference<AuctionEventListener> mAuctionListener;
        private JSONObject mRequestData;
        private int mErrorCode;
        private String mErrorMessage;
        private String mAuctionId;
        private List<AuctionResponseItem> mWaterfall;
        private AuctionResponseItem mGenericNotifications;
        private JSONObject mGenericParams;
        private long mRequestStartTime;
        private int mCurrentAuctionTrial;
        private String mAuctionFallback = "other";

        AuctionHttpRequestTask(AuctionEventListener listener) {
            this.mAuctionListener = new WeakReference<AuctionEventListener>(listener);
        }

        protected Boolean doInBackground(Object ... objects) {
            long auctionTrialTimeout;
            int auctionMaxTrials;
            boolean isEncryptedResponse;
            URL auctionURL;
            this.mRequestStartTime = new Date().getTime();
            HttpURLConnection urlConnection = null;
            try {
                auctionURL = new URL((String)objects[0]);
                this.mRequestData = (JSONObject)objects[1];
                isEncryptedResponse = (Boolean)objects[2];
                auctionMaxTrials = (Integer)objects[3];
                auctionTrialTimeout = (Long)objects[4];
            }
            catch (Exception e2) {
                this.mErrorCode = 1007;
                this.mErrorMessage = e2.getMessage();
                this.mCurrentAuctionTrial = 0;
                this.mAuctionFallback = "other";
                return false;
            }
            this.mCurrentAuctionTrial = 0;
            while (this.mCurrentAuctionTrial < auctionMaxTrials) {
                block14: {
                    try {
                        long startTimeOfCurrentTrial = new Date().getTime();
                        String message = "Auction Handler: auction trial " + (this.mCurrentAuctionTrial + 1) + " out of " + auctionMaxTrials + " max trials";
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, message, 0);
                        IronSourceUtils.sendAutomationLog(message);
                        urlConnection = this.prepareAuctionRequest(auctionURL, auctionTrialTimeout);
                        this.sendAuctionRequest(urlConnection, this.mRequestData);
                        int httpResponseCode = urlConnection.getResponseCode();
                        if (httpResponseCode != 200) {
                            this.mErrorCode = 1001;
                            this.mErrorMessage = "Auction status not 200 error, error code response from server - " + httpResponseCode;
                            urlConnection.disconnect();
                            if (this.mCurrentAuctionTrial < auctionMaxTrials - 1) {
                                this.waitUntilNextTrial(auctionTrialTimeout, startTimeOfCurrentTrial);
                            }
                            break block14;
                        }
                        String responseStr = this.readResponse(urlConnection);
                        try {
                            this.handleResponse(responseStr, isEncryptedResponse);
                        }
                        catch (JSONException e3) {
                            if (e3.getMessage() != null && e3.getMessage().equalsIgnoreCase("decryption error")) {
                                this.mErrorCode = 1003;
                                this.mErrorMessage = "Auction decryption error";
                            } else {
                                this.mErrorCode = 1002;
                                this.mErrorMessage = "Auction parsing error";
                            }
                            this.mAuctionFallback = "parsing";
                            urlConnection.disconnect();
                            return false;
                        }
                        urlConnection.disconnect();
                        return true;
                    }
                    catch (SocketTimeoutException e4) {
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        this.mErrorCode = 1006;
                        this.mErrorMessage = "Connection timed out";
                    }
                    catch (Exception e5) {
                        IronLog.INTERNAL.error("getting exception " + e5);
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        this.mErrorCode = 1000;
                        this.mErrorMessage = e5.getMessage();
                        this.mAuctionFallback = "other";
                        return false;
                    }
                }
                ++this.mCurrentAuctionTrial;
            }
            this.mCurrentAuctionTrial = auctionMaxTrials - 1;
            this.mAuctionFallback = "trials_fail";
            return false;
        }

        private void waitUntilNextTrial(long auctionTrialTimeout, long startTimeOfCurrentTrial) {
            long timeToWaitUntilNextTrial = auctionTrialTimeout - (new Date().getTime() - startTimeOfCurrentTrial);
            if (timeToWaitUntilNextTrial > 0L) {
                SystemClock.sleep((long)timeToWaitUntilNextTrial);
            }
        }

        private void sendAuctionRequest(HttpURLConnection urlConnection, JSONObject requestData) throws IOException {
            OutputStream outputStream = urlConnection.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            BufferedWriter writer = new BufferedWriter(outputStreamWriter);
            String body = requestData.toString();
            body = IronSourceAES.encode("C38FB23A402222A0C17D34A92F971D1F", body);
            body = String.format("{\"request\" : \"%1$s\"}", body);
            writer.write(body);
            writer.flush();
            writer.close();
            outputStreamWriter.close();
            outputStream.close();
        }

        private HttpURLConnection prepareAuctionRequest(URL auctionURL, long trialTimeout) throws IOException {
            int timeout = (int)trialTimeout;
            HttpURLConnection urlConnection = (HttpURLConnection)auctionURL.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            urlConnection.setReadTimeout(timeout);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            return urlConnection;
        }

        private void handleResponse(String responseStr, boolean isEncryptedResponse) throws JSONException {
            if (TextUtils.isEmpty((CharSequence)responseStr)) {
                throw new JSONException("empty response");
            }
            JSONObject jsonObj = new JSONObject(responseStr);
            if (isEncryptedResponse) {
                try {
                    String encryptedStr = jsonObj.getString("response");
                    jsonObj = new JSONObject(IronSourceAES.decode("C38FB23A402222A0C17D34A92F971D1F", encryptedStr));
                }
                catch (Exception e2) {
                    throw new JSONException("decryption error");
                }
            }
            AuctionDataUtils.AuctionData auctionData = AuctionDataUtils.getInstance().getAuctionDataFromResponse(jsonObj);
            this.mAuctionId = auctionData.getAuctionId();
            this.mWaterfall = auctionData.getWaterfall();
            this.mGenericNotifications = auctionData.getGenericNotifications();
            this.mGenericParams = auctionData.getGenericParams();
            this.mErrorCode = auctionData.getErrorCode();
            this.mErrorMessage = auctionData.getErrorMessage();
        }

        private String readResponse(HttpURLConnection urlConnection) throws IOException {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
            BufferedReader reader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            reader.close();
            inputStreamReader.close();
            return stringBuilder.toString();
        }

        protected void onPostExecute(Boolean isSuccess) {
            AuctionEventListener listener = (AuctionEventListener)this.mAuctionListener.get();
            if (listener == null) {
                return;
            }
            long elapsedTime = new Date().getTime() - this.mRequestStartTime;
            if (isSuccess.booleanValue()) {
                listener.onAuctionSuccess(this.mWaterfall, this.mAuctionId, this.mGenericNotifications, this.mGenericParams, this.mCurrentAuctionTrial + 1, elapsedTime);
            } else {
                listener.onAuctionFailed(this.mErrorCode, this.mErrorMessage, this.mCurrentAuctionTrial + 1, this.mAuctionFallback, elapsedTime);
            }
        }
    }
}

