/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.utils.IronSourceAsyncHttpRequestTask;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceSharedPrefHelper {
    private static final String SUPERSONIC_SHARED_PREF = "supersonic_shared_preferen";
    private static final String VERSION = "version";
    private static final String BACK_BUTTON_STATE = "back_button_state";
    private static final String SEARCH_KEYS = "search_keys";
    private SharedPreferences mSharedPreferences;
    private static IronSourceSharedPrefHelper mInstance;

    private IronSourceSharedPrefHelper(Context context) {
        this.mSharedPreferences = context.getSharedPreferences(SUPERSONIC_SHARED_PREF, 0);
    }

    public static synchronized IronSourceSharedPrefHelper getSupersonicPrefHelper(Context context) {
        if (mInstance == null) {
            mInstance = new IronSourceSharedPrefHelper(context);
        }
        return mInstance;
    }

    public static synchronized IronSourceSharedPrefHelper getSupersonicPrefHelper() {
        return mInstance;
    }

    public void setBackButtonState(String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(BACK_BUTTON_STATE, value);
        editor.apply();
    }

    public SSAEnums.BackButtonState getBackButtonState() {
        String stateStr = this.mSharedPreferences.getString(BACK_BUTTON_STATE, "2");
        int state = Integer.parseInt(stateStr);
        if (state == 0) {
            return SSAEnums.BackButtonState.None;
        }
        if (state == 1) {
            return SSAEnums.BackButtonState.Device;
        }
        if (state == 2) {
            return SSAEnums.BackButtonState.Controller;
        }
        return SSAEnums.BackButtonState.Controller;
    }

    public void setSearchKeys(String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(SEARCH_KEYS, value);
        editor.apply();
    }

    public List<String> getSearchKeys() {
        SSAObj ssaObj;
        String value = this.mSharedPreferences.getString(SEARCH_KEYS, null);
        ArrayList<String> keys = new ArrayList<String>();
        if (value != null && (ssaObj = new SSAObj(value)).containsKey("searchKeys")) {
            JSONArray jsonArr = (JSONArray)ssaObj.get("searchKeys");
            try {
                keys.addAll(ssaObj.toList(jsonArr));
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        return keys;
    }

    public boolean setUserData(String key, String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public String getUserData(String key) {
        String value = this.mSharedPreferences.getString(key, null);
        if (value != null) {
            return value;
        }
        return "{}";
    }

    public String getCurrentSDKVersion() {
        return this.mSharedPreferences.getString(VERSION, "UN_VERSIONED");
    }

    public void setCurrentSDKVersion(String sdkVersion) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(VERSION, sdkVersion);
        editor.apply();
    }

    public String getCampaignLastUpdate(String campaign) {
        return this.mSharedPreferences.getString(campaign, null);
    }

    public void setCampaignLastUpdate(String campaign, String lastUpdate) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(campaign, lastUpdate);
        editor.apply();
    }

    public boolean setLatestCompletionsTime(String timestamp, String applicationKey, String userId) {
        String value = this.mSharedPreferences.getString("ssaUserData", null);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                JSONObject applicationKeyJson;
                JSONObject ssaUserDataJson = new JSONObject(value);
                if (!ssaUserDataJson.isNull(applicationKey) && !(applicationKeyJson = ssaUserDataJson.getJSONObject(applicationKey)).isNull(userId)) {
                    JSONObject userIdJson = applicationKeyJson.getJSONObject(userId);
                    userIdJson.put("timestamp", (Object)timestamp);
                    SharedPreferences.Editor editor = this.mSharedPreferences.edit();
                    editor.putString("ssaUserData", ssaUserDataJson.toString());
                    return editor.commit();
                }
            }
            catch (JSONException e2) {
                new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=" + e2.getStackTrace()[0].getMethodName()});
            }
        }
        return false;
    }
}

