/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.precache;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.ironsource.sdk.data.SSAFile;
import com.ironsource.sdk.precache.DownloadHandler;
import com.ironsource.sdk.precache.OnPreCacheCompletion;
import com.ironsource.sdk.precache.Utils;
import com.ironsource.sdk.utils.IronSourceStorageUtils;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;

public class DownloadManager {
    private static final String TAG = "DownloadManager";
    public static final int OPERATION_TIMEOUT = 5000;
    static final int MESSAGE_MALFORMED_URL_EXCEPTION = 1004;
    static final int MESSAGE_HTTP_NOT_FOUND = 1005;
    static final int MESSAGE_HTTP_EMPTY_RESPONSE = 1006;
    static final int MESSAGE_EMPTY_URL = 1007;
    static final int MESSAGE_SOCKET_TIMEOUT_EXCEPTION = 1008;
    static final int MESSAGE_IO_EXCEPTION = 1009;
    static final int MESSAGE_URI_SYNTAX_EXCEPTION = 1010;
    static final int MESSAGE_GENERAL_HTTP_ERROR_CODE = 1011;
    static final int MESSAGE_FILE_NOT_FOUND_EXCEPTION = 1018;
    static final int MESSAGE_OUT_OF_MEMORY_EXCEPTION = 1019;
    static final int MESSAGE_NUM_OF_BANNERS_TO_CACHE = 1013;
    static final int MESSAGE_FILE_DOWNLOAD_SUCCESS = 1016;
    static final int MESSAGE_FILE_DOWNLOAD_FAIL = 1017;
    static final int MESSAGE_TMP_FILE_RENAME_FAILED = 1020;
    protected static final String FILE_NOT_FOUND_EXCEPTION = "file not found exception";
    protected static final String OUT_OF_MEMORY_EXCEPTION = "out of memory exception";
    private static final String TEMP_DIR_FOR_FILES = "temp";
    private static final String TEMP_PREFIX_FOR_FILES = "tmp_";
    private DownloadHandler mDownloadHandler;
    public static final String FILE_ALREADY_EXIST = "file_already_exist";
    public static final String NO_DISK_SPACE = "no_disk_space";
    public static final String STORAGE_UNAVAILABLE = "sotrage_unavailable";
    public static final String NO_NETWORK_CONNECTION = "no_network_connection";
    private static final String UNABLE_TO_CREATE_FOLDER = "unable_to_create_folder";
    private static DownloadManager mDownloadManager;
    private Thread mMobileControllerThread;
    private final String mCacheRootDirectory;

    private DownloadManager(String cacheRootDirectory) {
        this.mCacheRootDirectory = cacheRootDirectory;
        this.mDownloadHandler = this.getDownloadHandler();
        IronSourceStorageUtils.deleteFolder(this.mCacheRootDirectory, TEMP_DIR_FOR_FILES);
        IronSourceStorageUtils.makeDir(this.mCacheRootDirectory, TEMP_DIR_FOR_FILES);
    }

    public static synchronized DownloadManager getInstance(String cacheRootDirectory) {
        if (mDownloadManager == null) {
            mDownloadManager = new DownloadManager(cacheRootDirectory);
        }
        return mDownloadManager;
    }

    static byte[] getBytes(InputStream in) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((bytesRead = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    DownloadHandler getDownloadHandler() {
        return new DownloadHandler();
    }

    public void setOnPreCacheCompletion(OnPreCacheCompletion listener) {
        this.mDownloadHandler.setOnPreCacheCompletion(listener);
    }

    public synchronized void release() {
        mDownloadManager = null;
        if (this.mDownloadHandler != null) {
            this.mDownloadHandler.release();
            this.mDownloadHandler = null;
        }
    }

    public void downloadFile(SSAFile file) {
        SingleFileWorkerThread worker = new SingleFileWorkerThread(file, this.mDownloadHandler, this.mCacheRootDirectory, this.getTempFilesDirectory());
        new Thread(worker).start();
    }

    public void downloadMobileControllerFile(SSAFile file) {
        SingleFileWorkerThread mobileControllerWorker = new SingleFileWorkerThread(file, this.mDownloadHandler, this.mCacheRootDirectory, this.getTempFilesDirectory());
        this.mMobileControllerThread = new Thread(mobileControllerWorker);
        this.mMobileControllerThread.start();
    }

    public boolean isMobileControllerThreadLive() {
        return this.mMobileControllerThread != null && this.mMobileControllerThread.isAlive();
    }

    String getTempFilesDirectory() {
        return this.mCacheRootDirectory + File.separator + TEMP_DIR_FOR_FILES;
    }

    static class Result {
        public String url;
        int responseCode;
        byte[] body;

        Result() {
        }
    }

    static class FileWorkerThread
    implements Callable<Result> {
        private String mFileUrl;
        private String mDirectory;
        private String mFileName;
        private long mConnectionRetries;
        private String mTmpFilesDirectory;

        public FileWorkerThread(String url, String directory, String fileName, long connectionRetries, String tmpFilesDirectory) {
            this.mFileUrl = url;
            this.mDirectory = directory;
            this.mFileName = fileName;
            this.mConnectionRetries = connectionRetries;
            this.mTmpFilesDirectory = tmpFilesDirectory;
        }

        int saveFile(byte[] data, String destFileName) throws Exception {
            return IronSourceStorageUtils.saveFile(data, destFileName);
        }

        boolean renameFile(String fromName, String toName) throws Exception {
            return IronSourceStorageUtils.renameFile(fromName, toName);
        }

        byte[] getBytes(InputStream in) throws IOException {
            return DownloadManager.getBytes(in);
        }

        @Override
        public Result call() {
            Result results = null;
            if (this.mConnectionRetries == 0L) {
                this.mConnectionRetries = 1L;
            }
            int tryIndex = 0;
            while ((long)tryIndex < this.mConnectionRetries) {
                results = this.downloadContent(this.mFileUrl, tryIndex);
                int responseCode = results.responseCode;
                if (responseCode != 1008 && responseCode != 1009) break;
                ++tryIndex;
            }
            if (null != results && null != results.body) {
                String origFileName = this.mDirectory + File.separator + this.mFileName;
                String tmpFileName = this.mTmpFilesDirectory + File.separator + DownloadManager.TEMP_PREFIX_FOR_FILES + this.mFileName;
                try {
                    int totalBytesRead = this.saveFile(results.body, tmpFileName);
                    if (totalBytesRead == 0) {
                        results.responseCode = 1006;
                    } else if (!this.renameFile(tmpFileName, origFileName)) {
                        results.responseCode = 1020;
                    }
                }
                catch (FileNotFoundException e2) {
                    results.responseCode = 1018;
                }
                catch (Exception e3) {
                    if (!TextUtils.isEmpty((CharSequence)e3.getMessage())) {
                        Logger.i(DownloadManager.TAG, e3.getMessage());
                    }
                    results.responseCode = 1009;
                }
                catch (Error err) {
                    if (!TextUtils.isEmpty((CharSequence)err.getMessage())) {
                        Logger.i(DownloadManager.TAG, err.getMessage());
                    }
                    results.responseCode = 1019;
                }
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result downloadContent(String url, int tryNumber) {
            Result results = new Result();
            HttpURLConnection connection = null;
            int responseCode = 0;
            if (TextUtils.isEmpty((CharSequence)url)) {
                results.url = url;
                results.responseCode = 1007;
                return results;
            }
            InputStream is = null;
            try {
                URL mUrl = new URL(url);
                mUrl.toURI();
                connection = (HttpURLConnection)mUrl.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.connect();
                responseCode = connection.getResponseCode();
                if (responseCode < 200 || responseCode >= 400) {
                    responseCode = 1011;
                } else {
                    is = connection.getInputStream();
                    results.body = this.getBytes(is);
                }
                if (responseCode != 200) {
                    Logger.i(DownloadManager.TAG, " RESPONSE CODE: " + responseCode + " URL: " + url + " ATTEMPT: " + tryNumber);
                }
            }
            catch (MalformedURLException e2) {
                responseCode = 1004;
            }
            catch (URISyntaxException e3) {
                responseCode = 1010;
            }
            catch (SocketTimeoutException e4) {
                responseCode = 1008;
            }
            catch (FileNotFoundException e5) {
                responseCode = 1018;
            }
            catch (Exception e6) {
                if (!TextUtils.isEmpty((CharSequence)e6.getMessage())) {
                    Logger.i(DownloadManager.TAG, e6.getMessage());
                }
                responseCode = 1009;
            }
            catch (Error err) {
                responseCode = 1019;
                if (!TextUtils.isEmpty((CharSequence)err.getMessage())) {
                    Logger.i(DownloadManager.TAG, err.getMessage());
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e7) {
                    e7.printStackTrace();
                }
                if (connection != null) {
                    connection.disconnect();
                }
                results.url = url;
                results.responseCode = responseCode;
            }
            return results;
        }
    }

    static class SingleFileWorkerThread
    implements Runnable {
        private final long DEFAULT_CONNECTION_RETRIES = 3L;
        private final String mTempFilesDirectory;
        Handler mDownloadHandler;
        private String mFile;
        private String mPath;
        private String mFileName;
        private long mConnectionRetries;
        private String mCacheRootDirectory;

        SingleFileWorkerThread(SSAFile file, Handler downloadHandler, String cacheRootDir, String tempFilesDirectory) {
            this.mFile = file.getFile();
            this.mPath = file.getPath();
            this.mFileName = this.guessFileName(this.mFile);
            this.mConnectionRetries = 3L;
            this.mCacheRootDirectory = cacheRootDir;
            this.mDownloadHandler = downloadHandler;
            this.mTempFilesDirectory = tempFilesDirectory;
        }

        String guessFileName(String file) {
            return SDKUtils.getFileName(this.mFile);
        }

        FileWorkerThread getFileWorkerThread(String url, String directory, String fileName, long connectionRetries, String tmpFilesDirectory) {
            return new FileWorkerThread(url, directory, fileName, connectionRetries, tmpFilesDirectory);
        }

        Message getMessage() {
            return new Message();
        }

        String makeDir(String cacheRootDirectory, String directory) {
            return IronSourceStorageUtils.makeDir(cacheRootDirectory, directory);
        }

        @Override
        public void run() {
            SSAFile ssaFile = new SSAFile(this.mFileName, this.mPath);
            Message msg = this.getMessage();
            msg.obj = ssaFile;
            String folderName = this.makeDir(this.mCacheRootDirectory, this.mPath);
            if (folderName == null) {
                msg.what = 1017;
                ssaFile.setErrMsg(DownloadManager.UNABLE_TO_CREATE_FOLDER);
                this.mDownloadHandler.sendMessage(msg);
                return;
            }
            FileWorkerThread fileWorkerThread = this.getFileWorkerThread(this.mFile, folderName, ssaFile.getFile(), this.mConnectionRetries, this.mTempFilesDirectory);
            Result results = fileWorkerThread.call();
            int code = results.responseCode;
            msg.what = 1016;
            if (code != 200) {
                msg.what = 1017;
                ssaFile.setErrMsg(Utils.convertErrorCodeToMessage(code));
            }
            this.mDownloadHandler.sendMessage(msg);
        }
    }
}

