/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.text.TextUtils;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.ISNAdView.ISNAdViewDelegate;
import com.ironsource.sdk.controller.WebViewMessagingMediator;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.WPADUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class BannerJSAdapter
implements ISNAdViewDelegate {
    private static final String TAG = BannerJSAdapter.class.getSimpleName();
    private ISNAdView mIsnAdView;
    private WebViewMessagingMediator mControllerMessageMediator;
    public static final String FUNCTION_NAME = "functionName";
    public static final String FUNCTION_PARAMS = "functionParams";
    public static final String SUCCESS = "success";
    public static final String FAIL = "fail";

    public void setCommunicationWithController(WebViewMessagingMediator delegate) {
        this.mControllerMessageMediator = delegate;
    }

    public void setCommunicationWithAdView(ISNAdView adView) {
        this.mIsnAdView = adView;
        this.mIsnAdView.setControllerDelegate(this);
    }

    @Override
    public void sendMessageToController(String message, JSONObject params) {
        if (this.mControllerMessageMediator != null && !TextUtils.isEmpty((CharSequence)message)) {
            this.mControllerMessageMediator.sendMessageToController(message, params);
        }
    }

    @Override
    public void sendErrorMessageToController(String failureMethod, String errorMessage, String adViewId) {
        JSONObject errorObject = WPADUtils.buildErrorObject(errorMessage, adViewId);
        this.sendMessageToController(failureMethod, errorObject);
    }

    void sendMessageToISNAdView(String message) {
        try {
            JSONObject functionData = new JSONObject(message);
            String functionName = functionData.optString(FUNCTION_NAME);
            JSONObject functionParams = functionData.optJSONObject(FUNCTION_PARAMS);
            String successMethod = functionData.optString(SUCCESS);
            String failureMethod = functionData.optString(FAIL);
            if (TextUtils.isEmpty((CharSequence)functionName)) {
                Logger.i(TAG, "BannerJSAdapter | sendMessageToISNAdView | Invalid message format: " + message);
                return;
            }
            if (this.mIsnAdView == null) {
                this.sendErrorMessageToController(failureMethod, "Send message to ISNAdView failed", "");
                return;
            }
            this.mIsnAdView.receiveMessageFromController(functionName, functionParams, successMethod, failureMethod);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }
}

