/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.WPAD;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.ironsource.sdk.Events.ISNEventParams;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.SDK5Events;
import com.ironsource.sdk.ISNAdView.ISNAdViewDelegate;
import com.ironsource.sdk.ISNAdView.ISNAdViewLogic;
import com.ironsource.sdk.ISNAdView.ISNAdViewWebClient;
import com.ironsource.sdk.WPAD.ISNAdViewJSInterface;
import com.ironsource.sdk.WPAD.ISNAdViewProtocol;
import com.ironsource.sdk.utils.IronSourceStorageUtils;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.WebViewUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ISNAdunitWebView
implements ISNAdViewProtocol {
    private String mAdViewId;
    private WebView mWebView;
    private ISNAdViewLogic mIsnAdViewLogic;
    private String mCacheDirectory;
    private static String WEBVIEW_IS_NOT_NULL = "loadWithUrl | webView is not null";
    private static final String FILE_PREFIX = "file://";
    private Activity mActivity;
    private String TAG = ISNAdunitWebView.class.getSimpleName();

    public ISNAdunitWebView(ISNAdViewDelegate delegate, Activity activity, String id) {
        this.mActivity = activity;
        this.mIsnAdViewLogic = new ISNAdViewLogic();
        this.mIsnAdViewLogic.setAdViewId(id);
        this.mCacheDirectory = this.initializeCacheDirectory(activity.getApplicationContext());
        this.mAdViewId = id;
        this.mIsnAdViewLogic.setControllerDelegate(delegate);
    }

    String initializeCacheDirectory(Context context) {
        return IronSourceStorageUtils.initializeCacheDirectory(context);
    }

    private void createWebView(final String failureMethod) {
        Logger.i(this.TAG, "createWebView");
        this.mWebView = new WebView((Context)this.mActivity);
        this.mWebView.addJavascriptInterface((Object)new ISNAdViewJSInterface(this), "containerMsgHandler");
        this.mWebView.setWebViewClient((WebViewClient)new ISNAdViewWebClient(new ISNAdViewProtocol.IErrorReportDelegate(){

            @Override
            public void reportOnError(String errMessage) {
                Logger.i(ISNAdunitWebView.this.TAG, "createWebView failed!");
                ISNAdunitWebView.this.mIsnAdViewLogic.sendErrorMessageToController(failureMethod, errMessage);
            }
        }));
        WebViewUtils.setWebViewSettings(this.mWebView);
        this.mIsnAdViewLogic.setAdViewWebView(this.mWebView);
        this.mIsnAdViewLogic.setAdViewIdentifier(this.mAdViewId);
    }

    @Override
    public WebView getViewToPresent() {
        return this.mWebView;
    }

    @Override
    public void loadWithUrl(final JSONObject params, final String successCallback, final String failureMethod) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ISNAdunitWebView.this.mWebView != null) {
                    ISNEventsTracker.logEvent(SDK5Events.adunitCouldNotLoadToWebView, new ISNEventParams().addPair("callfailreason", WEBVIEW_IS_NOT_NULL).getData());
                }
                try {
                    ISNAdunitWebView.this.createWebView(failureMethod);
                    String adunitUrl = ISNAdunitWebView.this.createAdunitUrl(params.getString("urlForWebView"));
                    ISNAdunitWebView.this.mWebView.loadUrl(adunitUrl);
                    JSONObject response = new JSONObject();
                    response.put("adViewId", (Object)ISNAdunitWebView.this.mAdViewId);
                    ISNAdunitWebView.this.mIsnAdViewLogic.sendMessageToController(successCallback, response);
                }
                catch (Exception e2) {
                    ISNAdunitWebView.this.mIsnAdViewLogic.sendErrorMessageToController(failureMethod, e2.getMessage());
                    ISNEventsTracker.logEvent(SDK5Events.adunitCouldNotLoadToWebView, new ISNEventParams().addPair("callfailreason", e2.getMessage()).getData());
                }
            }
        });
    }

    @Override
    public void sendIsExternalAdViewInitiated(final String successMethod) {
        this.mWebView.post(new Runnable(){

            @Override
            public void run() {
                ISNAdunitWebView.this.mIsnAdViewLogic.sendIsExternalAdViewInitiated(successMethod);
            }
        });
    }

    private String createAdunitUrl(String urlForWebView) {
        String url = urlForWebView;
        if (this.isRelativePath(urlForWebView)) {
            url = FILE_PREFIX + this.mCacheDirectory + this.removePreFixOfRelativePath(urlForWebView);
        }
        return url;
    }

    private String removePreFixOfRelativePath(String urlForWebView) {
        String first = urlForWebView.substring(urlForWebView.indexOf("/") + 1);
        return first.substring(first.indexOf("/"));
    }

    private boolean isRelativePath(String urlForWebView) {
        return urlForWebView.startsWith(".");
    }

    @Override
    public void sendMessageToAd(JSONObject params, String successMethod, String failureMethod) throws JSONException {
        try {
            this.mIsnAdViewLogic.sendMessageToAdunit(params.getString("params"), successMethod, failureMethod);
        }
        catch (Exception e2) {
            Logger.i(this.TAG, "sendMessageToAd fail message: " + e2.getMessage());
            throw e2;
        }
    }

    @JavascriptInterface
    public void handleMessageFromAd(String message) {
        this.mIsnAdViewLogic.handleMessageFromWebView(message);
    }

    @Override
    public synchronized void performCleanup(final String successCallback, final String failureCallback) {
        if (this.mActivity == null) {
            return;
        }
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    Logger.i(ISNAdunitWebView.this.TAG, "perforemCleanup");
                    try {
                        if (ISNAdunitWebView.this.mWebView != null) {
                            ISNAdunitWebView.this.mWebView.destroy();
                        }
                        JSONObject responseParams = new JSONObject();
                        responseParams.put("adViewId", (Object)ISNAdunitWebView.this.mAdViewId);
                        ISNAdunitWebView.this.mIsnAdViewLogic.sendMessageToController(successCallback, responseParams);
                        ISNAdunitWebView.this.mIsnAdViewLogic.destroy();
                        ISNAdunitWebView.this.mIsnAdViewLogic = null;
                        ISNAdunitWebView.this.mActivity = null;
                    }
                    catch (Exception e2) {
                        Log.e((String)ISNAdunitWebView.this.TAG, (String)("performCleanup | could not destroy ISNAdView webView ID: " + ISNAdunitWebView.this.mAdViewId));
                        ISNEventsTracker.logEvent(SDK5Events.webViewCleanUpFailed, new ISNEventParams().addPair("callfailreason", e2.getMessage()).getData());
                        if (ISNAdunitWebView.this.mIsnAdViewLogic == null) break block3;
                        ISNAdunitWebView.this.mIsnAdViewLogic.sendErrorMessageToController(failureCallback, e2.getMessage());
                    }
                }
            }
        });
    }
}

