/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.ISNAdView;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import com.ironsource.sdk.ISNAdView.ISNAdViewDelegate;
import com.ironsource.sdk.ISNAdView.ViewVisibilityParameters;
import org.json.JSONException;
import org.json.JSONObject;

public class ISNAdViewLogic {
    private JSONObject mAdViewConfiguration = null;
    private static Handler mUIThreadHandler;
    private ISNAdViewDelegate mDelegate;
    private ViewVisibilityParameters mAdViewVisibilityParameters;
    private WebView mWebView;
    private String mAdViewId;
    private String TAG = ISNAdViewLogic.class.getSimpleName();
    private String[] commandsToHandleInAdView = new String[]{"handleGetViewVisibility"};
    private final String[] supportedCommandsFromController = new String[]{"loadWithUrl", "updateAd", "isExternalAdViewInitiated", "handleGetViewVisibility", "sendMessage"};

    public ISNAdViewLogic() {
        this.mAdViewVisibilityParameters = new ViewVisibilityParameters();
    }

    public void setAdViewId(String adViewId) {
        this.mAdViewId = adViewId;
    }

    public void setControllerDelegate(ISNAdViewDelegate delegate) {
        this.mDelegate = delegate;
    }

    public String getAdViewId() {
        return this.mAdViewId;
    }

    private Handler getUIThreadHandler() {
        try {
            if (mUIThreadHandler == null) {
                mUIThreadHandler = new Handler(Looper.getMainLooper());
            }
        }
        catch (Exception e2) {
            Log.e((String)this.TAG, (String)"Error while trying execute method getUIThreadHandler");
            e2.printStackTrace();
        }
        return mUIThreadHandler;
    }

    public void setAdViewWebView(WebView webview) {
        this.mWebView = webview;
    }

    public void setAdViewIdentifier(String id) {
        this.mAdViewConfiguration = new JSONObject();
        try {
            this.mAdViewConfiguration.put("externalAdViewId", (Object)id);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    public void destroy() {
        this.mAdViewConfiguration = null;
        this.mDelegate = null;
        this.mAdViewVisibilityParameters = null;
        mUIThreadHandler = null;
    }

    JSONObject buildDataForLoadingAd(JSONObject loadParams, String containerIdentifier) throws Exception {
        try {
            boolean isInReload = this.isInReload();
            if (this.mAdViewConfiguration == null) {
                this.mAdViewConfiguration = new JSONObject(loadParams.toString());
            }
            this.mAdViewConfiguration.put("externalAdViewId", (Object)containerIdentifier);
            this.mAdViewConfiguration.put("isInReload", isInReload);
            return this.mAdViewConfiguration;
        }
        catch (Exception e2) {
            throw new Exception("ISNAdViewLogic | buildDataForLoadingAd | Could not build load parameters");
        }
    }

    private boolean isInReload() {
        return this.mAdViewConfiguration != null;
    }

    public void sendMessageToController(String message, JSONObject params) {
        if (this.mDelegate != null) {
            this.mDelegate.sendMessageToController(message, params);
        }
    }

    public void sendErrorMessageToController(String failureMethod, String errorMessage) {
        if (this.mDelegate != null) {
            this.mDelegate.sendErrorMessageToController(failureMethod, errorMessage, this.mAdViewId);
        }
    }

    void handleMessageFromController(final String functionName, final JSONObject functionParams, final String successMethod, final String failureMethod) {
        this.getUIThreadHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!ISNAdViewLogic.this.canHandleCommandFromController(functionName)) {
                        String errorMessage = "ISNAdViewLogic | handleMessageFromController | cannot handle command: " + functionName;
                        Log.e((String)ISNAdViewLogic.this.TAG, (String)errorMessage);
                        ISNAdViewLogic.this.mDelegate.sendErrorMessageToController(failureMethod, errorMessage, ISNAdViewLogic.this.mAdViewId);
                        return;
                    }
                    if (functionName.equalsIgnoreCase("isExternalAdViewInitiated")) {
                        ISNAdViewLogic.this.sendIsExternalAdViewInitiated(successMethod);
                    } else if (functionName.equalsIgnoreCase("handleGetViewVisibility")) {
                        ISNAdViewLogic.this.sendHandleGetViewVisibilityParams(successMethod);
                    } else if (functionName.equalsIgnoreCase("sendMessage") || functionName.equalsIgnoreCase("updateAd")) {
                        ISNAdViewLogic.this.sendMessageToAdunit(functionParams.getString("params"), successMethod, failureMethod);
                    } else {
                        String errorMessage = "ISNAdViewLogic | handleMessageFromController | unhandled API request " + functionName + " " + functionParams.toString();
                        Log.e((String)ISNAdViewLogic.this.TAG, (String)errorMessage);
                        ISNAdViewLogic.this.mDelegate.sendErrorMessageToController(failureMethod, errorMessage, ISNAdViewLogic.this.mAdViewId);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    String errorMessage = "ISNAdViewLogic | handleMessageFromController | Error while trying handle message: " + functionName;
                    Log.e((String)ISNAdViewLogic.this.TAG, (String)errorMessage);
                    ISNAdViewLogic.this.mDelegate.sendErrorMessageToController(failureMethod, errorMessage, ISNAdViewLogic.this.mAdViewId);
                }
            }
        });
    }

    private boolean canHandleCommandFromController(String command) {
        boolean isCommandFoundInCommandsArray = false;
        for (int i = 0; i < this.supportedCommandsFromController.length && !isCommandFoundInCommandsArray; ++i) {
            if (!this.supportedCommandsFromController[i].equalsIgnoreCase(command)) continue;
            isCommandFoundInCommandsArray = true;
        }
        return isCommandFoundInCommandsArray;
    }

    public void updateViewVisibilityParameters(String keyToUpdate, int newVisibilityState, boolean isShownValueToUpdate) {
        this.mAdViewVisibilityParameters.updateViewVisibilityParameters(keyToUpdate, newVisibilityState, isShownValueToUpdate);
        if (this.shouldReportVisibilityToController(keyToUpdate)) {
            this.reportAdContainerIsVisible();
        }
    }

    private boolean shouldReportVisibilityToController(String keyToUpdate) {
        if (Build.VERSION.SDK_INT <= 22) {
            return keyToUpdate.equalsIgnoreCase("isWindowVisible");
        }
        return keyToUpdate.equalsIgnoreCase("isVisible");
    }

    private void reportAdContainerIsVisible() {
        if (this.mDelegate == null || this.mAdViewVisibilityParameters == null) {
            return;
        }
        JSONObject impressionParams = this.buildParamsObjectForAdViewVisibility();
        this.sendMessageToController("containerIsVisible", impressionParams);
    }

    public void reportAdContainerWasRemoved() {
        if (this.mDelegate == null || this.mAdViewVisibilityParameters == null) {
            return;
        }
        JSONObject destructionParams = this.buildParamsObjectForAdViewVisibility();
        this.sendMessageToController("containerWasRemoved", destructionParams);
    }

    private JSONObject buildParamsObjectForAdViewVisibility() {
        return new JSONObject(){
            {
                try {
                    this.put("configs", ISNAdViewLogic.this.extendConfigurationWithVisibilityParams(ISNAdViewLogic.this.mAdViewConfiguration, ISNAdViewLogic.this.mAdViewVisibilityParameters.collectVisibilityParameters()));
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
        };
    }

    private JSONObject extendConfigurationWithVisibilityParams(JSONObject config, JSONObject visibilityParams) {
        try {
            JSONObject extendedConfigs = new JSONObject(config.toString());
            extendedConfigs.put("visibilityParams", (Object)visibilityParams);
            return extendedConfigs;
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            return config;
        }
    }

    public void sendIsExternalAdViewInitiated(String successMethod) {
        try {
            boolean isExternalAdViewInitiated = this.mWebView != null && this.mWebView.getUrl() != null;
            JSONObject containerAdViewStatusParams = new JSONObject();
            containerAdViewStatusParams.put("isExternalAdViewInitiated", isExternalAdViewInitiated);
            containerAdViewStatusParams.put("adViewId", (Object)this.mAdViewId);
            this.sendMessageToController(successMethod, containerAdViewStatusParams);
        }
        catch (Exception e2) {
            Log.e((String)this.TAG, (String)"Error while trying execute method sendIsExternalAdViewInitiated");
            e2.printStackTrace();
        }
    }

    private void sendHandleGetViewVisibilityParams(String successMethod) throws JSONException {
        JSONObject messageParams = this.mAdViewVisibilityParameters.collectVisibilityParameters();
        messageParams.put("adViewId", (Object)this.mAdViewId);
        this.sendMessageToController(successMethod, messageParams);
    }

    public void sendMessageToAdunit(String params, String successMethod, String failureMethod) throws JSONException {
        if (this.mWebView == null) {
            String errorMessage = "No external adunit attached to ISNAdView while trying to send message: " + params;
            Log.e((String)this.TAG, (String)errorMessage);
            this.mDelegate.sendErrorMessageToController(failureMethod, errorMessage, this.mAdViewId);
            return;
        }
        try {
            new JSONObject(params);
        }
        catch (JSONException e2) {
            params = "\"" + params + "\"";
        }
        final String command = this.buildCommandForWebView(params);
        this.getUIThreadHandler().post(new Runnable(){

            @Override
            public void run() {
                ISNAdViewLogic.this.injectJavaScriptIntoWebView(command);
            }
        });
        JSONObject messageParams = new JSONObject();
        messageParams.put("adViewId", (Object)this.mAdViewId);
        this.sendMessageToController(successMethod, messageParams);
    }

    private String buildCommandForWebView(String params) {
        return String.format("window.ssa.onMessageReceived(%1$s)", params);
    }

    private void injectJavaScriptIntoWebView(String command) {
        try {
            String url = "javascript:try{" + command + "}catch(e){console.log(\"JS exception: \" + JSON.stringify(e));}";
            if (Build.VERSION.SDK_INT >= 19) {
                this.mWebView.evaluateJavascript(url, null);
            } else {
                this.mWebView.loadUrl(url);
            }
        }
        catch (Throwable t) {
            Log.e((String)this.TAG, (String)("injectJavaScriptIntoWebView | Error while trying inject JS into external adunit: " + command + "Android API level: " + Build.VERSION.SDK_INT));
            t.printStackTrace();
        }
    }

    public void handleMessageFromWebView(String data) {
        try {
            JSONObject params = new JSONObject(data);
            String method = params.optString("method");
            if (!TextUtils.isEmpty((CharSequence)method) && this.shouldHandleMessageInContainer(method)) {
                if (method.equalsIgnoreCase("handleGetViewVisibility")) {
                    this.sendHandleGetViewVisibilityParamsForWebView(params);
                }
            } else {
                this.sendMessageToController("containerSendMessage", params);
            }
        }
        catch (JSONException e2) {
            Log.e((String)this.TAG, (String)("ISNAdViewLogic | receiveMessageFromExternal | Error while trying handle message: " + data));
            e2.printStackTrace();
        }
    }

    private boolean shouldHandleMessageInContainer(String message) {
        for (int i = 0; i < this.commandsToHandleInAdView.length; ++i) {
            if (!this.commandsToHandleInAdView[i].equalsIgnoreCase(message)) continue;
            return true;
        }
        return false;
    }

    private void sendHandleGetViewVisibilityParamsForWebView(JSONObject params) throws JSONException {
        String visibilityMsgToAdunit = this.buildVisibilityMessageForAdunit(params).toString();
        this.sendMessageToAdunit(visibilityMsgToAdunit, null, null);
    }

    private JSONObject buildVisibilityMessageForAdunit(JSONObject params) {
        JSONObject visibilityMessage = new JSONObject();
        try {
            visibilityMessage.put("id", (Object)params.getString("id"));
            visibilityMessage.put("data", (Object)this.mAdViewVisibilityParameters.collectVisibilityParameters());
        }
        catch (Exception e2) {
            Log.e((String)this.TAG, (String)("Error while trying execute method buildVisibilityMessageForAdunit | params: " + params));
            e2.printStackTrace();
        }
        return visibilityMessage;
    }
}

