/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.Events;

import android.util.Log;
import com.ironsource.eventsTracker.EventsConfiguration;
import com.ironsource.eventsTracker.EventsTracker;
import com.ironsource.sdk.Events.ISNEventsBaseData;
import com.ironsource.sdk.Events.SDK5Events;
import java.util.HashMap;
import java.util.Map;

public class ISNEventsTracker {
    private static ISNEventsTracker eventsTrackerInstance = null;
    private EventsTracker eventsTracker;

    private ISNEventsTracker() {
    }

    private static ISNEventsTracker getInstance() {
        if (eventsTrackerInstance == null) {
            eventsTrackerInstance = new ISNEventsTracker();
        }
        return eventsTrackerInstance;
    }

    public static void init(EventsConfiguration eventsConfigurations, ISNEventsBaseData eventsBaseData) {
        try {
            if (eventsConfigurations != null) {
                ISNEventsTracker.getInstance().eventsTracker = new EventsTracker(eventsConfigurations, eventsBaseData);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void logEvent(SDK5Events.Event event) {
        ISNEventsTracker.logEvent(event, new HashMap<String, Object>());
    }

    public static void logEvent(SDK5Events.Event event, Map<String, Object> params) {
        EventsTracker tracker = ISNEventsTracker.getInstance().eventsTracker;
        if (tracker == null) {
            Log.d((String)"sdk5Events", (String)"logEvent failed eventsTracker doesn't exist");
            return;
        }
        if (params != null) {
            params.put("eventid", event.id);
        }
        tracker.log(event.name, params);
    }
}

