/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.timer;

import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractTimer<T> {
    private Timer mTimer;
    private long mDuration;
    protected T mListener;

    public AbstractTimer(long duration) {
        this.mDuration = duration;
    }

    protected boolean isDisabled() {
        return this.mDuration <= 0L;
    }

    abstract void onTick();

    protected void startTimer(T listener) {
        if (this.isDisabled()) {
            return;
        }
        if (listener == null) {
            return;
        }
        this.mListener = listener;
        this.stopTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractTimer.this.onTick();
            }
        }, this.mDuration);
    }

    protected void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }
}

