/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.metadata;

import com.ironsource.mediationsdk.metadata.MetaData;
import java.util.ArrayList;
import java.util.List;

public class MetaDataUtils {
    public static MetaData.MetaDataValueTypes getValueTypeForKey(String key) {
        if (key.equalsIgnoreCase("do_not_sell")) {
            return MetaData.MetaDataValueTypes.META_DATA_VALUE_BOOLEAN;
        }
        return MetaData.MetaDataValueTypes.META_DATA_VALUE_STRING;
    }

    public static boolean isKnownKey(String key) {
        return key.equalsIgnoreCase("do_not_sell");
    }

    public static String formatValueForType(String value, MetaData.MetaDataValueTypes valueType) {
        String formattedValue = value;
        if (valueType == MetaData.MetaDataValueTypes.META_DATA_VALUE_BOOLEAN) {
            formattedValue = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") ? "true" : (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") ? "false" : "");
        }
        return formattedValue;
    }

    public static MetaData formatMetaData(String key, List<String> values) {
        if (!MetaDataUtils.isKnownKey(key)) {
            MetaData metaData = new MetaData(key, values);
            return metaData;
        }
        String formattedKey = key.toLowerCase();
        ArrayList<MetaData.MetaDataValueTypes> valuesType = new ArrayList<MetaData.MetaDataValueTypes>();
        ArrayList<String> formattedValues = new ArrayList<String>();
        for (String value : values) {
            MetaData.MetaDataValueTypes valueType = MetaDataUtils.getValueTypeForKey(formattedKey);
            String formattedValue = MetaDataUtils.formatValueForType(value, valueType);
            valuesType.add(valueType);
            formattedValues.add(formattedValue);
        }
        MetaData formattedMetaData = new MetaData(formattedKey, formattedValues, valuesType);
        return formattedMetaData;
    }

    public static String checkMetaDataKeyValidity(String key) {
        if (key == null || key.length() > 64 || !key.matches("[A-Za-z0-9_\\-.]+")) {
            return "The MetaData key you entered is invalid. Please enter a key of maximum 64 characters that consists of only letters, digits and the following characters: . - _";
        }
        return "";
    }

    public static String checkMetaDataValueValidity(List<String> values) {
        if (values.size() == 0) {
            return "The MetaData list should include at least one element.";
        }
        for (String value : values) {
            if (value != null && value.length() <= 64 && value.matches("[A-Za-z0-9_\\-.]+")) continue;
            return "The MetaData value(s) you entered is invalid. Please enter a value of maximum 64 characters that consists of only letters, digits and the following characters: . - _";
        }
        return "";
    }

    public static boolean isValidCCPAMetaData(String key, String value) {
        return key.equals("do_not_sell") && value.length() > 0;
    }

    public static boolean getMetaDataBooleanValue(String value) {
        return !value.equals("false");
    }
}

