/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.events;

import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.events.BaseEventsManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;

public class InterstitialEventsManager
extends BaseEventsManager {
    private static InterstitialEventsManager sInstance;
    private String mCurrentISPlacement;

    private InterstitialEventsManager() {
        this.mFormatterType = "ironbeast";
        this.mAdUnitType = 2;
        this.mEventType = "IS";
        this.mCurrentISPlacement = "";
    }

    public static synchronized InterstitialEventsManager getInstance() {
        if (sInstance == null) {
            sInstance = new InterstitialEventsManager();
            sInstance.initState();
        }
        return sInstance;
    }

    @Override
    protected boolean shouldExtractCurrentPlacement(EventData event) {
        return false;
    }

    @Override
    protected boolean shouldIncludeCurrentPlacement(EventData event) {
        return false;
    }

    @Override
    protected boolean isTriggerEvent(EventData currentEvent) {
        int eventId = currentEvent.getEventId();
        return eventId == 2204 || eventId == 2004 || eventId == 2005 || eventId == 2301 || eventId == 2300 || eventId == 3005 || eventId == 3015;
    }

    @Override
    protected int getSessionDepth(EventData event) {
        boolean isBanner = event.getEventId() >= 3000 && event.getEventId() < 4000;
        return SessionDepthManager.getInstance().getSessionDepth(isBanner ? 3 : 2);
    }

    @Override
    protected void setCurrentPlacement(EventData event) {
        this.mCurrentISPlacement = event.getAdditionalDataJSON().optString("placement");
    }

    @Override
    protected String getCurrentPlacement(int eventId) {
        return this.mCurrentISPlacement;
    }

    @Override
    protected void initConnectivitySensitiveEventsSet() {
        this.mConnectivitySensitiveEventsSet.add(2001);
        this.mConnectivitySensitiveEventsSet.add(2002);
        this.mConnectivitySensitiveEventsSet.add(2003);
        this.mConnectivitySensitiveEventsSet.add(2004);
        this.mConnectivitySensitiveEventsSet.add(2200);
        this.mConnectivitySensitiveEventsSet.add(2211);
        this.mConnectivitySensitiveEventsSet.add(2212);
    }
}

