/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.DemandOnlySmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.DemandOnlyIsManagerListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;

public class DemandOnlyIsSmash
extends DemandOnlySmash
implements InterstitialSmashListener {
    private DemandOnlyIsManagerListener mListener;
    private long mLoadStartTime;

    public DemandOnlyIsSmash(String appKey, String userId, ProviderSettings settings, DemandOnlyIsManagerListener listener, int loadTimeout, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getInterstitialSettings()), adapter);
        this.mListener = listener;
        this.mLoadTimeoutSecs = loadTimeout;
        this.mAdapter.initInterstitial(appKey, userId, this.mAdUnitSettings, this);
    }

    public void loadInterstitial(String serverData, String auctionId, List<String> bUrl) {
        this.logInternal("loadInterstitial state=" + this.getStateString());
        DemandOnlySmash.SMASH_STATE currentState = this.compareAndSetState(new DemandOnlySmash.SMASH_STATE[]{DemandOnlySmash.SMASH_STATE.NOT_LOADED, DemandOnlySmash.SMASH_STATE.LOADED}, DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS);
        if (currentState == DemandOnlySmash.SMASH_STATE.NOT_LOADED || currentState == DemandOnlySmash.SMASH_STATE.LOADED) {
            this.mLoadStartTime = new Date().getTime();
            this.startLoadTimer();
            if (this.isBidder()) {
                this.mAuctionId = auctionId;
                this.mBUrl = bUrl;
                this.mAdapter.loadInterstitialForBidding(this.mAdUnitSettings, this, serverData);
            } else {
                this.mAdapter.loadInterstitial(this.mAdUnitSettings, this);
            }
        } else if (currentState == DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            IronSourceError error = new IronSourceError(1050, "load already in progress");
            this.mListener.onInterstitialAdLoadFailed(error, this, 0L);
        } else {
            IronSourceError error = new IronSourceError(1050, "cannot load because show is in progress");
            this.mListener.onInterstitialAdLoadFailed(error, this, 0L);
        }
    }

    public void showInterstitial() {
        this.logInternal("showInterstitial state=" + this.getStateString());
        if (this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOADED, DemandOnlySmash.SMASH_STATE.SHOW_IN_PROGRESS)) {
            this.mAdapter.showInterstitial(this.mAdUnitSettings, this);
        } else {
            IronSourceError error = new IronSourceError(1051, "load must be called before show");
            this.mListener.onInterstitialAdShowFailed(error, this);
        }
    }

    public boolean isInterstitialReady() {
        return this.mAdapter.isInterstitialReady(this.mAdUnitSettings);
    }

    private void startLoadTimer() {
        this.logInternal("start timer");
        this.startTimer(new TimerTask(){

            @Override
            public void run() {
                DemandOnlyIsSmash.this.logInternal("load timed out state=" + DemandOnlyIsSmash.this.getStateString());
                if (DemandOnlyIsSmash.this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS, DemandOnlySmash.SMASH_STATE.NOT_LOADED)) {
                    long elapsedTime = new Date().getTime() - DemandOnlyIsSmash.this.mLoadStartTime;
                    DemandOnlyIsSmash.this.mListener.onInterstitialAdLoadFailed(new IronSourceError(1052, "load timed out"), DemandOnlyIsSmash.this, elapsedTime);
                }
            }
        });
    }

    @Override
    public void onInterstitialInitSuccess() {
    }

    @Override
    public void onInterstitialInitFailed(IronSourceError error) {
    }

    @Override
    public void onInterstitialAdReady() {
        this.logAdapterCallback("onInterstitialAdReady state=" + this.getStateString());
        this.stopTimer();
        if (this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS, DemandOnlySmash.SMASH_STATE.LOADED)) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onInterstitialAdReady(this, elapsedTime);
        }
    }

    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error) {
        this.logAdapterCallback("onInterstitialAdLoadFailed error=" + error.getErrorMessage() + " state=" + this.getStateString());
        this.stopTimer();
        if (this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS, DemandOnlySmash.SMASH_STATE.NOT_LOADED)) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onInterstitialAdLoadFailed(error, this, elapsedTime);
        }
    }

    @Override
    public void onInterstitialAdOpened() {
        this.logAdapterCallback("onInterstitialAdOpened");
        this.mListener.onInterstitialAdOpened(this);
    }

    @Override
    public void onInterstitialAdClosed() {
        this.setState(DemandOnlySmash.SMASH_STATE.NOT_LOADED);
        this.logAdapterCallback("onInterstitialAdClosed");
        this.mListener.onInterstitialAdClosed(this);
    }

    @Override
    public void onInterstitialAdShowSucceeded() {
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error) {
        this.setState(DemandOnlySmash.SMASH_STATE.NOT_LOADED);
        this.logAdapterCallback("onInterstitialAdShowFailed error=" + error.getErrorMessage());
        this.mListener.onInterstitialAdShowFailed(error, this);
    }

    @Override
    public void onInterstitialAdClicked() {
        this.logAdapterCallback("onInterstitialAdClicked");
        this.mListener.onInterstitialAdClicked(this);
    }

    @Override
    public void onInterstitialAdVisible() {
        this.logAdapterCallback("onInterstitialAdVisible");
        this.mListener.onInterstitialAdVisible(this);
    }

    private void logAdapterCallback(String line) {
        String text = "DemandOnlyInterstitialSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "DemandOnlyInterstitialSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

