/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.impressionData.ImpressionData;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.logger.IronLog;

public abstract class BaseProgManager {
    private ImpressionDataListener impressionDataListener;

    public BaseProgManager(ImpressionDataListener impressionDataListener) {
        this.impressionDataListener = impressionDataListener;
    }

    public void setImpressionDataListener(ImpressionDataListener impressionDataListener) {
        this.impressionDataListener = impressionDataListener;
    }

    protected void reportImpressionDataToPublisher(AuctionResponseItem auctionResponseItem, String placementName) {
        if (auctionResponseItem != null && this.impressionDataListener != null) {
            ImpressionData impressionData = auctionResponseItem.getImpressionData(placementName);
            if (impressionData != null) {
                IronLog.CALLBACK.info("onImpressionSuccess: " + impressionData);
                this.impressionDataListener.onImpressionSuccess(impressionData);
            }
        } else {
            IronLog.INTERNAL.verbose("no auctionResponseItem or listener");
        }
    }

    protected String getAuctionFallbackId() {
        return "fallback_" + System.currentTimeMillis();
    }
}

