/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AdaptersCompatibilityHandler;
import com.ironsource.mediationsdk.BannerCallbackThrottler;
import com.ironsource.mediationsdk.BannerSmash;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.BannerManagerListener;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class BannerManager
implements BannerManagerListener {
    private BannerSmash mActiveSmash;
    private IronSourceBannerLayout mIronsourceBanner;
    private BannerPlacement mCurrentPlacement;
    private BANNER_STATE mState;
    private IronSourceLoggerManager mLoggerManager;
    private String mAppKey;
    private String mUserId;
    private final CopyOnWriteArrayList<BannerSmash> mSmashArray = new CopyOnWriteArrayList();
    private long mReloadInterval;
    private Timer mReloadTimer;
    private Boolean mIsInForeground = true;
    AtomicBoolean mDidImplementOnResume;
    AtomicBoolean mDidImplementOnPause;

    public BannerManager(List<ProviderSettings> adaptersConfigs, String appKey, String userId, long timeout, int reloadInterval, int delayLoadFailure) {
        this.mLoggerManager = IronSourceLoggerManager.getLogger();
        this.mState = BANNER_STATE.NOT_INITIATED;
        this.mDidImplementOnPause = new AtomicBoolean();
        this.mDidImplementOnResume = new AtomicBoolean();
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mReloadInterval = reloadInterval;
        BannerCallbackThrottler.getInstance().setDelayLoadFailureNotificationInSeconds(delayLoadFailure);
        for (int i = 0; i < adaptersConfigs.size(); ++i) {
            ProviderSettings config = adaptersConfigs.get(i);
            AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(config, config.getBannerSettings());
            if (adapter != null && AdaptersCompatibilityHandler.getInstance().isBannerAdapterCompatible(adapter)) {
                BannerSmash smash = new BannerSmash(this, config, adapter, timeout, i + 1);
                this.mSmashArray.add(smash);
                continue;
            }
            this.debugLog(config.getProviderInstanceName() + " can't load adapter or wrong version");
        }
        this.mCurrentPlacement = null;
        this.setState(BANNER_STATE.READY_TO_LOAD);
    }

    public synchronized void loadBanner(IronSourceBannerLayout banner, BannerPlacement placement) {
        try {
            if (banner == null || banner.isDestroyed()) {
                String errorMessage = String.format("can't load banner - %s", banner == null ? "banner is null" : "banner is destroyed");
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, errorMessage, 3);
                return;
            }
            if (placement == null || TextUtils.isEmpty((CharSequence)placement.getPlacementName())) {
                String errorMessage = String.format("can't load banner - %s", placement == null ? "placement is null" : "placement name is empty");
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, errorMessage, 3);
                return;
            }
            if (this.mState != BANNER_STATE.READY_TO_LOAD || BannerCallbackThrottler.getInstance().hasPendingInvocation()) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "A banner is already loaded", 3);
                return;
            }
            this.setState(BANNER_STATE.FIRST_LOAD_IN_PROGRESS);
            this.mIronsourceBanner = banner;
            this.mCurrentPlacement = placement;
            this.sendMediationEvent(3001);
            if (CappingManager.isBnPlacementCapped((Context)ContextProvider.getInstance().getCurrentActiveActivity(), placement.getPlacementName())) {
                BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(604, "placement " + placement.getPlacementName() + " is capped"));
                this.sendMediationEvent(3111, new Object[][]{{"errorCode", 604}});
                this.setState(BANNER_STATE.READY_TO_LOAD);
                return;
            }
            for (BannerSmash smash : this.mSmashArray) {
                smash.setReadyToLoad(true);
            }
            BannerSmash smash = this.mSmashArray.get(0);
            this.sendProviderEvent(3002, smash);
            smash.loadBanner(banner, this.mAppKey, this.mUserId);
        }
        catch (Exception e2) {
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(605, "loadBanner() failed " + e2.getMessage()));
            this.sendMediationEvent(3111, new Object[][]{{"errorCode", 605}, {"reason", e2.getMessage()}});
            this.setState(BANNER_STATE.READY_TO_LOAD);
        }
    }

    public synchronized void destroyBanner(IronSourceBannerLayout banner) {
        if (banner == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "destroyBanner banner cannot be null", 3);
            return;
        }
        if (banner.isDestroyed()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Banner is already destroyed and can't be used anymore. Please create a new one using IronSource.createBanner API", 3);
            return;
        }
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(3);
        this.sendMediationEvent(3100, new Object[][]{{"sessionDepth", sessionDepth}});
        this.stopReloadTimer();
        if (this.mActiveSmash != null) {
            this.sendProviderEvent(3305, this.mActiveSmash, new Object[][]{{"sessionDepth", sessionDepth}});
            SessionDepthManager.getInstance().increaseSessionDepth(3);
            this.mActiveSmash.destroyBanner();
            this.mActiveSmash = null;
        }
        banner.destroyBanner();
        this.mIronsourceBanner = null;
        this.mCurrentPlacement = null;
        this.setState(BANNER_STATE.READY_TO_LOAD);
    }

    private void errorLog(String text) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "BannerManager " + text, 3);
    }

    private void debugLog(String text) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "BannerManager " + text, 0);
    }

    private void setState(BANNER_STATE state) {
        this.mState = state;
        this.debugLog("state=" + state.name());
    }

    private void callbackLog(String text, BannerSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "BannerManager " + text + " " + smash.getName(), 0);
    }

    private void bindView(BannerSmash smash, View adView, FrameLayout.LayoutParams frameLayoutParams) {
        this.mActiveSmash = smash;
        this.mIronsourceBanner.addViewWithFrameLayoutParams(adView, frameLayoutParams);
    }

    @Override
    public void onBannerAdLoaded(BannerSmash smash, View adView, FrameLayout.LayoutParams frameLayoutParams) {
        this.callbackLog("onBannerAdLoaded", smash);
        if (this.mState == BANNER_STATE.FIRST_LOAD_IN_PROGRESS) {
            this.sendProviderEvent(3005, smash);
            this.bindView(smash, adView, frameLayoutParams);
            String placementName = this.mCurrentPlacement != null ? this.mCurrentPlacement.getPlacementName() : "";
            CappingManager.incrementBnShowCounter((Context)ContextProvider.getInstance().getCurrentActiveActivity(), placementName);
            if (CappingManager.isBnPlacementCapped((Context)ContextProvider.getInstance().getCurrentActiveActivity(), placementName)) {
                this.sendMediationEvent(3400);
            }
            this.mIronsourceBanner.sendBannerAdLoaded(smash.getName());
            this.sendMediationEvent(3110);
            this.setState(BANNER_STATE.RELOAD_IN_PROGRESS);
            this.startReloadTimer();
        } else if (this.mState == BANNER_STATE.LOAD_IN_PROGRESS) {
            this.sendProviderEvent(3015, smash);
            this.bindView(smash, adView, frameLayoutParams);
            this.setState(BANNER_STATE.RELOAD_IN_PROGRESS);
            this.startReloadTimer();
        }
    }

    @Override
    public void onBannerAdLoadFailed(IronSourceError error, BannerSmash smash, boolean isNoFillError) {
        this.callbackLog("onBannerAdLoadFailed " + error.getErrorMessage(), smash);
        if (this.mState != BANNER_STATE.FIRST_LOAD_IN_PROGRESS && this.mState != BANNER_STATE.LOAD_IN_PROGRESS) {
            this.debugLog("onBannerAdLoadFailed " + smash.getName() + " wrong state=" + this.mState.name());
            return;
        }
        if (isNoFillError) {
            this.sendProviderEvent(3306, smash);
        } else {
            this.sendProviderEvent(3300, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        }
        if (this.loadNextSmash()) {
            return;
        }
        if (this.mState == BANNER_STATE.FIRST_LOAD_IN_PROGRESS) {
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(this.mIronsourceBanner, new IronSourceError(606, "No ads to show"));
            this.sendMediationEvent(3111, new Object[][]{{"errorCode", 606}});
            this.setState(BANNER_STATE.READY_TO_LOAD);
        } else {
            this.sendMediationEvent(3201);
            this.setState(BANNER_STATE.RELOAD_IN_PROGRESS);
            this.startReloadTimer();
        }
    }

    @Override
    public void onBannerAdReloaded(BannerSmash smash, View adView, FrameLayout.LayoutParams frameLayoutParams, boolean bindView) {
        this.callbackLog("onBannerAdReloaded", smash);
        if (this.mState != BANNER_STATE.RELOAD_IN_PROGRESS) {
            this.debugLog("onBannerAdReloaded " + smash.getName() + " wrong state=" + this.mState.name());
            return;
        }
        IronSourceUtils.sendAutomationLog("bannerReloadSucceeded");
        this.sendProviderEvent(3015, smash);
        this.callbackLog("bindView = " + bindView, smash);
        if (bindView) {
            this.bindView(smash, adView, frameLayoutParams);
        }
        this.startReloadTimer();
    }

    @Override
    public void onBannerAdReloadFailed(IronSourceError error, BannerSmash smash, boolean isNoFillError) {
        this.callbackLog("onBannerAdReloadFailed " + error.getErrorMessage(), smash);
        if (this.mState != BANNER_STATE.RELOAD_IN_PROGRESS) {
            this.debugLog("onBannerAdReloadFailed " + smash.getName() + " wrong state=" + this.mState.name());
            return;
        }
        if (isNoFillError) {
            this.sendProviderEvent(3307, smash);
        } else {
            this.sendProviderEvent(3301, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        }
        if (this.mSmashArray.size() == 1) {
            this.sendMediationEvent(3201);
            this.startReloadTimer();
            return;
        }
        this.setState(BANNER_STATE.LOAD_IN_PROGRESS);
        this.resetIteration();
        this.loadNextSmash();
    }

    @Override
    public void onBannerAdClicked(BannerSmash smash) {
        this.callbackLog("onBannerAdClicked", smash);
        Object[][] eventData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronsourceBanner.sendBannerAdClicked();
        } else {
            eventData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3112, eventData);
        this.sendProviderEvent(3008, smash, eventData);
    }

    @Override
    public void onBannerAdScreenDismissed(BannerSmash smash) {
        this.callbackLog("onBannerAdScreenDismissed", smash);
        Object[][] eventData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronsourceBanner.sendBannerAdScreenDismissed();
        } else {
            eventData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3114, eventData);
        this.sendProviderEvent(3303, smash, eventData);
    }

    @Override
    public void onBannerAdScreenPresented(BannerSmash smash) {
        this.callbackLog("onBannerAdScreenPresented", smash);
        Object[][] eventData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronsourceBanner.sendBannerAdScreenPresented();
        } else {
            eventData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3113, eventData);
        this.sendProviderEvent(3302, smash, eventData);
    }

    @Override
    public void onBannerAdLeftApplication(BannerSmash smash) {
        this.callbackLog("onBannerAdLeftApplication", smash);
        Object[][] eventData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronsourceBanner.sendBannerAdLeftApplication();
        } else {
            eventData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3115, eventData);
        this.sendProviderEvent(3304, smash, eventData);
    }

    private boolean canSendBannerCallbacks() {
        return this.mIronsourceBanner != null && !this.mIronsourceBanner.isDestroyed();
    }

    private void sendMediationEvent(int eventId) {
        this.sendMediationEvent(eventId, null);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
        try {
            if (this.mIronsourceBanner != null) {
                this.addEventSizeFields(data, this.mIronsourceBanner.getSize());
            }
            if (this.mCurrentPlacement != null) {
                data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
            }
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private void sendProviderEvent(int eventId, BannerSmash smash) {
        this.sendProviderEvent(eventId, smash, null);
    }

    private void addEventSizeFields(JSONObject data, ISBannerSize size) {
        try {
            switch (size.getDescription()) {
                case "BANNER": {
                    data.put("bannerAdSize", 1);
                    break;
                }
                case "LARGE": {
                    data.put("bannerAdSize", 2);
                    break;
                }
                case "RECTANGLE": {
                    data.put("bannerAdSize", 3);
                    break;
                }
                case "SMART": {
                    data.put("bannerAdSize", 5);
                    break;
                }
                case "CUSTOM": {
                    data.put("bannerAdSize", 6);
                    data.put("custom_banner_size", (Object)(size.getWidth() + "x" + size.getHeight()));
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
    }

    private void sendProviderEvent(int eventId, BannerSmash smash, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            if (this.mIronsourceBanner != null) {
                this.addEventSizeFields(data, this.mIronsourceBanner.getSize());
            }
            if (this.mCurrentPlacement != null) {
                data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
            }
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private void resetIteration() {
        for (BannerSmash smash : this.mSmashArray) {
            smash.setReadyToLoad(true);
        }
    }

    private boolean loadNextSmash() {
        for (BannerSmash smash : this.mSmashArray) {
            if (!smash.isReadyToLoad() || this.mActiveSmash == smash) continue;
            if (this.mState == BANNER_STATE.FIRST_LOAD_IN_PROGRESS) {
                this.sendProviderEvent(3002, smash);
            } else {
                this.sendProviderEvent(3012, smash);
            }
            smash.loadBanner(this.mIronsourceBanner, this.mAppKey, this.mUserId);
            return true;
        }
        return false;
    }

    public void onPause() {
        this.mIsInForeground = false;
    }

    public void onResume() {
        this.mIsInForeground = true;
    }

    private void startReloadTimer() {
        try {
            this.stopReloadTimer();
            if (this.mReloadInterval > 0L) {
                this.mReloadTimer = new Timer();
                this.mReloadTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        BannerManager.this.onReloadTimer();
                    }
                }, this.mReloadInterval * 1000L);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void stopReloadTimer() {
        if (this.mReloadTimer != null) {
            this.mReloadTimer.cancel();
            this.mReloadTimer = null;
        }
    }

    private void onReloadTimer() {
        if (this.mState != BANNER_STATE.RELOAD_IN_PROGRESS) {
            this.debugLog("onReloadTimer wrong state=" + this.mState.name());
            return;
        }
        if (this.mIsInForeground.booleanValue()) {
            this.sendMediationEvent(3011);
            this.sendProviderEvent(3012, this.mActiveSmash);
            this.mActiveSmash.reloadBanner();
        } else {
            this.sendMediationEvent(3200, new Object[][]{{"errorCode", 614}});
            this.startReloadTimer();
        }
    }

    private static enum BANNER_STATE {
        NOT_INITIATED,
        READY_TO_LOAD,
        FIRST_LOAD_IN_PROGRESS,
        LOAD_IN_PROGRESS,
        RELOAD_IN_PROGRESS;

    }
}

