/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AuctionHistory {
    public static final int NO_LIMIT = -1;
    public static final int DISABLED_FEATURE = 0;
    private ConcurrentHashMap<String, ArrayList<ISAuctionPerformance>> auctionPerformance;
    private int historyLimit;

    public AuctionHistory(List<String> waterfall, int limit) {
        this.historyLimit = limit;
        this.auctionPerformance = new ConcurrentHashMap();
        for (String instanceName : waterfall) {
            ArrayList instancePerformance = new ArrayList();
            this.auctionPerformance.put(instanceName, instancePerformance);
        }
    }

    public void storeWaterfallPerformance(ConcurrentHashMap<String, ISAuctionPerformance> waterfallPerformance) {
        if (this.historyLimit == 0) {
            return;
        }
        Set instancesNamesSet = this.auctionPerformance.keySet();
        for (String instanceName : instancesNamesSet) {
            ISAuctionPerformance instancePerformance = ISAuctionPerformance.ISAuctionPerformanceNotPartOfWaterfall;
            if (waterfallPerformance.containsKey(instanceName)) {
                instancePerformance = waterfallPerformance.get(instanceName);
            }
            ArrayList<ISAuctionPerformance> instanceStoredPerformance = this.auctionPerformance.get(instanceName);
            if (this.historyLimit != -1 && instanceStoredPerformance.size() == this.historyLimit) {
                instanceStoredPerformance.remove(0);
            }
            instanceStoredPerformance.add(instancePerformance);
        }
    }

    public String getStoredPerformanceForInstance(String instanceName) {
        ArrayList<ISAuctionPerformance> performanceArray = this.auctionPerformance.get(instanceName);
        if (performanceArray != null && !performanceArray.isEmpty()) {
            Iterator<ISAuctionPerformance> it = performanceArray.iterator();
            String performanceString = "";
            performanceString = performanceString + it.next().ordinal();
            while (it.hasNext()) {
                performanceString = performanceString + ",";
                performanceString = performanceString + it.next().ordinal();
            }
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, instanceName + " stored performance: : " + performanceString, 1);
            return performanceString;
        }
        return "";
    }

    public static enum ISAuctionPerformance {
        ISAuctionPerformanceDidntAttemptToLoad,
        ISAuctionPerformanceFailedToLoad,
        ISAuctionPerformanceLoadedSuccessfully,
        ISAuctionPerformanceFailedToShow,
        ISAuctionPerformanceShowedSuccessfully,
        ISAuctionPerformanceNotPartOfWaterfall;

    }
}

