/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.eventsTracker;

import android.util.Log;
import android.util.Pair;
import com.ironsource.eventsTracker.EventsConfiguration;
import com.ironsource.eventsTracker.IBaseData;
import com.ironsource.eventsTracker.IFormatter;
import com.ironsource.network.ISHttpService;
import com.ironsource.network.Response;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EventsTracker {
    private static final String TAG = "EventsTracker";
    private IBaseData _baseData;
    private EventsConfiguration _configuration;
    private IFormatter _formatter;
    private ExecutorService _logExecutorService;

    public EventsTracker(EventsConfiguration configuration, IBaseData baseData) {
        if (configuration == null) {
            throw new InvalidParameterException("Null configuration not supported ");
        }
        if (configuration.getFormatter() == null) {
            throw new InvalidParameterException("Null formatter not supported ");
        }
        this._configuration = configuration;
        this._baseData = baseData;
        this._formatter = configuration.getFormatter();
        this._logExecutorService = Executors.newSingleThreadExecutor();
    }

    public void log(String eventName, Map<String, Object> extraParameters) {
        this.logConsole(String.format(Locale.ENGLISH, "%s %s", eventName, extraParameters.toString()));
        if (!this._configuration.areEventsEnabled()) {
            return;
        }
        if (eventName.isEmpty()) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("eventname", eventName);
        this.append(dataMap, this._baseData.getData());
        this.append(dataMap, extraParameters);
        this.logEvent(this._formatter.format(dataMap));
    }

    private void append(Map<String, Object> data, Map<String, Object> dataToAppend) {
        try {
            data.putAll(dataToAppend);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logEvent(final String data) {
        this._logExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Response response = new Response();
                    ArrayList<Pair<String, String>> headers = EventsTracker.this._configuration.getHeaders();
                    if ("POST".equals(EventsTracker.this._configuration.getHttpMethod())) {
                        response = ISHttpService.sendPOSTRequest(EventsTracker.this._configuration.getEndpoint(), data, headers);
                    } else if ("GET".equals(EventsTracker.this._configuration.getHttpMethod())) {
                        response = ISHttpService.sendGETRequest(EventsTracker.this._configuration.getEndpoint(), data, headers);
                    }
                    EventsTracker.this.logConsole("response status code: " + response.responseCode);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    private void logConsole(String message) {
        if (this._configuration.isAllowLogs()) {
            Log.d((String)TAG, (String)message);
        }
    }
}

