/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.BannerSmash;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.logger.ThreadExceptionHandler;
import com.ironsource.mediationsdk.sdk.GeneralProperties;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceUtils {
    private static final String ADAPTER_VERSION_KEY = "providerAdapterVersion";
    private static final String BROWSER_USER_AGENT = "browser_user_agent";
    private static final String DEFAULT_IS_EVENTS_FORMATTER_TYPE = "default_is_events_formatter_type";
    private static final String DEFAULT_IS_EVENTS_URL = "default_is_events_url";
    private static final String DEFAULT_IS_NON_CONNECTIVITY_EVENTS = "default_is_non_connectivity_events";
    private static final String DEFAULT_IS_OPT_IN_EVENTS = "default_is_opt_in_events";
    private static final String DEFAULT_IS_OPT_OUT_EVENTS = "default_is_opt_out_events";
    private static final String DEFAULT_IS_TRIGGER_EVENTS = "default_is_trigger_events";
    private static final String DEFAULT_RV_EVENTS_FORMATTER_TYPE = "default_rv_events_formatter_type";
    private static final String DEFAULT_RV_EVENTS_URL = "default_rv_events_url";
    private static final String DEFAULT_RV_NON_CONNECTIVITY_EVENTS = "default_rv_non_connectivity_events";
    private static final String DEFAULT_RV_OPT_IN_EVENTS = "default_rv_opt_in_events";
    private static final String DEFAULT_RV_OPT_OUT_EVENTS = "default_rv_opt_out_events";
    private static final String DEFAULT_RV_TRIGGER_EVENTS = "default_rv_trigger_events";
    public static final String KEY = "C38FB23A402222A0C17D34A92F971D1F";
    private static final String GENERAL_PROPERTIES = "general_properties";
    private static final String LAST_RESPONSE = "last_response";
    private static final String PROVIDER_KEY = "provider";
    private static final String PROVIDER_PRIORITY = "providerPriority";
    private static final String SDK_VERSION = "7.0.4.1";
    private static final String SDK_VERSION_KEY = "providerSDKVersion";
    private static final String SHARED_PREFERENCES_NAME = "Mediation_Shared_Preferences";
    private static final String SUB_PROVIDER_ID_KEY = "spId";
    private static int serr = 1;
    private static AtomicBoolean mDidCreateSessionID = new AtomicBoolean(false);
    private static String mSessionId = null;
    private static Boolean mFirstSession = null;

    private static void setSerr(int value) {
        serr = value;
    }

    public static int getSerr() {
        return serr;
    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (Throwable e2) {
            if (input == null) {
                IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "getMD5(input:null)", e2);
            } else {
                IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "getMD5(input:" + input + ")", e2);
            }
            return "";
        }
    }

    private static String getSHA256(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, digest);
            return String.format("%064x", number);
        }
        catch (NoSuchAlgorithmException e2) {
            if (input == null) {
                IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "getSHA256(input:null)", e2);
            } else {
                IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "getSHA256(input:" + input + ")", e2);
            }
            return "";
        }
    }

    public static String getTransId(String strToTransId) {
        return IronSourceUtils.getSHA256(strToTransId);
    }

    public static int getCurrentTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static String getConnectionType(Context c2) {
        String CONNECTION_WIFI = "WIFI";
        String CONNECTION_MOBILE = "MOBILE";
        String noneConnectionType = "none";
        String wifiConnectionType = "wifi";
        String cellularConnectionType = "cellular";
        if (c2 == null) {
            return "none";
        }
        ConnectivityManager cm = (ConnectivityManager)c2.getSystemService("connectivity");
        if (cm == null) {
            return "none";
        }
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = cm.getActiveNetwork();
            NetworkCapabilities mNetworkCapabilities = cm.getNetworkCapabilities(network);
            if (mNetworkCapabilities == null) {
                return "none";
            }
            if (mNetworkCapabilities.hasTransport(1)) {
                return "wifi";
            }
            if (mNetworkCapabilities.hasTransport(0)) {
                return "cellular";
            }
            return "none";
        }
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getTypeName().equalsIgnoreCase("WIFI")) {
                return "wifi";
            }
            if (info.getTypeName().equalsIgnoreCase("MOBILE")) {
                return "cellular";
            }
        } else {
            return "none";
        }
        return "none";
    }

    public static String getSDKVersion() {
        return SDK_VERSION;
    }

    public static void createAndStartWorker(Runnable runnable, String threadName) {
        Thread worker = new Thread(runnable, threadName);
        worker.setUncaughtExceptionHandler(new ThreadExceptionHandler());
        worker.start();
    }

    public static String getBase64Auth(String loginUsername, String loginPass) {
        String source = loginUsername + ":" + loginPass;
        return "Basic " + Base64.encodeToString((byte[])source.getBytes(), (int)10);
    }

    private static String getDefaultEventsUrlByEventType(String eventType) {
        if ("IS".equals(eventType)) {
            return DEFAULT_IS_EVENTS_URL;
        }
        if ("RV".equals(eventType)) {
            return DEFAULT_RV_EVENTS_URL;
        }
        return "";
    }

    private static String getDefaultOptOutEventsByEventType(String eventType) {
        if ("IS".equals(eventType)) {
            return DEFAULT_IS_OPT_OUT_EVENTS;
        }
        if ("RV".equals(eventType)) {
            return DEFAULT_RV_OPT_OUT_EVENTS;
        }
        return "";
    }

    private static String getDefaultOptInEventsByEventType(String eventType) {
        if ("IS".equals(eventType)) {
            return DEFAULT_IS_OPT_IN_EVENTS;
        }
        if ("RV".equals(eventType)) {
            return DEFAULT_RV_OPT_IN_EVENTS;
        }
        return "";
    }

    private static String getDefaultTriggerEventsByEventType(String eventType) {
        if ("IS".equals(eventType)) {
            return DEFAULT_IS_TRIGGER_EVENTS;
        }
        if ("RV".equals(eventType)) {
            return DEFAULT_RV_TRIGGER_EVENTS;
        }
        return "";
    }

    private static String getDefaultNonConnectivityEventsByEventType(String eventType) {
        if ("IS".equals(eventType)) {
            return DEFAULT_IS_NON_CONNECTIVITY_EVENTS;
        }
        if ("RV".equals(eventType)) {
            return DEFAULT_RV_NON_CONNECTIVITY_EVENTS;
        }
        return "";
    }

    private static String getDefaultFormatterTypeByEventType(String eventType) {
        if ("IS".equals(eventType)) {
            return DEFAULT_IS_EVENTS_FORMATTER_TYPE;
        }
        if ("RV".equals(eventType)) {
            return DEFAULT_RV_EVENTS_FORMATTER_TYPE;
        }
        return "";
    }

    public static synchronized void saveDefaultEventsURL(Context context, String eventType, String eventsUrl) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(IronSourceUtils.getDefaultEventsUrlByEventType(eventType), eventsUrl);
            editor.commit();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:saveDefaultEventsURL(eventType: " + eventType + ", eventsUrl:" + eventsUrl + ")", e2);
        }
    }

    public static synchronized void saveDefaultOptOutEvents(Context context, String eventType, int[] optOutEvents) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            String optOutEventsString = null;
            if (optOutEvents != null) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < optOutEvents.length; ++i) {
                    str.append(optOutEvents[i]).append(",");
                }
                optOutEventsString = str.toString();
            }
            editor.putString(IronSourceUtils.getDefaultOptOutEventsByEventType(eventType), optOutEventsString);
            editor.commit();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:saveDefaultOptOutEvents(eventType: " + eventType + ", optOutEvents:" + optOutEvents + ")", e2);
        }
    }

    public static synchronized void saveDefaultOptInEvents(Context context, String eventType, int[] optInEvents) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            String optInEventsString = null;
            if (optInEvents != null) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < optInEvents.length; ++i) {
                    str.append(optInEvents[i]).append(",");
                }
                optInEventsString = str.toString();
            }
            editor.putString(IronSourceUtils.getDefaultOptInEventsByEventType(eventType), optInEventsString);
            editor.commit();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:saveDefaultOptInEvents(eventType: " + eventType + ", optInEvents:" + optInEvents + ")", e2);
        }
    }

    public static synchronized void saveDefaultTriggerEvents(Context context, String eventType, int[] triggerEvents) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            String triggerEventsString = null;
            if (triggerEvents != null) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < triggerEvents.length; ++i) {
                    str.append(triggerEvents[i]).append(",");
                }
                triggerEventsString = str.toString();
            }
            editor.putString(IronSourceUtils.getDefaultTriggerEventsByEventType(eventType), triggerEventsString);
            editor.commit();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:saveDefaultTriggerEvents(eventType: " + eventType + ", triggerEvents:" + triggerEvents + ")", e2);
        }
    }

    public static synchronized void saveDefaultNonConnectivityEvents(Context context, String eventType, int[] nonConnectivityEvents) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            String nonConnectivityEventsString = null;
            if (nonConnectivityEvents != null) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < nonConnectivityEvents.length; ++i) {
                    str.append(nonConnectivityEvents[i]).append(",");
                }
                nonConnectivityEventsString = str.toString();
            }
            editor.putString(IronSourceUtils.getDefaultNonConnectivityEventsByEventType(eventType), nonConnectivityEventsString);
            editor.commit();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:saveDefaultNonConnectivityEvents(eventType: " + eventType + ", nonConnectivityEvents:" + nonConnectivityEvents + ")", e2);
        }
    }

    public static synchronized void saveDefaultEventsFormatterType(Context context, String eventType, String formatterType) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(IronSourceUtils.getDefaultFormatterTypeByEventType(eventType), formatterType);
            editor.commit();
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:saveDefaultEventsFormatterType(eventType: " + eventType + ", formatterType:" + formatterType + ")", e2);
        }
    }

    public static synchronized String getDefaultEventsFormatterType(Context context, String eventType, String defaultFormatterType) {
        String formatterType = defaultFormatterType;
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            formatterType = preferences.getString(IronSourceUtils.getDefaultFormatterTypeByEventType(eventType), defaultFormatterType);
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getDefaultEventsFormatterType(eventType: " + eventType + ", defaultFormatterType:" + defaultFormatterType + ")", e2);
        }
        return formatterType;
    }

    public static synchronized String getDefaultEventsURL(Context context, String eventType, String defaultEventsURL) {
        String serverUrl = defaultEventsURL;
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            serverUrl = preferences.getString(IronSourceUtils.getDefaultEventsUrlByEventType(eventType), defaultEventsURL);
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getDefaultEventsURL(eventType: " + eventType + ", defaultEventsURL:" + defaultEventsURL + ")", e2);
        }
        return serverUrl;
    }

    public static synchronized int[] getDefaultOptOutEvents(Context context, String eventType) {
        int[] optOutEvents = null;
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            String optOutEventsString = preferences.getString(IronSourceUtils.getDefaultOptOutEventsByEventType(eventType), null);
            if (!TextUtils.isEmpty((CharSequence)optOutEventsString)) {
                StringTokenizer stringTokenizer = new StringTokenizer(optOutEventsString, ",");
                ArrayList<Integer> result = new ArrayList<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    result.add(Integer.parseInt(stringTokenizer.nextToken()));
                }
                optOutEvents = new int[result.size()];
                for (int i = 0; i < optOutEvents.length; ++i) {
                    optOutEvents[i] = (Integer)result.get(i);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getDefaultOptOutEvents(eventType: " + eventType + ")", e2);
        }
        return optOutEvents;
    }

    public static synchronized void saveBrowserUserAgent(Context context, String browserUserAgent) {
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(BROWSER_USER_AGENT, browserUserAgent);
            editor.apply();
        }
        catch (Exception e2) {
            IronLog.NATIVE.error("failed to save browser user agent - exception = " + e2);
        }
    }

    public static synchronized String getBrowserUserAgent(Context context) {
        String browserUserAgent = "";
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            browserUserAgent = preferences.getString(BROWSER_USER_AGENT, "");
        }
        catch (Exception e2) {
            IronLog.NATIVE.error("failed to get browser user agent - exception = " + e2);
        }
        return browserUserAgent;
    }

    public static synchronized int[] getDefaultOptInEvents(Context context, String eventType) {
        int[] optInEvents = null;
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            String optInEventsString = preferences.getString(IronSourceUtils.getDefaultOptInEventsByEventType(eventType), null);
            if (!TextUtils.isEmpty((CharSequence)optInEventsString)) {
                StringTokenizer stringTokenizer = new StringTokenizer(optInEventsString, ",");
                ArrayList<Integer> result = new ArrayList<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    result.add(Integer.parseInt(stringTokenizer.nextToken()));
                }
                optInEvents = new int[result.size()];
                for (int i = 0; i < optInEvents.length; ++i) {
                    optInEvents[i] = (Integer)result.get(i);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getDefaultOptInEvents(eventType: " + eventType + ")", e2);
        }
        return optInEvents;
    }

    public static synchronized int[] getDefaultTriggerEvents(Context context, String eventType) {
        int[] triggerEvents = null;
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            String triggerEventsString = preferences.getString(IronSourceUtils.getDefaultTriggerEventsByEventType(eventType), null);
            if (!TextUtils.isEmpty((CharSequence)triggerEventsString)) {
                StringTokenizer stringTokenizer = new StringTokenizer(triggerEventsString, ",");
                ArrayList<Integer> result = new ArrayList<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    result.add(Integer.parseInt(stringTokenizer.nextToken()));
                }
                triggerEvents = new int[result.size()];
                for (int i = 0; i < triggerEvents.length; ++i) {
                    triggerEvents[i] = (Integer)result.get(i);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getDefaultTriggerEvents(eventType: " + eventType + ")", e2);
        }
        return triggerEvents;
    }

    public static synchronized int[] getDefaultNonConnectivityEvents(Context context, String eventType) {
        int[] nonConnectivityEvents = null;
        try {
            SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
            String nonConnectivityEventsString = preferences.getString(IronSourceUtils.getDefaultNonConnectivityEventsByEventType(eventType), null);
            if (!TextUtils.isEmpty((CharSequence)nonConnectivityEventsString)) {
                StringTokenizer stringTokenizer = new StringTokenizer(nonConnectivityEventsString, ",");
                ArrayList<Integer> result = new ArrayList<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    result.add(Integer.parseInt(stringTokenizer.nextToken()));
                }
                nonConnectivityEvents = new int[result.size()];
                for (int i = 0; i < nonConnectivityEvents.length; ++i) {
                    nonConnectivityEvents[i] = (Integer)result.get(i);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getDefaultNonConnectivityEvents(eventType: " + eventType + ")", e2);
        }
        return nonConnectivityEvents;
    }

    public static synchronized void saveLastResponse(Context context, String response) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(LAST_RESPONSE, response);
        editor.apply();
    }

    public static String getLastResponse(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return preferences.getString(LAST_RESPONSE, "");
    }

    static synchronized void saveGeneralProperties(Context context, JSONObject properties) {
        if (context == null || properties == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(GENERAL_PROPERTIES, properties.toString());
        editor.apply();
    }

    public static synchronized JSONObject getGeneralProperties(Context context) {
        JSONObject result = new JSONObject();
        if (context == null) {
            return result;
        }
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        String generalPropertiesString = preferences.getString(GENERAL_PROPERTIES, result.toString());
        try {
            result = new JSONObject(generalPropertiesString);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        if (activeNetwork == null) {
            return false;
        }
        return activeNetwork.isConnected();
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static JSONObject getProviderAdditionalData(AbstractSmash smash) {
        JSONObject data = new JSONObject();
        try {
            data.put(PROVIDER_PRIORITY, smash.getProviderPriority());
            data.put(SUB_PROVIDER_ID_KEY, (Object)smash.getSubProviderId());
            data.put(PROVIDER_KEY, (Object)smash.getAdSourceNameForEvents());
            data.put(SDK_VERSION_KEY, (Object)smash.getAdapter().getCoreSDKVersion());
            data.put(ADAPTER_VERSION_KEY, (Object)smash.getAdapter().getVersion());
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getProviderAdditionalData(adapter: " + smash.getName() + ")", e2);
        }
        return data;
    }

    public static JSONObject getProviderAdditionalData(BannerSmash smash) {
        JSONObject data = new JSONObject();
        try {
            data.put(SUB_PROVIDER_ID_KEY, (Object)smash.getSubProviderId());
            data.put(PROVIDER_KEY, (Object)smash.getAdSourceNameForEvents());
            data.put(SDK_VERSION_KEY, (Object)smash.getAdapter().getCoreSDKVersion());
            data.put(ADAPTER_VERSION_KEY, (Object)smash.getAdapter().getVersion());
            data.put(PROVIDER_PRIORITY, smash.getProviderPriority());
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "IronSourceUtils:getProviderAdditionalData(adapter: " + smash.getName() + ")", e2);
        }
        return data;
    }

    public static JSONObject getMediationAdditionalData(boolean isDemandOnlyMode) {
        return IronSourceUtils.getMediationAdditionalData(isDemandOnlyMode, false, 1);
    }

    public static JSONObject getJsonForUserId(boolean isDynamicUserId) {
        JSONObject data = new JSONObject();
        try {
            data.put(PROVIDER_KEY, (Object)"Mediation");
            if (isDynamicUserId) {
                data.put("ext1", (Object)"dynamic");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return data;
    }

    public static JSONObject getJsonForMetaData(String key, List<String> values, List<String> formattedValues) {
        JSONObject data = new JSONObject();
        try {
            data.put(PROVIDER_KEY, (Object)"Mediation");
            ArrayList<String> formattedValuesArray = new ArrayList<String>();
            int i = 0;
            for (int j = 0; i < values.size() && j < formattedValues.size(); ++i, ++j) {
                String value = values.get(i);
                String formattedValue = formattedValues.get(j);
                if (!TextUtils.isEmpty((CharSequence)formattedValue) && !value.equals(formattedValue)) {
                    value = value + ";" + formattedValue;
                }
                formattedValuesArray.add(value);
            }
            String extVal = key + ";" + TextUtils.join((CharSequence)",", formattedValuesArray);
            data.put("ext1", (Object)extVal);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return data;
    }

    public static JSONObject getMediationAdditionalData(boolean isDemandOnlyMode, boolean isProgrammatic, int programmaticMode) {
        JSONObject data = new JSONObject();
        try {
            data.put(PROVIDER_KEY, (Object)"Mediation");
            if (isDemandOnlyMode) {
                data.put("isDemandOnly", 1);
            }
            if (isProgrammatic) {
                data.put("programmatic", programmaticMode);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return data;
    }

    static void saveStringToSharedPrefs(Context context, String key, String value) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    static String getStringFromSharedPrefs(Context context, String key, String defaultValue) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return preferences.getString(key, defaultValue);
    }

    static void saveBooleanToSharedPrefs(Context context, String key, boolean value) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    static boolean getBooleanFromSharedPrefs(Context context, String key, boolean defaultValue) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return preferences.getBoolean(key, defaultValue);
    }

    static void saveIntToSharedPrefs(Context context, String key, int value) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    static int getIntFromSharedPrefs(Context context, String key, int defaultValue) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return preferences.getInt(key, defaultValue);
    }

    static void saveLongToSharedPrefs(Context context, String key, long value) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    static long getLongFromSharedPrefs(Context context, String key, long defaultValue) {
        SharedPreferences preferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return preferences.getLong(key, defaultValue);
    }

    public static JSONObject mergeJsons(JSONObject mainJson, JSONObject secondaryJson) {
        try {
            if (mainJson == null && secondaryJson == null) {
                return new JSONObject();
            }
            if (mainJson == null) {
                return secondaryJson;
            }
            if (secondaryJson == null) {
                return mainJson;
            }
            Iterator it = secondaryJson.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (mainJson.has(key)) continue;
                mainJson.put(key, secondaryJson.get(key));
            }
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        return mainJson;
    }

    public static synchronized void sendAutomationLog(String text) {
        String message = "automation_log:" + Long.toString(System.currentTimeMillis()) + " text: " + text;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, message, 1);
    }

    static Map<String, String> parseJsonToStringMap(JSONObject genericParams) {
        HashMap<String, String> genericParamsMap = new HashMap<String, String>();
        try {
            if (genericParams != JSONObject.NULL) {
                Iterator keys = genericParams.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (genericParams.get(key).toString().isEmpty()) continue;
                    genericParamsMap.put(key, genericParams.get(key).toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return genericParamsMap;
    }

    public static synchronized String getSessionId() {
        if (mDidCreateSessionID.compareAndSet(false, true)) {
            mSessionId = UUID.randomUUID().toString();
        }
        return mSessionId;
    }

    public static boolean getFirstSession(Context context) {
        if (mFirstSession == null) {
            mFirstSession = !IronSourceUtils.isInitResponseCached(context);
        }
        return mFirstSession;
    }

    public static String getUserIdForNetworks() {
        String userIdType = GeneralProperties.getProperties().get("userIdType");
        String userId = GeneralProperties.getProperties().get("userId");
        if (userIdType != null && userIdType.equals("userGenerated") && !TextUtils.isEmpty((CharSequence)userId)) {
            return userId;
        }
        return null;
    }

    public static String getMediationUserId() {
        return GeneralProperties.getProperties().get("userId");
    }

    public static boolean isAndroidXAvailable() {
        String androidxBaseClass = "androidx.appcompat.app.AppCompatActivity";
        try {
            Class.forName(androidxBaseClass);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isInitResponseCached(Context context) {
        String cachedAppKey = IronSourceUtils.getCachedValueByKeyOfCachedInitResponse(context, "appKey");
        String cachedUserId = IronSourceUtils.getCachedValueByKeyOfCachedInitResponse(context, "userId");
        String cachedSettings = IronSourceUtils.getCachedValueByKeyOfCachedInitResponse(context, "response");
        return !TextUtils.isEmpty((CharSequence)cachedAppKey) && !TextUtils.isEmpty((CharSequence)cachedUserId) && !TextUtils.isEmpty((CharSequence)cachedSettings);
    }

    private static JSONObject getCachedInitResponse(Context context) {
        JSONObject cachedJsonObject;
        String cachedResponseString = IronSourceUtils.getLastResponse(context);
        try {
            cachedJsonObject = new JSONObject(cachedResponseString);
        }
        catch (JSONException e2) {
            cachedJsonObject = new JSONObject();
        }
        return cachedJsonObject;
    }

    public static String getCachedValueByKeyOfCachedInitResponse(Context context, String key) {
        JSONObject cachedJsonObject = IronSourceUtils.getCachedInitResponse(context);
        String cachedKey = cachedJsonObject.optString(key);
        return cachedKey;
    }
}

