/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.LWSRvManagerListener;
import com.ironsource.mediationsdk.LoadWhileShowSupportState;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class LWSProgRvSmash
extends ProgSmash
implements RewardedVideoSmashListener {
    private SMASH_STATE mState;
    private LWSRvManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private String mAppKey;
    private String mUserId;
    private Placement mPlacement;
    private int mSessionDepth;
    private long mLoadStartTime;
    private String mAuctionId;
    private int mAuctionTrial;
    private String mAuctionFailReason;
    private final Object mStateLock = new Object();
    private final Object mTimerLock = new Object();
    private long mClosedTime;

    public LWSProgRvSmash(String appKey, String userId, ProviderSettings settings, LWSRvManagerListener listener, int loadTimeoutSecs, AbstractAdapter adapter, int sessionDepth) {
        super(new AdapterConfig(settings, settings.getRewardedVideoSettings()), adapter);
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeoutSecs;
        this.mAdapter.updateRewardedVideoListener(this);
        this.mSessionDepth = sessionDepth;
        this.mState = SMASH_STATE.NO_INIT;
        this.mClosedTime = 0L;
        if (this.mAdapterConfig.isBidder()) {
            this.initForBidding();
        }
    }

    public LWSProgRvSmash(LWSProgRvSmash otherSmash, LWSRvManagerListener listener, AbstractAdapter adapter, int sessionDepth, String waterfallId, int auctionTrial, String auctionFailReason) {
        this(otherSmash.mAppKey, otherSmash.mUserId, otherSmash.mAdapterConfig.getProviderSettings(), listener, otherSmash.mLoadTimeoutSecs, adapter, sessionDepth);
        this.mAuctionId = waterfallId;
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFailReason = auctionFailReason;
    }

    public boolean isLoadingInProgress() {
        return this.mState == SMASH_STATE.INIT_IN_PROGRESS || this.mState == SMASH_STATE.LOAD_IN_PROGRESS;
    }

    public boolean isLoaded() {
        return this.mState == SMASH_STATE.LOADED;
    }

    public Map<String, Object> getBiddingData() {
        try {
            return this.isBidder() ? this.mAdapter.getRewardedVideoBiddingData(this.mAdUnitSettings) : null;
        }
        catch (Throwable t) {
            this.logInternalError("getBiddingData exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5001}, {"reason", t.getLocalizedMessage()}});
            return null;
        }
    }

    private void initForBidding() {
        this.logInternal("initForBidding()");
        this.setState(SMASH_STATE.INIT_IN_PROGRESS);
        this.setCustomParams();
        try {
            this.mAdapter.initRewardedVideoForBidding(this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError("initForBidding exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.onRewardedVideoInitFailed(new IronSourceError(1040, t.getLocalizedMessage()));
        }
    }

    public boolean isRewardedVideoAvailable() {
        return this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
    }

    public boolean isReadyToShow() {
        try {
            if (this.isBidder()) {
                return this.mState == SMASH_STATE.LOADED && this.isRewardedVideoAvailable();
            }
            return this.isRewardedVideoAvailable();
        }
        catch (Throwable t) {
            this.logInternalError("isReadyToShow exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5002}, {"reason", t.getLocalizedMessage()}});
            return false;
        }
    }

    public LoadWhileShowSupportState getLoadWhileShowSupportState() {
        return this.mAdapter.getLoadWhileShowSupportState(this.mAdUnitSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVideo(String serverData) {
        SMASH_STATE currentState;
        this.logInternal("loadVideo() auctionId: " + this.mAuctionId + " state: " + (Object)((Object)this.mState));
        this.setIsLoadCandidate(false);
        Object object = this.mStateLock;
        synchronized (object) {
            currentState = this.mState;
            if (this.mState != SMASH_STATE.LOAD_IN_PROGRESS && this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
            }
        }
        if (currentState == SMASH_STATE.LOAD_IN_PROGRESS) {
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5003}, {"reason", "load during load"}});
            return;
        }
        if (currentState == SMASH_STATE.SHOW_IN_PROGRESS) {
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5004}, {"reason", "load during show"}});
            return;
        }
        this.startLoadTimer();
        this.mLoadStartTime = new Date().getTime();
        this.sendProviderEvent(1001);
        try {
            if (this.isBidder()) {
                this.mAdapter.loadRewardedVideoForBidding(this.mAdUnitSettings, this, serverData);
                return;
            }
            this.setCustomParams();
            this.mAdapter.initRewardedVideo(this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError("loadVideo exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5005}, {"reason", t.getLocalizedMessage()}});
        }
    }

    public void reportShowChance(boolean status) {
        this.sendProviderEventWithPlacement(1209, new Object[][]{{"status", status ? "true" : "false"}});
    }

    public void showVideo(Placement placement) {
        this.stopLoadTimer();
        this.logInternal("showVideo()");
        this.mPlacement = placement;
        this.setState(SMASH_STATE.SHOW_IN_PROGRESS);
        this.sendProviderEventWithPlacement(1201);
        try {
            this.mAdapter.showRewardedVideo(this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError("showVideo exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.onRewardedVideoAdShowFailed(new IronSourceError(1038, t.getLocalizedMessage()));
        }
    }

    public void setCappedPerSession() {
        this.mAdapter.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, "rewardedvideo");
        this.sendProviderEvent(1401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(SMASH_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = state;
        }
    }

    private void setCustomParams() {
        try {
            String pluginType;
            String segment = IronSourceObject.getInstance().getMediationSegment();
            if (!TextUtils.isEmpty((CharSequence)segment)) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
        }
        catch (Exception e2) {
            this.logInternal("setCustomParams() " + e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
        this.logInternal("onRewardedVideoAvailabilityChanged available=" + available + " state=" + this.mState.name());
        boolean isWrongSmashState = false;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == SMASH_STATE.LOAD_IN_PROGRESS) {
                this.setState(available ? SMASH_STATE.LOADED : SMASH_STATE.NOT_LOADED);
            } else {
                isWrongSmashState = true;
            }
        }
        if (isWrongSmashState) {
            if (available) {
                this.sendProviderEvent(1207, new Object[][]{{"ext1", this.mState.name()}});
            } else {
                this.sendProviderEvent(1208, new Object[][]{{"errorCode", 1034}, {"duration", this.getElapsedTime()}, {"ext1", this.mState.name()}});
            }
            return;
        }
        this.stopLoadTimer();
        this.sendProviderEvent(available ? 1002 : 1200, new Object[][]{{"duration", this.getElapsedTime()}});
        if (available) {
            this.mListener.onLoadSuccess(this);
        } else {
            this.mListener.onLoadError(this);
        }
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
        this.sendProviderEvent(1212, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", this.getElapsedTime()}});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        this.logInternal("onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
        this.sendProviderEventWithPlacement(1202, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5006}, {"reason", "showFailed: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.ENDED);
        }
        this.mListener.onRewardedVideoAdShowFailed(error, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitSuccess() {
        this.logInternal("onRewardedVideoInitSuccess");
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5007}, {"reason", "initSuccess: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.NOT_LOADED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
        this.logInternal("onRewardedVideoInitFailed error=" + error.getErrorMessage());
        this.stopLoadTimer();
        this.sendProviderEvent(1200, new Object[][]{{"errorCode", 1033}, {"duration", this.getElapsedTime()}});
        this.sendProviderEvent(1212, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", this.getElapsedTime()}});
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5008}, {"reason", "initFailed: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.NO_INIT);
        }
        this.mListener.onLoadError(this);
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.logInternal("onRewardedVideoAdOpened");
        this.mListener.onRewardedVideoAdOpened(this);
        this.sendProviderEventWithPlacement(1005);
    }

    @Override
    public void onRewardedVideoAdStarted() {
        this.logInternal("onRewardedVideoAdStarted");
        this.mListener.onRewardedVideoAdStarted(this);
        this.sendProviderEventWithPlacement(1204);
    }

    @Override
    public void onRewardedVideoAdVisible() {
        this.logInternal("onRewardedVideoAdVisible");
        this.sendProviderEventWithPlacement(1206);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed() {
        this.logInternal("onRewardedVideoAdClosed");
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                this.sendProviderEventWithPlacement(1203);
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5009}, {"reason", "adClosed: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.ENDED);
        }
        this.mClosedTime = new Date().getTime();
        this.mListener.onRewardedVideoAdClosed(this);
    }

    @Override
    public void onRewardedVideoAdEnded() {
        this.logInternal("onRewardedVideoAdEnded");
        this.mListener.onRewardedVideoAdEnded(this);
        this.sendProviderEventWithPlacement(1205);
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        this.logInternal("onRewardedVideoAdRewarded");
        long rewardedTime = new Date().getTime();
        this.mListener.onRewardedVideoAdRewarded(this, this.mPlacement);
        Map<String, Object> data = this.getProviderEventData();
        if (this.mPlacement != null) {
            data.put("placement", this.mPlacement.getPlacementName());
            data.put("rewardName", this.mPlacement.getRewardName());
            data.put("rewardAmount", this.mPlacement.getRewardAmount());
        }
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
            data.put("dynamicUserId", IronSourceObject.getInstance().getDynamicUserId());
        }
        if (IronSourceObject.getInstance().getRvServerParams() != null) {
            for (String key : IronSourceObject.getInstance().getRvServerParams().keySet()) {
                data.put("custom_" + key, IronSourceObject.getInstance().getRvServerParams().get(key));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAuctionId)) {
            data.put("auctionId", this.mAuctionId);
        }
        if (this.shouldAddAuctionParams(1010)) {
            RewardedVideoEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFailReason);
        }
        data.put("sessionDepth", this.mSessionDepth);
        EventData event = new EventData(1010, new JSONObject(data));
        String strToTransId = "" + Long.toString(event.getTimeStamp()) + this.mAppKey + this.getInstanceName();
        String transId = IronSourceUtils.getTransId(strToTransId);
        event.addToAdditionalData("transId", transId);
        if (this.mClosedTime != 0L) {
            long timeAfterClosed = rewardedTime - this.mClosedTime;
            this.logInternal("onRewardedVideoAdRewarded timeAfterClosed=" + timeAfterClosed);
            event.addToAdditionalData("duration", timeAfterClosed);
        }
        RewardedVideoEventsManager.getInstance().log(event);
    }

    @Override
    public void onRewardedVideoAdClicked() {
        this.logInternal("onRewardedVideoAdClicked");
        this.mListener.onRewardedVideoAdClicked(this, this.mPlacement);
        this.sendProviderEventWithPlacement(1006);
    }

    @Override
    public int getProgrammaticValue() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLoadTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
    }

    private long getElapsedTime() {
        return new Date().getTime() - this.mLoadStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    boolean shouldInvokeCallback = false;
                    int errorCode = 510;
                    String errorMessage = "Rewarded Video - load instance time out";
                    if (LWSProgRvSmash.this.mState == SMASH_STATE.LOAD_IN_PROGRESS || LWSProgRvSmash.this.mState == SMASH_STATE.INIT_IN_PROGRESS) {
                        if (LWSProgRvSmash.this.mState == SMASH_STATE.LOAD_IN_PROGRESS) {
                            errorCode = 1025;
                        } else {
                            errorCode = 1032;
                            errorMessage = "Rewarded Video - init instance time out";
                        }
                        LWSProgRvSmash.this.setState(SMASH_STATE.NOT_LOADED);
                        shouldInvokeCallback = true;
                    }
                    LWSProgRvSmash.this.logInternal(errorMessage);
                    if (shouldInvokeCallback) {
                        LWSProgRvSmash.this.sendProviderEvent(1200, new Object[][]{{"errorCode", errorCode}, {"duration", LWSProgRvSmash.this.getElapsedTime()}});
                        LWSProgRvSmash.this.sendProviderEvent(1212, new Object[][]{{"errorCode", errorCode}, {"reason", errorMessage}, {"duration", LWSProgRvSmash.this.getElapsedTime()}});
                        LWSProgRvSmash.this.mListener.onLoadError(LWSProgRvSmash.this);
                    } else {
                        LWSProgRvSmash.this.sendProviderEvent(1208, new Object[][]{{"errorCode", 1025}, {"duration", LWSProgRvSmash.this.getElapsedTime()}, {"ext1", LWSProgRvSmash.this.mState.name()}});
                    }
                }
            }, this.mLoadTimeoutSecs * 1000);
        }
    }

    public String getAuctionId() {
        return this.mAuctionId;
    }

    private void logInternal(String line) {
        String text = "LWSProgRvSmash " + this.getInstanceName() + " " + this.hashCode() + "  : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void logInternalError(String line) {
        String text = "LWSProgRvSmash " + this.getInstanceName() + " " + this.hashCode() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 3);
    }

    private void sendProviderEventWithPlacement(int eventId) {
        this.sendProviderEventWithPlacement(eventId, null);
    }

    public void sendProviderEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, true);
    }

    private void sendProviderEvent(int eventId) {
        this.sendProviderEvent(eventId, null, false);
    }

    public void sendProviderEvent(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, false);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        Map<String, Object> data = this.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)this.mAuctionId)) {
            data.put("auctionId", this.mAuctionId);
        }
        if (isAddPlacement && this.mPlacement != null && !TextUtils.isEmpty((CharSequence)this.mPlacement.getPlacementName())) {
            data.put("placement", this.mPlacement.getPlacementName());
        }
        if (this.shouldAddAuctionParams(eventId)) {
            RewardedVideoEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFailReason);
        }
        data.put("sessionDepth", this.mSessionDepth);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getInstanceName() + " smash: RV sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
        if (eventId == 1203) {
            SessionDepthManager.getInstance().increaseSessionDepth(1);
        }
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 1001 || eventId == 1002 || eventId == 1200 || eventId == 1005 || eventId == 1203 || eventId == 1201 || eventId == 1202 || eventId == 1006 || eventId == 1010;
    }

    protected static enum SMASH_STATE {
        NO_INIT,
        INIT_IN_PROGRESS,
        NOT_LOADED,
        LOAD_IN_PROGRESS,
        LOADED,
        SHOW_IN_PROGRESS,
        ENDED;

    }
}

