/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.metadata.MetaDataUtils;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceAdInstanceBuilder;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceAdapter
extends AbstractAdapter
implements ContextProvider.ContextLifeCycleListener {
    private static final String VERSION = "7.0.4.1";
    private static final int IS_LOAD_EXCEPTION = 1000;
    private static final int IS_SHOW_EXCEPTION = 1001;
    private static final int RV_LOAD_EXCEPTION = 1002;
    private static final int RV_SHOW_EXCEPTION = 1003;
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private final String APPLICATION_USER_GENDER = "applicationUserGender";
    private final String APPLICATION_USER_AGE_GROUP = "applicationUserAgeGroup";
    private final String SESSION_ID = "sessionid";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    private final String CUSTOM_SEGMENT = "custom_Segment";
    private final String ADM_KEY = "adm";
    private final String DEMAND_SOURCE_NAME = "demandSourceName";
    private final String LWS_SUPPORT_STATE = "isSupportedLWS";
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToISAd;
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToRvAd;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mDemandSourceToRvSmash;
    private ConcurrentHashMap<String, InterstitialSmashListener> mDemandSourceToISSmash;
    private static AtomicBoolean mDidInitSdk = new AtomicBoolean(false);
    private static String userAgeGroup;
    private static String userGender;
    private static String mediationSegment;

    public static IronSourceAdapter startAdapter(String providerName) {
        return new IronSourceAdapter(providerName);
    }

    private IronSourceAdapter(String providerName) {
        super(providerName);
        IronLog.INTERNAL.verbose(providerName + ": new instance");
        this.mDemandSourceToISAd = new ConcurrentHashMap();
        this.mDemandSourceToRvAd = new ConcurrentHashMap();
        this.mDemandSourceToRvSmash = new ConcurrentHashMap();
        this.mDemandSourceToISSmash = new ConcurrentHashMap();
        userAgeGroup = null;
        userGender = null;
        mediationSegment = null;
        ContextProvider.getInstance().registerLifeCycleListener(this);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onPause(Activity activity) {
        IronLog.ADAPTER_API.verbose("IronSourceNetwork.onPause");
        IronSourceNetwork.onPause(activity);
    }

    @Override
    public void onResume(Activity activity) {
        IronLog.ADAPTER_API.verbose("IronSourceNetwork.onResume");
        IronSourceNetwork.onResume(activity);
    }

    @Override
    protected void setConsent(boolean consent) {
        IronLog.ADAPTER_API.verbose("(" + (consent ? "true" : "false") + ")");
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("consent", (Object)(consent ? "1" : "0"));
        }
        catch (JSONException e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            return;
        }
        IronSourceNetwork.updateMetadata(consentParams);
    }

    @Override
    public void setAge(int age) {
        IronLog.INTERNAL.verbose(": " + age);
        userAgeGroup = age >= 13 && age <= 17 ? "1" : (age >= 18 && age <= 20 ? "2" : (age >= 21 && age <= 24 ? "3" : (age >= 25 && age <= 34 ? "4" : (age >= 35 && age <= 44 ? "5" : (age >= 45 && age <= 54 ? "6" : (age >= 55 && age <= 64 ? "7" : (age > 65 && age <= 120 ? "8" : "0")))))));
    }

    @Override
    public void setGender(String gender) {
        IronLog.INTERNAL.verbose(gender);
        userGender = gender;
    }

    @Override
    public void setMediationSegment(String segment) {
        mediationSegment = segment;
    }

    private HashMap<String, String> getInitParams() {
        String pluginType;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)userAgeGroup)) {
            params.put("applicationUserAgeGroup", userAgeGroup);
        }
        if (!TextUtils.isEmpty((CharSequence)userGender)) {
            params.put("applicationUserGender", userGender);
        }
        if (!TextUtils.isEmpty((CharSequence)(pluginType = this.getPluginType()))) {
            params.put("SDKPluginType", pluginType);
        }
        if (!TextUtils.isEmpty((CharSequence)mediationSegment)) {
            params.put("custom_Segment", mediationSegment);
        }
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getSessionId())) {
            params.put("sessionid", IronSourceObject.getInstance().getSessionId());
        }
        return params;
    }

    @Override
    public JSONObject getPlayerBiddingData() {
        IronLog.ADAPTER_API.verbose("");
        JSONObject biddingData = new JSONObject();
        JSONObject token = null;
        try {
            token = IronSourceNetwork.getRawToken(ContextProvider.getInstance().getApplicationContext());
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("getRawToken exception: " + e2.getLocalizedMessage());
        }
        if (token != null) {
            biddingData = token;
        } else {
            IronLog.ADAPTER_API.error("Player's bidding token is null");
        }
        return biddingData;
    }

    @Override
    public void earlyInit(String appKey, String userId, JSONObject config) {
        if (appKey != null) {
            IronSourceUtils.sendAutomationLog(this.getDemandSourceName(config) + ": earlyInit");
            this.initSDK(appKey, config);
        } else {
            IronLog.ADAPTER_API.error("Appkey is null for early init");
        }
    }

    @Override
    public Map<String, Object> getInterstitialBiddingData(JSONObject config) {
        IronLog.ADAPTER_API.verbose("");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(ContextProvider.getInstance().getApplicationContext());
        if (token != null) {
            ret.put("token", token);
        } else {
            IronLog.ADAPTER_API.error("IS bidding token is null");
            ret.put("token", "");
        }
        return ret;
    }

    @Override
    public void initInterstitialForBidding(String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initInterstitialInternal(appKey, config, listener, demandSourceName);
    }

    @Override
    public void initInterstitial(String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initInterstitialInternal(appKey, config, listener, demandSourceName);
    }

    private void initInterstitialInternal(String appKey, JSONObject config, InterstitialSmashListener listener, String demandSourceName) {
        this.initSDK(appKey, config);
        this.mDemandSourceToISSmash.put(demandSourceName, listener);
        listener.onInterstitialInitSuccess();
    }

    @Override
    public void loadInterstitialForBidding(JSONObject config, InterstitialSmashListener listener, String serverData) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, false, true, false);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("for bidding exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), null, false, false, false);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
            this.showAdInternal(adInstance, 2);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onInterstitialAdShowFailed(new IronSourceError(1001, e2.getMessage()));
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    @Override
    public Map<String, Object> getRewardedVideoBiddingData(JSONObject config) {
        IronLog.ADAPTER_API.verbose("getRewardedVideoBiddingData");
        HashMap<String, Object> biddingData = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(ContextProvider.getInstance().getApplicationContext());
        if (token != null) {
            biddingData.put("token", token);
        } else {
            IronLog.ADAPTER_API.error("RV bidding token is null");
            biddingData.put("token", "");
        }
        return biddingData;
    }

    @Override
    public void initRewardedVideoForBidding(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(appKey, config, listener, demandSourceName);
        listener.onRewardedVideoInitSuccess();
    }

    @Override
    public void initRewardedVideoForDemandOnly(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(appKey, config, listener, demandSourceName);
    }

    @Override
    public void initRewardedVideo(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        IronLog.INTERNAL.verbose(demandSourceName + ": demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(appKey, config, listener, demandSourceName);
        this.fetchRewardedVideoForAutomaticLoad(config, listener);
    }

    private void initRewardedVideoInternal(String appKey, JSONObject config, RewardedVideoSmashListener listener, String demandSourceName) {
        this.initSDK(appKey, config);
        this.mDemandSourceToRvSmash.put(demandSourceName, listener);
    }

    private IronSourceAdInstance getAdInstance(String demandSourceName, boolean isDemandOnlyForRv, boolean isBidder, boolean isRewarded) {
        IronSourceAdInstance adInstance;
        IronSourceAdInstance ironSourceAdInstance = adInstance = isRewarded ? this.mDemandSourceToRvAd.get(demandSourceName) : this.mDemandSourceToISAd.get(demandSourceName);
        if (adInstance == null) {
            IronSourceAdInstanceBuilder builder;
            IronLog.ADAPTER_API.verbose("creating ad instance for " + demandSourceName + " isDemandOnlyForRv=" + isDemandOnlyForRv + " isBidder=" + isBidder + " isRewarded=" + isRewarded);
            if (isRewarded) {
                builder = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceRewardedVideoListener(this.mDemandSourceToRvSmash.get(demandSourceName), demandSourceName, isDemandOnlyForRv)).setExtraParams(this.getInitParams());
                builder.setRewarded();
            } else {
                builder = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceInterstitialListener(this.mDemandSourceToISSmash.get(demandSourceName), demandSourceName)).setExtraParams(this.getInitParams());
            }
            if (isBidder) {
                builder.setInAppBidding();
            }
            adInstance = builder.build();
            if (isRewarded) {
                this.mDemandSourceToRvAd.put(demandSourceName, adInstance);
            } else {
                this.mDemandSourceToISAd.put(demandSourceName, adInstance);
            }
        }
        return adInstance;
    }

    @Override
    public void fetchRewardedVideoForAutomaticLoad(JSONObject config, RewardedVideoSmashListener listener) {
        block2: {
            String demandSourceName = this.getDemandSourceName(config);
            IronLog.ADAPTER_API.verbose(demandSourceName);
            try {
                this.loadAdInternal(demandSourceName, null, false, false, true);
            }
            catch (Exception e2) {
                IronLog.ADAPTER_API.error("exception " + e2.getMessage());
                listener = this.mDemandSourceToRvSmash.get(demandSourceName);
                if (listener == null) break block2;
                IronLog.ADAPTER_API.error("exception " + e2.getMessage());
                listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
                listener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    @Override
    public void loadRewardedVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), null, true, false, true);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadRewardedVideoForDemandOnlyForBidding(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, true, true, true);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadRewardedVideoForBidding(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
        IronLog.ADAPTER_API.verbose(this.getDemandSourceName(config));
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, false, true, true);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
            listener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    private void loadAdInternal(String demandSourceName, String serverData, boolean isDemandOnlyForRv, boolean isBidder, boolean isRewarded) throws Exception {
        HashMap<String, String> loadConfig = new HashMap<String, String>();
        if (serverData != null) {
            loadConfig.put("adm", AuctionDataUtils.getInstance().getAdmFromServerData(serverData));
            Map<String, String> auctionResponseServerDataParams = AuctionDataUtils.getInstance().getAuctionResponseServerDataParams(serverData);
            loadConfig.putAll(auctionResponseServerDataParams);
        }
        IronSourceAdInstance adInstance = this.getAdInstance(demandSourceName, isDemandOnlyForRv, isBidder, isRewarded);
        this.printInstanceExtraParams(loadConfig);
        IronLog.ADAPTER_API.verbose("demandSourceName=" + adInstance.getName());
        IronSourceNetwork.loadAd(adInstance, loadConfig);
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
            this.showAdInternal(adInstance, 1);
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error("exception " + e2.getMessage());
            listener.onRewardedVideoAdShowFailed(new IronSourceError(1003, e2.getMessage()));
        }
    }

    private void showAdInternal(IronSourceAdInstance adInstance, int adUnit) throws Exception {
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(adUnit);
        HashMap<String, String> showParams = new HashMap<String, String>();
        showParams.put("sessionDepth", String.valueOf(sessionDepth));
        IronLog.ADAPTER_API.verbose("demandSourceName=" + adInstance.getName() + " showParams=" + showParams);
        IronSourceNetwork.showAd(adInstance, showParams);
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    private void initSDK(String appKey, JSONObject config) {
        if (mDidInitSdk.compareAndSet(false, true)) {
            String userId = IronSourceUtils.getMediationUserId();
            int logLevel = config.optInt("debugMode", 0);
            if (this.isAdaptersDebugEnabled()) {
                logLevel = 3;
            }
            IronLog.ADAPTER_API.verbose("etting debug mode to " + logLevel);
            SDKUtils.setDebugMode(logLevel);
            SDKUtils.setControllerUrl(config.optString("controllerUrl"));
            IronLog.ADAPTER_API.verbose("IronSourceNetwork setting controller url to  " + config.optString("controllerUrl"));
            SDKUtils.setControllerConfig(config.optString("controllerConfig"));
            IronLog.ADAPTER_API.verbose("IronSourceNetwork setting controller config to  " + config.optString("controllerConfig"));
            HashMap<String, String> initParams = this.getInitParams();
            IronLog.ADAPTER_API.verbose("with appKey=" + appKey + " userId=" + userId + " parameters " + initParams);
            IronSourceNetwork.initSDK(ContextProvider.getInstance().getCurrentActiveActivity(), appKey, userId, initParams);
        }
    }

    private String getDemandSourceName(JSONObject config) {
        if (!TextUtils.isEmpty((CharSequence)config.optString("demandSourceName"))) {
            return config.optString("demandSourceName");
        }
        return this.getProviderName();
    }

    private boolean isValidMetaData(String key, String value) {
        if (key.equals("do_not_sell")) {
            return MetaDataUtils.isValidCCPAMetaData(key, value);
        }
        return true;
    }

    @Override
    protected void setMetaData(String key, String value) {
        if (!mDidInitSdk.get()) {
            IronLog.ADAPTER_API.verbose("key=" + key + ", value=" + value);
            if (!this.isValidMetaData(key, value)) {
                IronLog.ADAPTER_API.verbose("MetaData not valid");
                return;
            }
            JSONObject metaDataJson = new JSONObject();
            try {
                metaDataJson.put(key, (Object)value);
                IronSourceNetwork.updateMetadata(metaDataJson);
            }
            catch (JSONException e2) {
                IronLog.ADAPTER_API.error("error - " + (Object)((Object)e2));
                e2.printStackTrace();
            }
        }
    }

    private void printInstanceExtraParams(Map<String, String> params) {
        if (params != null && params.size() > 0) {
            IronLog.ADAPTER_API.verbose("instance extra params:");
            for (String key : params.keySet()) {
                IronLog.ADAPTER_API.verbose(key + "=" + params.get(key));
            }
        }
    }

    private class IronSourceRewardedVideoListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        RewardedVideoSmashListener mListener;
        boolean mIsRvDemandOnly;

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = false;
        }

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName, boolean isDemandOnly) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = isDemandOnly;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            if (this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoLoadSuccess();
            } else {
                this.mListener.onRewardedVideoAvailabilityChanged(true);
            }
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener " + description);
            this.mListener.onRewardedVideoLoadFailed(ErrorBuilder.buildLoadFailedError(description));
            if (!this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        @Override
        public void onInterstitialOpen() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            this.mListener.onRewardedVideoAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener demandSourceId=" + demandSourceId + " amount=" + amount);
            this.mListener.onRewardedVideoAdRewarded();
        }

        @Override
        public void onInterstitialClose() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            this.mListener.onRewardedVideoAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            if (!this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + "rewardedVideoListener " + description);
            this.mListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildShowFailedError("Rewarded Video", description));
        }

        @Override
        public void onInterstitialClick() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener");
            this.mListener.onRewardedVideoAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " rewardedVideoListener eventName=" + eventName);
            this.mListener.onRewardedVideoAdVisible();
        }
    }

    private class IronSourceInterstitialListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        private InterstitialSmashListener mListener;

        IronSourceInterstitialListener(InterstitialSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdReady();
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener " + description);
            this.mListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
        }

        @Override
        public void onInterstitialOpen() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener demandSourceId=" + demandSourceId + " amount=" + amount);
        }

        @Override
        public void onInterstitialClose() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdShowSucceeded();
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener " + description);
            this.mListener.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", description));
        }

        @Override
        public void onInterstitialClick() {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener");
            this.mListener.onInterstitialAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronLog.ADAPTER_CALLBACK.verbose(this.mDemandSourceName + " interstitialListener eventName=" + eventName);
            this.mListener.onInterstitialAdVisible();
        }
    }
}

