/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.ironsource.sdk.utils.Logger;

public class WebViewUtils {
    private static String TAG = WebViewUtils.class.getSimpleName();

    public static FrameLayout createLayout(Context context, View view) {
        FrameLayout.LayoutParams coverScreenParams = new FrameLayout.LayoutParams(-1, -1);
        FrameLayout viewLayout = new FrameLayout(context);
        FrameLayout customViewContainer = new FrameLayout(context);
        FrameLayout.LayoutParams fp = new FrameLayout.LayoutParams(-1, -1);
        customViewContainer.setLayoutParams((ViewGroup.LayoutParams)fp);
        customViewContainer.setVisibility(8);
        FrameLayout contentView = new FrameLayout(context);
        FrameLayout.LayoutParams lpChild2 = new FrameLayout.LayoutParams(-1, -1);
        contentView.setLayoutParams((ViewGroup.LayoutParams)lpChild2);
        contentView.addView(view);
        viewLayout.addView((View)customViewContainer, (ViewGroup.LayoutParams)coverScreenParams);
        viewLayout.addView((View)contentView);
        return viewLayout;
    }

    public static void setWebViewSettings(WebView webview) {
        WebSettings webviewSettings = webview.getSettings();
        webviewSettings.setLoadWithOverviewMode(true);
        webviewSettings.setUseWideViewPort(true);
        webview.setVerticalScrollBarEnabled(false);
        webview.setHorizontalScrollBarEnabled(false);
        webviewSettings.setAllowFileAccess(true);
        webviewSettings.setBuiltInZoomControls(false);
        webviewSettings.setJavaScriptEnabled(true);
        webviewSettings.setSupportMultipleWindows(true);
        webviewSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webviewSettings.setGeolocationEnabled(true);
        webviewSettings.setGeolocationDatabasePath("/data/data/org.itri.html5webview/databases/");
        webviewSettings.setDomStorageEnabled(true);
        try {
            WebViewUtils.setDisplayZoomControls(webviewSettings);
            WebViewUtils.setMediaPlaybackJellyBean(webviewSettings);
        }
        catch (Throwable e2) {
            Logger.e(TAG, "setWebSettings - " + e2.toString());
        }
    }

    private static void setDisplayZoomControls(WebSettings settings) {
        if (Build.VERSION.SDK_INT > 11) {
            settings.setDisplayZoomControls(false);
        }
    }

    @SuppressLint(value={"NewApi"})
    private static void setMediaPlaybackJellyBean(WebSettings settings) {
        if (Build.VERSION.SDK_INT >= 17) {
            settings.setMediaPlaybackRequiresUserGesture(false);
        }
    }
}

