/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.handlers;

import android.app.Activity;
import com.ironsource.sdk.agent.IronSourceAdsPublisherAgent;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.utils.IronSourceSharedPrefHelper;

public class BackButtonHandler {
    public static BackButtonHandler mInstance;

    public static BackButtonHandler getInstance() {
        if (mInstance == null) {
            return new BackButtonHandler();
        }
        return mInstance;
    }

    public boolean handleBackButton(Activity activity) {
        SSAEnums.BackButtonState state = IronSourceSharedPrefHelper.getSupersonicPrefHelper().getBackButtonState();
        switch (state) {
            case None: {
                return false;
            }
            case Device: {
                return false;
            }
            case Controller: {
                try {
                    IronSourceAdsPublisherAgent ssaPubAgt = IronSourceAdsPublisherAgent.getInstance(activity);
                    WebController webViewController = (WebController)ssaPubAgt.getControllerManager().getController();
                    if (webViewController != null) {
                        webViewController.nativeNavigationPressed("back");
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }
}

