/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.sdk.Events.ISNEventParams;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.SDK5Events;
import com.ironsource.sdk.WPAD.AdViewsManager;
import com.ironsource.sdk.agent.IronSourceAdsPublisherAgent;
import com.ironsource.sdk.controller.VideoEventsListener;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.data.AdUnitsState;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.handlers.BackButtonHandler;
import com.ironsource.sdk.listeners.OnWebViewChangeListener;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import com.ironsource.sdk.utils.WebViewUtils;

public class ControllerActivity
extends Activity
implements OnWebViewChangeListener,
VideoEventsListener {
    private static final String TAG = ControllerActivity.class.getSimpleName();
    private static final int CONTROLLER_WEB_VIEW_ID = 1;
    private static String CONTAINAER_IS_NULL = "removeWebViewContainerView | mContainer is null";
    private static String VIEW_IS_NULL = "removeWebViewContainerView | view is null";
    private String AD_WEB_VIEW_ID;
    public int currentRequestedRotation = -1;
    private WebController mWebViewController;
    private RelativeLayout mContainer;
    private FrameLayout mWebViewFrameContainer;
    private boolean mIsImmersive = false;
    private Handler mUiThreadHandler = new Handler();
    private final Runnable decorViewSettings = new Runnable(){

        @Override
        public void run() {
            ControllerActivity.this.getWindow().getDecorView().setSystemUiVisibility(SDKUtils.getActivityUIFlags(ControllerActivity.this.mIsImmersive));
        }
    };
    final RelativeLayout.LayoutParams MATCH_PARENT_LAYOUT_PARAMS = new RelativeLayout.LayoutParams(-1, -1);
    private boolean calledFromOnCreate = false;
    private String mProductType;
    private AdUnitsState mState;
    private boolean mControllerClearedFromOnPause;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            Logger.i(TAG, "onCreate");
            this.hideActivityTitle();
            this.hideActivtiyStatusBar();
            IronSourceAdsPublisherAgent ssaPubAgt = IronSourceAdsPublisherAgent.getInstance(this);
            this.mWebViewController = (WebController)ssaPubAgt.getControllerManager().getController();
            this.mWebViewController.getLayout().setId(1);
            this.mWebViewController.setOnWebViewControllerChangeListener(this);
            this.mWebViewController.setVideoEventsListener(this);
            Intent intent = this.getIntent();
            this.mProductType = intent.getStringExtra("productType");
            this.mIsImmersive = intent.getBooleanExtra("immersive", false);
            this.AD_WEB_VIEW_ID = intent.getStringExtra("adViewId");
            this.mControllerClearedFromOnPause = false;
            if (this.mIsImmersive) {
                this.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                    public void onSystemUiVisibilityChange(int visibility) {
                        if ((visibility & 0x1002) == 0) {
                            ControllerActivity.this.mUiThreadHandler.removeCallbacks(ControllerActivity.this.decorViewSettings);
                            ControllerActivity.this.mUiThreadHandler.postDelayed(ControllerActivity.this.decorViewSettings, 500L);
                        }
                    }
                });
                this.runOnUiThread(this.decorViewSettings);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mProductType) && SSAEnums.ProductType.OfferWall.toString().equalsIgnoreCase(this.mProductType)) {
                if (savedInstanceState != null) {
                    AdUnitsState state = (AdUnitsState)savedInstanceState.getParcelable("state");
                    if (state != null) {
                        this.mState = state;
                        this.mWebViewController.restoreState(state);
                    }
                    this.finish();
                } else {
                    this.mState = this.mWebViewController.getSavedState();
                }
            }
            this.mContainer = new RelativeLayout((Context)this);
            this.setContentView((View)this.mContainer, (ViewGroup.LayoutParams)this.MATCH_PARENT_LAYOUT_PARAMS);
            this.mWebViewFrameContainer = this.createWebViewFrameContainer(this.AD_WEB_VIEW_ID);
            View view = this.mContainer.findViewById(1);
            if (view == null && this.mWebViewFrameContainer.getParent() != null) {
                this.calledFromOnCreate = true;
                this.finish();
            }
            this.initOrientationState();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.finish();
        }
    }

    private FrameLayout createWebViewFrameContainer(String viewId) {
        if (viewId == null || viewId.isEmpty() || viewId.equals(Integer.toString(1))) {
            return WebViewUtils.createLayout(this.getApplicationContext(), (View)this.mWebViewController.getLayout());
        }
        return WebViewUtils.createLayout(this.getApplicationContext(), (View)AdViewsManager.getInstance().getAdViewById(viewId));
    }

    private void initOrientationState() {
        Intent intent = this.getIntent();
        String orientation = intent.getStringExtra("orientation_set_flag");
        int rotation = intent.getIntExtra("rotation_set_flag", 0);
        this.handleOrientationState(orientation, rotation);
    }

    private void handleOrientationState(String orientation, int rotation) {
        if (orientation != null) {
            if ("landscape".equalsIgnoreCase(orientation)) {
                this.setInitiateLandscapeOrientation();
            } else if ("portrait".equalsIgnoreCase(orientation)) {
                this.setInitiatePortraitOrientation();
            } else if ("device".equalsIgnoreCase(orientation)) {
                if (DeviceStatus.isDeviceOrientationLocked((Context)this)) {
                    this.setRequestedOrientation(1);
                }
            } else if (this.getRequestedOrientation() == -1) {
                this.setRequestedOrientation(4);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!TextUtils.isEmpty((CharSequence)this.mProductType) && SSAEnums.ProductType.OfferWall.toString().equalsIgnoreCase(this.mProductType)) {
            this.mState.setShouldRestore(true);
            outState.putParcelable("state", (Parcelable)this.mState);
        }
    }

    protected void onResume() {
        super.onResume();
        Logger.i(TAG, "onResume");
        this.mContainer.addView((View)this.mWebViewFrameContainer, (ViewGroup.LayoutParams)this.MATCH_PARENT_LAYOUT_PARAMS);
        if (this.mWebViewController != null) {
            this.mWebViewController.registerConnectionReceiver((Context)this);
            this.mWebViewController.resume();
            this.mWebViewController.viewableChange(true, "main");
        }
        ((AudioManager)this.getSystemService("audio")).requestAudioFocus(null, 3, 2);
    }

    protected void onPause() {
        super.onPause();
        Logger.i(TAG, "onPause");
        boolean isFinishing = this.isFinishing();
        ((AudioManager)this.getSystemService("audio")).abandonAudioFocus(null);
        if (this.mWebViewController != null) {
            this.mWebViewController.unregisterConnectionReceiver((Context)this);
            this.mWebViewController.pause();
            this.mWebViewController.viewableChange(false, "main");
        }
        this.removeWebViewContainerView(isFinishing);
        if (isFinishing) {
            this.mControllerClearedFromOnPause = true;
            Logger.i(TAG, "onPause | isFinishing");
            this.clearWebviewController();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        Logger.i(TAG, "onDestroy");
        if (this.calledFromOnCreate) {
            this.removeWebViewContainerView(true);
        }
        if (!this.mControllerClearedFromOnPause) {
            Logger.i(TAG, "onDestroy | destroyedFromBackground");
            this.clearWebviewController();
        }
    }

    private void clearWebviewController() {
        if (this.mWebViewController != null) {
            Logger.i(TAG, "clearWebviewController");
            this.mWebViewController.setState(WebController.State.Gone);
            this.mWebViewController.removeVideoEventsListener();
            this.mWebViewController.notifyLifeCycle(this.mProductType, "onDestroy");
        }
    }

    private void removeWebViewContainerView(boolean isFinishing) {
        try {
            if (!this.isControllerView() && isFinishing) {
                return;
            }
            if (this.mContainer == null) {
                throw new Exception(CONTAINAER_IS_NULL);
            }
            ViewGroup parent = (ViewGroup)this.mWebViewFrameContainer.getParent();
            View view = this.getCurrentView(parent);
            if (view == null) {
                throw new Exception(VIEW_IS_NULL);
            }
            if (isFinishing) {
                ViewGroup viewParent = (ViewGroup)view.getParent();
                viewParent.removeView(view);
            }
            parent.removeView((View)this.mWebViewFrameContainer);
        }
        catch (Exception ex) {
            ISNEventsTracker.logEvent(SDK5Events.removeWebViewFailed, new ISNEventParams().addPair("callfailreason", ex.getMessage()).getData());
            Logger.i(TAG, "removeWebViewContainerView fail " + ex.getMessage());
        }
    }

    private View getCurrentView(ViewGroup parent) {
        Object view = this.isControllerView() ? parent.findViewById(1) : AdViewsManager.getInstance().getAdViewById(this.AD_WEB_VIEW_ID);
        return view;
    }

    private boolean isControllerView() {
        return this.AD_WEB_VIEW_ID == null;
    }

    @Override
    public void onCloseRequested() {
        this.finish();
    }

    @Override
    public void onOrientationChanged(String orientation, int rotation) {
        this.handleOrientationState(orientation, rotation);
    }

    @Override
    public boolean onBackButtonPressed() {
        this.onBackPressed();
        return true;
    }

    public void onBackPressed() {
        Logger.i(TAG, "onBackPressed");
        boolean isHandled = BackButtonHandler.getInstance().handleBackButton(this);
        if (!isHandled) {
            super.onBackPressed();
        }
    }

    protected void onUserLeaveHint() {
        super.onUserLeaveHint();
        Logger.i(TAG, "onUserLeaveHint");
    }

    private void hideActivityTitle() {
        this.requestWindowFeature(1);
    }

    private void hideActivtiyStatusBar() {
        this.getWindow().setFlags(1024, 1024);
    }

    private void keepScreenOn() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ControllerActivity.this.getWindow().addFlags(128);
            }
        });
    }

    private void cancelScreenOn() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ControllerActivity.this.getWindow().clearFlags(128);
            }
        });
    }

    private void setInitiateLandscapeOrientation() {
        int rotation = DeviceStatus.getApplicationRotation((Context)this);
        Logger.i(TAG, "setInitiateLandscapeOrientation");
        if (rotation == 0) {
            Logger.i(TAG, "ROTATION_0");
            this.setRequestedOrientation(0);
        } else if (rotation == 2) {
            Logger.i(TAG, "ROTATION_180");
            this.setRequestedOrientation(8);
        } else if (rotation == 3) {
            Logger.i(TAG, "ROTATION_270 Right Landscape");
            this.setRequestedOrientation(8);
        } else if (rotation == 1) {
            Logger.i(TAG, "ROTATION_90 Left Landscape");
            this.setRequestedOrientation(0);
        } else {
            Logger.i(TAG, "No Rotation");
        }
    }

    private void setInitiatePortraitOrientation() {
        int rotation = DeviceStatus.getApplicationRotation((Context)this);
        Logger.i(TAG, "setInitiatePortraitOrientation");
        if (rotation == 0) {
            Logger.i(TAG, "ROTATION_0");
            this.setRequestedOrientation(1);
        } else if (rotation == 2) {
            Logger.i(TAG, "ROTATION_180");
            this.setRequestedOrientation(9);
        } else if (rotation == 1) {
            Logger.i(TAG, "ROTATION_270 Right Landscape");
            this.setRequestedOrientation(1);
        } else if (rotation == 3) {
            Logger.i(TAG, "ROTATION_90 Left Landscape");
            this.setRequestedOrientation(1);
        } else {
            Logger.i(TAG, "No Rotation");
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.mWebViewController.inCustomView()) {
            this.mWebViewController.hideCustomView();
            return true;
        }
        if (this.mIsImmersive && (keyCode == 25 || keyCode == 24)) {
            this.mUiThreadHandler.removeCallbacks(this.decorViewSettings);
            this.mUiThreadHandler.postDelayed(this.decorViewSettings, 500L);
        }
        return super.onKeyDown(keyCode, event);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (this.currentRequestedRotation != requestedOrientation) {
            Logger.i(TAG, "Rotation: Req = " + requestedOrientation + " Curr = " + this.currentRequestedRotation);
            this.currentRequestedRotation = requestedOrientation;
            super.setRequestedOrientation(requestedOrientation);
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (this.mIsImmersive && hasFocus) {
            this.runOnUiThread(this.decorViewSettings);
        }
    }

    @Override
    public void onVideoStarted() {
        this.toggleKeepScreen(true);
    }

    @Override
    public void onVideoPaused() {
        this.toggleKeepScreen(false);
    }

    @Override
    public void onVideoResumed() {
        this.toggleKeepScreen(true);
    }

    @Override
    public void onVideoEnded() {
        this.toggleKeepScreen(false);
    }

    @Override
    public void onVideoStopped() {
        this.toggleKeepScreen(false);
    }

    public void toggleKeepScreen(boolean screenOn) {
        if (screenOn) {
            this.keepScreenOn();
        } else {
            this.cancelScreenOn();
        }
    }
}

