/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.impressionData;

import com.ironsource.mediationsdk.logger.IronLog;
import org.json.JSONException;
import org.json.JSONObject;

public class ImpressionData {
    private final String IMPRESSION_DATA_KEY_AUCTION_ID = "auctionId";
    private final String IMPRESSION_DATA_KEY_AD_UNIT = "adUnit";
    private final String IMPRESSION_DATA_KEY_COUNTRY = "country";
    private final String IMPRESSION_DATA_KEY_ABTEST = "ab";
    private final String IMPRESSION_DATA_KEY_SEGMENT_NAME = "segmentName";
    private final String IMPRESSION_DATA_KEY_PLACEMENT = "placement";
    private final String IMPRESSION_DATA_KEY_AD_NETWORK = "adNetwork";
    private final String IMPRESSION_DATA_KEY_INSTANCE_NAME = "instanceName";
    private final String IMPRESSION_DATA_KEY_INSTANCE_ID = "instanceId";
    private final String IMPRESSION_DATA_KEY_REVENUE = "revenue";
    private final String IMPRESSION_DATA_KEY_PRECISION = "precision";
    private final String IMPRESSION_DATA_KEY_LIFETIME_REVENUE = "lifetimeRevenue";
    private final String IMPRESSION_DATA_KEY_ENCRYPTED_CPM = "encryptedCPM";
    private JSONObject allData;
    private String auctionId = null;
    private String adUnit = null;
    private String country = null;
    private String ab = null;
    private String segmentName = null;
    private String placement = null;
    private String adNetwork = null;
    private String instanceName = null;
    private String instanceId = null;
    private Double revenue = null;
    private String precision = null;
    private Double lifetimeRevenue = null;
    private String encryptedCPM = null;

    public ImpressionData(JSONObject json) {
        if (json != null) {
            try {
                this.allData = json;
                this.auctionId = json.optString("auctionId", null);
                this.adUnit = json.optString("adUnit", null);
                this.country = json.optString("country", null);
                this.ab = json.optString("ab", null);
                this.segmentName = json.optString("segmentName", null);
                this.placement = json.optString("placement", null);
                this.adNetwork = json.optString("adNetwork", null);
                this.instanceName = json.optString("instanceName", null);
                this.instanceId = json.optString("instanceId", null);
                this.precision = json.optString("precision", null);
                this.encryptedCPM = json.optString("encryptedCPM", null);
                double lifetimeRevenueDouble = json.optDouble("lifetimeRevenue");
                this.lifetimeRevenue = Double.isNaN(lifetimeRevenueDouble) ? null : Double.valueOf(lifetimeRevenueDouble);
                double revenueDouble = json.optDouble("revenue");
                this.revenue = Double.isNaN(revenueDouble) ? null : Double.valueOf(revenueDouble);
            }
            catch (Exception e2) {
                IronLog.INTERNAL.error("error parsing impression " + e2.getMessage());
            }
        }
    }

    public void replaceMacroForPlacementWithValue(String macro, String newValue) {
        if (this.placement != null) {
            this.placement = this.placement.replace(macro, newValue);
            if (this.allData != null) {
                try {
                    this.allData.put("placement", (Object)this.placement);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public String toString() {
        return "ImpressionData{auctionId='" + this.auctionId + '\'' + ", adUnit='" + this.adUnit + '\'' + ", country='" + this.country + '\'' + ", ab='" + this.ab + '\'' + ", segmentName='" + this.segmentName + '\'' + ", placement='" + this.placement + '\'' + ", adNetwork='" + this.adNetwork + '\'' + ", instanceName='" + this.instanceName + '\'' + ", instanceId='" + this.instanceId + '\'' + ", revenue=" + this.revenue + ", precision='" + this.precision + '\'' + ", lifetimeRevenue=" + this.lifetimeRevenue + ", encryptedCPM='" + this.encryptedCPM + '\'' + '}';
    }

    public String getAuctionId() {
        return this.auctionId;
    }

    public String getAdUnit() {
        return this.adUnit;
    }

    public String getCountry() {
        return this.country;
    }

    public String getAb() {
        return this.ab;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public String getPlacement() {
        return this.placement;
    }

    public String getAdNetwork() {
        return this.adNetwork;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Double getRevenue() {
        return this.revenue;
    }

    public String getPrecision() {
        return this.precision;
    }

    public Double getLifetimeRevenue() {
        return this.lifetimeRevenue;
    }

    public String getEncryptedCPM() {
        return this.encryptedCPM;
    }

    public JSONObject getAllData() {
        return this.allData;
    }
}

