/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgIsManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ProgIsSmash
extends ProgSmash
implements InterstitialSmashListener {
    private SMASH_STATE mState;
    private ProgIsManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private String mAppKey;
    private String mUserId;
    private long mLoadStartTime;
    private final Object mTimerLock = new Object();

    public ProgIsSmash(String appKey, String userId, ProviderSettings settings, ProgIsManagerListener listener, int loadTimeout, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getInterstitialSettings()), adapter);
        this.mState = SMASH_STATE.NO_INIT;
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeout;
        this.mAdapter.addInterstitialListener(this);
    }

    public Map<String, Object> getBiddingData() {
        try {
            return this.isBidder() ? this.mAdapter.getInterstitialBiddingData(this.mAdUnitSettings) : null;
        }
        catch (Throwable t) {
            this.logInternalError("getBiddingData exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            return null;
        }
    }

    public boolean isLoadingInProgress() {
        return this.mState == SMASH_STATE.INIT_IN_PROGRESS || this.mState == SMASH_STATE.LOAD_IN_PROGRESS;
    }

    public void initForBidding() {
        this.logInternal("initForBidding()");
        this.setState(SMASH_STATE.INIT_IN_PROGRESS);
        this.setCustomParams();
        try {
            this.mAdapter.initInterstitialForBidding(this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError(this.getInstanceName() + "loadInterstitial exception : " + t.getLocalizedMessage());
            t.printStackTrace();
            this.onInterstitialInitFailed(new IronSourceError(1041, t.getLocalizedMessage()));
        }
    }

    public void loadInterstitial(String serverData) {
        try {
            this.mLoadStartTime = new Date().getTime();
            this.logInternal("loadInterstitial");
            this.setIsLoadCandidate(false);
            if (this.isBidder()) {
                this.startTimer();
                this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
                this.mAdapter.loadInterstitialForBidding(this.mAdUnitSettings, this, serverData);
                return;
            }
            if (this.mState == SMASH_STATE.NO_INIT) {
                this.startTimer();
                this.setState(SMASH_STATE.INIT_IN_PROGRESS);
                this.setCustomParams();
                this.mAdapter.initInterstitial(this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
                return;
            }
            this.startTimer();
            this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
            this.mAdapter.loadInterstitial(this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError("loadInterstitial exception: " + t.getLocalizedMessage());
            t.printStackTrace();
        }
    }

    public void showInterstitial() {
        try {
            this.mAdapter.showInterstitial(this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError(this.getInstanceName() + "showInterstitial exception : " + t.getLocalizedMessage());
            t.printStackTrace();
            this.mListener.onInterstitialAdShowFailed(new IronSourceError(1039, t.getLocalizedMessage()), this);
        }
    }

    public void setCappedPerSession() {
        this.mAdapter.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, "interstitial");
    }

    public boolean isReadyToShow() {
        try {
            return this.mAdapter.isInterstitialReady(this.mAdUnitSettings);
        }
        catch (Throwable t) {
            this.logInternalError("isReadyToShow exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            return false;
        }
    }

    private void setState(SMASH_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        this.mState = state;
    }

    private void setCustomParams() {
        try {
            String pluginType;
            String segment = IronSourceObject.getInstance().getMediationSegment();
            if (!TextUtils.isEmpty((CharSequence)segment)) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
        }
        catch (Exception e2) {
            this.logInternal("setCustomParams() " + e2.getMessage());
        }
    }

    @Override
    public void onInterstitialInitSuccess() {
        this.logAdapterCallback("onInterstitialInitSuccess state=" + this.mState.name());
        if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
            return;
        }
        this.stopTimer();
        if (this.isBidder()) {
            this.setState(SMASH_STATE.INIT_SUCCESS);
        } else {
            this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
            this.startTimer();
            try {
                this.mAdapter.loadInterstitial(this.mAdUnitSettings, this);
            }
            catch (Throwable t) {
                this.logInternalError("onInterstitialInitSuccess exception: " + t.getLocalizedMessage());
                t.printStackTrace();
            }
        }
        this.mListener.onInterstitialInitSuccess(this);
    }

    @Override
    public void onInterstitialInitFailed(IronSourceError error) {
        this.logAdapterCallback("onInterstitialInitFailed error" + error.getErrorMessage() + " state=" + this.mState.name());
        if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
            return;
        }
        this.stopTimer();
        this.setState(SMASH_STATE.NO_INIT);
        this.mListener.onInterstitialInitFailed(error, this);
        if (!this.isBidder()) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onInterstitialAdLoadFailed(error, this, elapsedTime);
        }
    }

    @Override
    public void onInterstitialAdReady() {
        this.logAdapterCallback("onInterstitialAdReady state=" + this.mState.name());
        this.stopTimer();
        if (this.mState != SMASH_STATE.LOAD_IN_PROGRESS) {
            return;
        }
        this.setState(SMASH_STATE.LOADED);
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.mListener.onInterstitialAdReady(this, elapsedTime);
    }

    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error) {
        this.logAdapterCallback("onInterstitialAdLoadFailed error=" + error.getErrorMessage() + " state=" + this.mState.name());
        this.stopTimer();
        if (this.mState != SMASH_STATE.LOAD_IN_PROGRESS) {
            return;
        }
        this.setState(SMASH_STATE.LOAD_FAILED);
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.mListener.onInterstitialAdLoadFailed(error, this, elapsedTime);
    }

    @Override
    public void onInterstitialAdOpened() {
        this.logAdapterCallback("onInterstitialAdOpened");
        this.mListener.onInterstitialAdOpened(this);
    }

    @Override
    public void onInterstitialAdClosed() {
        this.logAdapterCallback("onInterstitialAdClosed");
        this.mListener.onInterstitialAdClosed(this);
    }

    @Override
    public void onInterstitialAdShowSucceeded() {
        this.logAdapterCallback("onInterstitialAdShowSucceeded");
        this.mListener.onInterstitialAdShowSucceeded(this);
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error) {
        this.logAdapterCallback("onInterstitialAdShowFailed error=" + error.getErrorMessage());
        this.mListener.onInterstitialAdShowFailed(error, this);
    }

    @Override
    public void onInterstitialAdClicked() {
        this.logAdapterCallback("onInterstitialAdClicked");
        this.mListener.onInterstitialAdClicked(this);
    }

    @Override
    public void onInterstitialAdVisible() {
        this.logAdapterCallback("onInterstitialAdVisible");
        this.mListener.onInterstitialAdVisible(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            this.logInternal("start timer");
            this.stopTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ProgIsSmash.this.logInternal("timed out state=" + ProgIsSmash.this.mState.name() + " isBidder=" + ProgIsSmash.this.isBidder());
                    if (ProgIsSmash.this.mState == SMASH_STATE.INIT_IN_PROGRESS && ProgIsSmash.this.isBidder()) {
                        ProgIsSmash.this.setState(SMASH_STATE.NO_INIT);
                    } else {
                        ProgIsSmash.this.setState(SMASH_STATE.LOAD_FAILED);
                        long elapsedTime = new Date().getTime() - ProgIsSmash.this.mLoadStartTime;
                        ProgIsSmash.this.mListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("timed out"), ProgIsSmash.this, elapsedTime);
                    }
                }
            }, this.mLoadTimeoutSecs * 1000);
        }
    }

    private void logAdapterCallback(String line) {
        String text = "ProgIsSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "ProgIsSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void logInternalError(String line) {
        String text = "ProgIsSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 3);
    }

    protected static enum SMASH_STATE {
        NO_INIT,
        INIT_IN_PROGRESS,
        INIT_SUCCESS,
        LOAD_IN_PROGRESS,
        LOADED,
        LOAD_FAILED;

    }
}

