/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.AuctionEventListener;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionHistory;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.BannerCallbackThrottler;
import com.ironsource.mediationsdk.BannerData;
import com.ironsource.mediationsdk.BannerUtils;
import com.ironsource.mediationsdk.BaseProgManager;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.ProgBannerManagerListener;
import com.ironsource.mediationsdk.ProgBannerSmash;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.BannerPlacement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.timer.BannerReloadTimer;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class ProgBannerManager
extends BaseProgManager
implements ProgBannerManagerListener,
AuctionEventListener,
BannerReloadTimer.ReloadIntervalInterface,
ContextProvider.ContextLifeCycleListener {
    private BannerData mData;
    private BannerManagerState mCurrentState = BannerManagerState.NONE;
    private BannerReloadTimer mTimer;
    private IronSourceBannerLayout mIronSourceBanner;
    private BannerPlacement mCurrentPlacement;
    private int mCurrentLoadingIndex;
    private ProgBannerSmash mActiveSmash;
    private int mCurrentSessionDepth;
    private final ConcurrentHashMap<String, ProgBannerSmash> mSmashes;
    private CopyOnWriteArrayList<ProgBannerSmash> mWaterfall;
    private String mCurrentAuctionId;
    private String mAuctionFallback = "";
    private int mAuctionTrail;
    private AuctionHandler mAuctionHandler;
    private AuctionResponseItem mGenericNotifications;
    private AuctionHistory mAuctionHistory;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private ConcurrentHashMap<String, AuctionHistory.ISAuctionPerformance> mWaterfallPerformance;
    private long mInitMangerTimeStamp;
    private final Object mStateLock = new Object();
    private AtomicBoolean mIsInForeground;

    public ProgBannerManager(List<ProviderSettings> adaptersConfigs, BannerData bannerData, ImpressionDataListener impressionDataListener) {
        super(impressionDataListener);
        IronLog.INTERNAL.verbose("isAuctionEnabled = " + bannerData.isAuctionEnabled());
        this.mData = bannerData;
        this.mTimer = new BannerReloadTimer(this.mData.getBannerRefreshIntervalInSeconds());
        this.mSmashes = new ConcurrentHashMap();
        this.mWaterfall = new CopyOnWriteArrayList();
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mWaterfallPerformance = new ConcurrentHashMap();
        this.mCurrentSessionDepth = SessionDepthManager.getInstance().getSessionDepth(3);
        BannerCallbackThrottler.getInstance().setDelayLoadFailureNotificationInSeconds(this.mData.getBannerDelayLoadFailureInSeconds());
        if (this.mData.isAuctionEnabled()) {
            this.mAuctionHandler = new AuctionHandler("banner", this.mData.getAuctionSettings(), this);
        }
        this.initAuctionHistory(adaptersConfigs);
        this.setSmashMap(adaptersConfigs);
        this.mIsInForeground = new AtomicBoolean(true);
        ContextProvider.getInstance().registerLifeCycleListener(this);
        this.mInitMangerTimeStamp = new Date().getTime();
        this.setState(BannerManagerState.READY_TO_LOAD);
    }

    private void initAuctionHistory(List<ProviderSettings> adaptersConfigs) {
        ArrayList<String> instances = new ArrayList<String>();
        for (ProviderSettings provider : adaptersConfigs) {
            instances.add(provider.getProviderName());
        }
        this.mAuctionHistory = new AuctionHistory(instances, this.mData.getAuctionSettings().getAuctionSavedHistoryLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareStateAndSetIfTrue(BannerManagerState expectedState, BannerManagerState stateToSet) {
        boolean stateWasAsExpected = false;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mCurrentState == expectedState) {
                IronLog.INTERNAL.verbose("set state from '" + (Object)((Object)this.mCurrentState) + "' to '" + (Object)((Object)stateToSet) + "'");
                stateWasAsExpected = true;
                this.mCurrentState = stateToSet;
            }
        }
        return stateWasAsExpected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(BannerManagerState state) {
        IronLog.INTERNAL.verbose("from '" + (Object)((Object)this.mCurrentState) + "' to '" + (Object)((Object)state) + "'");
        Object object = this.mStateLock;
        synchronized (object) {
            this.mCurrentState = state;
        }
    }

    public void loadBanner(final IronSourceBannerLayout banner, final BannerPlacement placement) {
        IronLog.INTERNAL.verbose("");
        if (this.compareStateAndSetIfTrue(BannerManagerState.READY_TO_LOAD, BannerManagerState.STARTED_LOADING)) {
            if (!BannerCallbackThrottler.getInstance().hasPendingInvocation()) {
                BannerUtils.verifyLoadBanner(banner, placement, new BannerUtils.VerifyBannerListener(){

                    @Override
                    public void success() {
                        IronLog.INTERNAL.verbose("placement = " + placement.getPlacementName());
                        ProgBannerManager.this.mIronSourceBanner = banner;
                        ProgBannerManager.this.mCurrentPlacement = placement;
                        if (CappingManager.isBnPlacementCapped((Context)ContextProvider.getInstance().getCurrentActiveActivity(), placement.getPlacementName())) {
                            IronLog.INTERNAL.verbose("placement is capped");
                            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(banner, new IronSourceError(604, "placement '" + placement.getPlacementName() + "' is capped"));
                            Object[][] additionalData = new Object[][]{{"errorCode", 604}};
                            ProgBannerManager.this.sendMediationEvent(3111, additionalData);
                            ProgBannerManager.this.setState(BannerManagerState.READY_TO_LOAD);
                            return;
                        }
                        ProgBannerManager.this.sendMediationEvent(3001);
                        ProgBannerManager.this.startLoadingBanner(false);
                    }

                    @Override
                    public void failed(String errorMessage) {
                        IronLog.API.error("can't load banner - errorMessage = " + errorMessage);
                    }
                });
            } else {
                IronLog.INTERNAL.verbose("can't load banner - already has pending invocation");
            }
        } else {
            IronLog.API.error("can't load banner - loadBanner already called and still in progress");
        }
    }

    private void startLoadingBanner(boolean isReload) {
        BannerManagerState stateToSet;
        IronLog.INTERNAL.verbose("current state = " + (Object)((Object)this.mCurrentState));
        if (this.mData.isAuctionEnabled()) {
            stateToSet = isReload ? BannerManagerState.AUCTION : BannerManagerState.FIRST_AUCTION;
        } else {
            BannerManagerState bannerManagerState = stateToSet = isReload ? BannerManagerState.RELOADING : BannerManagerState.LOADING;
        }
        if (this.compareStateAndSetIfTrue(BannerManagerState.STARTED_LOADING, stateToSet)) {
            this.mCurrentAuctionId = "";
            this.mCurrentLoadingIndex = 0;
            this.mCurrentSessionDepth = SessionDepthManager.getInstance().getSessionDepth(3);
            if (isReload) {
                this.sendMediationEvent(3011);
            }
            if (this.mData.isAuctionEnabled()) {
                this.makeAuction();
            } else {
                this.updateWaterfallToNonBidding();
                this.loadNextSmash();
            }
        } else {
            IronLog.INTERNAL.error("wrong state - " + (Object)((Object)this.mCurrentState));
        }
    }

    public void destroyBanner(final IronSourceBannerLayout banner) {
        IronLog.INTERNAL.verbose("");
        BannerUtils.verifyDestroyBanner(banner, new BannerUtils.VerifyBannerListener(){

            @Override
            public void success() {
                IronLog.INTERNAL.verbose("destroying banner");
                ProgBannerManager.this.mTimer.stopReloadTimer();
                ProgBannerManager.this.sendMediationEvent(3100);
                ProgBannerManager.this.destroyActiveSmash();
                banner.destroyBanner();
                ProgBannerManager.this.mIronSourceBanner = null;
                ProgBannerManager.this.mCurrentPlacement = null;
                ProgBannerManager.this.setState(BannerManagerState.READY_TO_LOAD);
            }

            @Override
            public void failed(String errorMessage) {
                IronLog.API.error("destroy banner failed - errorMessage = " + errorMessage);
            }
        });
    }

    @Override
    public void onResume(Activity activity) {
        this.mIsInForeground.set(true);
    }

    @Override
    public void onPause(Activity activity) {
        this.mIsInForeground.set(false);
    }

    @Override
    public void onAuctionSuccess(List<AuctionResponseItem> newWaterfall, String auctionId, AuctionResponseItem genericNotifications, int auctionTrial, long elapsedTime) {
        IronLog.INTERNAL.verbose("auctionId = " + auctionId);
        if (this.isWaitingForAuctionResponse()) {
            this.mAuctionFallback = "";
            this.mCurrentAuctionId = auctionId;
            this.mAuctionTrail = auctionTrial;
            this.mGenericNotifications = genericNotifications;
            Object[][] additionalData = new Object[][]{{"duration", elapsedTime}};
            this.sendMediationEvent(3502, additionalData);
            this.setState(this.mCurrentState == BannerManagerState.FIRST_AUCTION ? BannerManagerState.LOADING : BannerManagerState.RELOADING);
            String waterfallString = this.updateWaterfall(newWaterfall);
            additionalData = new Object[][]{{"ext1", waterfallString}};
            this.sendMediationEvent(3511, additionalData);
            this.loadNextSmash();
        } else {
            IronLog.INTERNAL.warning("wrong state - mCurrentState = " + (Object)((Object)this.mCurrentState));
        }
    }

    @Override
    public void onAuctionFailed(int errorCode, String errorMessage, int auctionTrial, String auctionFallback, long elapsedTime) {
        IronLog.INTERNAL.verbose("error = " + errorCode + ", " + errorMessage);
        if (this.isWaitingForAuctionResponse()) {
            this.mAuctionFallback = auctionFallback;
            this.mAuctionTrail = auctionTrial;
            Object[][] additionalData = new Object[][]{{"duration", elapsedTime}, {"errorCode", errorCode}, {"reason", errorMessage}};
            this.sendMediationEvent(3501, additionalData);
            this.setState(this.mCurrentState == BannerManagerState.FIRST_AUCTION ? BannerManagerState.LOADING : BannerManagerState.RELOADING);
            this.updateWaterfallToNonBidding();
            this.loadNextSmash();
        } else {
            IronLog.INTERNAL.warning("wrong state - mCurrentState = " + (Object)((Object)this.mCurrentState));
        }
    }

    @Override
    public void onBannerLoadSuccess(ProgBannerSmash smash, View adView, FrameLayout.LayoutParams frameLayoutParams) {
        IronLog.INTERNAL.verbose("smash = " + smash.getInstanceSignature());
        if (this.isWaitingForLoadResponse()) {
            if (this.mActiveSmash != null && !this.mActiveSmash.getInstanceSignature().equals(smash.getInstanceSignature())) {
                IronLog.INTERNAL.error("smash is not mActiveSmash it is a different instance");
            }
            this.bindView(adView, frameLayoutParams);
            this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceShowedSuccessfully);
            if (this.mData.isAuctionEnabled()) {
                AuctionResponseItem winnerInstance = this.mWaterfallServerData.get(smash.getInstanceName());
                if (winnerInstance != null) {
                    this.mAuctionHandler.reportLoadSuccess(winnerInstance, smash.getInstanceType(), this.mGenericNotifications);
                    this.mAuctionHandler.reportAuctionLose(this.mWaterfall, this.mWaterfallServerData, smash.getInstanceType(), this.mGenericNotifications, winnerInstance);
                    this.mAuctionHandler.reportImpression(winnerInstance, smash.getInstanceType(), this.mGenericNotifications, this.getCurrentPlacementName());
                    this.reportImpressionDataToPublisher(true, this.mWaterfallServerData.get(smash.getInstanceName()), this.getCurrentPlacementName());
                } else {
                    String smashName = smash.getInstanceName();
                    IronLog.INTERNAL.error("onLoadSuccess winner instance " + smashName + " missing from waterfall. auctionId = " + this.mCurrentAuctionId);
                    this.sendMediationEvent(83317, new Object[][]{{"errorCode", 1010}, {"reason", "Loaded missing"}, {"ext1", smashName}});
                }
            }
            if (this.mCurrentState == BannerManagerState.LOADING) {
                this.mIronSourceBanner.sendBannerAdLoaded(smash.getInstanceName());
                this.sendMediationEvent(3110);
            }
            this.handlePlacementCapping();
            SessionDepthManager.getInstance().increaseSessionDepth(3);
            this.setState(BannerManagerState.LOADED);
            this.mTimer.startReloadTimer(this);
        } else {
            IronLog.INTERNAL.warning("wrong state - mCurrentState = " + (Object)((Object)this.mCurrentState));
        }
    }

    @Override
    public void onBannerLoadFailed(IronSourceError error, ProgBannerSmash smash, boolean isNoFillError) {
        IronLog.INTERNAL.verbose("error = " + error);
        if (this.isWaitingForLoadResponse()) {
            this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceFailedToLoad);
            this.loadNextSmash();
        } else {
            IronLog.INTERNAL.warning("wrong state - mCurrentState = " + (Object)((Object)this.mCurrentState));
        }
    }

    @Override
    public void onBannerClicked(ProgBannerSmash smash) {
        IronLog.INTERNAL.verbose(smash.getInstanceSignature());
        Object[][] additionalData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronSourceBanner.sendBannerAdClicked();
        } else {
            additionalData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3112, additionalData);
    }

    @Override
    public void onBannerScreenDismissed(ProgBannerSmash smash) {
        IronLog.INTERNAL.verbose(smash.getInstanceSignature());
        Object[][] additionalData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronSourceBanner.sendBannerAdScreenDismissed();
        } else {
            additionalData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3114, additionalData);
    }

    @Override
    public void onBannerScreenPresented(ProgBannerSmash smash) {
        IronLog.INTERNAL.verbose(smash.getInstanceSignature());
        Object[][] additionalData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronSourceBanner.sendBannerAdScreenPresented();
        } else {
            additionalData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3113, additionalData);
    }

    @Override
    public void onBannerLeftApplication(ProgBannerSmash smash) {
        IronLog.INTERNAL.verbose(smash.getInstanceSignature());
        Object[][] additionalData = null;
        if (this.canSendBannerCallbacks()) {
            this.mIronSourceBanner.sendBannerAdLeftApplication();
        } else {
            additionalData = new Object[][]{{"reason", "banner is destroyed"}};
        }
        this.sendMediationEvent(3115, additionalData);
    }

    @Override
    public void onReloadInterval() {
        if (this.mIsInForeground.get()) {
            if (this.compareStateAndSetIfTrue(BannerManagerState.LOADED, BannerManagerState.STARTED_LOADING)) {
                IronLog.INTERNAL.verbose("start loading");
                this.startLoadingBanner(true);
            } else {
                IronLog.INTERNAL.error("wrong state = " + (Object)((Object)this.mCurrentState));
            }
        } else {
            IronLog.INTERNAL.verbose("app in background - start reload timer");
            this.sendMediationEvent(3200, new Object[][]{{"errorCode", 614}});
            this.mTimer.startReloadTimer(this);
        }
    }

    private void makeAuction() {
        IronLog.INTERNAL.verbose("");
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgBannerManager.this.storeWaterfallPerformance();
                if (ProgBannerManager.this.waitBeforeAuction()) {
                    return;
                }
                ProgBannerManager.this.sendMediationEvent(3500);
                BannerUtils.createAuctionCandidates(ProgBannerManager.this.getCurrentPlacementName(), ProgBannerManager.this.mSmashes, new BannerUtils.CreateCandidatesListener(){

                    @Override
                    public void onFinish(Map<String, Object> bidderCandidates, List<String> noBidderCandidates, StringBuilder waterfallString) {
                        IronLog.INTERNAL.verbose("auction waterfallString = " + waterfallString);
                        if (bidderCandidates.size() == 0 && noBidderCandidates.size() == 0) {
                            ProgBannerManager.this.sendMediationEvent(3501, new Object[][]{{"errorCode", 1005}, {"duration", 0}});
                            if (ProgBannerManager.this.compareStateAndSetIfTrue(BannerManagerState.AUCTION, BannerManagerState.LOADED)) {
                                ProgBannerManager.this.mTimer.startReloadTimer(ProgBannerManager.this);
                            } else {
                                BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(ProgBannerManager.this.mIronSourceBanner, new IronSourceError(1005, "No candidates available for auctioning"));
                                ProgBannerManager.this.sendMediationEvent(3111, new Object[][]{{"errorCode", 1005}});
                                ProgBannerManager.this.setState(BannerManagerState.READY_TO_LOAD);
                            }
                        } else {
                            Object[][] additionalData = new Object[][]{{"ext1", waterfallString.toString()}};
                            ProgBannerManager.this.sendMediationEvent(3510, additionalData);
                            if (ProgBannerManager.this.mAuctionHandler != null) {
                                ProgBannerManager.this.mAuctionHandler.executeAuction(ContextProvider.getInstance().getApplicationContext(), bidderCandidates, noBidderCandidates, ProgBannerManager.this.mAuctionHistory, ProgBannerManager.this.mCurrentSessionDepth, ProgBannerManager.this.getBannerSizeForAuction());
                            } else {
                                IronLog.INTERNAL.error("mAuctionHandler is null");
                            }
                        }
                    }
                });
            }
        });
    }

    private void setSmashMap(List<ProviderSettings> adaptersConfigs) {
        for (int i = 0; i < adaptersConfigs.size(); ++i) {
            ProviderSettings providerSettings = adaptersConfigs.get(i);
            AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(providerSettings, providerSettings.getBannerSettings());
            if (adapter != null) {
                ProgBannerSmash smash = new ProgBannerSmash(this.mData, this, providerSettings, adapter, this.mCurrentSessionDepth);
                this.mSmashes.put(smash.getInstanceName(), smash);
                continue;
            }
            IronLog.INTERNAL.verbose(providerSettings.getProviderInstanceName() + " can't load adapter");
        }
    }

    private void loadNextSmash() {
        for (int i = this.mCurrentLoadingIndex; i < this.mWaterfall.size(); ++i) {
            ProgBannerSmash smash = this.mWaterfall.get(i);
            if (!smash.getIsLoadCandidate()) continue;
            IronLog.INTERNAL.verbose("loading smash - " + smash.getInstanceSignature());
            this.mCurrentLoadingIndex = i + 1;
            this.loadSmash(smash);
            return;
        }
        this.handleEndOfWaterfallWithoutLoading();
    }

    private void loadSmash(ProgBannerSmash smash) {
        this.mActiveSmash = smash;
        String serverData = null;
        if (smash.isBidder()) {
            serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
            smash.setDynamicDemandSourceIdByServerData(serverData);
        }
        smash.loadBanner(this.mIronSourceBanner, this.mCurrentPlacement, serverData);
    }

    private void handleEndOfWaterfallWithoutLoading() {
        String errorReason = this.mWaterfall.isEmpty() ? "Empty waterfall" : "No candidates left to load";
        IronLog.INTERNAL.verbose("errorReason = " + errorReason);
        if (this.compareStateAndSetIfTrue(BannerManagerState.LOADING, BannerManagerState.READY_TO_LOAD)) {
            Object[][] additionalData = new Object[][]{{"errorCode", 606}, {"reason", errorReason}};
            this.sendMediationEvent(3111, additionalData);
            BannerCallbackThrottler.getInstance().sendBannerAdLoadFailed(this.mIronSourceBanner, new IronSourceError(606, errorReason));
        } else if (this.compareStateAndSetIfTrue(BannerManagerState.RELOADING, BannerManagerState.LOADED)) {
            this.sendMediationEvent(3201);
            this.mTimer.startReloadTimer(this);
        } else {
            this.setState(BannerManagerState.READY_TO_LOAD);
            IronLog.INTERNAL.error("wrong state = " + (Object)((Object)this.mCurrentState));
        }
    }

    private void bindView(View adView, FrameLayout.LayoutParams frameLayoutParams) {
        this.mIronSourceBanner.addViewWithFrameLayoutParams(adView, frameLayoutParams);
    }

    private String updateWaterfall(List<AuctionResponseItem> waterfall) {
        IronLog.INTERNAL.verbose("waterfall.size() = " + waterfall.size());
        this.mWaterfall.clear();
        this.mWaterfallServerData.clear();
        this.mWaterfallPerformance.clear();
        StringBuilder waterfallString = new StringBuilder();
        for (int i = 0; i < waterfall.size(); ++i) {
            AuctionResponseItem item = waterfall.get(i);
            this.addSmashToWaterfall(item);
            waterfallString.append(this.createWaterfallStringFromAuctionItem(item));
            if (i == waterfall.size() - 1) continue;
            waterfallString.append(",");
        }
        IronLog.INTERNAL.verbose("response waterfall = " + waterfallString.toString());
        return waterfallString.toString();
    }

    private void addSmashToWaterfall(AuctionResponseItem item) {
        ProgBannerSmash smashFromInitResponse = this.mSmashes.get(item.getInstanceName());
        if (smashFromInitResponse != null) {
            AbstractAdapter adapter = AdapterRepository.getInstance().createAdapter(smashFromInitResponse.mAdapterConfig.getProviderSettings());
            if (adapter != null) {
                ProgBannerSmash smash = new ProgBannerSmash(this.mData, this, smashFromInitResponse.mAdapterConfig.getProviderSettings(), adapter, this.mCurrentSessionDepth, this.mCurrentAuctionId, this.mAuctionTrail, this.mAuctionFallback);
                smash.setIsLoadCandidate(true);
                this.mWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
                this.mWaterfallPerformance.put(item.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceDidntAttemptToLoad);
            }
        } else {
            IronLog.INTERNAL.error("could not find matching smash for auction response item - item = " + item.getInstanceName());
        }
    }

    private void updateWaterfallToNonBidding() {
        List<AuctionResponseItem> nonBiddersWaterfall = this.extractNonBidderProvidersFromWaterfall();
        this.updateWaterfall(nonBiddersWaterfall);
    }

    private List<AuctionResponseItem> extractNonBidderProvidersFromWaterfall() {
        CopyOnWriteArrayList<AuctionResponseItem> nonBidders = new CopyOnWriteArrayList<AuctionResponseItem>();
        for (ProgBannerSmash smash : this.mSmashes.values()) {
            if (smash.isBidder() || CappingManager.isBnPlacementCapped((Context)ContextProvider.getInstance().getCurrentActiveActivity(), this.getCurrentPlacementName())) continue;
            nonBidders.add(new AuctionResponseItem(smash.getInstanceName()));
        }
        return nonBidders;
    }

    private void handlePlacementCapping() {
        String placementName = this.getCurrentPlacementName();
        CappingManager.incrementBnShowCounter((Context)ContextProvider.getInstance().getCurrentActiveActivity(), placementName);
        if (CappingManager.isBnPlacementCapped((Context)ContextProvider.getInstance().getCurrentActiveActivity(), placementName)) {
            this.sendMediationEvent(3400);
        }
    }

    private String createWaterfallStringFromAuctionItem(AuctionResponseItem item) {
        ProgBannerSmash smash = this.mSmashes.get(item.getInstanceName());
        String isProgrammatic = smash != null ? (smash.isBidder() ? "2" : "1") : (TextUtils.isEmpty((CharSequence)item.getServerData()) ? "1" : "2");
        return isProgrammatic + item.getInstanceName();
    }

    private boolean canSendBannerCallbacks() {
        return this.mIronSourceBanner != null && !this.mIronSourceBanner.isDestroyed();
    }

    private void storeWaterfallPerformance() {
        if (!this.mWaterfallPerformance.isEmpty()) {
            this.mAuctionHistory.storeWaterfallPerformance(this.mWaterfallPerformance);
            this.mWaterfallPerformance.clear();
        }
    }

    private void destroyActiveSmash() {
        if (this.mActiveSmash != null) {
            IronLog.INTERNAL.verbose("mActiveSmash = " + this.mActiveSmash.getInstanceSignature());
            this.mActiveSmash.destroyBanner();
            this.mActiveSmash = null;
        }
    }

    private boolean waitBeforeAuction() {
        long timeToWaitBeforeAuction = BannerUtils.getTimeToWaitBeforeFirstAuction(this.mInitMangerTimeStamp, this.mData.getTimeToWaitBeforeFirstAuctionInMillis());
        if (timeToWaitBeforeAuction > 0L) {
            IronLog.INTERNAL.verbose("waiting before auction - timeToWaitBeforeAuction = " + timeToWaitBeforeAuction);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ProgBannerManager.this.makeAuction();
                }
            }, timeToWaitBeforeAuction);
            return true;
        }
        return false;
    }

    private void sendMediationEvent(int eventId) {
        this.sendMediationEvent(eventId, null);
    }

    private void sendMediationEvent(int eventId, Object[][] additionalData) {
        JSONObject data = IronSourceUtils.getMediationAdditionalData(false, true, 1);
        try {
            ISBannerSize size = this.getCurrentBannerSize();
            if (size != null) {
                ProgBannerManager.addEventSizeFields(data, size);
            }
            if (this.mCurrentPlacement != null) {
                data.put("placement", (Object)this.getCurrentPlacementName());
            }
            data.put("sessionDepth", this.mCurrentSessionDepth);
            if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
                data.put("auctionId", (Object)this.mCurrentAuctionId);
            }
            if (this.shouldAddAuctionParams(eventId)) {
                data.put("auctionTrials", this.mAuctionTrail);
                if (!TextUtils.isEmpty((CharSequence)this.mAuctionFallback)) {
                    data.put("auctionFallback", (Object)this.mAuctionFallback);
                }
            }
            if (additionalData != null) {
                for (Object[] pair : additionalData) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronLog.INTERNAL.error(Log.getStackTraceString((Throwable)e2));
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private static void addEventSizeFields(JSONObject data, ISBannerSize size) {
        try {
            switch (size.getDescription()) {
                case "BANNER": {
                    data.put("bannerAdSize", 1);
                    break;
                }
                case "LARGE": {
                    data.put("bannerAdSize", 2);
                    break;
                }
                case "RECTANGLE": {
                    data.put("bannerAdSize", 3);
                    break;
                }
                case "SMART": {
                    data.put("bannerAdSize", 5);
                    break;
                }
                case "CUSTOM": {
                    data.put("bannerAdSize", 6);
                    data.put("custom_banner_size", (Object)(size.getWidth() + "x" + size.getHeight()));
                }
            }
        }
        catch (Exception e2) {
            IronLog.INTERNAL.error(Log.getStackTraceString((Throwable)e2));
        }
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 3011 || eventId == 3110 || eventId == 3111 || eventId == 3112 || eventId == 3115 || eventId == 3501 || eventId == 3502;
    }

    private ISBannerSize getBannerSizeForAuction() {
        ISBannerSize bannerSize = null;
        if (this.mIronSourceBanner != null && this.mIronSourceBanner.getSize() != null) {
            bannerSize = this.mIronSourceBanner.getSize().isSmart() ? (AdapterUtils.isLargeScreen(ContextProvider.getInstance().getCurrentActiveActivity()) ? ISBannerSize.LEADERBOARD : ISBannerSize.BANNER) : this.mIronSourceBanner.getSize();
        }
        return bannerSize;
    }

    private ISBannerSize getCurrentBannerSize() {
        return this.mIronSourceBanner != null ? this.mIronSourceBanner.getSize() : null;
    }

    private String getCurrentPlacementName() {
        return this.mCurrentPlacement != null ? this.mCurrentPlacement.getPlacementName() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaitingForLoadResponse() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mCurrentState == BannerManagerState.LOADING || this.mCurrentState == BannerManagerState.RELOADING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaitingForAuctionResponse() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mCurrentState == BannerManagerState.FIRST_AUCTION || this.mCurrentState == BannerManagerState.AUCTION;
        }
    }

    static enum BannerManagerState {
        NONE,
        READY_TO_LOAD,
        STARTED_LOADING,
        FIRST_AUCTION,
        AUCTION,
        LOADING,
        RELOADING,
        LOADED;

    }
}

