/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.environment.NetworkStateReceiver;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AuctionEventListener;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionHistory;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.BaseProgManager;
import com.ironsource.mediationsdk.IProgRvManager;
import com.ironsource.mediationsdk.LWSProgRvSmash;
import com.ironsource.mediationsdk.LWSRvManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.RVListenerWrapper;
import com.ironsource.mediationsdk.RvLoadTrigger;
import com.ironsource.mediationsdk.RvLoadTriggerCallback;
import com.ironsource.mediationsdk.WaterfallLifeCycleHolder;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionCappingManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class LWSProgRvManager
extends BaseProgManager
implements LWSRvManagerListener,
RvLoadTriggerCallback,
AuctionEventListener,
IProgRvManager,
NetworkStateReceiver.NetworkStateReceiverListener {
    private WaterfallLifeCycleHolder waterfallLifeCycleHolder;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private ConcurrentHashMap<String, AuctionHistory.ISAuctionPerformance> mWaterfallPerformance;
    private AuctionResponseItem mGenericNotifications;
    private AuctionHistory mAuctionHistory;
    private AuctionHandler mAuctionHandler;
    private RvLoadTrigger mRvLoadTrigger;
    private boolean mIsAuctionEnabled;
    private long mAuctionStartTime;
    private String mAuctionFailedReason = "";
    private int mAuctionTrial;
    private NetworkStateReceiver mNetworkStateReceiver;
    private boolean mShouldTrackNetworkState = false;
    private final ConcurrentHashMap<String, LWSProgRvSmash> smashes;
    private SessionCappingManager mSessionCappingManager;
    private int mSessionDepth = 1;
    private String mCurrentPlacement;
    private int mMaxSmashesToLoad;
    private boolean mAdvancedLoading;
    private boolean mIsShowingVideo;
    private RV_MEDIATION_STATE mState;
    private long mLastChangedAvailabilityTime;
    private Boolean mLastReportedAvailabilityState;
    private final Object stateLock = new Object();

    public LWSProgRvManager(List<ProviderSettings> providersList, RewardedVideoConfigurations configs, String appKey, String userId, ImpressionDataListener impressionDataListener) {
        super(impressionDataListener);
        long initStartTime = new Date().getTime();
        this.sendMediationEventWithoutAuctionId(81312);
        this.setState(RV_MEDIATION_STATE.RV_STATE_INITIATING);
        this.mLastReportedAvailabilityState = null;
        this.mMaxSmashesToLoad = configs.getRewardedVideoAdaptersSmartLoadAmount();
        this.mAdvancedLoading = configs.getRewardedVideoAdvancedLoading();
        this.mCurrentPlacement = "";
        AuctionSettings auctionSettings = configs.getRewardedVideoAuctionSettings();
        this.mIsShowingVideo = false;
        this.waterfallLifeCycleHolder = new WaterfallLifeCycleHolder(configs.getRewardedVideoAuctionSettings().getLoadWhileShowSupportArray(), configs.getRewardedVideoAuctionSettings().getTimeToDeleteOldWaterfallAfterAuction());
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mWaterfallPerformance = new ConcurrentHashMap();
        this.mLastChangedAvailabilityTime = new Date().getTime();
        boolean bl = this.mIsAuctionEnabled = auctionSettings.getNumOfMaxTrials() > 0;
        if (this.mIsAuctionEnabled) {
            this.mAuctionHandler = new AuctionHandler("rewardedVideo", auctionSettings, this);
        }
        this.mRvLoadTrigger = new RvLoadTrigger(auctionSettings, this);
        this.smashes = new ConcurrentHashMap();
        ArrayList<String> instances = new ArrayList<String>();
        for (ProviderSettings provider : providersList) {
            AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(provider, provider.getRewardedVideoSettings());
            if (adapter == null) continue;
            LWSProgRvSmash smash = new LWSProgRvSmash(appKey, userId, provider, this, configs.getRewardedVideoAdaptersSmartLoadTimeout(), adapter, this.mSessionDepth);
            String instanceName = smash.getInstanceName();
            this.smashes.put(instanceName, smash);
            instances.add(instanceName);
        }
        this.mAuctionHistory = new AuctionHistory(instances, auctionSettings.getAuctionSavedHistoryLimit());
        this.mSessionCappingManager = new SessionCappingManager(new ArrayList<ProgSmash>(this.smashes.values()));
        long elapsedTime = new Date().getTime() - initStartTime;
        this.sendMediationEventWithoutAuctionId(81313, new Object[][]{{"duration", elapsedTime}});
        this.loadRewardedVideo(auctionSettings.getTimeToWaitBeforeFirstAuctionMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showRewardedVideo(Placement placement) {
        LWSProgRvSmash smashToShow = null;
        Object object = this.stateLock;
        synchronized (object) {
            if (placement == null) {
                String message = "showRewardedVideo error: empty default placement";
                this.logAPIError(message);
                IronSourceError error = new IronSourceError(1021, message);
                RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
                this.sendMediationEvent(1113, new Object[][]{{"errorCode", 1021}, {"reason", message}}, false, true);
                return;
            }
            this.mCurrentPlacement = placement.getPlacementName();
            this.logApi("showRewardedVideo(" + placement + ")");
            this.sendMediationEventWithPlacement(1100);
            if (this.mIsShowingVideo) {
                String message = "showRewardedVideo error: can't show ad while an ad is already showing";
                this.logAPIError(message);
                IronSourceError error = new IronSourceError(1022, message);
                RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
                this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 1022}, {"reason", message}});
                return;
            }
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                String message = "showRewardedVideo error: show called while no ads are available";
                this.logAPIError(message);
                IronSourceError error = new IronSourceError(1023, message);
                RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
                this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 1023}, {"reason", message}});
                return;
            }
            if (CappingManager.isRvPlacementCapped(ContextProvider.getInstance().getApplicationContext(), this.mCurrentPlacement)) {
                String message = "showRewardedVideo error: placement " + this.mCurrentPlacement + " is capped";
                this.logAPIError(message);
                IronSourceError error = new IronSourceError(524, message);
                RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
                this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 524}, {"reason", message}});
                return;
            }
            for (LWSProgRvSmash smash : this.waterfallLifeCycleHolder.getCurrentWaterfall()) {
                if (smash.isReadyToShow()) {
                    this.mIsShowingVideo = true;
                    smash.reportShowChance(true);
                    smashToShow = smash;
                    this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                    break;
                }
                smash.reportShowChance(false);
            }
            if (smashToShow == null) {
                String message = "showRewardedVideo(): No ads to show";
                this.logApi(message);
                RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
                this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 509}, {"reason", message}});
                this.mRvLoadTrigger.showError();
                return;
            }
        }
        if (smashToShow != null) {
            this.showVideo(smashToShow, placement);
            return;
        }
    }

    @Override
    public boolean isRewardedVideoAvailable() {
        if (this.mShouldTrackNetworkState && !IronSourceUtils.isNetworkConnected(ContextProvider.getInstance().getApplicationContext())) {
            return false;
        }
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW || this.mIsShowingVideo) {
            return false;
        }
        for (LWSProgRvSmash smash : this.waterfallLifeCycleHolder.getCurrentWaterfall()) {
            if (!smash.isReadyToShow()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoadSuccess(LWSProgRvSmash smash) {
        Object object = this.stateLock;
        synchronized (object) {
            this.logSmashCallback(smash, "onLoadSuccess mState=" + (Object)((Object)this.mState));
            if (smash.getAuctionId() != this.waterfallLifeCycleHolder.getCurrentWaterfallId() || this.mState == RV_MEDIATION_STATE.RV_STATE_AUCTION_IN_PROGRESS) {
                this.logInternal("onLoadSuccess was invoked with auctionId: " + smash.getAuctionId() + " and the current id is " + this.waterfallLifeCycleHolder.getCurrentWaterfallId());
                smash.sendProviderEvent(81315, new Object[][]{{"errorCode", 2}, {"reason", "onLoadSuccess wrong auction ID " + (Object)((Object)this.mState)}});
                return;
            }
            this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceLoadedSuccessfully);
            if (this.mState == RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES) {
                this.reportAvailabilityIfNeeded(true);
                this.setState(RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW);
                long elapsedTime = new Date().getTime() - this.mAuctionStartTime;
                this.sendMediationEvent(1003, new Object[][]{{"duration", elapsedTime}});
                if (this.mIsAuctionEnabled) {
                    AuctionResponseItem winnerInstance = this.mWaterfallServerData.get(smash.getInstanceName());
                    if (winnerInstance != null) {
                        this.mAuctionHandler.reportLoadSuccess(winnerInstance, smash.getInstanceType(), this.mGenericNotifications);
                        this.mAuctionHandler.reportAuctionLose(this.waterfallLifeCycleHolder.getCurrentWaterfall(), this.mWaterfallServerData, smash.getInstanceType(), this.mGenericNotifications, winnerInstance);
                    } else {
                        String smashName = smash != null ? smash.getInstanceName() : "Smash is null";
                        this.logErrorInternal("onLoadSuccess winner instance " + smashName + " missing from waterfall. auctionId: " + smash.getAuctionId() + " and the current id is " + this.waterfallLifeCycleHolder.getCurrentWaterfallId());
                        this.sendMediationEvent(81317, new Object[][]{{"errorCode", 1010}, {"reason", "Loaded missing " + (Object)((Object)RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES)}, {"ext1", smashName}});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoadError(LWSProgRvSmash smash) {
        CopyOnWriteArrayList<LWSProgRvSmash> smashesToLoad = new CopyOnWriteArrayList<LWSProgRvSmash>();
        Iterator iterator = this.stateLock;
        synchronized (iterator) {
            this.logSmashCallback(smash, "onLoadError mState=" + (Object)((Object)this.mState));
            if (smash.getAuctionId() != this.waterfallLifeCycleHolder.getCurrentWaterfallId() || this.mState == RV_MEDIATION_STATE.RV_STATE_AUCTION_IN_PROGRESS) {
                this.logInternal("onLoadError was invoked with auctionId:" + smash.getAuctionId() + " and the current id is " + this.waterfallLifeCycleHolder.getCurrentWaterfallId());
                smash.sendProviderEvent(81315, new Object[][]{{"errorCode", 4}, {"reason", "loadError wrong auction ID " + (Object)((Object)this.mState)}});
                return;
            }
            this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceFailedToLoad);
            if (this.mState == RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES || this.mState == RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                boolean hasLoadInProgress = false;
                boolean hasLoaded = false;
                for (LWSProgRvSmash waterfallSmash : this.waterfallLifeCycleHolder.getCurrentWaterfall()) {
                    if (waterfallSmash.getIsLoadCandidate()) {
                        if (this.mAdvancedLoading && waterfallSmash.isBidder() && (hasLoadInProgress || hasLoaded)) {
                            String reason = hasLoadInProgress ? "a non bidder is being loaded" : "a non bidder was already loaded successfully";
                            this.logInternal("Advanced Loading: Won't start loading bidder " + waterfallSmash.getInstanceName() + " as " + reason);
                            break;
                        }
                        if (this.mWaterfallServerData.get(waterfallSmash.getInstanceName()) == null) continue;
                        smashesToLoad.add(waterfallSmash);
                        if (!this.mAdvancedLoading || !smash.isBidder() || waterfallSmash.isBidder() || smashesToLoad.size() >= this.mMaxSmashesToLoad) break;
                        hasLoadInProgress = true;
                        continue;
                    }
                    if (waterfallSmash.isLoadingInProgress()) {
                        hasLoadInProgress = true;
                        continue;
                    }
                    if (!waterfallSmash.isReadyToShow()) continue;
                    hasLoaded = true;
                }
                if (!(smashesToLoad != null && smashesToLoad.size() != 0 || hasLoaded || hasLoadInProgress)) {
                    this.logInternal("onLoadError(): No other available smashes");
                    if (!this.mIsShowingVideo) {
                        this.reportAvailabilityIfNeeded(false);
                    }
                    this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                    this.mRvLoadTrigger.loadError();
                }
            }
        }
        for (LWSProgRvSmash smashToLoad : smashesToLoad) {
            this.loadSmash(smashToLoad);
        }
    }

    @Override
    public void onRewardedVideoAdOpened(LWSProgRvSmash smash) {
        this.waterfallLifeCycleHolder.setShowingSmash(smash);
        ++this.mSessionDepth;
        this.logSmashCallback(smash, "onRewardedVideoAdOpened");
        RVListenerWrapper.getInstance().onRewardedVideoAdOpened();
        if (this.mIsAuctionEnabled) {
            AuctionResponseItem showingInstance = this.mWaterfallServerData.get(smash.getInstanceName());
            if (showingInstance != null) {
                this.mAuctionHandler.reportImpression(showingInstance, smash.getInstanceType(), this.mGenericNotifications, this.mCurrentPlacement);
                this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceShowedSuccessfully);
                this.reportImpressionDataToPublisher(true, showingInstance, this.mCurrentPlacement);
            } else {
                String smashName = smash != null ? smash.getInstanceName() : "Smash is null";
                this.logErrorInternal("onRewardedVideoAdOpened showing instance " + smashName + " missing from waterfall");
                this.sendMediationEvent(81317, new Object[][]{{"errorCode", 1011}, {"reason", "Showing missing " + (Object)((Object)this.mState)}, {"ext1", smashName}});
            }
        }
        this.mRvLoadTrigger.showStart();
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, LWSProgRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
        this.mIsShowingVideo = false;
        this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
        this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceFailedToShow);
        this.reportImpressionDataToPublisher(false, this.mWaterfallServerData.get(smash.getInstanceName()), this.mCurrentPlacement);
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            this.reportAvailabilityIfNeeded(false);
        }
        this.mRvLoadTrigger.showError();
    }

    @Override
    public void onRewardedVideoAdClosed(LWSProgRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdClosed, mediation state: " + this.mState.name());
        RVListenerWrapper.getInstance().onRewardedVideoAdClosed();
        this.mIsShowingVideo = false;
        boolean hasLoadedNextWaterfall = this.mState == RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW;
        StringBuilder availableInstancesString = new StringBuilder();
        if (hasLoadedNextWaterfall) {
            for (LWSProgRvSmash aSmash : this.waterfallLifeCycleHolder.getCurrentWaterfall()) {
                if (!aSmash.isLoaded()) continue;
                availableInstancesString.append(aSmash.getInstanceName() + ";");
            }
        }
        smash.sendProviderEventWithPlacement(1203, new Object[][]{{"ext1", "otherRVAvailable = " + (availableInstancesString.length() > 0 ? "true|" + availableInstancesString : "false")}});
        if (smash.equals(this.waterfallLifeCycleHolder.getShowingSmash())) {
            this.waterfallLifeCycleHolder.setShowingSmash(null);
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                this.reportAvailabilityIfNeeded(false);
            }
        }
    }

    @Override
    public void onRewardedVideoAdStarted(LWSProgRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdStarted");
        RVListenerWrapper.getInstance().onRewardedVideoAdStarted();
    }

    @Override
    public void onRewardedVideoAdEnded(LWSProgRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdEnded");
        RVListenerWrapper.getInstance().onRewardedVideoAdEnded();
    }

    @Override
    public void onRewardedVideoAdRewarded(LWSProgRvSmash smash, Placement placement) {
        this.logSmashCallback(smash, "onRewardedVideoAdRewarded");
        RVListenerWrapper.getInstance().onRewardedVideoAdRewarded(placement);
    }

    @Override
    public void onRewardedVideoAdClicked(LWSProgRvSmash smash, Placement placement) {
        this.logSmashCallback(smash, "onRewardedVideoAdClicked");
        RVListenerWrapper.getInstance().onRewardedVideoAdClicked(placement);
    }

    @Override
    public void onAuctionSuccess(List<AuctionResponseItem> newWaterfall, String auctionId, AuctionResponseItem genericNotifications, int auctionTrial, long elapsedTime) {
        this.logInternal("makeAuction(): success");
        this.mGenericNotifications = genericNotifications;
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFailedReason = "";
        this.updateWaterfall(newWaterfall, auctionId);
        this.sendMediationEvent(1302, new Object[][]{{"duration", elapsedTime}});
        this.loadSmashes();
    }

    @Override
    public void onAuctionFailed(int errorCode, String errorMessage, int auctionTrial, String auctionFailedReason, long elapsedTime) {
        this.logInternal("Auction failed | moving to fallback waterfall");
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFailedReason = auctionFailedReason;
        this.updateWaterfallToNonBidding();
        if (TextUtils.isEmpty((CharSequence)errorMessage)) {
            this.sendMediationEventWithoutAuctionId(1301, new Object[][]{{"errorCode", errorCode}, {"duration", elapsedTime}});
        } else {
            this.sendMediationEventWithoutAuctionId(1301, new Object[][]{{"errorCode", errorCode}, {"reason", errorMessage}, {"duration", elapsedTime}});
        }
        this.loadSmashes();
    }

    @Override
    public void onLoadTriggered() {
        this.logInternal("onLoadTriggered: RV load was triggered in " + (Object)((Object)this.mState) + " state");
        this.loadRewardedVideo(0L);
    }

    private void loadRewardedVideo(long timeToWaitBeforeAuction) {
        if (this.mSessionCappingManager.areAllSmashesCapped()) {
            this.logInternal("all smashes are capped");
            this.sendMediationEvent(81001, new Object[][]{{"errorCode", 80001}, {"reason", "all smashes are capped"}});
            this.handleLoadFailure();
            return;
        }
        if (this.mIsAuctionEnabled) {
            if (!this.mWaterfallPerformance.isEmpty()) {
                this.mAuctionHistory.storeWaterfallPerformance(this.mWaterfallPerformance);
                this.mWaterfallPerformance.clear();
            }
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    LWSProgRvManager.this.makeAuction();
                }
            }, timeToWaitBeforeAuction);
        } else {
            this.logInternal("auction fallback flow starting");
            this.updateWaterfallToNonBidding();
            if (this.waterfallLifeCycleHolder.getCurrentWaterfall().isEmpty()) {
                this.logInternal("loadSmashes -  waterfall is empty");
                this.sendMediationEvent(81001, new Object[][]{{"errorCode", 80004}, {"reason", "waterfall is empty"}});
                this.handleLoadFailure();
                return;
            }
            this.sendMediationEventWithoutAuctionId(1000);
            this.loadSmashes();
        }
    }

    private void showVideo(LWSProgRvSmash smash, Placement placement) {
        this.logInternal("showVideo()");
        this.mSessionCappingManager.increaseShowCounter(smash);
        if (this.mSessionCappingManager.isCapped(smash)) {
            smash.setCappedPerSession();
            IronSourceUtils.sendAutomationLog(smash.getInstanceName() + " rewarded video is now session capped");
        }
        CappingManager.incrementRvShowCounter(ContextProvider.getInstance().getApplicationContext(), placement.getPlacementName());
        if (CappingManager.isRvPlacementCapped(ContextProvider.getInstance().getApplicationContext(), placement.getPlacementName())) {
            this.sendMediationEventWithPlacement(1400);
        }
        smash.showVideo(placement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAuction() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_AUCTION_IN_PROGRESS) {
                this.setState(RV_MEDIATION_STATE.RV_STATE_AUCTION_IN_PROGRESS);
                AsyncTask.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LWSProgRvManager.this.logInternal("makeAuction()");
                        LWSProgRvManager.this.mAuctionStartTime = new Date().getTime();
                        HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
                        ArrayList<String> noBidderCandidates = new ArrayList<String>();
                        StringBuilder waterfallStr = new StringBuilder();
                        for (LWSProgRvSmash smash : LWSProgRvManager.this.smashes.values()) {
                            if (LWSProgRvManager.this.mSessionCappingManager.isCapped(smash) || !LWSProgRvManager.this.waterfallLifeCycleHolder.shouldAddSmashToWaterfallRequest(smash)) continue;
                            if (smash.isBidder()) {
                                Map<String, Object> biddingData = smash.getBiddingData();
                                if (biddingData == null) continue;
                                bidderCandidates.put(smash.getInstanceName(), biddingData);
                                waterfallStr.append(smash.getInstanceType() + smash.getInstanceName() + ",");
                                continue;
                            }
                            noBidderCandidates.add(smash.getInstanceName());
                            waterfallStr.append(smash.getInstanceType() + smash.getInstanceName() + ",");
                        }
                        if (bidderCandidates.keySet().size() == 0 && noBidderCandidates.size() == 0) {
                            LWSProgRvManager.this.sendMediationEvent(1301, new Object[][]{{"errorCode", 1005}, {"duration", 0}});
                            LWSProgRvManager.this.logInternal("makeAuction() failed - No candidates available for auctioning");
                            LWSProgRvManager.this.handleLoadFailure();
                            return;
                        }
                        LWSProgRvManager.this.logInternal("makeAuction() - request waterfall is: " + waterfallStr);
                        LWSProgRvManager.this.sendMediationEventWithoutAuctionId(1000);
                        LWSProgRvManager.this.sendMediationEventWithoutAuctionId(1300);
                        LWSProgRvManager.this.sendMediationEventWithoutAuctionId(1310, new Object[][]{{"ext1", waterfallStr.toString()}});
                        LWSProgRvManager.this.mAuctionHandler.executeAuction(ContextProvider.getInstance().getApplicationContext(), bidderCandidates, noBidderCandidates, LWSProgRvManager.this.mAuctionHistory, LWSProgRvManager.this.mSessionDepth);
                    }
                });
            }
        }
    }

    private void updateWaterfallToNonBidding() {
        List<AuctionResponseItem> nonBiddersWaterfall = this.extractNonBidderProvidersFromWaterfall();
        this.updateWaterfall(nonBiddersWaterfall, "fallback_" + System.currentTimeMillis());
    }

    private List<AuctionResponseItem> extractNonBidderProvidersFromWaterfall() {
        CopyOnWriteArrayList<AuctionResponseItem> nonBidders = new CopyOnWriteArrayList<AuctionResponseItem>();
        for (LWSProgRvSmash smash : this.smashes.values()) {
            if (smash.isBidder() || this.mSessionCappingManager.isCapped(smash) || !this.waterfallLifeCycleHolder.shouldAddSmashToWaterfallRequest(smash)) continue;
            nonBidders.add(new AuctionResponseItem(smash.getInstanceName()));
        }
        return nonBidders;
    }

    private void updateWaterfall(List<AuctionResponseItem> waterfall, String currentWaterfallId) {
        this.mWaterfallServerData.clear();
        this.mWaterfallPerformance.clear();
        CopyOnWriteArrayList<LWSProgRvSmash> smashesFromWaterfall = new CopyOnWriteArrayList<LWSProgRvSmash>();
        StringBuilder waterfallStr = new StringBuilder();
        for (AuctionResponseItem item : waterfall) {
            waterfallStr.append(this.getAuctionResponseItemAsStringForReporting(item) + ",");
            LWSProgRvSmash smashFromInitResponse = this.smashes.get(item.getInstanceName());
            if (smashFromInitResponse != null) {
                AbstractAdapter adapter = AdapterRepository.getInstance().createAdapter(smashFromInitResponse.mAdapterConfig.getProviderSettings());
                if (adapter == null) continue;
                LWSProgRvSmash smash = new LWSProgRvSmash(smashFromInitResponse, this, adapter, this.mSessionDepth, currentWaterfallId, this.mAuctionTrial, this.mAuctionFailedReason);
                smash.setIsLoadCandidate(true);
                smashesFromWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
                this.mWaterfallPerformance.put(item.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceDidntAttemptToLoad);
                continue;
            }
            this.logInternal("updateWaterfall() - could not find matching smash for auction response item " + item.getInstanceName());
        }
        this.waterfallLifeCycleHolder.updateWaterFall(smashesFromWaterfall, currentWaterfallId);
        if (this.waterfallLifeCycleHolder.areWaterFallsOverMaximum()) {
            this.sendMediationEvent(81318, new Object[][]{{"reason", "waterfalls hold too many with size=" + this.waterfallLifeCycleHolder.getNumberOfWaterfalls()}});
        }
        this.logInternal("updateWaterfall() - response waterfall is " + waterfallStr.toString());
        if (waterfallStr.length() == 0) {
            this.logInternal("Updated waterfall is empty");
        }
        this.sendMediationEvent(1311, new Object[][]{{"ext1", waterfallStr.toString()}});
    }

    private String getAuctionResponseItemAsStringForReporting(AuctionResponseItem item) {
        LWSProgRvSmash smash = this.smashes.get(item.getInstanceName());
        String isProgrammatic = smash != null ? Integer.toString(smash.getInstanceType()) : (TextUtils.isEmpty((CharSequence)item.getServerData()) ? "1" : "2");
        return isProgrammatic + item.getInstanceName();
    }

    private void loadSmashes() {
        if (this.waterfallLifeCycleHolder.getCurrentWaterfall().isEmpty()) {
            this.logInternal("loadSmashes -  waterfall is empty");
            this.sendMediationEvent(81001, new Object[][]{{"errorCode", 80004}, {"reason", "waterfall is empty"}});
            this.handleLoadFailure();
            return;
        }
        this.setState(RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES);
        int loadedInstances = 0;
        for (int i = 0; i < this.waterfallLifeCycleHolder.getCurrentWaterfall().size() && loadedInstances < this.mMaxSmashesToLoad; ++i) {
            LWSProgRvSmash smash = this.waterfallLifeCycleHolder.getCurrentWaterfall().get(i);
            if (!smash.getIsLoadCandidate()) continue;
            if (this.mAdvancedLoading && smash.isBidder()) {
                if (loadedInstances == 0) {
                    this.loadSmash(smash);
                    break;
                }
                this.logInternal("Advanced Loading: Won't start loading bidder " + smash.getInstanceName() + " as a non bidder is being loaded");
                break;
            }
            this.loadSmash(smash);
            ++loadedInstances;
        }
    }

    private void loadSmash(LWSProgRvSmash smash) {
        String serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
        smash.setDynamicDemandSourceIdByServerData(serverData);
        smash.loadVideo(serverData);
    }

    private void handleLoadFailure() {
        this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
        if (!this.mIsShowingVideo) {
            this.reportAvailabilityIfNeeded(false);
        }
        this.mRvLoadTrigger.loadError();
    }

    private void setState(RV_MEDIATION_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        this.mState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportAvailabilityIfNeeded(boolean isAvailable) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.mLastReportedAvailabilityState == null || this.mLastReportedAvailabilityState != isAvailable) {
                this.mLastReportedAvailabilityState = isAvailable;
                long timeSpentInLastAvailability = new Date().getTime() - this.mLastChangedAvailabilityTime;
                this.mLastChangedAvailabilityTime = new Date().getTime();
                if (isAvailable) {
                    this.sendMediationEvent(1111, new Object[][]{{"duration", timeSpentInLastAvailability}});
                } else {
                    this.sendMediationEvent(1112, new Object[][]{{"duration", timeSpentInLastAvailability}});
                }
                RVListenerWrapper.getInstance().onRewardedVideoAvailabilityChanged(isAvailable);
            }
        }
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 1003 || eventId == 1302 || eventId == 1301;
    }

    private void logSmashCallback(LWSProgRvSmash smash, String line) {
        String text = smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "LWSProgRvManager: " + text, 0);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "LWSProgRvManager: " + text, 0);
    }

    private void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "LWSProgRvManager: " + text, 3);
    }

    private void logAPIError(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 3);
    }

    private void logApi(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 1);
    }

    private void sendMediationEventWithoutAuctionId(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false, false);
    }

    private void sendMediationEventWithoutAuctionId(int eventId) {
        this.sendMediationEvent(eventId, null, false, false);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false, true);
    }

    private void sendMediationEventWithPlacement(int eventId) {
        this.sendMediationEvent(eventId, null, true, true);
    }

    private void sendMediationEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, true, true);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals, boolean isAddPlacement, boolean isAddAuctionId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("programmatic", 2);
        if (isAddAuctionId && !TextUtils.isEmpty((CharSequence)this.waterfallLifeCycleHolder.getCurrentWaterfallId())) {
            data.put("auctionId", this.waterfallLifeCycleHolder.getCurrentWaterfallId());
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        if (this.shouldAddAuctionParams(eventId)) {
            RewardedVideoEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFailedReason);
        }
        data.put("sessionDepth", this.mSessionDepth);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "LWSProgRvManager: RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    @Override
    public void onNetworkAvailabilityChanged(boolean connected) {
        if (!this.mShouldTrackNetworkState) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Network Availability Changed To: " + connected, 1);
        if (this.shouldNotifyNetworkAvailabilityChanged(connected)) {
            this.reportAvailabilityIfNeeded(connected);
        }
    }

    @Override
    public void shouldTrackNetworkState(Context context, boolean track) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "LWSProgRvManager Should Track Network State: " + track, 0);
        this.mShouldTrackNetworkState = track;
        if (this.mShouldTrackNetworkState) {
            if (this.mNetworkStateReceiver == null) {
                this.mNetworkStateReceiver = new NetworkStateReceiver(context, this);
            }
            context.getApplicationContext().registerReceiver((BroadcastReceiver)this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        } else if (this.mNetworkStateReceiver != null) {
            context.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mNetworkStateReceiver);
        }
    }

    private boolean shouldNotifyNetworkAvailabilityChanged(boolean connected) {
        boolean shouldNotify = false;
        if (this.mLastReportedAvailabilityState == null) {
            return false;
        }
        if (connected && !this.mLastReportedAvailabilityState.booleanValue() && this.isRewardedVideoAvailable()) {
            shouldNotify = true;
        } else if (!connected && this.mLastReportedAvailabilityState.booleanValue()) {
            shouldNotify = true;
        }
        return shouldNotify;
    }

    private static enum RV_MEDIATION_STATE {
        RV_STATE_INITIATING,
        RV_STATE_AUCTION_IN_PROGRESS,
        RV_STATE_NOT_LOADED,
        RV_STATE_LOADING_SMASHES,
        RV_STATE_READY_TO_SHOW;

    }
}

