/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.impressionData.ImpressionData;
import com.ironsource.mediationsdk.utilities.IronsourceJsonUtilities;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuctionResponseItem {
    private String mInstanceName;
    private String mServerData;
    private String mPrice;
    private List<String> mBurls;
    private List<String> mLurls;
    private List<String> mNurls;
    private boolean mIsValid;
    private ImpressionData mImpressionData;

    public AuctionResponseItem(String instanceName) {
        this.mInstanceName = instanceName;
        this.mServerData = "";
        this.mPrice = "";
        this.mBurls = new ArrayList<String>();
        this.mLurls = new ArrayList<String>();
        this.mNurls = new ArrayList<String>();
        this.mIsValid = true;
        this.mImpressionData = null;
    }

    public AuctionResponseItem(JSONObject json, JSONObject auctionImpressionData) {
        this.mIsValid = false;
        try {
            int i;
            if (json.has("instance")) {
                this.mInstanceName = json.getString("instance");
            }
            this.mServerData = json.has("adMarkup") ? json.getString("adMarkup") : (json.has("serverData") ? json.getString("serverData") : "");
            this.mPrice = json.has("price") ? json.getString("price") : "0";
            JSONObject notifications = json.optJSONObject("notifications");
            this.mBurls = new ArrayList<String>();
            if (notifications.has("burl")) {
                JSONArray burls = notifications.getJSONArray("burl");
                for (i = 0; i < burls.length(); ++i) {
                    this.mBurls.add(burls.getString(i));
                }
            }
            this.mLurls = new ArrayList<String>();
            if (notifications.has("lurl")) {
                JSONArray lurls = notifications.getJSONArray("lurl");
                for (i = 0; i < lurls.length(); ++i) {
                    this.mLurls.add(lurls.getString(i));
                }
            }
            this.mNurls = new ArrayList<String>();
            if (notifications.has("nurl")) {
                JSONArray nurls = notifications.getJSONArray("nurl");
                for (i = 0; i < nurls.length(); ++i) {
                    this.mNurls.add(nurls.getString(i));
                }
            }
            JSONObject instanceImpressionData = null;
            if (json.has("armData")) {
                instanceImpressionData = json.optJSONObject("armData");
            }
            this.mImpressionData = new ImpressionData(IronsourceJsonUtilities.mergeJsonObjects(auctionImpressionData, instanceImpressionData));
        }
        catch (Exception e2) {
            return;
        }
        this.mIsValid = true;
    }

    public AuctionResponseItem(JSONObject json) {
        this(json, null);
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public String getServerData() {
        return this.mServerData;
    }

    public String getPrice() {
        return this.mPrice;
    }

    public List<String> getBurls() {
        return this.mBurls;
    }

    public List<String> getLurls() {
        return this.mLurls;
    }

    public List<String> getNurls() {
        return this.mNurls;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public ImpressionData getImpressionData(String placementName) {
        if (this.mImpressionData != null) {
            this.mImpressionData.replaceMacroForPlacementWithValue("${PLACEMENT_NAME}", placementName);
        }
        return this.mImpressionData;
    }
}

