/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.RvLoadTriggerCallback;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import java.util.Timer;
import java.util.TimerTask;

public class RvLoadTrigger {
    private AuctionSettings mAuctionSettings;
    private RvLoadTriggerCallback mListener;
    private Timer mTimer;

    public RvLoadTrigger(AuctionSettings auctionSettings, RvLoadTriggerCallback listener) {
        this.mAuctionSettings = auctionSettings;
        this.mListener = listener;
        this.mTimer = null;
    }

    public synchronized void showStart() {
        if (this.mAuctionSettings.getIsAuctionOnShowStart()) {
            this.stopTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RvLoadTrigger.this.mListener.onLoadTriggered();
                }
            }, this.mAuctionSettings.getTimeToWaitBeforeAuctionMs());
        }
    }

    public synchronized void showEnd() {
        if (!this.mAuctionSettings.getIsAuctionOnShowStart()) {
            this.stopTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RvLoadTrigger.this.mListener.onLoadTriggered();
                }
            }, this.mAuctionSettings.getTimeToWaitBeforeAuctionMs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showError() {
        RvLoadTrigger rvLoadTrigger = this;
        synchronized (rvLoadTrigger) {
            this.stopTimer();
        }
        this.mListener.onLoadTriggered();
    }

    public synchronized void loadError() {
        this.stopTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RvLoadTrigger.this.mListener.onLoadTriggered();
            }
        }, this.mAuctionSettings.getAuctionRetryInterval());
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }
}

