/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.eventsTracker;

import android.util.Pair;
import com.ironsource.eventsTracker.IFormatter;
import java.util.ArrayList;
import java.util.List;

public final class EventsConfiguration {
    private String endpoint;
    private boolean areEventsEnabled;
    private String httpMethod;
    private IFormatter formatter;
    private boolean allowLogs = false;
    private ArrayList<Pair<String, String>> headers;

    EventsConfiguration(Builder builder) {
        this.endpoint = builder.endpoint;
        this.areEventsEnabled = builder.areEventEnabled;
        this.httpMethod = builder.httpMethod;
        this.formatter = builder.formatter;
        this.allowLogs = builder.allowLogs;
        if (builder.headers != null) {
            this.headers = new ArrayList(builder.headers);
        }
    }

    public boolean areEventsEnabled() {
        return this.areEventsEnabled;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public IFormatter getFormatter() {
        return this.formatter;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean isAllowLogs() {
        return this.allowLogs;
    }

    public ArrayList<Pair<String, String>> getHeaders() {
        return new ArrayList<Pair<String, String>>(this.headers);
    }

    public static class Builder {
        private String endpoint = "";
        private boolean areEventEnabled = false;
        private String httpMethod = "POST";
        private IFormatter formatter;
        private boolean allowLogs = false;
        private ArrayList<Pair<String, String>> headers = new ArrayList();

        public Builder(String url) {
            if (url != null && !url.isEmpty()) {
                this.endpoint = url;
            }
        }

        public Builder setEnableEvents(boolean status) {
            this.areEventEnabled = status;
            return this;
        }

        public Builder setHttpMethodGet() {
            this.httpMethod = "GET";
            return this;
        }

        public Builder setHttpMethodPost() {
            this.httpMethod = "POST";
            return this;
        }

        public Builder setFormatter(IFormatter _formatter) {
            this.formatter = _formatter;
            return this;
        }

        public Builder addHeader(Pair<String, String> header) {
            this.headers.add(header);
            return this;
        }

        public Builder addHeaders(List<Pair<String, String>> headersInput) {
            this.headers.addAll(headersInput);
            return this;
        }

        public Builder setAllowLogs(boolean isEnabled) {
            this.allowLogs = isEnabled;
            return this;
        }

        public EventsConfiguration build() {
            return new EventsConfiguration(this);
        }
    }
}

