/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.sdk.controller.ControllerActivity;
import com.ironsource.sdk.controller.OpenUrlActivity;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.utils.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SDKUtils {
    private static final String TAG = SDKUtils.class.getSimpleName();
    private static String mAdvertisingId;
    private static boolean mIsLimitedTrackingEnabled;
    private static String mControllerUrl;
    private static int mDebugMode;
    private static String mControllerConfig;
    private static Map<String, String> mInitSDKParams;
    private static String mUserGroup;
    private static final AtomicInteger sNextGeneratedId;

    public static String getFileName(String url) {
        String[] assetSplit = url.split(File.separator);
        String fileName = assetSplit[assetSplit.length - 1];
        String[] fileNameArr = fileName.split("\\?");
        String name = fileNameArr[0];
        String encodedlFileName = null;
        try {
            encodedlFileName = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return encodedlFileName;
    }

    public static int pxToDp(long px) {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        int dp = (int)((float)px / displayMetrics.density + 0.5f);
        return dp;
    }

    public static int dpToPx(long dp) {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        int px = (int)((float)dp * displayMetrics.density + 0.5f);
        return px;
    }

    public static int convertPxToDp(int pixels) {
        int dp = (int)TypedValue.applyDimension((int)1, (float)pixels, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        return dp;
    }

    public static int convertDpToPx(int dp) {
        int pixels = (int)TypedValue.applyDimension((int)0, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        return pixels;
    }

    public static String translateRequestedOrientation(int orientation) {
        String result = "none";
        switch (orientation) {
            case 0: 
            case 6: 
            case 8: 
            case 11: {
                result = "landscape";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: {
                result = "portrait";
                break;
            }
        }
        return result;
    }

    public static String translateOrientation(int orientation) {
        String strOrientation = "none";
        switch (orientation) {
            case 2: {
                strOrientation = "landscape";
                break;
            }
            case 1: {
                strOrientation = "portrait";
            }
        }
        return strOrientation;
    }

    public static JSONObject getOrientation(Context context) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("orientation", (Object)SDKUtils.translateOrientation(DeviceStatus.getDeviceOrientation(context)));
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        return obj;
    }

    public static String createErrorMessage(String action, String stage) {
        String message = String.format("%s Failure occurred during initiation at: %s", action, stage);
        return message;
    }

    public static Long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static boolean isApplicationVisible(Context context) {
        String packageName = context.getPackageName();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equalsIgnoreCase(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static void showNoInternetDialog(Context context) {
        new AlertDialog.Builder(context).setMessage((CharSequence)"No Internet Connection").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).show();
    }

    public static byte[] encrypt(String x) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(x.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
        }
        if (digest != null) {
            return digest.digest();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is, boolean isGzipEnabled, String dir, String fileName) throws IOException {
        InputStream cleanedIs = is;
        if (isGzipEnabled) {
            cleanedIs = new GZIPInputStream(is);
        }
        BufferedReader reader = null;
        File outputFile = new File(dir, fileName);
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(cleanedIs, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            writer.write(sb.toString());
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            cleanedIs.close();
            if (isGzipEnabled) {
                is.close();
            }
            ((Writer)writer).close();
        }
    }

    public static String encodeString(String value) {
        String encodedString = "";
        try {
            encodedString = URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedString;
    }

    public static String decodeString(String value) {
        String decodedString = "";
        try {
            decodedString = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Logger.d(TAG, "Failed decoding string " + e2.getMessage());
        }
        return decodedString;
    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void loadGoogleAdvertiserInfo(Context context) {
        Exception exception = null;
        try {
            String[] deviceInfo = DeviceStatus.getAdvertisingIdInfo(context);
            mAdvertisingId = deviceInfo[0];
            mIsLimitedTrackingEnabled = Boolean.valueOf(deviceInfo[1]);
        }
        catch (Exception e2) {
            exception = e2;
        }
        finally {
            if (exception != null) {
                if (exception.getMessage() != null) {
                    Logger.i(TAG, exception.getClass().getSimpleName() + ": " + exception.getMessage());
                }
                if (exception.getCause() != null) {
                    Logger.i(TAG, exception.getClass().getSimpleName() + ": " + exception.getCause());
                }
            }
        }
    }

    public static String getAdvertiserId() {
        return mAdvertisingId;
    }

    public static boolean isLimitAdTrackingEnabled() {
        return mIsLimitedTrackingEnabled;
    }

    public static String getControllerUrl() {
        if (!TextUtils.isEmpty((CharSequence)mControllerUrl)) {
            return mControllerUrl;
        }
        return "";
    }

    public static String getSDKVersion() {
        return "5.87";
    }

    public static void setControllerUrl(String url) {
        mControllerUrl = url;
    }

    public static String getControllerConfig() {
        return mControllerConfig;
    }

    public static void setControllerConfig(String config) {
        mControllerConfig = config;
    }

    public static Map<String, String> getInitSDKParams() {
        return mInitSDKParams;
    }

    public static void setInitSDKParams(Map<String, String> config) {
        mInitSDKParams = config;
    }

    public static int getDebugMode() {
        return mDebugMode;
    }

    public static void setDebugMode(int debugMode) {
        mDebugMode = debugMode;
    }

    public static String getValueFromJsonObject(String json, String key) {
        String placementId;
        try {
            JSONObject jsonObj = new JSONObject(json);
            placementId = jsonObj.getString(key);
        }
        catch (Exception e2) {
            placementId = null;
        }
        return placementId;
    }

    public static boolean isExternalStorageAvailable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    public static int getActivityUIFlags(boolean isImmersive) {
        int uiFlags = 0;
        if (Build.VERSION.SDK_INT >= 14) {
            uiFlags = 2;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            uiFlags |= 0x704;
        }
        if (Build.VERSION.SDK_INT >= 19 && isImmersive) {
            uiFlags |= 0x1000;
        }
        return uiFlags;
    }

    private static int generateViewIdForOldOS() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            return SDKUtils.generateViewIdForOldOS();
        }
        return View.generateViewId();
    }

    public static JSONObject getControllerConfigAsJSONObject() {
        String controllerConfig = SDKUtils.getControllerConfig();
        try {
            return new JSONObject(controllerConfig);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return new JSONObject();
        }
    }

    public static SSAEnums.ProductType getProductType(String product) {
        SSAEnums.ProductType productType = null;
        if (product.equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.toString())) {
            productType = SSAEnums.ProductType.RewardedVideo;
        } else if (product.equalsIgnoreCase(SSAEnums.ProductType.Interstitial.toString())) {
            productType = SSAEnums.ProductType.Interstitial;
        } else if (product.equalsIgnoreCase(SSAEnums.ProductType.OfferWall.toString())) {
            productType = SSAEnums.ProductType.OfferWall;
        }
        return productType;
    }

    public static void setTesterParameters(String testerParameters) {
        mUserGroup = testerParameters;
    }

    public static String getTesterParameters() {
        return mUserGroup;
    }

    public static JSONObject mergeJSONObjects(JSONObject obj1, JSONObject obj2) throws Exception {
        JSONObject merged = new JSONObject();
        JSONArray names = new JSONArray();
        if (obj1 != null) {
            merged = new JSONObject(obj1.toString());
        }
        if (obj2 != null) {
            names = obj2.names();
        }
        if (names != null) {
            for (int i = 0; i < names.length(); ++i) {
                String key = names.getString(i);
                Object value = obj2.opt(key);
                merged.putOpt(key, value);
            }
        }
        return merged;
    }

    public static String flatMapToJsonAsString(Map<String, String> params) {
        JSONObject jsObj = new JSONObject();
        if (params != null) {
            Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> pairs = it.next();
                try {
                    jsObj.putOpt(pairs.getKey(), (Object)SDKUtils.encodeString(pairs.getValue()));
                }
                catch (JSONException e2) {
                    Logger.i(TAG, "flatMapToJsonAsStringfailed " + e2.toString());
                }
                it.remove();
            }
        }
        return jsObj.toString();
    }

    public static int getMinOSVersionSupport() {
        JSONObject supplyConfigurations = SDKUtils.getControllerConfigAsJSONObject();
        return supplyConfigurations.optInt("minOSVersionSupport");
    }

    public static Map<String, String> mergeHashMaps(Map<String, String>[] maps) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (maps == null) {
            return result;
        }
        for (Map<String, String> map : maps) {
            if (map == null) continue;
            result.putAll(map);
        }
        return result;
    }

    public static String fetchDemandSourceId(SSAObj ssaObj) {
        return SDKUtils.fetchDemandSourceId(ssaObj.getJsonObject());
    }

    public static String fetchDemandSourceId(JSONObject ssaObj) {
        String demandSourceId = ssaObj.optString("demandSourceId");
        return !TextUtils.isEmpty((CharSequence)demandSourceId) ? demandSourceId : ssaObj.optString("demandSourceName");
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static String requireNonEmptyOrNull(String obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static boolean isIronSourceActivity(Activity activity) {
        return activity instanceof ControllerActivity || activity instanceof OpenUrlActivity;
    }

    public static JSONObject getNetworkConfiguration() {
        JSONObject networkConfiguration = new JSONObject();
        try {
            JSONObject controllerConfiguration = SDKUtils.getControllerConfigAsJSONObject();
            networkConfiguration = controllerConfiguration.getJSONObject("networkConfig");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return networkConfiguration;
    }

    static {
        mIsLimitedTrackingEnabled = true;
        mDebugMode = 0;
        mUserGroup = "";
        sNextGeneratedId = new AtomicInteger(1);
    }
}

