/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.environment.UrlHandler;
import com.ironsource.network.ConnectivityService;
import com.ironsource.network.ConnectivityUtils;
import com.ironsource.sdk.Events.ISNEventParams;
import com.ironsource.sdk.Events.ISNEventsBaseData;
import com.ironsource.sdk.Events.ISNEventsTracker;
import com.ironsource.sdk.Events.SDK5Events;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.constants.Constants;
import com.ironsource.sdk.controller.BannerJSAdapter;
import com.ironsource.sdk.controller.ControllerActivity;
import com.ironsource.sdk.controller.ControllerAdapter;
import com.ironsource.sdk.controller.ControllerEventListener;
import com.ironsource.sdk.controller.ControllerMessageHandler;
import com.ironsource.sdk.controller.ControllerView;
import com.ironsource.sdk.controller.DemandSourceManager;
import com.ironsource.sdk.controller.DeviceDataJSAdapter;
import com.ironsource.sdk.controller.FeaturesManager;
import com.ironsource.sdk.controller.InterstitialActivity;
import com.ironsource.sdk.controller.IronSourceController;
import com.ironsource.sdk.controller.OMIDJSAdapter;
import com.ironsource.sdk.controller.OpenUrlActivity;
import com.ironsource.sdk.controller.PermissionsJSAdapter;
import com.ironsource.sdk.controller.SecureMessagingInterface;
import com.ironsource.sdk.controller.SecureMessagingService;
import com.ironsource.sdk.controller.TokenJSAdapter;
import com.ironsource.sdk.controller.VideoEventsListener;
import com.ironsource.sdk.controller.WebViewMessagingMediator;
import com.ironsource.sdk.data.AdUnitsReady;
import com.ironsource.sdk.data.AdUnitsState;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.data.SSAFile;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.listeners.OnGenericFunctionListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.OnWebViewChangeListener;
import com.ironsource.sdk.listeners.internals.DSAdProductListener;
import com.ironsource.sdk.listeners.internals.DSBannerListener;
import com.ironsource.sdk.listeners.internals.DSInterstitialListener;
import com.ironsource.sdk.listeners.internals.DSRewardedVideoListener;
import com.ironsource.sdk.precache.DownloadManager;
import com.ironsource.sdk.service.ConnectivityAdapter;
import com.ironsource.sdk.service.PackagesInstallationService;
import com.ironsource.sdk.utils.DeviceProperties;
import com.ironsource.sdk.utils.IronSourceAsyncHttpRequestTask;
import com.ironsource.sdk.utils.IronSourceSharedPrefHelper;
import com.ironsource.sdk.utils.IronSourceStorageUtils;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebController
extends WebView
implements IronSourceController,
DownloadManager.OnPreCacheCompletion,
DownloadListener {
    private String TAG = WebController.class.getSimpleName();
    private String PUB_TAG = "IronSource";
    public static int mDebugMode = 0;
    private final String GENERIC_MESSAGE = "We're sorry, some error occurred. we will investigate it";
    private String mApplicationKey;
    private String mUserId;
    private Map<String, String> mOWExtraParameters;
    public static String IS_STORE = "is_store";
    public static String EXTERNAL_URL = "external_url";
    public static String SECONDARY_WEB_VIEW = "secondary_web_view";
    private DownloadManager downloadManager;
    private boolean mIsWebControllerReady;
    private boolean mOWmiss;
    private boolean mOWCreditsMiss;
    private boolean isRemoveCloseEventHandler;
    private String mControllerKeyPressed = "interrupt";
    private CountDownTimer mCloseEventTimer;
    public CountDownTimer mLoadControllerTimer;
    private int mHiddenForceCloseWidth = 50;
    private int mHiddenForceCloseHeight = 50;
    private String mHiddenForceCloseLocation = "top-right";
    private ChromeClient mWebChromeClient;
    private View mCustomView;
    private FrameLayout mCustomViewContainer;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private FrameLayout mControllerLayout;
    private State mState;
    private String mOrientationState;
    private DSRewardedVideoListener mDSRewardedVideoListener;
    private OnGenericFunctionListener mOnGenericFunctionListener;
    private DSInterstitialListener mDSInterstitialListener;
    private OnOfferWallListener mOnOfferWallListener;
    private DSBannerListener mDSBannerListener;
    private Boolean isKitkatAndAbove = null;
    private String mCacheDirectory;
    private VideoEventsListener mVideoEventsListener;
    private AdUnitsState mSavedState;
    private Object mSavedStateLocker = new Object();
    Context mCurrentActivityContext;
    Handler mUiHandler;
    private boolean mIsImmersive = false;
    private DemandSourceManager mDemandSourceManager;
    private OMIDJSAdapter mOmidJsAdapter;
    private PermissionsJSAdapter mPermissionsJsAdapter;
    private BannerJSAdapter mBannerJsAdapter;
    private TokenJSAdapter mTokenJSAdapter;
    private DeviceDataJSAdapter mDeviceDataJsAdapter;
    private WebViewMessagingMediator mWebViewMessagingMediator;
    private ControllerEventListener mControllerListener;
    private ControllerAdapter mControllerAdapter;
    private ConnectivityAdapter mConnectivityAdapter;
    private static String JSON_KEY_SUCCESS = "success";
    private static String JSON_KEY_FAIL = "fail";
    private OnWebViewChangeListener mChangeListener;

    private Map<String, String> getExtraParamsByProduct(SSAEnums.ProductType type) {
        if (type == SSAEnums.ProductType.OfferWall) {
            return this.mOWExtraParameters;
        }
        return null;
    }

    public WebController(Activity activity, DemandSourceManager demandSourceManager, ControllerEventListener controllerListener) {
        super(activity.getApplicationContext());
        this.mCurrentActivityContext = new MutableContextWrapper((Context)activity);
        Logger.i(this.TAG, "C'tor");
        this.mControllerListener = controllerListener;
        this.mCacheDirectory = this.initializeCacheDirectory(this.mCurrentActivityContext.getApplicationContext());
        this.mDemandSourceManager = demandSourceManager;
        this.initLayout(this.mCurrentActivityContext);
        this.mSavedState = new AdUnitsState();
        this.downloadManager = this.getDownloadManager();
        this.downloadManager.setOnPreCacheCompletion(this);
        this.mWebChromeClient = new ChromeClient();
        this.setWebViewClient(new ViewClient());
        this.setWebChromeClient(this.mWebChromeClient);
        this.setWebViewSettings();
        this.createSecuredCommunication();
        this.setDownloadListener(this);
        this.setOnTouchListener(new SupersonicWebViewTouchListener());
        this.mUiHandler = this.createMainThreadHandler();
        this.mConnectivityAdapter = this.createConnectivityAdapter((Context)activity);
        this.registerConnectionReceiver((Context)activity);
        this.setDebugMode(FeaturesManager.getInstance().getDebugMode());
    }

    private ConnectivityAdapter createConnectivityAdapter(Context context) {
        return new ConnectivityAdapter(SDKUtils.getControllerConfigAsJSONObject(), context){

            @Override
            public void onConnected(String connectionType, JSONObject connectionInfo) {
                if (WebController.this.mIsWebControllerReady) {
                    WebController.this.sendConnectionTypeChanged(connectionType);
                }
            }

            @Override
            public void onDisconnected() {
                if (WebController.this.mIsWebControllerReady) {
                    WebController.this.sendConnectionTypeChanged("none");
                }
            }

            @Override
            public void onStatusChanged(String connectionType, JSONObject connectionInfo) {
                if (connectionInfo != null && WebController.this.mIsWebControllerReady) {
                    try {
                        connectionInfo.put("connectionType", (Object)connectionType);
                        WebController.this.sendConnectionInfoChanged(connectionInfo);
                    }
                    catch (JSONException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        };
    }

    private void createSecuredCommunication() {
        String tokenForMessaging = SecureMessagingService.generateToken();
        SecureMessagingService secureMessagingService = new SecureMessagingService(tokenForMessaging);
        this.addJavascriptInterface(this.createControllerMessageHandler(secureMessagingService), "Android");
        this.addJavascriptInterface(this.createSecureMessagingInterface(secureMessagingService), "GenerateTokenForMessaging");
    }

    ControllerMessageHandler createControllerMessageHandler(SecureMessagingService secureMessagingService) {
        NativeAPI nativeAPI = new NativeAPI();
        ControllerAdapter controllerAdapter = new ControllerAdapter(nativeAPI);
        return new ControllerMessageHandler(controllerAdapter, secureMessagingService);
    }

    SecureMessagingInterface createSecureMessagingInterface(SecureMessagingService secureMessagingService) {
        return new SecureMessagingInterface(secureMessagingService);
    }

    Handler createMainThreadHandler() {
        return new Handler(Looper.getMainLooper());
    }

    DownloadManager getDownloadManager() {
        return DownloadManager.getInstance(this.mCacheDirectory);
    }

    String initializeCacheDirectory(Context context) {
        return IronSourceStorageUtils.initializeCacheDirectory(context.getApplicationContext());
    }

    public void addOmidJSInterface(OMIDJSAdapter omidjsAdapter) {
        this.mOmidJsAdapter = omidjsAdapter;
    }

    public void addPermissionsJSInterface(PermissionsJSAdapter permissionsJSAdapter) {
        this.mPermissionsJsAdapter = permissionsJSAdapter;
    }

    public void addBannerJSInterface(BannerJSAdapter bannerJSAdapter) {
        this.mBannerJsAdapter = bannerJSAdapter;
        this.mBannerJsAdapter.setCommunicationWithController(this.getControllerDelegate());
    }

    public void addTokenJSInterface(TokenJSAdapter tokenJSAdapter) {
        this.mTokenJSAdapter = tokenJSAdapter;
    }

    public void addDeviceDataJSInterface(DeviceDataJSAdapter deviceDataJSAdapter) {
        this.mDeviceDataJsAdapter = deviceDataJSAdapter;
    }

    public void notifyLifeCycle(String productType, String event) {
        String params = this.parseToJson("lifeCycleEvent", event, "productType", productType, null, null, null, null, null, false);
        String script = this.generateJSToInject("onNativeLifeCycleEvent", params);
        this.injectJavascript(script);
    }

    public WebViewMessagingMediator getControllerDelegate() {
        if (this.mWebViewMessagingMediator == null) {
            this.mWebViewMessagingMediator = new WebViewMessagingMediator(){

                @Override
                public void sendMessageToController(String message, JSONObject params) {
                    String script = WebController.this.generateJSToInject(message, params.toString());
                    WebController.this.injectJavascript(script);
                }
            };
        }
        return this.mWebViewMessagingMediator;
    }

    private void initLayout(Context context) {
        FrameLayout.LayoutParams coverScreenParams = new FrameLayout.LayoutParams(-1, -1);
        this.mControllerLayout = new FrameLayout(context);
        this.mCustomViewContainer = new FrameLayout(context);
        FrameLayout.LayoutParams fp = new FrameLayout.LayoutParams(-1, -1);
        this.mCustomViewContainer.setLayoutParams((ViewGroup.LayoutParams)fp);
        this.mCustomViewContainer.setVisibility(8);
        FrameLayout mContentView = new FrameLayout(context);
        FrameLayout.LayoutParams lpChild2 = new FrameLayout.LayoutParams(-1, -1);
        mContentView.setLayoutParams((ViewGroup.LayoutParams)lpChild2);
        mContentView.addView((View)this);
        this.mControllerLayout.addView((View)this.mCustomViewContainer, (ViewGroup.LayoutParams)coverScreenParams);
        this.mControllerLayout.addView((View)mContentView);
    }

    private void setWebViewSettings() {
        WebSettings webviewSettings = this.getSettings();
        webviewSettings.setLoadWithOverviewMode(true);
        webviewSettings.setUseWideViewPort(true);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        webviewSettings.setAllowFileAccess(true);
        webviewSettings.setBuiltInZoomControls(false);
        webviewSettings.setJavaScriptEnabled(true);
        webviewSettings.setSupportMultipleWindows(true);
        webviewSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webviewSettings.setGeolocationEnabled(true);
        webviewSettings.setGeolocationDatabasePath("/data/data/org.itri.html5webview/databases/");
        webviewSettings.setDomStorageEnabled(true);
        try {
            this.setDisplayZoomControls(webviewSettings);
            this.setMediaPlaybackJellyBean(webviewSettings);
        }
        catch (Throwable e2) {
            Logger.e(this.TAG, "setWebSettings - " + e2.toString());
        }
    }

    private void setDisplayZoomControls(WebSettings s) {
        if (Build.VERSION.SDK_INT > 11) {
            s.setDisplayZoomControls(false);
        }
    }

    public WebBackForwardList saveState(Bundle outState) {
        return super.saveState(outState);
    }

    @SuppressLint(value={"NewApi"})
    private void setMediaPlaybackJellyBean(WebSettings s) {
        if (Build.VERSION.SDK_INT >= 17) {
            s.setMediaPlaybackRequiresUserGesture(false);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setWebDebuggingEnabled() {
        if (Build.VERSION.SDK_INT >= 19) {
            WebController.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    public void downloadController() {
        IronSourceStorageUtils.deleteFile(this.mCacheDirectory, "", "mobileController.html");
        String controllerPath = "";
        String controllerUrl = SDKUtils.getControllerUrl();
        SSAFile indexHtml = new SSAFile(controllerUrl, controllerPath);
        if (!this.downloadManager.isMobileControllerThreadLive()) {
            Logger.i(this.TAG, "Download Mobile Controller: " + controllerUrl);
            this.downloadManager.downloadMobileControllerFile(indexHtml);
        } else {
            Logger.i(this.TAG, "Download Mobile Controller: already alive");
        }
    }

    public void setDebugMode(int debugMode) {
        mDebugMode = debugMode;
    }

    public int getDebugMode() {
        return mDebugMode;
    }

    private boolean shouldNotifyDeveloper(String product) {
        boolean shouldNotify = false;
        if (TextUtils.isEmpty((CharSequence)product)) {
            Logger.d(this.TAG, "Trying to trigger a listener - no product was found");
            return false;
        }
        if (product.equalsIgnoreCase(SSAEnums.ProductType.Interstitial.toString())) {
            shouldNotify = this.mDSInterstitialListener != null;
        } else if (product.equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.toString())) {
            shouldNotify = this.mDSRewardedVideoListener != null;
        } else if (product.equalsIgnoreCase(SSAEnums.ProductType.Banner.toString())) {
            shouldNotify = this.mDSBannerListener != null;
        } else if (product.equalsIgnoreCase(SSAEnums.ProductType.OfferWall.toString()) || product.equalsIgnoreCase(SSAEnums.ProductType.OfferWallCredits.toString())) {
            boolean bl = shouldNotify = this.mOnOfferWallListener != null;
        }
        if (!shouldNotify) {
            Logger.d(this.TAG, "Trying to trigger a listener - no listener was found for product " + product);
        }
        return shouldNotify;
    }

    public void setOrientationState(String orientation) {
        this.mOrientationState = orientation;
    }

    public String getOrientationState() {
        return this.mOrientationState;
    }

    private DSAdProductListener getAdProductListenerByProductType(SSAEnums.ProductType type) {
        if (type == SSAEnums.ProductType.Interstitial) {
            return this.mDSInterstitialListener;
        }
        if (type == SSAEnums.ProductType.RewardedVideo) {
            return this.mDSRewardedVideoListener;
        }
        if (type == SSAEnums.ProductType.Banner) {
            return this.mDSBannerListener;
        }
        return null;
    }

    private SSAEnums.ProductType getStringProductTypeAsEnum(String productType) {
        if (TextUtils.isEmpty((CharSequence)productType)) {
            return null;
        }
        if (productType.equalsIgnoreCase(SSAEnums.ProductType.Interstitial.toString())) {
            return SSAEnums.ProductType.Interstitial;
        }
        if (productType.equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.toString())) {
            return SSAEnums.ProductType.RewardedVideo;
        }
        if (productType.equalsIgnoreCase(SSAEnums.ProductType.OfferWall.toString())) {
            return SSAEnums.ProductType.OfferWall;
        }
        if (productType.equalsIgnoreCase(SSAEnums.ProductType.Banner.toString())) {
            return SSAEnums.ProductType.Banner;
        }
        return null;
    }

    public void setVideoEventsListener(VideoEventsListener listener) {
        this.mVideoEventsListener = listener;
    }

    public void removeVideoEventsListener() {
        this.mVideoEventsListener = null;
    }

    private void setWebviewBackground(String value) {
        SSAObj ssaObj = new SSAObj(value);
        String keyColor = ssaObj.getString("color");
        int bgColor = 0;
        if (!"transparent".equalsIgnoreCase(keyColor)) {
            bgColor = Color.parseColor((String)keyColor);
        }
        this.setBackgroundColor(bgColor);
    }

    public void load(final int loadAttemp) {
        try {
            this.loadUrl("about:blank");
        }
        catch (Throwable e2) {
            Logger.e(this.TAG, "WebViewController:: load: " + e2.toString());
            new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=webviewLoadBlank"});
        }
        String controllerPath = "file://" + this.mCacheDirectory + File.separator + "mobileController.html";
        File file = new File(this.mCacheDirectory + File.separator + "mobileController.html");
        if (file.exists()) {
            JSONObject configObject = SDKUtils.getControllerConfigAsJSONObject();
            this.setWebDebuggingEnabled(configObject);
            String requestParameters = this.getRequestParameters(configObject);
            Map<String, String> initParams = SDKUtils.getInitSDKParams();
            if (initParams != null && initParams.containsKey("sessionid")) {
                requestParameters = String.format("%s&sessionid=%s", requestParameters, initParams.get("sessionid"));
            }
            String controllerPathWithParams = controllerPath + "?" + requestParameters;
            this.mLoadControllerTimer = new CountDownTimer(50000L, 1000L){

                public void onTick(long millisUntilFinished) {
                    Logger.i(WebController.this.TAG, "Loading Controller Timer Tick " + millisUntilFinished);
                }

                public void onFinish() {
                    Logger.i(WebController.this.TAG, "Loading Controller Timer Finish");
                    if (loadAttemp == 3) {
                        WebController.this.mControllerListener.handleControllerStageFailed("controller failed to load");
                        return;
                    }
                    WebController.this.load(loadAttemp + 1);
                }
            }.start();
            try {
                this.loadUrl(controllerPathWithParams);
            }
            catch (Throwable e3) {
                Logger.e(this.TAG, "WebViewController:: load: " + e3.toString());
                new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=webviewLoadWithPath"});
            }
            Logger.i(this.TAG, "load(): " + controllerPathWithParams);
        } else {
            Logger.i(this.TAG, "load(): Mobile Controller HTML Does not exist");
            new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=htmlControllerDoesNotExistOnFileSystem"});
        }
    }

    private void setWebDebuggingEnabled(JSONObject configObject) {
        if (configObject.optBoolean("inspectWebview")) {
            this.setWebDebuggingEnabled();
        }
    }

    private void initProduct(String applicationKey, String userId, SSAEnums.ProductType productType, DemandSource demandSource, OnInitProductHandler handler) {
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)applicationKey)) {
            handler.handleInitProductFailed("User id or Application key are missing", productType, demandSource);
            return;
        }
        Result result = this.createInitProductJSMethod(productType, demandSource);
        this.injectJavascript(result.script);
    }

    @Override
    public void initRewardedVideo(String applicationKey, String userId, DemandSource demandSource, DSRewardedVideoListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.mDSRewardedVideoListener = listener;
        this.mSavedState.setRVAppKey(applicationKey);
        this.mSavedState.setRVUserId(userId);
        this.initProduct(applicationKey, userId, SSAEnums.ProductType.RewardedVideo, demandSource, new OnInitProductHandler(){

            @Override
            public void handleInitProductFailed(String errorMessage, SSAEnums.ProductType productType, DemandSource demandSource) {
                WebController.this.triggerOnControllerInitProductFail(errorMessage, productType, demandSource);
            }
        });
    }

    @Override
    public void initInterstitial(String applicationKey, String userId, DemandSource demandSource, DSInterstitialListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.mDSInterstitialListener = listener;
        this.mSavedState.setInterstitialAppKey(this.mApplicationKey);
        this.mSavedState.setInterstitialUserId(this.mUserId);
        this.initProduct(this.mApplicationKey, this.mUserId, SSAEnums.ProductType.Interstitial, demandSource, new OnInitProductHandler(){

            @Override
            public void handleInitProductFailed(String errorMessage, SSAEnums.ProductType productType, DemandSource demandSource) {
                WebController.this.triggerOnControllerInitProductFail(errorMessage, productType, demandSource);
            }
        });
    }

    @Override
    public void loadInterstitial(String demandSourceName, DSInterstitialListener listener) {
        HashMap<String, String> productParamsMap = new HashMap<String, String>();
        productParamsMap.put("demandSourceName", demandSourceName);
        String params = SDKUtils.flatMapToJsonAsString(productParamsMap);
        this.mSavedState.setReportLoadInterstitial(demandSourceName, true);
        String script = this.generateJSToInject("loadInterstitial", params, "onLoadInterstitialSuccess", "onLoadInterstitialFail");
        this.injectJavascript(script);
    }

    @Override
    public void loadInterstitial(DemandSource demandSource, Map<String, String> loadParams, DSInterstitialListener listener) {
        this.handleLoadAd(demandSource, loadParams);
    }

    private void handleLoadAd(DemandSource demandSource, Map<String, String> loadParams) {
        Map<String, String> paramsMap = SDKUtils.mergeHashMaps(new Map[]{loadParams, demandSource.convertToMap()});
        this.mSavedState.setReportLoadInterstitial(demandSource.getId(), true);
        String params = SDKUtils.flatMapToJsonAsString(paramsMap);
        String script = this.generateJSToInject("loadInterstitial", params, "onLoadInterstitialSuccess", "onLoadInterstitialFail");
        this.injectJavascript(script);
    }

    @Override
    public void showInterstitial(JSONObject showParams, DSInterstitialListener listener) {
        String script = this.createShowProductJSMethod(SSAEnums.ProductType.Interstitial, showParams);
        this.injectJavascript(script);
    }

    @Override
    public void showInterstitial(DemandSource demandSource, Map<String, String> showParams, DSInterstitialListener listener) {
        Map<String, String> paramsMap = SDKUtils.mergeHashMaps(new Map[]{showParams, demandSource.convertToMap()});
        String script = this.createShowProductJSMethod(SSAEnums.ProductType.Interstitial, new JSONObject(paramsMap));
        this.injectJavascript(script);
    }

    @Override
    public boolean isInterstitialAdAvailable(String demandSourceName) {
        DemandSource demandSource = this.mDemandSourceManager.getDemandSourceById(SSAEnums.ProductType.Interstitial, demandSourceName);
        return demandSource != null && demandSource.getAvailabilityState();
    }

    @Override
    public void initOfferWall(String applicationKey, String userId, Map<String, String> extraParameters, OnOfferWallListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.mOWExtraParameters = extraParameters;
        this.mOnOfferWallListener = listener;
        this.mSavedState.setOfferWallExtraParams(this.mOWExtraParameters);
        this.mSavedState.setOfferwallReportInit(true);
        this.initProduct(this.mApplicationKey, this.mUserId, SSAEnums.ProductType.OfferWall, null, new OnInitProductHandler(){

            @Override
            public void handleInitProductFailed(String errorMessage, SSAEnums.ProductType productType, DemandSource demandSource) {
                WebController.this.triggerOnControllerInitProductFail(errorMessage, productType, demandSource);
            }
        });
    }

    @Override
    public void showOfferWall(Map<String, String> extraParameters) {
        this.mOWExtraParameters = extraParameters;
        String script = this.generateJSToInject("showOfferWall", "onShowOfferWallSuccess", "onShowOfferWallFail");
        this.injectJavascript(script);
    }

    @Override
    public void getOfferWallCredits(String applicationKey, String userId, OnOfferWallListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.mOnOfferWallListener = listener;
        this.initProduct(this.mApplicationKey, this.mUserId, SSAEnums.ProductType.OfferWallCredits, null, new OnInitProductHandler(){

            @Override
            public void handleInitProductFailed(String errorMessage, SSAEnums.ProductType productType, DemandSource demandSource) {
                WebController.this.triggerOnControllerInitProductFail(errorMessage, productType, demandSource);
            }
        });
    }

    @Override
    public void initBanner(String applicationKey, String userId, DemandSource demandSource, DSBannerListener listener) {
        this.mApplicationKey = applicationKey;
        this.mUserId = userId;
        this.mDSBannerListener = listener;
        this.initProduct(applicationKey, userId, SSAEnums.ProductType.Banner, demandSource, new OnInitProductHandler(){

            @Override
            public void handleInitProductFailed(String errorMessage, SSAEnums.ProductType productType, DemandSource demandSource) {
                WebController.this.triggerOnControllerInitProductFail(errorMessage, productType, demandSource);
            }
        });
    }

    @Override
    public void loadBanner(JSONObject loadParams, DSBannerListener listener) {
        if (loadParams != null) {
            String params = loadParams.toString();
            String script = this.generateJSToInject("loadBanner", params, "onLoadBannerSuccess", "onLoadBannerFail");
            this.injectJavascript(script);
        }
    }

    @Override
    public void updateConsentInfo(JSONObject consentParams) {
        String script = this.generateJSToInject("updateConsentInfo", consentParams != null ? consentParams.toString() : null);
        this.injectJavascript(script);
    }

    private Result createInitProductJSMethod(SSAEnums.ProductType type, DemandSource demandSource) {
        Result result = new Result();
        String script = "";
        if (type == SSAEnums.ProductType.RewardedVideo || type == SSAEnums.ProductType.Interstitial || type == SSAEnums.ProductType.OfferWall || type == SSAEnums.ProductType.Banner) {
            Map<String, String> extraParams;
            HashMap<String, String> productParamsMap = new HashMap<String, String>();
            productParamsMap.put("applicationKey", this.mApplicationKey);
            productParamsMap.put("applicationUserId", this.mUserId);
            if (demandSource != null) {
                if (demandSource.getExtraParams() != null) {
                    productParamsMap.putAll(demandSource.getExtraParams());
                }
                productParamsMap.put("demandSourceName", demandSource.getDemandSourceName());
                productParamsMap.put("demandSourceId", demandSource.getId());
            }
            if ((extraParams = this.getExtraParamsByProduct(type)) != null) {
                productParamsMap.putAll(extraParams);
            }
            String params = SDKUtils.flatMapToJsonAsString(productParamsMap);
            Constants.JSMethods method = Constants.JSMethods.getInitMethodByProduct(type);
            script = this.generateJSToInject(method.methodName, params, method.successCallbackName, method.failureCallbackName);
            result.methodName = method.methodName;
            result.script = script;
        } else if (type == SSAEnums.ProductType.OfferWallCredits) {
            String params = this.parseToJson("productType", "OfferWall", "applicationKey", this.mApplicationKey, "applicationUserId", this.mUserId, null, null, null, false);
            script = this.generateJSToInject("getUserCredits", params, "null", "onGetUserCreditsFail");
            result.methodName = "getUserCredits";
            result.script = script;
        }
        return result;
    }

    private String createShowProductJSMethod(SSAEnums.ProductType type, JSONObject showParams) {
        Map<String, String> extraParams;
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        String sessionDepth = Integer.toString(showParams.optInt("sessionDepth"));
        paramsMap.put("sessionDepth", sessionDepth);
        String demandSourceName = showParams.optString("demandSourceName");
        String demandSourceId = SDKUtils.fetchDemandSourceId(showParams);
        DemandSource demandSource = this.mDemandSourceManager.getDemandSourceById(type, demandSourceId);
        if (demandSource != null) {
            if (demandSource.getExtraParams() != null) {
                paramsMap.putAll(demandSource.getExtraParams());
            }
            if (!TextUtils.isEmpty((CharSequence)demandSourceName)) {
                paramsMap.put("demandSourceName", demandSourceName);
            }
            if (!TextUtils.isEmpty((CharSequence)demandSourceId)) {
                paramsMap.put("demandSourceId", demandSourceId);
            }
        }
        if ((extraParams = this.getExtraParamsByProduct(type)) != null) {
            paramsMap.putAll(extraParams);
        }
        String params = SDKUtils.flatMapToJsonAsString(paramsMap);
        Constants.JSMethods method = Constants.JSMethods.getShowMethodByProduct(type);
        return this.generateJSToInject(method.methodName, params, method.successCallbackName, method.failureCallbackName);
    }

    void setMissProduct(SSAEnums.ProductType type, DemandSource demandSource) {
        if (type == SSAEnums.ProductType.RewardedVideo || type == SSAEnums.ProductType.Interstitial || type == SSAEnums.ProductType.Banner) {
            if (demandSource != null) {
                demandSource.setDemandSourceInitState(1);
            }
        } else if (type == SSAEnums.ProductType.OfferWall) {
            this.mOWmiss = true;
        } else if (type == SSAEnums.ProductType.OfferWallCredits) {
            this.mOWCreditsMiss = true;
        }
        Logger.i(this.TAG, "setMissProduct(" + (Object)((Object)type) + ")");
    }

    private void triggerOnControllerInitProductFail(final String message, final SSAEnums.ProductType productType, final DemandSource demandSource) {
        if (this.shouldNotifyDeveloper(productType.toString())) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (SSAEnums.ProductType.RewardedVideo == productType || SSAEnums.ProductType.Interstitial == productType || SSAEnums.ProductType.Banner == productType) {
                        if (demandSource == null || TextUtils.isEmpty((CharSequence)demandSource.getId())) {
                            return;
                        }
                        DSAdProductListener listener = WebController.this.getAdProductListenerByProductType(productType);
                        Log.d((String)WebController.this.TAG, (String)("onAdProductInitFailed (message:" + message + ")(" + (Object)((Object)productType) + ")"));
                        if (listener != null) {
                            listener.onAdProductInitFailed(productType, demandSource.getId(), message);
                        }
                    } else if (SSAEnums.ProductType.OfferWall == productType) {
                        WebController.this.mOnOfferWallListener.onOfferwallInitFail(message);
                    } else if (SSAEnums.ProductType.OfferWallCredits == productType) {
                        WebController.this.mOnOfferWallListener.onGetOWCreditsFailed(message);
                    }
                }
            });
        }
    }

    @Override
    public void showRewardedVideo(JSONObject showParams, DSRewardedVideoListener listener) {
        String script = this.createShowProductJSMethod(SSAEnums.ProductType.RewardedVideo, showParams);
        this.injectJavascript(script);
    }

    public void assetCached(String file, String path) {
        String params = this.parseToJson("file", file, "path", path, null, null, null, null, null, false);
        String script = this.generateJSToInject("assetCached", params);
        this.injectJavascript(script);
    }

    public void assetCachedFailed(String file, String path, String errorMsg) {
        String params = this.parseToJson("file", file, "path", path, "errMsg", errorMsg, null, null, null, false);
        String script = this.generateJSToInject("assetCachedFailed", params);
        this.injectJavascript(script);
    }

    @Override
    public void enterBackground() {
        String script = this.generateJSToInject("enterBackground");
        this.injectJavascript(script);
    }

    @Override
    public void enterForeground() {
        String script = this.generateJSToInject("enterForeground");
        this.injectJavascript(script);
    }

    public void viewableChange(boolean visibility, String webview) {
        String params = this.parseToJson("webview", webview, null, null, null, null, null, null, "isViewable", visibility);
        String script = this.generateJSToInject("viewableChange", params);
        this.injectJavascript(script);
    }

    public void nativeNavigationPressed(String action) {
        String params = this.parseToJson("action", action, null, null, null, null, null, null, null, false);
        String script = this.generateJSToInject("nativeNavigationPressed", params);
        this.injectJavascript(script);
    }

    public void pageFinished() {
        String script = this.generateJSToInject("pageFinished");
        this.injectJavascript(script);
    }

    public void interceptedUrlToStore() {
        String script = this.generateJSToInject("interceptedUrlToStore");
        this.injectJavascript(script);
    }

    public void failedToStartStoreActivity(String errorMessage, String failedUrl) {
        String urlToSend = TextUtils.isEmpty((CharSequence)failedUrl) ? "unknown url" : failedUrl;
        String errorMessageToSend = TextUtils.isEmpty((CharSequence)errorMessage) ? "activity failed to open with unspecified reason" : errorMessage;
        String params = this.parseToJson("errMsg", errorMessageToSend, "url", urlToSend, null, null, null, null, null, false);
        this.injectJavascript(this.generateJSToInject("failedToStartStoreActivity", params));
    }

    private void injectJavascript(String script) {
        if (TextUtils.isEmpty((CharSequence)script)) {
            return;
        }
        String catchClosure = "empty";
        if (this.getDebugMode() == SSAEnums.DebugMode.MODE_0.getValue()) {
            catchClosure = "console.log(\"JS exeption: \" + JSON.stringify(e));";
        } else if (this.getDebugMode() >= SSAEnums.DebugMode.MODE_1.getValue() && this.getDebugMode() <= SSAEnums.DebugMode.MODE_3.getValue()) {
            catchClosure = "console.log(\"JS exeption: \" + JSON.stringify(e));";
        }
        final StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("try{").append(script).append("}catch(e){").append(catchClosure).append("}");
        final String url = "javascript:" + scriptBuilder.toString();
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Logger.i(WebController.this.TAG, url);
                try {
                    if (WebController.this.isKitkatAndAbove != null) {
                        if (WebController.this.isKitkatAndAbove.booleanValue()) {
                            WebController.this.evaluateJavascriptKitKat(scriptBuilder.toString());
                        } else {
                            WebController.this.loadUrl(url);
                        }
                    } else if (Build.VERSION.SDK_INT >= 19) {
                        try {
                            WebController.this.evaluateJavascriptKitKat(scriptBuilder.toString());
                            WebController.this.isKitkatAndAbove = true;
                        }
                        catch (NoSuchMethodError e2) {
                            Logger.e(WebController.this.TAG, "evaluateJavascrip NoSuchMethodError: SDK version=" + Build.VERSION.SDK_INT + " " + e2);
                            WebController.this.loadUrl(url);
                            WebController.this.isKitkatAndAbove = false;
                        }
                        catch (Throwable e3) {
                            Logger.e(WebController.this.TAG, "evaluateJavascrip Exception: SDK version=" + Build.VERSION.SDK_INT + " " + e3);
                            WebController.this.loadUrl(url);
                            WebController.this.isKitkatAndAbove = false;
                        }
                    } else {
                        WebController.this.loadUrl(url);
                        WebController.this.isKitkatAndAbove = false;
                    }
                }
                catch (Throwable t) {
                    Logger.e(WebController.this.TAG, "injectJavascript: " + t.toString());
                    new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=injectJavaScript"});
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void evaluateJavascriptKitKat(String script) {
        this.evaluateJavascript(script, null);
    }

    public Context getCurrentActivityContext() {
        MutableContextWrapper mctx = (MutableContextWrapper)this.mCurrentActivityContext;
        return mctx.getBaseContext();
    }

    private String getRequestParameters(JSONObject configObject) {
        String serverControllerUrl;
        Uri downloadUri;
        String osType;
        DeviceProperties properties = DeviceProperties.getInstance(this.getContext());
        StringBuilder builder = new StringBuilder();
        String sdkVer = DeviceProperties.getSupersonicSdkVersion();
        if (!TextUtils.isEmpty((CharSequence)sdkVer)) {
            builder.append("SDKVersion").append("=").append(sdkVer).append("&");
        }
        if (!TextUtils.isEmpty((CharSequence)(osType = properties.getDeviceOsType()))) {
            builder.append("deviceOs").append("=").append(osType);
        }
        if ((downloadUri = Uri.parse((String)(serverControllerUrl = SDKUtils.getControllerUrl()))) != null) {
            String scheme = downloadUri.getScheme() + ":";
            String host = downloadUri.getHost();
            int port = downloadUri.getPort();
            if (port != -1) {
                host = host + ":" + port;
            }
            builder.append("&").append("protocol").append("=").append(scheme);
            builder.append("&").append("domain").append("=").append(host);
            if (configObject.keys().hasNext()) {
                try {
                    JSONObject conf = new JSONObject(configObject, new String[]{"isSecured", "applicationKey"});
                    String config = conf.toString();
                    if (!TextUtils.isEmpty((CharSequence)config)) {
                        builder.append("&").append("controllerConfig").append("=").append(config);
                    }
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
            builder.append("&").append("debug").append("=").append(this.getDebugMode());
        }
        return builder.toString();
    }

    private void closeWebView() {
        if (this.mChangeListener != null) {
            this.mChangeListener.onCloseRequested();
        }
    }

    private WebView getWebview() {
        return this;
    }

    private void responseBack(String value, boolean result, String errorMessage, String errorCode) {
        SSAObj ssaObj = new SSAObj(value);
        String success = ssaObj.getString(JSON_KEY_SUCCESS);
        String fail = ssaObj.getString(JSON_KEY_FAIL);
        String funToCall = null;
        if (result) {
            if (!TextUtils.isEmpty((CharSequence)success)) {
                funToCall = success;
            }
        } else if (!TextUtils.isEmpty((CharSequence)fail)) {
            funToCall = fail;
        }
        if (!TextUtils.isEmpty((CharSequence)funToCall)) {
            JSONObject jsObj2;
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                try {
                    jsObj2 = new JSONObject(value);
                    value = jsObj2.put("errMsg", (Object)errorMessage).toString();
                }
                catch (JSONException jsObj2) {
                    // empty catch block
                }
            }
            if (!TextUtils.isEmpty((CharSequence)errorCode)) {
                try {
                    jsObj2 = new JSONObject(value);
                    value = jsObj2.put("errCode", (Object)errorCode).toString();
                }
                catch (JSONException jsObj3) {
                    // empty catch block
                }
            }
            String script = this.generateJSToInject(funToCall, value);
            this.injectJavascript(script);
        }
    }

    private String extractSuccessFunctionToCall(String jsonStr) {
        SSAObj ssaObj = new SSAObj(jsonStr);
        String funToCall = ssaObj.getString(JSON_KEY_SUCCESS);
        return funToCall;
    }

    private String extractFailFunctionToCall(String jsonStr) {
        SSAObj ssaObj = new SSAObj(jsonStr);
        String funToCall = ssaObj.getString(JSON_KEY_FAIL);
        return funToCall;
    }

    private String parseToJson(String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4, String key5, boolean value5) {
        JSONObject jsObj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)key1) && !TextUtils.isEmpty((CharSequence)value1)) {
                jsObj.put(key1, (Object)SDKUtils.encodeString(value1));
            }
            if (!TextUtils.isEmpty((CharSequence)key2) && !TextUtils.isEmpty((CharSequence)value2)) {
                jsObj.put(key2, (Object)SDKUtils.encodeString(value2));
            }
            if (!TextUtils.isEmpty((CharSequence)key3) && !TextUtils.isEmpty((CharSequence)value3)) {
                jsObj.put(key3, (Object)SDKUtils.encodeString(value3));
            }
            if (!TextUtils.isEmpty((CharSequence)key4) && !TextUtils.isEmpty((CharSequence)value4)) {
                jsObj.put(key4, (Object)SDKUtils.encodeString(value4));
            }
            if (!TextUtils.isEmpty((CharSequence)key5)) {
                jsObj.put(key5, value5);
            }
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=" + e2.getStackTrace()[0].getMethodName()});
        }
        return jsObj.toString();
    }

    private String mapToJson(Map<String, String> map) {
        JSONObject jsObj = new JSONObject();
        if (map != null && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String value = map.get(key);
                try {
                    jsObj.put(key, (Object)SDKUtils.encodeString(value));
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
        }
        return jsObj.toString();
    }

    private Object[] getDeviceParams(Context context) {
        boolean fail = false;
        DeviceProperties deviceProperties = DeviceProperties.getInstance(context);
        JSONObject jsObj = new JSONObject();
        try {
            boolean isRoot;
            String rootStr;
            float deviceScale;
            String scaleStr;
            String deviceLanguage;
            String connectionType;
            String deviceApiLevel;
            String deviceOSType;
            String deviceModel;
            jsObj.put("appOrientation", (Object)SDKUtils.translateRequestedOrientation(DeviceStatus.getActivityRequestedOrientation(this.getCurrentActivityContext())));
            String deviceOem = deviceProperties.getDeviceOem();
            if (deviceOem != null) {
                jsObj.put(SDKUtils.encodeString("deviceOEM"), (Object)SDKUtils.encodeString(deviceOem));
            }
            if ((deviceModel = deviceProperties.getDeviceModel()) != null) {
                jsObj.put(SDKUtils.encodeString("deviceModel"), (Object)SDKUtils.encodeString(deviceModel));
            } else {
                fail = true;
            }
            SDKUtils.loadGoogleAdvertiserInfo(context);
            String advertiserId = SDKUtils.getAdvertiserId();
            Boolean isLAT = SDKUtils.isLimitAdTrackingEnabled();
            if (!TextUtils.isEmpty((CharSequence)advertiserId)) {
                Logger.i(this.TAG, "add AID and LAT");
                jsObj.put("isLimitAdTrackingEnabled", (Object)isLAT);
                StringBuilder aid = new StringBuilder().append("deviceIds").append("[").append("AID").append("]");
                jsObj.put(aid.toString(), (Object)SDKUtils.encodeString(advertiserId));
            }
            if ((deviceOSType = deviceProperties.getDeviceOsType()) != null) {
                jsObj.put(SDKUtils.encodeString("deviceOs"), (Object)SDKUtils.encodeString(deviceOSType));
            } else {
                fail = true;
            }
            String deviceOSVersion = deviceProperties.getDeviceOsVersion();
            if (deviceOSVersion != null) {
                deviceOSVersion = deviceOSVersion.replaceAll("[^0-9/.]", "");
                jsObj.put(SDKUtils.encodeString("deviceOSVersion"), (Object)deviceOSVersion);
            } else {
                fail = true;
            }
            String deviceOSVersionFull = deviceProperties.getDeviceOsVersion();
            if (deviceOSVersionFull != null) {
                jsObj.put(SDKUtils.encodeString("deviceOSVersionFull"), (Object)SDKUtils.encodeString(deviceOSVersionFull));
            }
            if ((deviceApiLevel = String.valueOf(deviceProperties.getDeviceApiLevel())) != null) {
                jsObj.put(SDKUtils.encodeString("deviceApiLevel"), (Object)deviceApiLevel);
            } else {
                fail = true;
            }
            String ssaSDKVersion = DeviceProperties.getSupersonicSdkVersion();
            if (ssaSDKVersion != null) {
                jsObj.put(SDKUtils.encodeString("SDKVersion"), (Object)SDKUtils.encodeString(ssaSDKVersion));
            }
            if (deviceProperties.getDeviceCarrier() != null && deviceProperties.getDeviceCarrier().length() > 0) {
                jsObj.put(SDKUtils.encodeString("mobileCarrier"), (Object)SDKUtils.encodeString(deviceProperties.getDeviceCarrier()));
            }
            if (!(connectionType = ConnectivityUtils.getConnectionType(context)).equals("none")) {
                jsObj.put(SDKUtils.encodeString("connectionType"), (Object)SDKUtils.encodeString(connectionType));
            } else {
                fail = true;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                jsObj.put(SDKUtils.encodeString("hasVPN"), ConnectivityUtils.hasVPN(context));
            }
            if (!TextUtils.isEmpty((CharSequence)(deviceLanguage = context.getResources().getConfiguration().locale.getLanguage()))) {
                jsObj.put(SDKUtils.encodeString("deviceLanguage"), (Object)SDKUtils.encodeString(deviceLanguage.toUpperCase()));
            }
            if (SDKUtils.isExternalStorageAvailable()) {
                long freeDiskSize = DeviceStatus.getAvailableMemorySizeInMegaBytes(this.mCacheDirectory);
                jsObj.put(SDKUtils.encodeString("diskFreeSize"), (Object)SDKUtils.encodeString(String.valueOf(freeDiskSize)));
            } else {
                fail = true;
            }
            int deviceWidth = DeviceStatus.getDeviceWidth();
            String width = String.valueOf(deviceWidth);
            if (!TextUtils.isEmpty((CharSequence)width)) {
                StringBuilder key = new StringBuilder();
                key.append(SDKUtils.encodeString("deviceScreenSize")).append("[").append(SDKUtils.encodeString("width")).append("]");
                jsObj.put(key.toString(), (Object)SDKUtils.encodeString(width));
            } else {
                fail = true;
            }
            int deviceHeight = DeviceStatus.getDeviceHeight();
            String height = String.valueOf(deviceHeight);
            StringBuilder key = new StringBuilder();
            key.append(SDKUtils.encodeString("deviceScreenSize")).append("[").append(SDKUtils.encodeString("height")).append("]");
            jsObj.put(key.toString(), (Object)SDKUtils.encodeString(height));
            String packageName = ApplicationContext.getPackageName(this.getContext());
            if (!TextUtils.isEmpty((CharSequence)packageName)) {
                jsObj.put(SDKUtils.encodeString("bundleId"), (Object)SDKUtils.encodeString(packageName));
            }
            if (!TextUtils.isEmpty((CharSequence)(scaleStr = String.valueOf(deviceScale = DeviceStatus.getDeviceDensity())))) {
                jsObj.put(SDKUtils.encodeString("deviceScreenScale"), (Object)SDKUtils.encodeString(scaleStr));
            }
            if (!TextUtils.isEmpty((CharSequence)(rootStr = String.valueOf(isRoot = DeviceStatus.isRootedDevice())))) {
                jsObj.put(SDKUtils.encodeString("unLocked"), (Object)SDKUtils.encodeString(rootStr));
            }
            float deviceVolume = DeviceProperties.getInstance(context).getDeviceVolume(context);
            jsObj.put(SDKUtils.encodeString("deviceVolume"), (double)deviceVolume);
            Context ctx = this.getCurrentActivityContext();
            if (Build.VERSION.SDK_INT >= 19 && ctx instanceof Activity) {
                jsObj.put(SDKUtils.encodeString("immersiveMode"), DeviceStatus.isImmersiveSupported((Activity)ctx));
            }
            jsObj.put(SDKUtils.encodeString("batteryLevel"), DeviceStatus.getBatteryLevel(ctx));
            jsObj.put(SDKUtils.encodeString("mcc"), ConnectivityService.getNetworkMCC(ctx));
            jsObj.put(SDKUtils.encodeString("mnc"), ConnectivityService.getNetworkMNC(ctx));
            jsObj.put(SDKUtils.encodeString("phoneType"), ConnectivityService.getPhoneType(ctx));
            jsObj.put(SDKUtils.encodeString("simOperator"), (Object)SDKUtils.encodeString(ConnectivityService.getSimOperator(ctx)));
            jsObj.put(SDKUtils.encodeString("lastUpdateTime"), ApplicationContext.getLastUpdateTime(ctx));
            jsObj.put(SDKUtils.encodeString("firstInstallTime"), ApplicationContext.getFirstInstallTime(ctx));
            jsObj.put(SDKUtils.encodeString("appVersion"), (Object)SDKUtils.encodeString(ApplicationContext.getApplicationVersionName(ctx)));
            String installerPackageName = ApplicationContext.getInstallerPackageName(ctx);
            if (!TextUtils.isEmpty((CharSequence)installerPackageName)) {
                jsObj.put(SDKUtils.encodeString("installerPackageName"), (Object)SDKUtils.encodeString(installerPackageName));
            }
            this.addGooglePlayInstalledData(jsObj);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=" + e2.getStackTrace()[0].getMethodName()});
        }
        Object[] result = new Object[]{jsObj.toString(), fail};
        return result;
    }

    private void addGooglePlayInstalledData(JSONObject originalConfiguration) throws JSONException {
        originalConfiguration.put(SDKUtils.encodeString("gpi"), PackagesInstallationService.isGooglePlayInstalled(this.getContext()));
    }

    private Object[] getApplicationParams(String productType, String demandSourceId) {
        boolean fail = false;
        JSONObject jsObj = new JSONObject();
        Map<String, String> productExtraParams = null;
        if (!TextUtils.isEmpty((CharSequence)productType)) {
            SSAEnums.ProductType type = this.getStringProductTypeAsEnum(productType);
            if (type == SSAEnums.ProductType.OfferWall) {
                productExtraParams = this.mOWExtraParameters;
            } else {
                DemandSource demandSource = this.mDemandSourceManager.getDemandSourceById(type, demandSourceId);
                if (demandSource != null) {
                    productExtraParams = demandSource.getExtraParams();
                    productExtraParams.put("demandSourceName", demandSource.getDemandSourceName());
                    productExtraParams.put("demandSourceId", demandSource.getId());
                }
            }
            try {
                jsObj.put("productType", (Object)productType);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            try {
                Map<String, String> initParams = SDKUtils.getInitSDKParams();
                if (initParams != null) {
                    JSONObject jsonInitParams = new JSONObject(initParams);
                    jsObj = SDKUtils.mergeJSONObjects(jsObj, jsonInitParams);
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        } else {
            fail = true;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserId)) {
            try {
                jsObj.put(SDKUtils.encodeString("applicationUserId"), (Object)SDKUtils.encodeString(this.mUserId));
            }
            catch (JSONException e4) {
                e4.printStackTrace();
            }
        } else {
            fail = true;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mApplicationKey)) {
            try {
                jsObj.put(SDKUtils.encodeString("applicationKey"), (Object)SDKUtils.encodeString(this.mApplicationKey));
            }
            catch (JSONException e5) {
                e5.printStackTrace();
            }
        } else {
            fail = true;
        }
        if (productExtraParams != null && !productExtraParams.isEmpty()) {
            for (Map.Entry<String, String> entry : productExtraParams.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("sdkWebViewCache")) {
                    this.setWebviewCache(entry.getValue());
                }
                try {
                    jsObj.put(SDKUtils.encodeString(entry.getKey()), (Object)SDKUtils.encodeString(entry.getValue()));
                }
                catch (JSONException e6) {
                    e6.printStackTrace();
                }
            }
        }
        Object[] result = new Object[]{jsObj.toString(), fail};
        return result;
    }

    @Override
    public void onFileDownloadSuccess(SSAFile file) {
        if (file.getFile().contains("mobileController.html")) {
            this.load(1);
        } else {
            this.assetCached(file.getFile(), file.getPath());
        }
    }

    @Override
    public void onFileDownloadFail(SSAFile file) {
        if (file.getFile().contains("mobileController.html")) {
            this.mControllerListener.handleControllerStageFailed("controller failed to download - " + file.getErrMsg());
        } else {
            this.assetCachedFailed(file.getFile(), file.getPath(), file.getErrMsg());
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        Logger.i(this.TAG, url + " " + mimetype);
    }

    private void toastingErrMsg(final String methodName, String value) {
        SSAObj ssaObj = new SSAObj(value);
        final String message = ssaObj.getString("errMsg");
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WebController.this.getDebugMode() == SSAEnums.DebugMode.MODE_3.getValue()) {
                        Toast.makeText((Context)WebController.this.getCurrentActivityContext(), (CharSequence)(methodName + " : " + message), (int)1).show();
                    }
                }
            });
        }
    }

    public void setControllerKeyPressed(String value) {
        this.mControllerKeyPressed = value;
    }

    public String getControllerKeyPressed() {
        String keyPressed = this.mControllerKeyPressed;
        this.setControllerKeyPressed("interrupt");
        return keyPressed;
    }

    public void sendConnectionTypeChanged(String connectionType) {
        Logger.i(this.TAG, "device status changed, connection type " + connectionType);
        ISNEventsBaseData.setConnectionType(connectionType);
        String params = this.parseToJson("connectionType", connectionType, null, null, null, null, null, null, null, false);
        String script = this.generateJSToInject("deviceStatusChanged", params);
        this.injectJavascript(script);
    }

    public void sendConnectionInfoChanged(JSONObject connectionInfo) {
        Logger.i(this.TAG, "device connection info changed: " + connectionInfo.toString());
        String params = this.parseToJson("connectionInfo", connectionInfo.toString(), null, null, null, null, null, null, null, false);
        String script = this.generateJSToInject("connectionInfoChanged", params);
        this.injectJavascript(script);
    }

    public void engageEnd(String action) {
        if (action.equals("forceClose")) {
            this.closeWebView();
        }
        String params = this.parseToJson("action", action, null, null, null, null, null, null, null, false);
        String script = this.generateJSToInject("engageEnd", params);
        this.injectJavascript(script);
    }

    @Override
    public void registerConnectionReceiver(Context context) {
        if (this.mConnectivityAdapter == null) {
            return;
        }
        this.mConnectivityAdapter.startListenToNetworkChanges(context);
    }

    @Override
    public void unregisterConnectionReceiver(Context context) {
        if (this.mConnectivityAdapter == null) {
            return;
        }
        this.mConnectivityAdapter.stopListenToNetworkChanges(context);
    }

    public void pause() {
        if (Build.VERSION.SDK_INT > 10) {
            try {
                this.onPause();
            }
            catch (Throwable e2) {
                Logger.i(this.TAG, "WebViewController: pause() - " + e2);
                new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=webviewPause"});
            }
        }
    }

    public void resume() {
        if (Build.VERSION.SDK_INT > 10) {
            try {
                this.onResume();
            }
            catch (Throwable e2) {
                Logger.i(this.TAG, "WebViewController: onResume() - " + e2);
                new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=webviewResume"});
            }
        }
    }

    public void setOnWebViewControllerChangeListener(OnWebViewChangeListener listener) {
        this.mChangeListener = listener;
    }

    public FrameLayout getLayout() {
        return this.mControllerLayout;
    }

    public boolean inCustomView() {
        return this.mCustomView != null;
    }

    public void hideCustomView() {
        this.mWebChromeClient.onHideCustomView();
    }

    private void setWebviewCache(String value) {
        if (value.equalsIgnoreCase("0")) {
            this.getSettings().setCacheMode(2);
        } else {
            this.getSettings().setCacheMode(-1);
        }
    }

    public boolean handleSearchKeysURLs(String url) {
        List<String> searchKeys = IronSourceSharedPrefHelper.getSupersonicPrefHelper().getSearchKeys();
        try {
            if (searchKeys != null && !searchKeys.isEmpty()) {
                for (String key : searchKeys) {
                    if (!url.contains(key)) continue;
                    UrlHandler.openUrl(this.getCurrentActivityContext(), url);
                    return true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public void setState(State state) {
        this.mState = state;
    }

    public State getState() {
        return this.mState;
    }

    private void sendProductErrorMessage(SSAEnums.ProductType type, DemandSource demandSource) {
        this.triggerOnControllerInitProductFail(SDKUtils.createErrorMessage(this.getErrorCodeByProductType(type), "Initiating Controller"), type, demandSource);
    }

    private String getErrorCodeByProductType(SSAEnums.ProductType type) {
        String action = "";
        switch (type) {
            case RewardedVideo: {
                action = "Init RV";
                break;
            }
            case Interstitial: {
                action = "Init IS";
                break;
            }
            case OfferWall: {
                action = "Init OW";
                break;
            }
            case OfferWallCredits: {
                action = "Show OW Credits";
                break;
            }
            case Banner: {
                action = "Init BN";
                break;
            }
        }
        return action;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.downloadManager != null) {
            this.downloadManager.release();
        }
        if (this.mConnectivityAdapter != null) {
            this.mConnectivityAdapter.release();
        }
        this.mUiHandler = null;
        this.mCurrentActivityContext = null;
    }

    private String generateJSToInject(String funToCall) {
        StringBuilder script = new StringBuilder();
        script.append("SSA_CORE.SDKController.runFunction('").append(funToCall).append("');");
        return script.toString();
    }

    private String generateJSToInject(String funToCall, String parameters) {
        StringBuilder script = new StringBuilder();
        script.append("SSA_CORE.SDKController.runFunction('").append(funToCall).append("?parameters=").append(parameters).append("');");
        return script.toString();
    }

    private String generateJSToInject(String funToCall, String successFunc, String failFunc) {
        StringBuilder script = new StringBuilder();
        script.append("SSA_CORE.SDKController.runFunction('").append(funToCall).append("','").append(successFunc).append("','").append(failFunc).append("');");
        return script.toString();
    }

    private String generateJSToInject(String funToCall, String parameters, String successFunc, String failFunc) {
        StringBuilder script = new StringBuilder();
        script.append("SSA_CORE.SDKController.runFunction('").append(funToCall).append("?parameters=").append(parameters).append("','").append(successFunc).append("','").append(failFunc).append("');");
        return script.toString();
    }

    public AdUnitsState getSavedState() {
        return this.mSavedState;
    }

    @Override
    public void restoreSavedState() {
        this.restoreState(this.mSavedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(AdUnitsState state) {
        Object object = this.mSavedStateLocker;
        synchronized (object) {
            if (state.shouldRestore() && this.mIsWebControllerReady) {
                Log.d((String)this.TAG, (String)("restoreState(state:" + state + ")"));
                int lastAd = state.getDisplayedProduct();
                if (lastAd != -1) {
                    DSAdProductListener listener;
                    String demandSourceId;
                    SSAEnums.ProductType type;
                    if (lastAd == SSAEnums.ProductType.RewardedVideo.ordinal()) {
                        Log.d((String)this.TAG, (String)"onRVAdClosed()");
                        type = SSAEnums.ProductType.RewardedVideo;
                        demandSourceId = state.getDisplayedDemandSourceId();
                        listener = this.getAdProductListenerByProductType(type);
                        if (listener != null && !TextUtils.isEmpty((CharSequence)demandSourceId)) {
                            listener.onAdProductClose(type, demandSourceId);
                        }
                    } else if (lastAd == SSAEnums.ProductType.Interstitial.ordinal()) {
                        Log.d((String)this.TAG, (String)"onInterstitialAdClosed()");
                        type = SSAEnums.ProductType.Interstitial;
                        demandSourceId = state.getDisplayedDemandSourceId();
                        listener = this.getAdProductListenerByProductType(type);
                        if (listener != null && !TextUtils.isEmpty((CharSequence)demandSourceId)) {
                            listener.onAdProductClose(type, demandSourceId);
                        }
                    } else if (lastAd == SSAEnums.ProductType.OfferWall.ordinal()) {
                        Log.d((String)this.TAG, (String)"onOWAdClosed()");
                        if (this.mOnOfferWallListener != null) {
                            this.mOnOfferWallListener.onOWAdClosed();
                        }
                    }
                    state.adOpened(-1);
                    state.setDisplayedDemandSourceId(null);
                } else {
                    Log.d((String)this.TAG, (String)"No ad was opened");
                }
                String appKey = state.getInterstitialAppKey();
                String userId = state.getInterstitialUserId();
                Collection<DemandSource> demandSources = this.mDemandSourceManager.getDemandSources(SSAEnums.ProductType.Interstitial);
                for (DemandSource demandSource : demandSources) {
                    if (demandSource.getDemandSourceInitState() != 2) continue;
                    Log.d((String)this.TAG, (String)("initInterstitial(appKey:" + appKey + ", userId:" + userId + ", demandSource:" + demandSource.getDemandSourceName() + ")"));
                    this.initInterstitial(appKey, userId, demandSource, this.mDSInterstitialListener);
                }
                appKey = state.getRVAppKey();
                userId = state.getRVUserId();
                demandSources = this.mDemandSourceManager.getDemandSources(SSAEnums.ProductType.RewardedVideo);
                for (DemandSource demandSource : demandSources) {
                    if (demandSource.getDemandSourceInitState() != 2) continue;
                    String demandSourceName = demandSource.getDemandSourceName();
                    Log.d((String)this.TAG, (String)"onRVNoMoreOffers()");
                    this.mDSRewardedVideoListener.onRVNoMoreOffers(demandSourceName);
                    Log.d((String)this.TAG, (String)("initRewardedVideo(appKey:" + appKey + ", userId:" + userId + ", demandSource:" + demandSourceName + ")"));
                    this.initRewardedVideo(appKey, userId, demandSource, this.mDSRewardedVideoListener);
                }
                state.setShouldRestore(false);
            }
            this.mSavedState = state;
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (!this.mChangeListener.onBackButtonPressed()) {
                return super.onKeyDown(keyCode, event);
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    void runOnUiThread(Runnable task) {
        if (this.mUiHandler != null) {
            this.mUiHandler.post(task);
        }
    }

    @Override
    public void setCommunicationWithAdView(ISNAdView adView) {
        if (this.mBannerJsAdapter != null) {
            this.mBannerJsAdapter.setCommunicationWithAdView(adView);
        }
    }

    public static enum State {
        Display,
        Gone;

    }

    static class Result {
        String methodName;
        String script;

        Result() {
        }
    }

    private static interface OnInitProductHandler {
        public void handleInitProductFailed(String var1, SSAEnums.ProductType var2, DemandSource var3);
    }

    public class NativeAPI {
        @JavascriptInterface
        public void removeMessagingInterface(String value) {
            WebController.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WebController.this.removeJavascriptInterface("GenerateTokenForMessaging");
                }
            });
        }

        @JavascriptInterface
        public void initController(String value) {
            Logger.i(WebController.this.TAG, "initController(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            if (WebController.this.mLoadControllerTimer != null) {
                WebController.this.mLoadControllerTimer.cancel();
                WebController.this.mLoadControllerTimer = null;
            }
            if (ssaObj.containsKey("stage")) {
                String stage = ssaObj.getString("stage");
                if ("ready".equalsIgnoreCase(stage)) {
                    WebController.this.mIsWebControllerReady = true;
                    WebController.this.mControllerListener.handleControllerStageReady();
                    return;
                }
                if ("loaded".equalsIgnoreCase(stage)) {
                    WebController.this.mControllerListener.handleControllerStageLoaded();
                    return;
                }
                if ("failed".equalsIgnoreCase(stage)) {
                    String errorMessage = ssaObj.getString("errMsg");
                    WebController.this.mControllerListener.handleControllerStageFailed("controller failed to initialize : " + errorMessage);
                    return;
                }
                Logger.i(WebController.this.TAG, "No STAGE mentioned! Should not get here!");
            }
        }

        @JavascriptInterface
        public void getDeviceStatus(String value) {
            Logger.i(WebController.this.TAG, "getDeviceStatus(" + value + ")");
            String successFunToCall = WebController.this.extractSuccessFunctionToCall(value);
            String failFunToCall = WebController.this.extractFailFunctionToCall(value);
            Object[] resultArr = new Object[2];
            resultArr = WebController.this.getDeviceParams(WebController.this.getContext());
            String params = (String)resultArr[0];
            boolean failed = (Boolean)resultArr[1];
            String funToCall = null;
            if (failed) {
                if (!TextUtils.isEmpty((CharSequence)failFunToCall)) {
                    funToCall = failFunToCall;
                }
            } else if (!TextUtils.isEmpty((CharSequence)successFunToCall)) {
                funToCall = successFunToCall;
            }
            if (!TextUtils.isEmpty((CharSequence)funToCall)) {
                String script = WebController.this.generateJSToInject(funToCall, params, "onGetDeviceStatusSuccess", "onGetDeviceStatusFail");
                WebController.this.injectJavascript(script);
            }
        }

        @JavascriptInterface
        public void getConnectivityInfo(String value) {
            String script;
            Logger.i(WebController.this.TAG, "getConnectivityInfo(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String successFunToCall = ssaObj.getString(JSON_KEY_SUCCESS);
            String failureFunToCall = ssaObj.getString(JSON_KEY_FAIL);
            JSONObject data = new JSONObject();
            if (WebController.this.mConnectivityAdapter != null) {
                data = WebController.this.mConnectivityAdapter.getConnectivityData(WebController.this.getContext());
            }
            if (data.length() > 0) {
                script = WebController.this.generateJSToInject(successFunToCall, data.toString());
            } else {
                String params = WebController.this.parseToJson("errMsg", "failed to retrieve connection info", null, null, null, null, null, null, null, false);
                script = WebController.this.generateJSToInject(failureFunToCall, params);
            }
            WebController.this.injectJavascript(script);
        }

        @JavascriptInterface
        public void setMixedContentAlwaysAllow(String value) {
            Logger.i(WebController.this.TAG, "setMixedContentAlwaysAllow(" + value + ")");
            WebController.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 21) {
                        WebController.this.getSettings().setMixedContentMode(0);
                    }
                }
            });
        }

        @JavascriptInterface
        public void getControllerConfig(String value) {
            Logger.i(WebController.this.TAG, "getControllerConfig(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String successFunToCall = ssaObj.getString(JSON_KEY_SUCCESS);
            if (!TextUtils.isEmpty((CharSequence)successFunToCall)) {
                JSONObject controllerConfig = SDKUtils.getControllerConfigAsJSONObject();
                this.extendControllerConfig(controllerConfig);
                String script = WebController.this.generateJSToInject(successFunToCall, controllerConfig.toString());
                WebController.this.injectJavascript(script);
            }
        }

        private void extendControllerConfig(JSONObject controllerConfig) {
            this.addSupportedNativeFeaturesToConfig(controllerConfig);
            this.addTesterParametersToConfig(controllerConfig, SDKUtils.getTesterParameters());
        }

        private void addSupportedNativeFeaturesToConfig(JSONObject controllerConfig) {
            try {
                FeaturesManager featuresManager = FeaturesManager.getInstance();
                if (featuresManager.getSupportedFeatures().isEmpty()) {
                    return;
                }
                controllerConfig.put("nativeFeatures", (Object)new JSONArray(featuresManager.getSupportedFeatures()));
            }
            catch (Exception e2) {
                ISNEventParams params = new ISNEventParams().addPair("callfailreason", e2.getMessage());
                ISNEventsTracker.logEvent(SDK5Events.appendNativeFeaturesDataFailed, params.getData());
                Logger.d(WebController.this.TAG, "getControllerConfig Error while adding supported features data from FeaturesManager");
            }
        }

        private void addTesterParametersToConfig(JSONObject controllerConfig, String testerParameters) {
            if (this.areTesterParametersValid(testerParameters)) {
                try {
                    JSONObject testerParams = new JSONObject(testerParameters);
                    controllerConfig.putOpt("testerABGroup", testerParams.get("testerABGroup"));
                    controllerConfig.putOpt("testFriendlyName", testerParams.get("testFriendlyName"));
                }
                catch (JSONException jsonException) {
                    Logger.d(WebController.this.TAG, "getControllerConfig Error while parsing Tester AB Group parameters");
                }
            }
        }

        boolean areTesterParametersValid(String testerParameters) {
            if (!TextUtils.isEmpty((CharSequence)testerParameters) && !testerParameters.contains("-1")) {
                try {
                    JSONObject testerParams = new JSONObject(testerParameters);
                    if (!testerParams.getString("testerABGroup").isEmpty() && !testerParams.getString("testFriendlyName").isEmpty()) {
                        return true;
                    }
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
            return false;
        }

        @JavascriptInterface
        public void getApplicationInfo(String value) {
            Logger.i(WebController.this.TAG, "getApplicationInfo(" + value + ")");
            String successFunToCall = WebController.this.extractSuccessFunctionToCall(value);
            String failFunToCall = WebController.this.extractFailFunctionToCall(value);
            SSAObj ssaObj = new SSAObj(value);
            String product = ssaObj.getString("productType");
            String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            String funToCall = null;
            Object[] resultArr = new Object[2];
            resultArr = WebController.this.getApplicationParams(product, demandSourceId);
            String params = (String)resultArr[0];
            boolean failed = (Boolean)resultArr[1];
            if (failed) {
                if (!TextUtils.isEmpty((CharSequence)failFunToCall)) {
                    funToCall = failFunToCall;
                }
            } else if (!TextUtils.isEmpty((CharSequence)successFunToCall)) {
                funToCall = successFunToCall;
            }
            if (!TextUtils.isEmpty((CharSequence)funToCall)) {
                String script = WebController.this.generateJSToInject(funToCall, params, "onGetApplicationInfoSuccess", "onGetApplicationInfoFail");
                WebController.this.injectJavascript(script);
            }
        }

        @JavascriptInterface
        public void saveFile(String value) {
            String lastUpdateTimeStr;
            Logger.i(WebController.this.TAG, "saveFile(" + value + ")");
            SSAFile ssaFile = new SSAFile(value);
            if (DeviceStatus.getAvailableMemorySizeInMegaBytes(WebController.this.mCacheDirectory) <= 0L) {
                WebController.this.responseBack(value, false, "no_disk_space", null);
                return;
            }
            if (!SDKUtils.isExternalStorageAvailable()) {
                WebController.this.responseBack(value, false, "sotrage_unavailable", null);
                return;
            }
            if (IronSourceStorageUtils.isFileCached(WebController.this.mCacheDirectory, ssaFile)) {
                WebController.this.responseBack(value, false, "file_already_exist", null);
                return;
            }
            if (!ConnectivityService.isConnected(WebController.this.getContext())) {
                WebController.this.responseBack(value, false, "no_network_connection", null);
                return;
            }
            WebController.this.responseBack(value, true, null, null);
            String lastUpdateTimeObj = ssaFile.getLastUpdateTime();
            if (lastUpdateTimeObj != null && !TextUtils.isEmpty((CharSequence)(lastUpdateTimeStr = String.valueOf(lastUpdateTimeObj)))) {
                String folder;
                String path = ssaFile.getPath();
                if (path.contains("/")) {
                    String[] splitArr = ssaFile.getPath().split("/");
                    folder = splitArr[splitArr.length - 1];
                } else {
                    folder = path;
                }
                IronSourceSharedPrefHelper.getSupersonicPrefHelper().setCampaignLastUpdate(folder, lastUpdateTimeStr);
            }
            WebController.this.downloadManager.downloadFile(ssaFile);
        }

        @JavascriptInterface
        public void adUnitsReady(String value) {
            Logger.i(WebController.this.TAG, "adUnitsReady(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            final AdUnitsReady adUnitsReady = new AdUnitsReady(value);
            if (!adUnitsReady.isNumOfAdUnitsExist()) {
                WebController.this.responseBack(value, false, "Num Of Ad Units Do Not Exist", null);
                return;
            }
            WebController.this.responseBack(value, true, null, null);
            String product = adUnitsReady.getProductType();
            if (SSAEnums.ProductType.RewardedVideo.toString().equalsIgnoreCase(product) && WebController.this.shouldNotifyDeveloper(product)) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        int adUnits = Integer.parseInt(adUnitsReady.getNumOfAdUnits());
                        if (adUnits > 0) {
                            Log.d((String)WebController.this.TAG, (String)"onRVInitSuccess()");
                            WebController.this.mDSRewardedVideoListener.onAdProductInitSuccess(SSAEnums.ProductType.RewardedVideo, demandSourceId, adUnitsReady);
                        } else {
                            WebController.this.mDSRewardedVideoListener.onRVNoMoreOffers(demandSourceId);
                        }
                    }
                });
            }
        }

        @JavascriptInterface
        public void iabTokenAPI(String value) {
            try {
                Logger.i(WebController.this.TAG, "iabTokenAPI(" + value + ")");
                SSAObj ssaObj = new SSAObj(value);
                WebController.this.mTokenJSAdapter.call(ssaObj.toString(), new JSCallbackTask());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Logger.i(WebController.this.TAG, "iabTokenAPI failed with exception " + e2.getMessage());
            }
        }

        @JavascriptInterface
        public void deleteFolder(String value) {
            Logger.i(WebController.this.TAG, "deleteFolder(" + value + ")");
            SSAFile file = new SSAFile(value);
            if (!IronSourceStorageUtils.isPathExist(WebController.this.mCacheDirectory, file.getPath())) {
                WebController.this.responseBack(value, false, "Folder not exist", "1");
            } else {
                boolean result = IronSourceStorageUtils.deleteFolder(WebController.this.mCacheDirectory, file.getPath());
                WebController.this.responseBack(value, result, null, null);
            }
        }

        @JavascriptInterface
        public void deleteFile(String value) {
            Logger.i(WebController.this.TAG, "deleteFile(" + value + ")");
            SSAFile file = new SSAFile(value);
            if (!IronSourceStorageUtils.isPathExist(WebController.this.mCacheDirectory, file.getPath())) {
                WebController.this.responseBack(value, false, "File not exist", "1");
            } else {
                boolean result = IronSourceStorageUtils.deleteFile(WebController.this.mCacheDirectory, file.getPath(), file.getFile());
                WebController.this.responseBack(value, result, null, null);
            }
        }

        @JavascriptInterface
        public void displayWebView(String value) {
            Logger.i(WebController.this.TAG, "displayWebView(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            SSAObj ssaObj = new SSAObj(value);
            boolean display = (Boolean)ssaObj.get("display");
            String productType = ssaObj.getString("productType");
            boolean isStandaloneView = ssaObj.getBoolean("standaloneView");
            String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (display) {
                WebController.this.mIsImmersive = ssaObj.getBoolean("immersive");
                boolean isActivityThemeTranslucent = ssaObj.getBoolean("activityThemeTranslucent");
                if (WebController.this.getState() != State.Display) {
                    WebController.this.setState(State.Display);
                    Logger.i(WebController.this.TAG, "State: " + (Object)((Object)WebController.this.mState));
                    Context context = WebController.this.getCurrentActivityContext();
                    String orientation = WebController.this.getOrientationState();
                    int rotation = DeviceStatus.getApplicationRotation(context);
                    if (isStandaloneView) {
                        ControllerView controllerView = new ControllerView(context);
                        controllerView.addView((View)WebController.this.mControllerLayout);
                        controllerView.showInterstitial(WebController.this);
                    } else {
                        Intent intent = isActivityThemeTranslucent ? new Intent(context, InterstitialActivity.class) : new Intent(context, ControllerActivity.class);
                        if (SSAEnums.ProductType.RewardedVideo.toString().equalsIgnoreCase(productType)) {
                            if ("application".equals(orientation)) {
                                orientation = SDKUtils.translateRequestedOrientation(DeviceStatus.getActivityRequestedOrientation(WebController.this.getCurrentActivityContext()));
                            }
                            intent.putExtra("productType", SSAEnums.ProductType.RewardedVideo.toString());
                            WebController.this.mSavedState.adOpened(SSAEnums.ProductType.RewardedVideo.ordinal());
                            WebController.this.mSavedState.setDisplayedDemandSourceId(demandSourceId);
                            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.RewardedVideo.toString())) {
                                WebController.this.mDSRewardedVideoListener.onAdProductOpen(SSAEnums.ProductType.RewardedVideo, demandSourceId);
                            }
                        } else if (SSAEnums.ProductType.OfferWall.toString().equalsIgnoreCase(productType)) {
                            intent.putExtra("productType", SSAEnums.ProductType.OfferWall.toString());
                            WebController.this.mSavedState.adOpened(SSAEnums.ProductType.OfferWall.ordinal());
                        } else if (SSAEnums.ProductType.Interstitial.toString().equalsIgnoreCase(productType)) {
                            if ("application".equals(orientation)) {
                                orientation = SDKUtils.translateRequestedOrientation(DeviceStatus.getActivityRequestedOrientation(WebController.this.getCurrentActivityContext()));
                            }
                            intent.putExtra("productType", SSAEnums.ProductType.Interstitial.toString());
                        }
                        intent.setFlags(0x20000000);
                        intent.putExtra("immersive", WebController.this.mIsImmersive);
                        intent.putExtra("orientation_set_flag", orientation);
                        intent.putExtra("rotation_set_flag", rotation);
                        context.startActivity(intent);
                    }
                } else {
                    Logger.i(WebController.this.TAG, "State: " + (Object)((Object)WebController.this.mState));
                }
            } else {
                WebController.this.setState(State.Gone);
                WebController.this.closeWebView();
            }
        }

        @JavascriptInterface
        public void getOrientation(String value) {
            String funToCall = WebController.this.extractSuccessFunctionToCall(value);
            String params = SDKUtils.getOrientation(WebController.this.getCurrentActivityContext()).toString();
            if (!TextUtils.isEmpty((CharSequence)funToCall)) {
                String script = WebController.this.generateJSToInject(funToCall, params, "onGetOrientationSuccess", "onGetOrientationFail");
                WebController.this.injectJavascript(script);
            }
        }

        @JavascriptInterface
        public void setOrientation(String value) {
            Logger.i(WebController.this.TAG, "setOrientation(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String orientation = ssaObj.getString("orientation");
            WebController.this.setOrientationState(orientation);
            int rotation = DeviceStatus.getApplicationRotation(WebController.this.getCurrentActivityContext());
            if (WebController.this.mChangeListener != null) {
                WebController.this.mChangeListener.onOrientationChanged(orientation, rotation);
            }
        }

        @JavascriptInterface
        public void getCachedFilesMap(String value) {
            Logger.i(WebController.this.TAG, "getCachedFilesMap(" + value + ")");
            String funToCall = WebController.this.extractSuccessFunctionToCall(value);
            if (!TextUtils.isEmpty((CharSequence)funToCall)) {
                SSAObj ssaObj = new SSAObj(value);
                if (!ssaObj.containsKey("path")) {
                    WebController.this.responseBack(value, false, "path key does not exist", null);
                    return;
                }
                String mapPath = (String)ssaObj.get("path");
                if (!IronSourceStorageUtils.isPathExist(WebController.this.mCacheDirectory, mapPath)) {
                    WebController.this.responseBack(value, false, "path file does not exist on disk", null);
                    return;
                }
                String fileSystmeMap = IronSourceStorageUtils.getCachedFilesMap(WebController.this.mCacheDirectory, mapPath);
                String script = WebController.this.generateJSToInject(funToCall, fileSystmeMap, "onGetCachedFilesMapSuccess", "onGetCachedFilesMapFail");
                WebController.this.injectJavascript(script);
            }
        }

        private void callJavaScriptFunction(String funToCall, String params) {
            if (!TextUtils.isEmpty((CharSequence)funToCall)) {
                String script = WebController.this.generateJSToInject(funToCall, params);
                WebController.this.injectJavascript(script);
            }
        }

        @JavascriptInterface
        public void getDemandSourceState(String value) {
            Logger.i(WebController.this.TAG, "getMediationState(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String demandSourceName = ssaObj.getString("demandSourceName");
            String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            String product = ssaObj.getString("productType");
            try {
                SSAEnums.ProductType productType;
                if (product != null && demandSourceName != null && (productType = SDKUtils.getProductType(product)) != null) {
                    DemandSource demandSource = WebController.this.mDemandSourceManager.getDemandSourceById(productType, demandSourceId);
                    String funToCall = null;
                    JSONObject obj = new JSONObject();
                    obj.put("productType", (Object)product);
                    obj.put("demandSourceName", (Object)demandSourceName);
                    obj.put("demandSourceId", (Object)demandSourceId);
                    if (demandSource != null && !demandSource.isMediationState(-1)) {
                        funToCall = WebController.this.extractSuccessFunctionToCall(value);
                        obj.put("state", demandSource.getMediationState());
                    } else {
                        funToCall = WebController.this.extractFailFunctionToCall(value);
                    }
                    this.callJavaScriptFunction(funToCall, obj.toString());
                }
            }
            catch (Exception ex) {
                WebController.this.responseBack(value, false, ex.getMessage(), null);
                ex.printStackTrace();
            }
        }

        @JavascriptInterface
        public void adCredited(final String value) {
            Log.d((String)WebController.this.PUB_TAG, (String)("adCredited(" + value + ")"));
            SSAObj ssaObj = new SSAObj(value);
            String creditsStr = ssaObj.getString("credits");
            final int credits = creditsStr != null ? Integer.parseInt(creditsStr) : 0;
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            final String product = ssaObj.getString("productType");
            if (TextUtils.isEmpty((CharSequence)product)) {
                Log.d((String)WebController.this.PUB_TAG, (String)"adCredited | not product NAME !!!!");
            }
            if (SSAEnums.ProductType.Interstitial.toString().equalsIgnoreCase(product)) {
                this.handleAdCreditedOnInterstitial(demandSourceId, credits);
                return;
            }
            String totalCreditsStr = ssaObj.getString("total");
            final int totalCredits = totalCreditsStr != null ? Integer.parseInt(totalCreditsStr) : 0;
            boolean isExternalPoll = ssaObj.getBoolean("externalPoll");
            boolean totalCreditsFlag = false;
            String latestCompeltionsTime = null;
            boolean md5Signature = false;
            if (SSAEnums.ProductType.OfferWall.toString().equalsIgnoreCase(product)) {
                StringBuilder sig;
                String localMD5;
                if (ssaObj.isNull("signature") || ssaObj.isNull("timestamp") || ssaObj.isNull("totalCreditsFlag")) {
                    WebController.this.responseBack(value, false, "One of the keys are missing: signature/timestamp/totalCreditsFlag", null);
                    return;
                }
                String controllerMD5 = ssaObj.getString("signature");
                if (controllerMD5.equalsIgnoreCase(localMD5 = SDKUtils.getMD5((sig = new StringBuilder().append(totalCreditsStr).append(WebController.this.mApplicationKey).append(WebController.this.mUserId)).toString()))) {
                    md5Signature = true;
                } else {
                    WebController.this.responseBack(value, false, "Controller signature is not equal to SDK signature", null);
                }
                totalCreditsFlag = ssaObj.getBoolean("totalCreditsFlag");
                latestCompeltionsTime = ssaObj.getString("timestamp");
            }
            if (WebController.this.shouldNotifyDeveloper(product)) {
                final boolean mTotalCreditsFlag = totalCreditsFlag;
                final String mlatestCompeltionsTime = latestCompeltionsTime;
                final boolean mMd5Signature = md5Signature;
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (product.equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.toString())) {
                            WebController.this.mDSRewardedVideoListener.onRVAdCredited(demandSourceId, credits);
                        } else if (product.equalsIgnoreCase(SSAEnums.ProductType.OfferWall.toString()) && mMd5Signature && WebController.this.mOnOfferWallListener.onOWAdCredited(credits, totalCredits, mTotalCreditsFlag) && !TextUtils.isEmpty((CharSequence)mlatestCompeltionsTime)) {
                            boolean result = IronSourceSharedPrefHelper.getSupersonicPrefHelper().setLatestCompletionsTime(mlatestCompeltionsTime, WebController.this.mApplicationKey, WebController.this.mUserId);
                            if (result) {
                                WebController.this.responseBack(value, true, null, null);
                            } else {
                                WebController.this.responseBack(value, false, "Time Stamp could not be stored", null);
                            }
                        }
                    }
                });
            }
        }

        private void handleAdCreditedOnInterstitial(final String demandSourceId, final int credits) {
            if (!WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Interstitial.toString())) {
                return;
            }
            DemandSource demandSource = WebController.this.mDemandSourceManager.getDemandSourceById(SSAEnums.ProductType.Interstitial, demandSourceId);
            if (demandSource == null || !demandSource.isRewarded()) {
                return;
            }
            WebController.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WebController.this.mDSInterstitialListener.onInterstitialAdRewarded(demandSourceId, credits);
                }
            });
        }

        @JavascriptInterface
        public void removeCloseEventHandler(String value) {
            Logger.i(WebController.this.TAG, "removeCloseEventHandler(" + value + ")");
            if (WebController.this.mCloseEventTimer != null) {
                WebController.this.mCloseEventTimer.cancel();
            }
            WebController.this.isRemoveCloseEventHandler = true;
        }

        @JavascriptInterface
        public void onGetDeviceStatusSuccess(String value) {
            Logger.i(WebController.this.TAG, "onGetDeviceStatusSuccess(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGetDeviceStatusSuccess", value);
        }

        @JavascriptInterface
        public void onGetDeviceStatusFail(String value) {
            Logger.i(WebController.this.TAG, "onGetDeviceStatusFail(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGetDeviceStatusFail", value);
        }

        @JavascriptInterface
        public void onInitRewardedVideoFail(String value) {
            Logger.i(WebController.this.TAG, "onInitRewardedVideoFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            DemandSource demandSource = WebController.this.mDemandSourceManager.getDemandSourceById(SSAEnums.ProductType.RewardedVideo, demandSourceId);
            if (demandSource != null) {
                demandSource.setDemandSourceInitState(3);
            }
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.RewardedVideo.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        Log.d((String)WebController.this.TAG, (String)("onRVInitFail(message:" + toSend + ")"));
                        WebController.this.mDSRewardedVideoListener.onAdProductInitFailed(SSAEnums.ProductType.RewardedVideo, demandSourceId, toSend);
                    }
                });
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onInitRewardedVideoFail", value);
        }

        @JavascriptInterface
        public void onGetApplicationInfoSuccess(String value) {
            Logger.i(WebController.this.TAG, "onGetApplicationInfoSuccess(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGetApplicationInfoSuccess", value);
        }

        @JavascriptInterface
        public void onGetApplicationInfoFail(String value) {
            Logger.i(WebController.this.TAG, "onGetApplicationInfoFail(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGetApplicationInfoFail", value);
        }

        @JavascriptInterface
        public void onShowRewardedVideoSuccess(String value) {
            Logger.i(WebController.this.TAG, "onShowRewardedVideoSuccess(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onShowRewardedVideoSuccess", value);
        }

        @JavascriptInterface
        public void onShowRewardedVideoFail(String value) {
            Logger.i(WebController.this.TAG, "onShowRewardedVideoFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.RewardedVideo.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        Log.d((String)WebController.this.TAG, (String)("onRVShowFail(message:" + message + ")"));
                        WebController.this.mDSRewardedVideoListener.onRVShowFail(demandSourceId, toSend);
                    }
                });
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onShowRewardedVideoFail", value);
        }

        @JavascriptInterface
        public void onGetCachedFilesMapSuccess(String value) {
            Logger.i(WebController.this.TAG, "onGetCachedFilesMapSuccess(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGetCachedFilesMapSuccess", value);
        }

        @JavascriptInterface
        public void onGetCachedFilesMapFail(String value) {
            Logger.i(WebController.this.TAG, "onGetCachedFilesMapFail(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGetCachedFilesMapFail", value);
        }

        @JavascriptInterface
        public void onShowOfferWallSuccess(String value) {
            Logger.i(WebController.this.TAG, "onShowOfferWallSuccess(" + value + ")");
            WebController.this.mSavedState.adOpened(SSAEnums.ProductType.OfferWall.ordinal());
            final String placementId = SDKUtils.getValueFromJsonObject(value, "placementId");
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.OfferWall.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        WebController.this.mOnOfferWallListener.onOWShowSuccess(placementId);
                    }
                });
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onShowOfferWallSuccess", value);
        }

        @JavascriptInterface
        public void onShowOfferWallFail(String value) {
            Logger.i(WebController.this.TAG, "onShowOfferWallFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.OfferWall.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        WebController.this.mOnOfferWallListener.onOWShowFail(toSend);
                    }
                });
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onShowOfferWallFail", value);
        }

        @JavascriptInterface
        public void onInitInterstitialSuccess(String value) {
            Logger.i(WebController.this.TAG, "onInitInterstitialSuccess()");
            WebController.this.toastingErrMsg("onInitInterstitialSuccess", "true");
            SSAObj ssaObj = new SSAObj(value);
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                Logger.i(WebController.this.TAG, "onInitInterstitialSuccess failed with no demand source");
                return;
            }
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Interstitial.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)WebController.this.TAG, (String)"onInterstitialInitSuccess()");
                        WebController.this.mDSInterstitialListener.onAdProductInitSuccess(SSAEnums.ProductType.Interstitial, demandSourceId, null);
                    }
                });
            }
        }

        @JavascriptInterface
        public void onInitInterstitialFail(String value) {
            Logger.i(WebController.this.TAG, "onInitInterstitialFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                Logger.i(WebController.this.TAG, "onInitInterstitialSuccess failed with no demand source");
                return;
            }
            DemandSource demandSource = WebController.this.mDemandSourceManager.getDemandSourceById(SSAEnums.ProductType.Interstitial, demandSourceId);
            if (demandSource != null) {
                demandSource.setDemandSourceInitState(3);
            }
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Interstitial.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        Log.d((String)WebController.this.TAG, (String)("onInterstitialInitFail(message:" + toSend + ")"));
                        WebController.this.mDSInterstitialListener.onAdProductInitFailed(SSAEnums.ProductType.Interstitial, demandSourceId, toSend);
                    }
                });
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onInitInterstitialFail", value);
        }

        @JavascriptInterface
        public void adClicked(String value) {
            Logger.i(WebController.this.TAG, "adClicked(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String productType = ssaObj.getString("productType");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                return;
            }
            final SSAEnums.ProductType eProductType = WebController.this.getStringProductTypeAsEnum(productType);
            final DSAdProductListener listener = WebController.this.getAdProductListenerByProductType(eProductType);
            if (eProductType != null && listener != null) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        listener.onAdProductClick(eProductType, demandSourceId);
                    }
                });
            }
        }

        @JavascriptInterface
        public void onShowInterstitialSuccess(String value) {
            Logger.i(WebController.this.TAG, "onShowInterstitialSuccess(" + value + ")");
            WebController.this.responseBack(value, true, null, null);
            SSAObj ssaObj = new SSAObj(value);
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                Logger.i(WebController.this.TAG, "onShowInterstitialSuccess called with no demand");
                return;
            }
            WebController.this.mSavedState.adOpened(SSAEnums.ProductType.Interstitial.ordinal());
            WebController.this.mSavedState.setDisplayedDemandSourceId(demandSourceId);
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Interstitial.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        WebController.this.mDSInterstitialListener.onAdProductOpen(SSAEnums.ProductType.Interstitial, demandSourceId);
                        WebController.this.mDSInterstitialListener.onInterstitialShowSuccess(demandSourceId);
                    }
                });
                WebController.this.toastingErrMsg("onShowInterstitialSuccess", value);
            }
            this.setInterstitialAvailability(demandSourceId, false);
        }

        private void setInterstitialAvailability(String demandSourceId, boolean isAvailable) {
            DemandSource demandSource = WebController.this.mDemandSourceManager.getDemandSourceById(SSAEnums.ProductType.Interstitial, demandSourceId);
            if (demandSource != null) {
                demandSource.setAvailabilityState(isAvailable);
            }
        }

        @JavascriptInterface
        public void onInitOfferWallSuccess(String value) {
            WebController.this.toastingErrMsg("onInitOfferWallSuccess", "true");
            WebController.this.mSavedState.setOfferwallInitSuccess(true);
            if (WebController.this.mSavedState.reportInitOfferwall()) {
                WebController.this.mSavedState.setOfferwallReportInit(false);
                if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.OfferWall.toString())) {
                    WebController.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Log.d((String)WebController.this.TAG, (String)"onOfferWallInitSuccess()");
                            WebController.this.mOnOfferWallListener.onOfferwallInitSuccess();
                        }
                    });
                }
            }
        }

        @JavascriptInterface
        public void onInitOfferWallFail(String value) {
            Logger.i(WebController.this.TAG, "onInitOfferWallFail(" + value + ")");
            WebController.this.mSavedState.setOfferwallInitSuccess(false);
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            if (WebController.this.mSavedState.reportInitOfferwall()) {
                WebController.this.mSavedState.setOfferwallReportInit(false);
                if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.OfferWall.toString())) {
                    WebController.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            String toSend = message;
                            if (toSend == null) {
                                toSend = "We're sorry, some error occurred. we will investigate it";
                            }
                            Log.d((String)WebController.this.TAG, (String)("onOfferWallInitFail(message:" + toSend + ")"));
                            WebController.this.mOnOfferWallListener.onOfferwallInitFail(toSend);
                        }
                    });
                }
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onInitOfferWallFail", value);
        }

        @JavascriptInterface
        public void onLoadInterstitialSuccess(String value) {
            Logger.i(WebController.this.TAG, "onLoadInterstitialSuccess(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            this.setInterstitialAvailability(demandSourceId, true);
            WebController.this.responseBack(value, true, null, null);
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Interstitial.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        WebController.this.mDSInterstitialListener.onInterstitialLoadSuccess(demandSourceId);
                    }
                });
            }
            WebController.this.toastingErrMsg("onLoadInterstitialSuccess", "true");
        }

        @JavascriptInterface
        public void onLoadInterstitialFail(String value) {
            Logger.i(WebController.this.TAG, "onLoadInterstitialFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            WebController.this.responseBack(value, true, null, null);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                return;
            }
            this.setInterstitialAvailability(demandSourceId, false);
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Interstitial.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        WebController.this.mDSInterstitialListener.onInterstitialLoadFailed(demandSourceId, toSend);
                    }
                });
            }
            WebController.this.toastingErrMsg("onLoadInterstitialFail", "true");
        }

        @JavascriptInterface
        public void onShowInterstitialFail(String value) {
            Logger.i(WebController.this.TAG, "onShowInterstitialFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            WebController.this.responseBack(value, true, null, null);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                return;
            }
            this.setInterstitialAvailability(demandSourceId, false);
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Interstitial.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        WebController.this.mDSInterstitialListener.onInterstitialShowFailed(demandSourceId, toSend);
                    }
                });
            }
            WebController.this.toastingErrMsg("onShowInterstitialFail", value);
        }

        @JavascriptInterface
        public void onInitBannerSuccess(String value) {
            Logger.i(WebController.this.TAG, "onInitBannerSuccess()");
            WebController.this.toastingErrMsg("onInitBannerSuccess", "true");
            SSAObj ssaObj = new SSAObj(value);
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                Logger.i(WebController.this.TAG, "onInitBannerSuccess failed with no demand source");
                return;
            }
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Banner.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)WebController.this.TAG, (String)"onBannerInitSuccess()");
                        WebController.this.mDSBannerListener.onAdProductInitSuccess(SSAEnums.ProductType.Banner, demandSourceId, null);
                    }
                });
            }
        }

        @JavascriptInterface
        public void onInitBannerFail(String value) {
            Logger.i(WebController.this.TAG, "onInitBannerFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                Logger.i(WebController.this.TAG, "onInitBannerFail failed with no demand source");
                return;
            }
            DemandSource demandSource = WebController.this.mDemandSourceManager.getDemandSourceById(SSAEnums.ProductType.Banner, demandSourceId);
            if (demandSource != null) {
                demandSource.setDemandSourceInitState(3);
            }
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Banner.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        Log.d((String)WebController.this.TAG, (String)("onBannerInitFail(message:" + toSend + ")"));
                        WebController.this.mDSBannerListener.onAdProductInitFailed(SSAEnums.ProductType.Banner, demandSourceId, toSend);
                    }
                });
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onInitBannerFail", value);
        }

        @JavascriptInterface
        public void onLoadBannerSuccess(String value) {
            Logger.i(WebController.this.TAG, "onLoadBannerSuccess()");
            SSAObj ssaObj = new SSAObj(value);
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            WebController.this.responseBack(value, true, null, null);
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Banner.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)WebController.this.TAG, (String)"onBannerLoadSuccess()");
                        WebController.this.mDSBannerListener.onBannerLoadSuccess(demandSourceId);
                    }
                });
            }
        }

        @JavascriptInterface
        public void onLoadBannerFail(String value) {
            Logger.i(WebController.this.TAG, "onLoadBannerFail()");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            WebController.this.responseBack(value, true, null, null);
            if (TextUtils.isEmpty((CharSequence)demandSourceId)) {
                return;
            }
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.Banner.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)WebController.this.TAG, (String)"onLoadBannerFail()");
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        WebController.this.mDSBannerListener.onBannerLoadFail(demandSourceId, toSend);
                    }
                });
            }
        }

        @JavascriptInterface
        public void onGenericFunctionSuccess(String value) {
            Logger.i(WebController.this.TAG, "onGenericFunctionSuccess(" + value + ")");
            if (WebController.this.mOnGenericFunctionListener == null) {
                Logger.d(WebController.this.TAG, "genericFunctionListener was not found");
                return;
            }
            WebController.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WebController.this.mOnGenericFunctionListener.onGFSuccess();
                }
            });
            WebController.this.responseBack(value, true, null, null);
        }

        @JavascriptInterface
        public void onGenericFunctionFail(String value) {
            Logger.i(WebController.this.TAG, "onGenericFunctionFail(" + value + ")");
            if (WebController.this.mOnGenericFunctionListener == null) {
                Logger.d(WebController.this.TAG, "genericFunctionListener was not found");
                return;
            }
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            WebController.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WebController.this.mOnGenericFunctionListener.onGFFail(message);
                }
            });
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGenericFunctionFail", value);
        }

        @JavascriptInterface
        public void openUrl(String value) {
            Logger.i(WebController.this.TAG, "openUrl(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String url = ssaObj.getString("url");
            String method = ssaObj.getString("method");
            Context context = WebController.this.getCurrentActivityContext();
            try {
                if (method.equalsIgnoreCase("external_browser")) {
                    UrlHandler.openUrl(context, url);
                } else if (method.equalsIgnoreCase("webview")) {
                    Intent intent = new Intent(context, OpenUrlActivity.class);
                    intent.putExtra(EXTERNAL_URL, url);
                    intent.putExtra(SECONDARY_WEB_VIEW, true);
                    intent.putExtra("immersive", WebController.this.mIsImmersive);
                    context.startActivity(intent);
                } else if (method.equalsIgnoreCase("store")) {
                    Intent intent = new Intent(context, OpenUrlActivity.class);
                    intent.putExtra(EXTERNAL_URL, url);
                    intent.putExtra(IS_STORE, true);
                    intent.putExtra(SECONDARY_WEB_VIEW, true);
                    context.startActivity(intent);
                }
            }
            catch (Exception ex) {
                WebController.this.responseBack(value, false, ex.getMessage(), null);
                ex.printStackTrace();
            }
        }

        @JavascriptInterface
        public void setForceClose(String value) {
            Logger.i(WebController.this.TAG, "setForceClose(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String width = ssaObj.getString("width");
            String hight = ssaObj.getString("height");
            WebController.this.mHiddenForceCloseWidth = Integer.parseInt(width);
            WebController.this.mHiddenForceCloseHeight = Integer.parseInt(hight);
            WebController.this.mHiddenForceCloseLocation = ssaObj.getString("position");
        }

        @JavascriptInterface
        public void setBackButtonState(String value) {
            Logger.i(WebController.this.TAG, "setBackButtonState(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            String state = ssaObj.getString("state");
            IronSourceSharedPrefHelper.getSupersonicPrefHelper().setBackButtonState(state);
        }

        @JavascriptInterface
        public void setStoreSearchKeys(String value) {
            Logger.i(WebController.this.TAG, "setStoreSearchKeys(" + value + ")");
            IronSourceSharedPrefHelper.getSupersonicPrefHelper().setSearchKeys(value);
        }

        @JavascriptInterface
        public void setWebviewBackgroundColor(String value) {
            Logger.i(WebController.this.TAG, "setWebviewBackgroundColor(" + value + ")");
            WebController.this.setWebviewBackground(value);
        }

        @JavascriptInterface
        public void onOfferWallGeneric(String value) {
            Logger.i(WebController.this.TAG, "onOfferWallGeneric(" + value + ")");
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.OfferWall.toString())) {
                WebController.this.mOnOfferWallListener.onOWGeneric("", "");
            }
        }

        @JavascriptInterface
        public void setUserData(String value) {
            Logger.i(WebController.this.TAG, "setUserData(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            if (!ssaObj.containsKey("key")) {
                WebController.this.responseBack(value, false, "key does not exist", null);
                return;
            }
            if (!ssaObj.containsKey("value")) {
                WebController.this.responseBack(value, false, "value does not exist", null);
                return;
            }
            String mKey = ssaObj.getString("key");
            String mValue = ssaObj.getString("value");
            boolean result = IronSourceSharedPrefHelper.getSupersonicPrefHelper().setUserData(mKey, mValue);
            if (result) {
                String successFunToCall = WebController.this.extractSuccessFunctionToCall(value);
                String params = WebController.this.parseToJson(mKey, mValue, null, null, null, null, null, null, null, false);
                String script = WebController.this.generateJSToInject(successFunToCall, params);
                WebController.this.injectJavascript(script);
            } else {
                WebController.this.responseBack(value, false, "SetUserData failed writing to shared preferences", null);
            }
        }

        @JavascriptInterface
        public void getUserData(String value) {
            Logger.i(WebController.this.TAG, "getUserData(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            if (!ssaObj.containsKey("key")) {
                WebController.this.responseBack(value, false, "key does not exist", null);
                return;
            }
            String failFunToCall = WebController.this.extractSuccessFunctionToCall(value);
            String mKey = ssaObj.getString("key");
            String mValue = IronSourceSharedPrefHelper.getSupersonicPrefHelper().getUserData(mKey);
            String params = WebController.this.parseToJson(mKey, mValue, null, null, null, null, null, null, null, false);
            String script = WebController.this.generateJSToInject(failFunToCall, params);
            WebController.this.injectJavascript(script);
        }

        @JavascriptInterface
        public void onGetUserCreditsFail(String value) {
            Logger.i(WebController.this.TAG, "onGetUserCreditsFail(" + value + ")");
            SSAObj ssaObj = new SSAObj(value);
            final String message = ssaObj.getString("errMsg");
            if (WebController.this.shouldNotifyDeveloper(SSAEnums.ProductType.OfferWall.toString())) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String toSend = message;
                        if (toSend == null) {
                            toSend = "We're sorry, some error occurred. we will investigate it";
                        }
                        WebController.this.mOnOfferWallListener.onGetOWCreditsFailed(toSend);
                    }
                });
            }
            WebController.this.responseBack(value, true, null, null);
            WebController.this.toastingErrMsg("onGetUserCreditsFail", value);
        }

        @JavascriptInterface
        public void onAdWindowsClosed(String value) {
            Logger.i(WebController.this.TAG, "onAdWindowsClosed(" + value + ")");
            WebController.this.mSavedState.adClosed();
            WebController.this.mSavedState.setDisplayedDemandSourceId(null);
            SSAObj ssaObj = new SSAObj(value);
            String product = ssaObj.getString("productType");
            final String demandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
            final SSAEnums.ProductType type = WebController.this.getStringProductTypeAsEnum(product);
            Log.d((String)WebController.this.PUB_TAG, (String)("onAdClosed() with type " + (Object)((Object)type)));
            if (WebController.this.shouldNotifyDeveloper(product)) {
                WebController.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (type == SSAEnums.ProductType.RewardedVideo || type == SSAEnums.ProductType.Interstitial) {
                            DSAdProductListener listener = WebController.this.getAdProductListenerByProductType(type);
                            if (listener != null) {
                                listener.onAdProductClose(type, demandSourceId);
                            }
                        } else if (type == SSAEnums.ProductType.OfferWall) {
                            WebController.this.mOnOfferWallListener.onOWAdClosed();
                        }
                    }
                });
            }
        }

        @JavascriptInterface
        public void onVideoStatusChanged(String value) {
            Log.d((String)WebController.this.TAG, (String)("onVideoStatusChanged(" + value + ")"));
            SSAObj ssaObj = new SSAObj(value);
            String product = ssaObj.getString("productType");
            if (WebController.this.mVideoEventsListener != null && !TextUtils.isEmpty((CharSequence)product)) {
                String status = ssaObj.getString("status");
                if ("started".equalsIgnoreCase(status)) {
                    WebController.this.mVideoEventsListener.onVideoStarted();
                } else if ("paused".equalsIgnoreCase(status)) {
                    WebController.this.mVideoEventsListener.onVideoPaused();
                } else if ("playing".equalsIgnoreCase(status)) {
                    WebController.this.mVideoEventsListener.onVideoResumed();
                } else if ("ended".equalsIgnoreCase(status)) {
                    WebController.this.mVideoEventsListener.onVideoEnded();
                } else if ("stopped".equalsIgnoreCase(status)) {
                    WebController.this.mVideoEventsListener.onVideoStopped();
                } else {
                    Logger.i(WebController.this.TAG, "onVideoStatusChanged: unknown status: " + status);
                }
            }
        }

        @JavascriptInterface
        public void postAdEventNotification(String value) {
            try {
                Logger.i(WebController.this.TAG, "postAdEventNotification(" + value + ")");
                SSAObj ssaObj = new SSAObj(value);
                final String eventName = ssaObj.getString("eventName");
                if (TextUtils.isEmpty((CharSequence)eventName)) {
                    WebController.this.responseBack(value, false, "eventName does not exist", null);
                    return;
                }
                String demandSourceName = ssaObj.getString("dsName");
                String tempDemandSourceId = SDKUtils.fetchDemandSourceId(ssaObj);
                final String demandSourceId = !TextUtils.isEmpty((CharSequence)tempDemandSourceId) ? tempDemandSourceId : demandSourceName;
                final JSONObject extData = (JSONObject)ssaObj.get("extData");
                String productType = ssaObj.getString("productType");
                final SSAEnums.ProductType type = WebController.this.getStringProductTypeAsEnum(productType);
                if (WebController.this.shouldNotifyDeveloper(productType)) {
                    String funToCall = WebController.this.extractSuccessFunctionToCall(value);
                    if (!TextUtils.isEmpty((CharSequence)funToCall)) {
                        String params = WebController.this.parseToJson("productType", productType, "eventName", eventName, "demandSourceName", demandSourceName, "demandSourceId", demandSourceId, null, false);
                        String script = WebController.this.generateJSToInject(funToCall, params, "postAdEventNotificationSuccess", "postAdEventNotificationFail");
                        WebController.this.injectJavascript(script);
                    }
                    WebController.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (type == SSAEnums.ProductType.Interstitial || type == SSAEnums.ProductType.RewardedVideo) {
                                DSAdProductListener listener = WebController.this.getAdProductListenerByProductType(type);
                                if (listener != null) {
                                    listener.onAdProductEventNotificationReceived(type, demandSourceId, eventName, extData);
                                }
                            } else if (type == SSAEnums.ProductType.OfferWall) {
                                WebController.this.mOnOfferWallListener.onOfferwallEventNotificationReceived(eventName, extData);
                            }
                        }
                    });
                } else {
                    WebController.this.responseBack(value, false, "productType does not exist", null);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        void sendUnauthorizedError(String errorMessage) {
            String script = WebController.this.generateJSToInject("unauthorizedMessage", errorMessage, null, null);
            WebController.this.injectJavascript(script);
        }

        @JavascriptInterface
        public void bannerViewAPI(String value) {
            try {
                WebController.this.mBannerJsAdapter.sendMessageToISNAdView(value);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Logger.e(WebController.this.TAG, "bannerViewAPI failed with exception " + e2.getMessage());
            }
        }

        @JavascriptInterface
        public void omidAPI(final String value) {
            WebController.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.i(WebController.this.TAG, "omidAPI(" + value + ")");
                        SSAObj ssaObj = new SSAObj(value);
                        WebController.this.mOmidJsAdapter.call(ssaObj.toString(), new JSCallbackTask(), WebController.this.getWebview());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        Logger.i(WebController.this.TAG, "omidAPI failed with exception " + e2.getMessage());
                    }
                }
            });
        }

        @JavascriptInterface
        public void permissionsAPI(String value) {
            try {
                Logger.i(WebController.this.TAG, "permissionsAPI(" + value + ")");
                SSAObj ssaObj = new SSAObj(value);
                WebController.this.mPermissionsJsAdapter.call(ssaObj.toString(), new JSCallbackTask());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Logger.i(WebController.this.TAG, "permissionsAPI failed with exception " + e2.getMessage());
            }
        }

        @JavascriptInterface
        public void deviceDataAPI(String value) {
            try {
                Logger.i(WebController.this.TAG, "deviceDataAPI(" + value + ")");
                SSAObj ssaObj = new SSAObj(value);
                WebController.this.mDeviceDataJsAdapter.call(ssaObj.toString(), new JSCallbackTask());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Logger.i(WebController.this.TAG, "deviceDataAPI failed with exception " + e2.getMessage());
            }
        }

        @JavascriptInterface
        public void getDeviceVolume(String value) {
            Logger.i(WebController.this.TAG, "getDeviceVolume(" + value + ")");
            try {
                float currVolume = DeviceProperties.getInstance(WebController.this.getCurrentActivityContext()).getDeviceVolume(WebController.this.getCurrentActivityContext());
                SSAObj ssaObj = new SSAObj(value);
                ssaObj.put("deviceVolume", String.valueOf(currVolume));
                WebController.this.responseBack(ssaObj.toString(), true, null, null);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        class JSCallbackTask {
            JSCallbackTask() {
            }

            void sendMessage(boolean isSuccess, String callbackFunction, String messageData) {
                SSAObj res = new SSAObj();
                res.put(isSuccess ? JSON_KEY_SUCCESS : JSON_KEY_FAIL, callbackFunction);
                res.put("data", messageData);
                WebController.this.responseBack(res.toString(), isSuccess, null, null);
            }

            void sendMessage(boolean isSuccess, String callbackFunction, SSAObj messageData) {
                messageData.put(isSuccess ? JSON_KEY_SUCCESS : JSON_KEY_FAIL, callbackFunction);
                WebController.this.responseBack(messageData.toString(), isSuccess, null, null);
            }

            void sendMessage(boolean isSuccess, String callbackFunction, JSONObject messageData) {
                String errorMessage = null;
                String errorCode = null;
                try {
                    messageData.put(isSuccess ? JSON_KEY_SUCCESS : JSON_KEY_FAIL, (Object)callbackFunction);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                    errorMessage = e2.getMessage();
                    return;
                }
                WebController.this.responseBack(messageData.toString(), isSuccess, errorMessage, errorCode);
            }
        }
    }

    private class FrameBustWebViewClient
    extends WebViewClient {
        private FrameBustWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Context ctx = WebController.this.getCurrentActivityContext();
            Intent intent = new Intent(ctx, OpenUrlActivity.class);
            intent.putExtra(EXTERNAL_URL, url);
            intent.putExtra(SECONDARY_WEB_VIEW, false);
            ctx.startActivity(intent);
            return true;
        }
    }

    private class ChromeClient
    extends WebChromeClient {
        private ChromeClient() {
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            WebView childView = new WebView(view.getContext());
            childView.setWebChromeClient((WebChromeClient)this);
            childView.setWebViewClient((WebViewClient)new FrameBustWebViewClient());
            WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
            transport.setWebView(childView);
            resultMsg.sendToTarget();
            Logger.i("onCreateWindow", "onCreateWindow");
            return true;
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            Logger.i("MyApplication", consoleMessage.message() + " -- From line " + consoleMessage.lineNumber() + " of " + consoleMessage.sourceId());
            return true;
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            Logger.i("Test", "onShowCustomView");
            WebController.this.setVisibility(8);
            if (WebController.this.mCustomView != null) {
                Logger.i("Test", "mCustomView != null");
                callback.onCustomViewHidden();
                return;
            }
            Logger.i("Test", "mCustomView == null");
            WebController.this.mCustomViewContainer.addView(view);
            WebController.this.mCustomView = view;
            WebController.this.mCustomViewCallback = callback;
            WebController.this.mCustomViewContainer.setVisibility(0);
        }

        public View getVideoLoadingProgressView() {
            FrameLayout frameLayout = new FrameLayout(WebController.this.getCurrentActivityContext());
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            return frameLayout;
        }

        public void onHideCustomView() {
            Logger.i("Test", "onHideCustomView");
            if (WebController.this.mCustomView == null) {
                return;
            }
            WebController.this.mCustomView.setVisibility(8);
            WebController.this.mCustomViewContainer.removeView(WebController.this.mCustomView);
            WebController.this.mCustomView = null;
            WebController.this.mCustomViewContainer.setVisibility(8);
            WebController.this.mCustomViewCallback.onCustomViewHidden();
            WebController.this.setVisibility(0);
        }
    }

    private class ViewClient
    extends WebViewClient {
        private ViewClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Logger.i("onPageStarted", url);
            super.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            Logger.i("onPageFinished", url);
            if (url.contains("adUnit") || url.contains("index.html")) {
                WebController.this.pageFinished();
            }
            super.onPageFinished(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Logger.i("onReceivedError", failingUrl + " " + description);
            if (failingUrl.contains("mobileController.html") && WebController.this.mControllerListener != null) {
                WebController.this.mControllerListener.handleControllerStageFailed("WebView failed to load mobileController.html - " + description + " (errorCode: " + errorCode + ")");
            }
            super.onReceivedError(view, errorCode, description, failingUrl);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Logger.i("shouldOverrideUrlLoading", url);
            try {
                if (WebController.this.handleSearchKeysURLs(url)) {
                    WebController.this.interceptedUrlToStore();
                    return true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            Logger.i("shouldInterceptRequest", url);
            boolean mraidCall = false;
            try {
                URL mUrl = new URL(url);
                String file = mUrl.getFile();
                if (file.contains("mraid.js")) {
                    mraidCall = true;
                }
            }
            catch (MalformedURLException mUrl) {
                // empty catch block
            }
            if (mraidCall) {
                String filePath = "file://" + WebController.this.mCacheDirectory + File.separator + "mraid.js";
                File mraidFile = new File(filePath);
                try {
                    FileInputStream fis = new FileInputStream(mraidFile);
                    return new WebResourceResponse("text/javascript", "UTF-8", ((Object)((Object)this)).getClass().getResourceAsStream(filePath));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return super.shouldInterceptRequest(view, url);
        }
    }

    private class SupersonicWebViewTouchListener
    implements View.OnTouchListener {
        private SupersonicWebViewTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 1) {
                float xTouch = event.getX();
                float yTouch = event.getY();
                Logger.i(WebController.this.TAG, "X:" + (int)xTouch + " Y:" + (int)yTouch);
                int width = DeviceStatus.getDeviceWidth();
                int height = DeviceStatus.getDeviceHeight();
                Logger.i(WebController.this.TAG, "Width:" + width + " Height:" + height);
                int boundsTouchAreaX = SDKUtils.dpToPx(WebController.this.mHiddenForceCloseWidth);
                int boundsTouchAreaY = SDKUtils.dpToPx(WebController.this.mHiddenForceCloseHeight);
                int actualTouchX = 0;
                int actualTouchY = 0;
                if ("top-right".equalsIgnoreCase(WebController.this.mHiddenForceCloseLocation)) {
                    actualTouchX = width - (int)xTouch;
                    actualTouchY = (int)yTouch;
                } else if ("top-left".equalsIgnoreCase(WebController.this.mHiddenForceCloseLocation)) {
                    actualTouchX = (int)xTouch;
                    actualTouchY = (int)yTouch;
                } else if ("bottom-right".equalsIgnoreCase(WebController.this.mHiddenForceCloseLocation)) {
                    actualTouchX = width - (int)xTouch;
                    actualTouchY = height - (int)yTouch;
                } else if ("bottom-left".equalsIgnoreCase(WebController.this.mHiddenForceCloseLocation)) {
                    actualTouchX = (int)xTouch;
                    actualTouchY = height - (int)yTouch;
                }
                if (actualTouchX <= boundsTouchAreaX && actualTouchY <= boundsTouchAreaY) {
                    WebController.this.isRemoveCloseEventHandler = false;
                    if (WebController.this.mCloseEventTimer != null) {
                        WebController.this.mCloseEventTimer.cancel();
                    }
                    WebController.this.mCloseEventTimer = new CountDownTimer(2000L, 500L){

                        public void onTick(long millisUntilFinished) {
                            Logger.i(WebController.this.TAG, "Close Event Timer Tick " + millisUntilFinished);
                        }

                        public void onFinish() {
                            Logger.i(WebController.this.TAG, "Close Event Timer Finish");
                            if (WebController.this.isRemoveCloseEventHandler) {
                                WebController.this.isRemoveCloseEventHandler = false;
                            } else {
                                WebController.this.engageEnd("forceClose");
                            }
                        }
                    }.start();
                }
            }
            return false;
        }
    }
}

