/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.data;

import com.ironsource.sdk.listeners.OnAdProductListener;
import java.util.HashMap;
import java.util.Map;

public class DemandSource {
    public static final int INIT_NOT_STARTED = 0;
    public static final int INIT_PENDING = 1;
    public static final int INIT_SUCCEEDED = 2;
    public static final int INIT_FAILED = 3;
    public static final int MEDIATION_STATE_NOT_SET = -1;
    private String mName;
    private String mId;
    private int mMediationState = -1;
    private Map<String, String> mExtraParams;
    private int mInitState;
    private boolean mAvailabilityState;
    private OnAdProductListener mListener;

    public DemandSource(String id, String demandSourceName, Map<String, String> extraParams, OnAdProductListener listener) {
        this.mId = id;
        this.mName = demandSourceName;
        this.mExtraParams = extraParams;
        this.mListener = listener;
        this.mInitState = 0;
        this.mAvailabilityState = false;
    }

    public String getId() {
        return this.mId;
    }

    public String getDemandSourceName() {
        return this.mName;
    }

    public int getDemandSourceInitState() {
        return this.mInitState;
    }

    public boolean getAvailabilityState() {
        return this.mAvailabilityState;
    }

    public void setAvailabilityState(boolean isAvailable) {
        this.mAvailabilityState = isAvailable;
    }

    public Map<String, String> getExtraParams() {
        return this.mExtraParams;
    }

    public synchronized void setDemandSourceInitState(int initState) {
        this.mInitState = initState;
    }

    public OnAdProductListener getListener() {
        return this.mListener;
    }

    public int getMediationState() {
        return this.mMediationState;
    }

    public void setMediationState(int state) {
        this.mMediationState = state;
    }

    public boolean isMediationState(int state) {
        return this.mMediationState == state;
    }

    public Map<String, String> convertToMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("demandSourceId", this.mId);
        map.put("demandSourceName", this.mName);
        if (this.mExtraParams != null) {
            map.putAll(this.mExtraParams);
        }
        return map;
    }

    public boolean isRewarded() {
        if (this.mExtraParams != null && this.mExtraParams.containsKey("rewarded")) {
            return Boolean.parseBoolean(this.mExtraParams.get("rewarded"));
        }
        return false;
    }
}

