/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoManagerListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class RewardedVideoSmash
extends AbstractSmash
implements RewardedVideoSmashListener,
RewardedVideoSmashApi {
    private JSONObject mRewardedVideoAdapterConfigs;
    private RewardedVideoManagerListener mRewardedVideoManagerListener;
    private AtomicBoolean mShouldSendLoadEvents;
    private long mLoadStartTime;
    private String mRequestUrl;
    private int mTimeout;
    public int mSessionDepth;
    private final String REQUEST_URL_KEY = "requestUrl";

    RewardedVideoSmash(ProviderSettings adapterConfigs, int timeout) {
        super(adapterConfigs);
        this.mRewardedVideoAdapterConfigs = adapterConfigs.getRewardedVideoSettings();
        this.mMaxAdsPerIteration = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerIteration", 99);
        this.mMaxAdsPerSession = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerSession", 99);
        this.mMaxAdsPerDay = this.mRewardedVideoAdapterConfigs.optInt("maxAdsPerDay", 99);
        this.mRequestUrl = this.mRewardedVideoAdapterConfigs.optString("requestUrl");
        this.mShouldSendLoadEvents = new AtomicBoolean(false);
        this.mTimeout = timeout;
    }

    @Override
    void completeIteration() {
        this.mIterationShowCounter = 0;
        this.setMediationState(this.isRewardedVideoAvailable() ? AbstractSmash.MEDIATION_STATE.AVAILABLE : AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
    }

    @Override
    void startInitTimer() {
        try {
            this.stopInitTimer();
            this.mInitTimer = new Timer();
            this.mInitTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RewardedVideoSmash rewardedVideoSmash = RewardedVideoSmash.this;
                    synchronized (rewardedVideoSmash) {
                        this.cancel();
                        if (RewardedVideoSmash.this.mRewardedVideoManagerListener != null) {
                            String errorMessage = "Timeout for " + RewardedVideoSmash.this.getInstanceName();
                            RewardedVideoSmash.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, errorMessage, 0);
                            RewardedVideoSmash.this.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
                            long elapsedTime = new Date().getTime() - RewardedVideoSmash.this.mLoadStartTime;
                            if (RewardedVideoSmash.this.mShouldSendLoadEvents.compareAndSet(true, false)) {
                                RewardedVideoSmash.this.sendProviderEvent(1200, new Object[][]{{"errorCode", 1025}, {"duration", elapsedTime}});
                                RewardedVideoSmash.this.sendProviderEvent(1212, new Object[][]{{"errorCode", 1025}, {"reason", errorMessage}, {"duration", elapsedTime}});
                            } else {
                                RewardedVideoSmash.this.sendProviderEvent(1208, new Object[][]{{"errorCode", 1025}, {"duration", elapsedTime}});
                            }
                            RewardedVideoSmash.this.mRewardedVideoManagerListener.onRewardedVideoAvailabilityChanged(false, RewardedVideoSmash.this);
                        }
                    }
                }
            }, this.mTimeout * 1000);
        }
        catch (Exception e2) {
            this.logException("startInitTimer", e2.getLocalizedMessage());
        }
    }

    @Override
    void startLoadTimer() {
    }

    @Override
    protected String getAdUnitString() {
        return "rewardedvideo";
    }

    @Override
    public void initRewardedVideo(String appKey, String userId) {
        this.startInitTimer();
        if (this.mAdapter != null) {
            this.mShouldSendLoadEvents.set(true);
            this.mLoadStartTime = new Date().getTime();
            this.mAdapter.addRewardedVideoListener(this);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":initRewardedVideo()", 1);
            this.mAdapter.initRewardedVideo(appKey, userId, this.mRewardedVideoAdapterConfigs, this);
        }
    }

    @Override
    public void fetchRewardedVideo() {
        if (this.mAdapter != null) {
            if (this.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY && this.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION) {
                this.mShouldSendLoadEvents.set(true);
                this.mLoadStartTime = new Date().getTime();
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":fetchRewardedVideoForAutomaticLoad()", 1);
            this.mAdapter.fetchRewardedVideoForAutomaticLoad(this.mRewardedVideoAdapterConfigs, this);
        }
    }

    @Override
    public void showRewardedVideo() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":showRewardedVideo()", 1);
            this.preShow();
            this.mAdapter.showRewardedVideo(this.mRewardedVideoAdapterConfigs, this);
        }
    }

    @Override
    public boolean isRewardedVideoAvailable() {
        if (this.mAdapter != null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getInstanceName() + ":isRewardedVideoAvailable()", 1);
            return this.mAdapter.isRewardedVideoAvailable(this.mRewardedVideoAdapterConfigs);
        }
        return false;
    }

    @Override
    public void setRewardedVideoManagerListener(RewardedVideoManagerListener listener) {
        this.mRewardedVideoManagerListener = listener;
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdShowFailed(error, this);
        }
    }

    @Override
    public void onRewardedVideoInitSuccess() {
    }

    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
    }

    @Override
    public void onRewardedVideoAdOpened() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdOpened(this);
        }
    }

    @Override
    public void onRewardedVideoAdClosed() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdClosed(this);
        }
        this.fetchRewardedVideo();
    }

    @Override
    public synchronized void onRewardedVideoAvailabilityChanged(boolean available) {
        this.stopInitTimer();
        if (this.mShouldSendLoadEvents.compareAndSet(true, false)) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.sendProviderEvent(available ? 1002 : 1200, new Object[][]{{"duration", elapsedTime}});
        } else {
            this.sendProviderEvent(available ? 1207 : 1208);
        }
        if (this.isMediationAvailable() && (available && this.mMediationState != AbstractSmash.MEDIATION_STATE.AVAILABLE || !available && this.mMediationState != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE)) {
            this.setMediationState(available ? AbstractSmash.MEDIATION_STATE.AVAILABLE : AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
            if (this.mRewardedVideoManagerListener != null) {
                this.mRewardedVideoManagerListener.onRewardedVideoAvailabilityChanged(available, this);
            }
        }
    }

    @Override
    public void onRewardedVideoAdStarted() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdStarted(this);
        }
    }

    @Override
    public void onRewardedVideoAdEnded() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdEnded(this);
        }
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdRewarded(this);
        }
    }

    @Override
    public void onRewardedVideoAdClicked() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdClicked(this);
        }
    }

    @Override
    public void onRewardedVideoAdVisible() {
        if (this.mRewardedVideoManagerListener != null) {
            this.mRewardedVideoManagerListener.onRewardedVideoAdVisible(this);
        }
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.sendProviderEvent(1212, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", elapsedTime}});
    }

    private void sendProviderEvent(int eventId) {
        this.sendProviderEvent(eventId, null);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(this);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "RewardedVideoSmash logProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        RewardedVideoEventsManager.getInstance().log(event);
    }

    String getRequestUrl() {
        return this.mRequestUrl;
    }
}

