/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.RvAuctionTriggerCallback;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import java.util.Timer;
import java.util.TimerTask;

public class RvAuctionTrigger {
    private AuctionSettings mAuctionSettings;
    private RvAuctionTriggerCallback mListener;
    private Timer mTimer;

    public RvAuctionTrigger(AuctionSettings auctionSettings, RvAuctionTriggerCallback listener) {
        this.mAuctionSettings = auctionSettings;
        this.mListener = listener;
        this.mTimer = null;
    }

    public synchronized void showStart() {
        if (this.mAuctionSettings.getIsAuctionOnShowStart()) {
            this.stopTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RvAuctionTrigger.this.mListener.onAuctionTriggered();
                }
            }, this.mAuctionSettings.getTimeToWaitBeforeAuctionMs());
        }
    }

    public synchronized void showEnd() {
        if (!this.mAuctionSettings.getIsAuctionOnShowStart()) {
            this.stopTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RvAuctionTrigger.this.mListener.onAuctionTriggered();
                }
            }, this.mAuctionSettings.getTimeToWaitBeforeAuctionMs());
        }
    }

    public synchronized void showError() {
        this.stopTimer();
        this.mListener.onAuctionTriggered();
    }

    public synchronized void loadError() {
        this.stopTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RvAuctionTrigger.this.mListener.onAuctionTriggered();
            }
        }, this.mAuctionSettings.getAuctionRetryInterval());
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }
}

