/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.DemandOnlyRvSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.RVDemandOnlyListenerWrapper;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.sdk.DemandOnlyRvManagerListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

class DemandOnlyRvManager
implements DemandOnlyRvManagerListener {
    private ConcurrentHashMap<String, DemandOnlyRvSmash> mSmashes;
    private String mAppKey;

    DemandOnlyRvManager(Activity activity, List<ProviderSettings> providersList, RewardedVideoConfigurations configs, String appKey, String userId) {
        this.mAppKey = appKey;
        this.mSmashes = new ConcurrentHashMap();
        for (ProviderSettings provider : providersList) {
            if (provider.getProviderTypeForReflection().equalsIgnoreCase("SupersonicAds") || provider.getProviderTypeForReflection().equalsIgnoreCase("IronSource")) {
                AbstractAdapter adapter = this.loadAdapter(provider.getProviderInstanceName());
                if (adapter == null) continue;
                DemandOnlyRvSmash smash = new DemandOnlyRvSmash(activity, appKey, userId, provider, this, configs.getRewardedVideoAdaptersSmartLoadTimeout(), adapter);
                this.mSmashes.put(provider.getSubProviderId(), smash);
                continue;
            }
            this.logInternal("cannot load " + provider.getProviderTypeForReflection());
        }
    }

    public synchronized void onResume(Activity activity) {
        if (activity != null) {
            for (DemandOnlyRvSmash smash : this.mSmashes.values()) {
                smash.onResume(activity);
            }
        }
    }

    public synchronized void onPause(Activity activity) {
        if (activity != null) {
            for (DemandOnlyRvSmash smash : this.mSmashes.values()) {
                smash.onPause(activity);
            }
        }
    }

    public synchronized void setConsent(boolean consent) {
        for (DemandOnlyRvSmash smash : this.mSmashes.values()) {
            smash.setConsent(consent);
        }
    }

    public synchronized void loadRewardedVideo(String instanceId) {
        try {
            if (!this.mSmashes.containsKey(instanceId)) {
                this.sendMediationEvent(1500, instanceId);
                IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Rewarded Video");
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, error);
                return;
            }
            DemandOnlyRvSmash smash = this.mSmashes.get(instanceId);
            this.sendProviderEvent(1001, smash);
            smash.loadRewardedVideo();
        }
        catch (Exception e2) {
            this.logInternal("loadRewardedVideo exception " + e2.getMessage());
            IronSourceError error = ErrorBuilder.buildLoadFailedError("loadRewardedVideo exception");
            RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, error);
        }
    }

    public synchronized void showRewardedVideo(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(1500, instanceId);
            IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Rewarded Video");
            RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdShowFailed(instanceId, error);
            return;
        }
        DemandOnlyRvSmash smash = this.mSmashes.get(instanceId);
        this.sendProviderEvent(1201, smash);
        smash.showRewardedVideo();
    }

    public synchronized boolean isRewardedVideoAvailable(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(1500, instanceId);
            return false;
        }
        DemandOnlyRvSmash smash = this.mSmashes.get(instanceId);
        if (smash.isRewardedVideoAvailable()) {
            this.sendProviderEvent(1210, smash);
            return true;
        }
        this.sendProviderEvent(1211, smash);
        return false;
    }

    @Override
    public void onRewardedVideoLoadSuccess(DemandOnlyRvSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onRewardedVideoLoadSuccess");
        this.sendProviderEvent(1002, smash, new Object[][]{{"duration", elapsedTime}});
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoLoadSuccess(smash.getSubProviderId());
    }

    @Override
    public void onRewardedVideoAdLoadFailed(IronSourceError error, DemandOnlyRvSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onRewardedVideoAdLoadFailed error=" + error);
        String errorReason = error.getErrorMessage().substring(0, Math.min(error.getErrorMessage().length(), 39));
        this.sendProviderEvent(1200, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", errorReason}, {"duration", elapsedTime}});
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onRewardedVideoAdOpened(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdOpened");
        this.sendProviderEvent(1005, smash);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdOpened(smash.getSubProviderId());
    }

    @Override
    public void onRewardedVideoAdClosed(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdClosed");
        this.sendProviderEvent(1203, smash);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdClosed(smash.getSubProviderId());
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdShowFailed error=" + error);
        this.sendProviderEvent(1202, smash, new Object[][]{{"errorCode", error.getErrorCode()}});
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdShowFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onRewardedVideoAdClicked(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdClicked");
        this.sendProviderEvent(1006, smash);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdClicked(smash.getSubProviderId());
    }

    @Override
    public void onRewardedVideoAdVisible(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdVisible");
        this.sendProviderEvent(1206, smash);
    }

    @Override
    public void onRewardedVideoAdRewarded(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdRewarded");
        Map<String, Object> data = smash.getProviderEventData();
        String transId = Long.toString(new Date().getTime()) + this.mAppKey + smash.getInstanceName();
        data.put("transId", IronSourceUtils.getTransId(transId));
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
            data.put("dynamicUserId", IronSourceObject.getInstance().getDynamicUserId());
        }
        if (IronSourceObject.getInstance().getRvServerParams() != null) {
            for (String key : IronSourceObject.getInstance().getRvServerParams().keySet()) {
                data.put("custom_" + key, IronSourceObject.getInstance().getRvServerParams().get(key));
            }
        }
        EventData event = new EventData(1010, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdRewarded(smash.getSubProviderId());
    }

    private void sendProviderEvent(int eventId, DemandOnlyRvSmash smash) {
        this.sendProviderEvent(eventId, smash, null);
    }

    private void sendProviderEvent(int eventId, DemandOnlyRvSmash smash, Object[][] keyVals) {
        Map<String, Object> data = smash.getProviderEventData();
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private void sendMediationEvent(int eventId, String instanceId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("isDemandOnly", 1);
        data.put("spId", instanceId != null ? instanceId : "");
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private AbstractAdapter loadAdapter(String name) {
        try {
            Class<?> mAdapterClass = Class.forName("com.ironsource.adapters.ironsource.IronSourceAdapter");
            Method startAdapterMethod = mAdapterClass.getMethod("startAdapter", String.class);
            return (AbstractAdapter)startAdapterMethod.invoke(mAdapterClass, name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "DemandOnlyRvManager " + text, 0);
    }

    private void logSmashCallback(DemandOnlyRvSmash smash, String line) {
        String text = "DemandOnlyRvManager " + smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

