/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceAdInstanceBuilder;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceAdapter
extends AbstractAdapter {
    private static final String VERSION = "6.9.1";
    private static final int IS_LOAD_EXCEPTION = 1000;
    private static final int IS_SHOW_EXCEPTION = 1001;
    private static final int RV_LOAD_EXCEPTION = 1002;
    private static final int RV_SHOW_EXCEPTION = 1003;
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private final String APPLICATION_USER_GENDER = "applicationUserGender";
    private final String APPLICATION_USER_AGE_GROUP = "applicationUserAgeGroup";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    private final String CUSTOM_SEGMENT = "custom_Segment";
    private final String ADM_KEY = "adm";
    private final String DEMAND_SOURCE_NAME = "demandSourceName";
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToISAd;
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToRvAd;
    private boolean mDidInitSdk = false;
    private String mUserAgeGroup;
    private String mUserGender;
    private String mMediationSegment;
    private Context mContext;

    public static IronSourceAdapter startAdapter(String providerName) {
        return new IronSourceAdapter(providerName);
    }

    private IronSourceAdapter(String providerName) {
        super(providerName);
        this.log(providerName + ": new instance");
        this.mDemandSourceToISAd = new ConcurrentHashMap();
        this.mDemandSourceToRvAd = new ConcurrentHashMap();
        this.mUserAgeGroup = null;
        this.mUserGender = null;
        this.mMediationSegment = null;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onPause(Activity activity) {
        IronSourceNetwork.onPause(activity);
    }

    @Override
    public void onResume(Activity activity) {
        IronSourceNetwork.onResume(activity);
    }

    @Override
    protected void setConsent(boolean consent) {
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("gdprConsentStatus", (Object)String.valueOf(consent));
        }
        catch (JSONException e2) {
            this.logError("setConsent exception " + e2.getMessage());
            return;
        }
        IronSourceNetwork.updateConsentInfo(consentParams);
    }

    @Override
    public void setAge(int age) {
        this.mUserAgeGroup = age >= 13 && age <= 17 ? "1" : (age >= 18 && age <= 20 ? "2" : (age >= 21 && age <= 24 ? "3" : (age >= 25 && age <= 34 ? "4" : (age >= 35 && age <= 44 ? "5" : (age >= 45 && age <= 54 ? "6" : (age >= 55 && age <= 64 ? "7" : (age > 65 && age <= 120 ? "8" : "0")))))));
    }

    @Override
    public void setGender(String gender) {
        this.mUserGender = gender;
    }

    @Override
    public void setMediationSegment(String segment) {
        this.mMediationSegment = segment;
    }

    private HashMap<String, String> getInitParams() {
        String pluginType;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.mUserAgeGroup)) {
            params.put("applicationUserAgeGroup", this.mUserAgeGroup);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserGender)) {
            params.put("applicationUserGender", this.mUserGender);
        }
        if (!TextUtils.isEmpty((CharSequence)(pluginType = this.getPluginType()))) {
            params.put("SDKPluginType", pluginType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediationSegment)) {
            params.put("custom_Segment", this.mMediationSegment);
        }
        return params;
    }

    @Override
    public void preInitInterstitial(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        this.log(config, "preInitInterstitial");
        this.initSDK(activity, appKey, userId, config);
    }

    @Override
    public synchronized Map<String, Object> getIsBiddingData(JSONObject config) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(this.mContext);
        if (token != null) {
            ret.put("token", token);
        } else {
            this.logError("IS bidding token is null");
            ret.put("token", "");
        }
        return ret;
    }

    @Override
    public void initInterstitialForBidding(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        this.log(config, "initInterstitialForBidding");
        this.initSDK(activity, appKey, userId, config);
        String demandSourceName = this.getDemandSourceName(config);
        IronSourceAdInstance adInstance = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceInterstitialListener(listener, demandSourceName)).setInAppBidding().build();
        this.mDemandSourceToISAd.put(demandSourceName, adInstance);
        listener.onInterstitialInitSuccess();
    }

    @Override
    public void initInterstitial(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        this.log(config, "initInterstitial");
        this.initSDK(activity, appKey, userId, config);
        String demandSourceName = this.getDemandSourceName(config);
        IronSourceAdInstance adInstance = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceInterstitialListener(listener, demandSourceName)).build();
        this.mDemandSourceToISAd.put(demandSourceName, adInstance);
        listener.onInterstitialInitSuccess();
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener, String serverData) {
        this.log(config, "loadInterstitial");
        try {
            HashMap<String, String> loadConfig = new HashMap<String, String>();
            loadConfig.put("adm", serverData);
            IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
            IronSourceNetwork.loadAd(adInstance, loadConfig);
        }
        catch (Exception e2) {
            this.logError("loadInterstitial for bidding exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        this.log(config, "loadInterstitial");
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
            IronSourceNetwork.loadAd(adInstance);
        }
        catch (Exception e2) {
            this.logError("loadInterstitial exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        this.log(config, "showInterstitial");
        try {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
            HashMap<String, String> showParams = new HashMap<String, String>();
            showParams.put("sessionDepth", String.valueOf(sessionDepth));
            IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
            IronSourceNetwork.showAd(adInstance, showParams);
        }
        catch (Exception e2) {
            this.logError("showInterstitial exception " + e2.getMessage());
            listener.onInterstitialAdShowFailed(new IronSourceError(1001, e2.getMessage()));
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    @Override
    public synchronized Map<String, Object> getRvBiddingData(JSONObject config) {
        HashMap<String, Object> biddingData = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(this.mContext);
        if (token != null) {
            biddingData.put("token", token);
        } else {
            this.logError("RV bidding token is null");
            biddingData.put("token", "");
        }
        return biddingData;
    }

    @Override
    public void initRvForBidding(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        this.log(config, "initRvForBidding");
        this.initSDK(activity, appKey, userId, config);
        String demandSourceName = this.getDemandSourceName(config);
        IronSourceAdInstance adInstance = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceRewardedVideoListener(listener, demandSourceName)).setInAppBidding().setRewarded().build();
        this.mDemandSourceToRvAd.put(demandSourceName, adInstance);
    }

    @Override
    public void initRvForDemandOnly(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        this.log(config, "initRvForDemandOnly");
        this.initSDK(activity, appKey, userId, config);
        String demandSourceName = this.getDemandSourceName(config);
        IronSourceAdInstance adInstance = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceRewardedVideoListener(listener, demandSourceName, true)).setRewarded().build();
        this.mDemandSourceToRvAd.put(demandSourceName, adInstance);
    }

    @Override
    public void initRewardedVideo(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        this.log(config, "initRewardedVideo");
        this.initSDK(activity, appKey, userId, config);
        String demandSourceName = this.getDemandSourceName(config);
        IronSourceAdInstance adInstance = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceRewardedVideoListener(listener, demandSourceName)).setRewarded().build();
        this.mDemandSourceToRvAd.put(demandSourceName, adInstance);
        this.fetchRewardedVideo(config);
    }

    @Override
    public void fetchRewardedVideo(JSONObject config) {
        block3: {
            this.log(config, "fetchRewardedVideo");
            IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
            if (adInstance == null) {
                this.logError("fetchRewardedVideo exception: null adInstance ");
                return;
            }
            try {
                IronSourceNetwork.loadAd(adInstance);
            }
            catch (Exception e2) {
                this.logError("fetchRewardedVideo exception " + e2.getMessage());
                OnInterstitialListener listener = adInstance.getAdListener();
                if (listener == null) break block3;
                listener.onInterstitialLoadFailed("fetch exception");
            }
        }
    }

    @Override
    public void loadVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener) {
        this.log(config, "loadVideoForDemandOnly");
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
            IronSourceNetwork.loadAd(adInstance);
        }
        catch (Exception e2) {
            this.logError("loadVideoForDemandOnly exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadVideo(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
        this.log(config, "loadVideo (RV in bidding mode)");
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
            IronSourceNetwork.loadAd(adInstance);
        }
        catch (Exception e2) {
            this.logError("loadVideo exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        this.log(config, "showRewardedVideo");
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
            HashMap<String, String> showParams = new HashMap<String, String>();
            showParams.put("sessionDepth", String.valueOf(sessionDepth));
            IronSourceNetwork.showAd(adInstance, showParams);
        }
        catch (Exception e2) {
            this.logError("showRewardedVideo exception " + e2.getMessage());
            listener.onRewardedVideoAdShowFailed(new IronSourceError(1003, e2.getMessage()));
        }
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    private synchronized void initSDK(Activity activity, String appKey, String userId, JSONObject config) {
        if (!this.mDidInitSdk) {
            this.mDidInitSdk = true;
            if (this.isAdaptersDebugEnabled()) {
                SDKUtils.setDebugMode(3);
            } else {
                SDKUtils.setDebugMode(config.optInt("debugMode", 0));
            }
            SDKUtils.setControllerUrl(config.optString("controllerUrl"));
            SDKUtils.setControllerConfig(config.optString("controllerConfig", ""));
            this.mContext = activity.getApplicationContext();
            IronSourceNetwork.initSDK(activity, appKey, userId, this.getInitParams());
        }
    }

    private String getDemandSourceName(JSONObject config) {
        if (!TextUtils.isEmpty((CharSequence)config.optString("demandSourceName"))) {
            return config.optString("demandSourceName");
        }
        return this.getProviderName();
    }

    private void logError(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IronSourceAdapter: " + text, 3);
    }

    private void log(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IronSourceAdapter: " + text, 0);
    }

    private void log(JSONObject config, String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IronSourceAdapter " + this.getDemandSourceName(config) + ": " + text, 0);
    }

    private class IronSourceRewardedVideoListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        RewardedVideoSmashListener mListener;
        boolean mIsRvDemandOnly;

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = false;
        }

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName, boolean isDemandOnly) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = isDemandOnly;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialInitSuccess");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialInitFailed");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialLoadSuccess");
            if (this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoLoadSuccess();
            } else {
                this.mListener.onRewardedVideoAvailabilityChanged(true);
            }
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialLoadFailed " + description);
            if (this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoLoadFailed(ErrorBuilder.buildLoadFailedError(description));
            } else {
                this.mListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        @Override
        public void onInterstitialOpen() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialOpen");
            this.mListener.onRewardedVideoAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialAdRewarded demandSourceId=" + demandSourceId + " amount=" + amount);
            this.mListener.onRewardedVideoAdRewarded();
        }

        @Override
        public void onInterstitialClose() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialClose");
            this.mListener.onRewardedVideoAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialShowSuccess");
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronSourceAdapter.this.log("rewardedVideoListener onInterstitialShowSuccess " + description);
            this.mListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildShowFailedError("Rewarded Video", description));
        }

        @Override
        public void onInterstitialClick() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialClick");
            this.mListener.onRewardedVideoAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " rewardedVideoListener onInterstitialEventNotificationReceived eventName=" + eventName);
            this.mListener.onRewardedVideoAdVisible();
        }
    }

    private class IronSourceInterstitialListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        private InterstitialSmashListener mListener;

        IronSourceInterstitialListener(InterstitialSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialInitSuccess");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialInitFailed");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialLoadSuccess");
            this.mListener.onInterstitialAdReady();
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialLoadFailed " + description);
            this.mListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
        }

        @Override
        public void onInterstitialOpen() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialOpen");
            this.mListener.onInterstitialAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialAdRewarded demandSourceId=" + demandSourceId + " amount=" + amount);
        }

        @Override
        public void onInterstitialClose() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialClose");
            this.mListener.onInterstitialAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialShowSuccess");
            this.mListener.onInterstitialAdShowSucceeded();
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialShowFailed " + description);
            this.mListener.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", description));
        }

        @Override
        public void onInterstitialClick() {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialClick");
            this.mListener.onInterstitialAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronSourceAdapter.this.log(this.mDemandSourceName + " interstitialListener onInterstitialEventNotificationReceived eventName=" + eventName);
            this.mListener.onInterstitialAdVisible();
        }
    }
}

