/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import com.ironsource.sdk.controller.IronSourceWebView;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.service.TokenService;
import com.ironsource.sdk.utils.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenJSAdapter {
    private static final String TAG = TokenJSAdapter.class.getSimpleName();
    private static final String UPDATE_TOKEN = "updateToken";
    private static final String functionName = "functionName";
    private static final String functionParams = "functionParams";
    private static final String success = "success";
    private static final String fail = "fail";
    private TokenService mTokenService;

    public TokenJSAdapter(TokenService tokenService) {
        this.mTokenService = tokenService;
    }

    private FunctionCall fetchFunctionCall(String params) throws JSONException {
        JSONObject functionData = new JSONObject(params);
        FunctionCall res = new FunctionCall();
        res.name = functionData.optString(functionName);
        res.params = functionData.optJSONObject(functionParams);
        res.successCallback = functionData.optString(success);
        res.failureCallback = functionData.optString(fail);
        return res;
    }

    void call(String params, IronSourceWebView.JSInterface.JSCallbackTask callback) throws Exception {
        FunctionCall fCall = this.fetchFunctionCall(params);
        if (UPDATE_TOKEN.equals(fCall.name)) {
            this.updateToken(fCall.params, fCall, callback);
        } else {
            Logger.i(TAG, "TokenJSAdapter unhandled API request " + params);
        }
    }

    public void updateToken(JSONObject value, FunctionCall fCall, IronSourceWebView.JSInterface.JSCallbackTask callback) {
        SSAObj result = new SSAObj();
        try {
            this.mTokenService.updateData(value);
            callback.sendMessage(true, fCall.successCallback, result);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Logger.i(TAG, "TokenJSAdapter UPDATE_TOKEN JSON Exception when getting parameter " + e2.getMessage());
            callback.sendMessage(false, fCall.failureCallback, result);
        }
    }

    private static class FunctionCall {
        String name;
        JSONObject params;
        String successCallback;
        String failureCallback;

        private FunctionCall() {
        }
    }
}

