/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class ProgRvSmash
extends ProgSmash
implements RewardedVideoSmashListener {
    private SMASH_STATE mState = SMASH_STATE.NO_INIT;
    private ProgRvManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private Activity mActivity;
    private String mAppKey;
    private String mUserId;
    private String mServerDataToLoad;
    private boolean mShouldLoadAfterClose;
    private boolean mShouldLoadAfterLoad;
    private boolean mIsShowCandidate;
    private Placement mCurrentPlacement;
    private long mLoadStartTime;
    private String mCurrentAuctionId;
    private String mAuctionIdToLoad;

    public ProgRvSmash(Activity activity, String appKey, String userId, ProviderSettings settings, ProgRvManagerListener listener, int loadTimeoutSecs, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getRewardedVideoSettings()), adapter);
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeoutSecs;
        this.mAdapter.addRewardedVideoListener(this);
        this.mShouldLoadAfterClose = false;
        this.mShouldLoadAfterLoad = false;
        this.mIsShowCandidate = false;
        this.mCurrentPlacement = null;
        this.mServerDataToLoad = "";
        this.mCurrentAuctionId = "";
        this.mAuctionIdToLoad = "";
    }

    public synchronized boolean isReadyToBid() {
        return this.mState != SMASH_STATE.NO_INIT && this.mState != SMASH_STATE.INIT_IN_PROGRESS;
    }

    public synchronized boolean isLoadingInProgress() {
        return this.mState == SMASH_STATE.INIT_IN_PROGRESS || this.mState == SMASH_STATE.LOAD_IN_PROGRESS;
    }

    public synchronized Map<String, Object> getBiddingData() {
        return this.isBidder() ? this.mAdapter.getRvBiddingData(this.mAdUnitSettings) : null;
    }

    public synchronized void initForBidding() {
        this.logInternal("initForBidding()");
        this.setState(SMASH_STATE.INIT_IN_PROGRESS);
        this.setCustomParams();
        this.mAdapter.initRvForBidding(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
    }

    public synchronized void unloadVideo() {
        if (this.isBidder()) {
            this.mIsShowCandidate = false;
        }
    }

    public synchronized boolean isReadyToShow() {
        if (this.isBidder()) {
            return this.mIsShowCandidate && this.mState == SMASH_STATE.LOADED && this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
        }
        return this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
    }

    public synchronized void loadVideo(String serverData, String auctionId) {
        this.logInternal("loadVideo() auctionId: " + auctionId + " state: " + (Object)((Object)this.mState));
        this.setIsLoadCandidate(false);
        this.mIsShowCandidate = true;
        if (this.mState == SMASH_STATE.LOAD_IN_PROGRESS) {
            this.mShouldLoadAfterLoad = true;
            this.mAuctionIdToLoad = auctionId;
            this.mServerDataToLoad = serverData;
            this.mListener.onLoadError(this, auctionId);
            return;
        }
        if (this.mState == SMASH_STATE.SHOW_IN_PROGRESS) {
            this.mShouldLoadAfterClose = true;
            this.mAuctionIdToLoad = auctionId;
            this.mServerDataToLoad = serverData;
            return;
        }
        this.mCurrentAuctionId = auctionId;
        this.startLoadTimer();
        this.mLoadStartTime = new Date().getTime();
        this.sendProviderEvent(1001);
        if (this.isBidder()) {
            this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
            this.mAdapter.loadVideo(this.mAdUnitSettings, this, serverData);
            return;
        }
        if (this.mState == SMASH_STATE.NO_INIT) {
            this.setCustomParams();
            this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
            this.mAdapter.initRewardedVideo(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
            return;
        }
        this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
        this.mAdapter.fetchRewardedVideo(this.mAdUnitSettings);
    }

    public synchronized void reportShowChance(boolean status) {
        this.sendProviderEventWithPlacement(1209, new Object[][]{{"status", status ? "true" : "false"}});
    }

    public synchronized void showVideo(Placement placement) {
        this.logInternal("showVideo()");
        this.mCurrentPlacement = placement;
        this.setState(SMASH_STATE.SHOW_IN_PROGRESS);
        this.mAdapter.showRewardedVideo(this.mAdUnitSettings, this);
        this.sendProviderEventWithPlacement(1201);
    }

    public synchronized void setCappedPerSession() {
        this.mAdapter.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, "rewardedvideo");
        this.sendProviderEvent(1401);
    }

    private void setState(SMASH_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        this.mState = state;
    }

    private void setCustomParams() {
        try {
            Boolean consent;
            String pluginType;
            String segment;
            String gender;
            Integer age = IronSourceObject.getInstance().getAge();
            if (age != null) {
                this.mAdapter.setAge(age);
            }
            if (!TextUtils.isEmpty((CharSequence)(gender = IronSourceObject.getInstance().getGender()))) {
                this.mAdapter.setGender(gender);
            }
            if (!TextUtils.isEmpty((CharSequence)(segment = IronSourceObject.getInstance().getMediationSegment()))) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
            if ((consent = IronSourceObject.getInstance().getConsent()) != null) {
                this.logInternal("setConsent(" + consent + ")");
                this.mAdapter.setConsent(consent);
            }
        }
        catch (Exception e2) {
            this.logInternal("setCustomParams() " + e2.getMessage());
        }
    }

    @Override
    public synchronized void onRewardedVideoAvailabilityChanged(boolean available) {
        this.stopLoadTimer();
        this.logAdapterCallback("onRewardedVideoAvailabilityChanged available=" + available + " state=" + this.mState.name());
        if (this.mState != SMASH_STATE.LOAD_IN_PROGRESS) {
            this.sendProviderEvent(available ? 1207 : 1208);
            return;
        }
        this.setState(available ? SMASH_STATE.LOADED : SMASH_STATE.NOT_LOADED);
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.sendProviderEvent(available ? 1002 : 1200, new Object[][]{{"duration", elapsedTime}});
        if (this.mShouldLoadAfterLoad) {
            this.mShouldLoadAfterLoad = false;
            this.logInternal("onRewardedVideoAvailabilityChanged to " + available + "and mShouldLoadAfterLoad is true - calling loadVideo");
            this.loadVideo(this.mServerDataToLoad, this.mAuctionIdToLoad);
            return;
        }
        if (available) {
            this.mListener.onLoadSuccess(this, this.mCurrentAuctionId);
        } else {
            this.mListener.onLoadError(this, this.mCurrentAuctionId);
        }
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
    }

    @Override
    public synchronized void onRewardedVideoAdShowFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
        String errorReason = error.getErrorMessage().substring(0, Math.min(error.getErrorMessage().length(), 39));
        this.sendProviderEventWithPlacement(1202, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", errorReason}});
        if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
            return;
        }
        this.setState(SMASH_STATE.NOT_LOADED);
        this.mListener.onRewardedVideoAdShowFailed(error, this);
    }

    @Override
    public synchronized void onRewardedVideoInitSuccess() {
        this.logAdapterCallback("onRewardedVideoInitSuccess");
        if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
            return;
        }
        this.setState(SMASH_STATE.NOT_LOADED);
    }

    @Override
    public synchronized void onRewardedVideoInitFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoInitFailed error=" + error.getErrorMessage());
        this.stopLoadTimer();
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.sendProviderEvent(1200, new Object[][]{{"errorCode", 1033}, {"duration", elapsedTime}});
        if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
            return;
        }
        this.setState(SMASH_STATE.NO_INIT);
        this.mListener.onLoadError(this, this.mCurrentAuctionId);
    }

    @Override
    public synchronized void onRewardedVideoAdOpened() {
        this.logAdapterCallback("onRewardedVideoAdOpened");
        this.mListener.onRewardedVideoAdOpened(this);
        this.sendProviderEventWithPlacement(1005);
    }

    @Override
    public synchronized void onRewardedVideoAdStarted() {
        this.logAdapterCallback("onRewardedVideoAdStarted");
        this.mListener.onRewardedVideoAdStarted(this);
        this.sendProviderEventWithPlacement(1204);
    }

    @Override
    public synchronized void onRewardedVideoAdVisible() {
        this.logAdapterCallback("onRewardedVideoAdVisible");
        this.sendProviderEventWithPlacement(1206);
    }

    @Override
    public synchronized void onRewardedVideoAdClosed() {
        this.logAdapterCallback("onRewardedVideoAdClosed");
        this.sendProviderEventWithPlacement(1203);
        if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
            return;
        }
        this.setState(SMASH_STATE.NOT_LOADED);
        this.mListener.onRewardedVideoAdClosed(this);
        if (this.mShouldLoadAfterClose) {
            this.logInternal("onRewardedVideoAdClosed and mShouldLoadAfterClose is true - calling loadVideo");
            this.mShouldLoadAfterClose = false;
            this.loadVideo(this.mServerDataToLoad, this.mAuctionIdToLoad);
            this.mServerDataToLoad = "";
            this.mAuctionIdToLoad = "";
        }
    }

    @Override
    public synchronized void onRewardedVideoAdEnded() {
        this.logAdapterCallback("onRewardedVideoAdEnded");
        this.mListener.onRewardedVideoAdEnded(this);
        this.sendProviderEventWithPlacement(1205);
    }

    @Override
    public synchronized void onRewardedVideoAdRewarded() {
        this.logAdapterCallback("onRewardedVideoAdRewarded");
        this.mListener.onRewardedVideoAdRewarded(this, this.mCurrentPlacement);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"placement", this.mCurrentPlacement.getPlacementName()});
        data.add(new Object[]{"rewardName", this.mCurrentPlacement.getRewardName()});
        data.add(new Object[]{"rewardAmount", this.mCurrentPlacement.getRewardAmount()});
        String transId = Long.toString(new Date().getTime()) + this.mAppKey + this.getInstanceName();
        data.add(new Object[]{"transId", IronSourceUtils.getTransId(transId)});
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
            data.add(new Object[]{"dynamicUserId", IronSourceObject.getInstance().getDynamicUserId()});
        }
        if (IronSourceObject.getInstance().getRvServerParams() != null) {
            for (String key : IronSourceObject.getInstance().getRvServerParams().keySet()) {
                data.add(new Object[]{"custom_" + key, IronSourceObject.getInstance().getRvServerParams().get(key)});
            }
        }
        this.sendProviderEvent(1010, (Object[][])data.toArray((T[])new Object[2][data.size()]));
    }

    @Override
    public synchronized void onRewardedVideoAdClicked() {
        this.logAdapterCallback("onRewardedVideoAdClicked");
        this.mListener.onRewardedVideoAdClicked(this, this.mCurrentPlacement);
        this.sendProviderEventWithPlacement(1006);
    }

    private void stopLoadTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void startLoadTimer() {
        this.stopLoadTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ProgRvSmash.this.logInternal("Rewarded Video - load instance time out");
                long elapsedTime = new Date().getTime() - ProgRvSmash.this.mLoadStartTime;
                if (ProgRvSmash.this.mState == SMASH_STATE.LOAD_IN_PROGRESS) {
                    ProgRvSmash.this.sendProviderEvent(1200, new Object[][]{{"errorCode", 1025}, {"duration", elapsedTime}});
                    ProgRvSmash.this.setState(SMASH_STATE.NOT_LOADED);
                    ProgRvSmash.this.mListener.onLoadError(ProgRvSmash.this, ProgRvSmash.this.mCurrentAuctionId);
                } else if (ProgRvSmash.this.mState == SMASH_STATE.INIT_IN_PROGRESS) {
                    ProgRvSmash.this.sendProviderEvent(1200, new Object[][]{{"errorCode", 1032}, {"duration", elapsedTime}});
                    ProgRvSmash.this.setState(SMASH_STATE.NOT_LOADED);
                    ProgRvSmash.this.mListener.onLoadError(ProgRvSmash.this, ProgRvSmash.this.mCurrentAuctionId);
                } else {
                    ProgRvSmash.this.sendProviderEvent(1208);
                    ProgRvSmash.this.setState(SMASH_STATE.NOT_LOADED);
                }
            }
        }, this.mLoadTimeoutSecs * 1000);
    }

    private void logAdapterCallback(String line) {
        String text = this.getInstanceName() + " smash: " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = this.getInstanceName() + " smash: " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void sendProviderEventWithPlacement(int eventId) {
        this.sendProviderEventWithPlacement(eventId, null);
    }

    private void sendProviderEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, true);
    }

    private void sendProviderEvent(int eventId) {
        this.sendProviderEvent(eventId, null, false);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, false);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        Map<String, Object> data = this.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && this.mCurrentPlacement != null && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement.getPlacementName())) {
            data.put("placement", this.mCurrentPlacement.getPlacementName());
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getInstanceName() + " smash: RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    protected static enum SMASH_STATE {
        NO_INIT,
        INIT_IN_PROGRESS,
        NOT_LOADED,
        LOAD_IN_PROGRESS,
        LOADED,
        SHOW_IN_PROGRESS;

    }
}

