/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class DemandOnlySmash {
    protected AbstractAdapter mAdapter;
    protected AdapterConfig mAdapterConfig;
    protected JSONObject mAdUnitSettings;

    public DemandOnlySmash(AdapterConfig adapterConfig, AbstractAdapter adapter) {
        this.mAdapterConfig = adapterConfig;
        this.mAdapter = adapter;
        this.mAdUnitSettings = adapterConfig.getAdUnitSetings();
    }

    public synchronized void onResume(Activity activity) {
        this.mAdapter.onResume(activity);
    }

    public synchronized void onPause(Activity activity) {
        this.mAdapter.onPause(activity);
    }

    public synchronized void setConsent(boolean consent) {
        this.mAdapter.setConsent(consent);
    }

    public synchronized String getInstanceName() {
        return this.mAdapterConfig.getProviderName();
    }

    public synchronized String getSubProviderId() {
        return this.mAdapterConfig.getSubProviderId();
    }

    public Map<String, Object> getProviderEventData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            data.put("providerAdapterVersion", this.mAdapter != null ? this.mAdapter.getVersion() : "");
            data.put("providerSDKVersion", this.mAdapter != null ? this.mAdapter.getCoreSDKVersion() : "");
            data.put("spId", this.mAdapterConfig.getSubProviderId());
            data.put("provider", this.mAdapterConfig.getAdSourceNameForEvents());
            data.put("isDemandOnly", 1);
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "getProviderEventData " + this.getInstanceName() + ")", e2);
        }
        return data;
    }

    protected static enum SMASH_STATE {
        NOT_LOADED,
        LOAD_IN_PROGRESS,
        LOADED,
        SHOW_IN_PROGRESS;

    }
}

