/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.DemandOnlySmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.DemandOnlyRvManagerListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class DemandOnlyRvSmash
extends DemandOnlySmash
implements RewardedVideoSmashListener {
    private DemandOnlyRvManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private long mLoadStartTime;
    private DemandOnlySmash.SMASH_STATE mState;

    DemandOnlyRvSmash(Activity activity, String appKey, String userId, ProviderSettings settings, DemandOnlyRvManagerListener listener, int loadTimeout, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getInterstitialSettings()), adapter);
        this.mAdapterConfig = new AdapterConfig(settings, settings.getRewardedVideoSettings());
        this.mAdUnitSettings = this.mAdapterConfig.getAdUnitSetings();
        this.mAdapter = adapter;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeout;
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        this.mAdapter.initRvForDemandOnly(activity, appKey, userId, this.mAdUnitSettings, this);
    }

    public void loadRewardedVideo() {
        this.logInternal("loadRewardedVideo state=" + this.mState.name());
        if (this.mState == DemandOnlySmash.SMASH_STATE.NOT_LOADED || this.mState == DemandOnlySmash.SMASH_STATE.LOADED) {
            this.mState = DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS;
            this.startTimer();
            this.mLoadStartTime = new Date().getTime();
            this.mAdapter.loadVideoForDemandOnly(this.mAdUnitSettings, this);
        } else if (this.mState == DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            IronSourceError error = new IronSourceError(1053, "load already in progress");
            this.mListener.onRewardedVideoAdLoadFailed(error, this, 0L);
        } else {
            IronSourceError error = new IronSourceError(1053, "cannot load because show is in progress");
            this.mListener.onRewardedVideoAdLoadFailed(error, this, 0L);
        }
    }

    public void showRewardedVideo() {
        this.logInternal("showRewardedVideo state=" + this.mState.name());
        if (this.mState == DemandOnlySmash.SMASH_STATE.LOADED) {
            this.mState = DemandOnlySmash.SMASH_STATE.SHOW_IN_PROGRESS;
            this.mAdapter.showRewardedVideo(this.mAdUnitSettings, this);
        } else {
            IronSourceError error = new IronSourceError(1054, "load must be called before show");
            this.mListener.onRewardedVideoAdShowFailed(error, this);
        }
    }

    public boolean isRewardedVideoAvailable() {
        return this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
    }

    private void stopTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void startTimer() {
        this.logInternal("start timer");
        this.stopTimer();
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DemandOnlyRvSmash.this.logInternal("load timed out state=" + DemandOnlyRvSmash.this.mState.toString());
                if (DemandOnlyRvSmash.this.mState == DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
                    DemandOnlyRvSmash.this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
                    long elapsedTime = new Date().getTime() - DemandOnlyRvSmash.this.mLoadStartTime;
                    DemandOnlyRvSmash.this.mListener.onRewardedVideoAdLoadFailed(new IronSourceError(1055, "load timed out"), DemandOnlyRvSmash.this, elapsedTime);
                }
            }
        }, this.mLoadTimeoutSecs * 1000);
    }

    @Override
    public void onRewardedVideoInitSuccess() {
    }

    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
        this.logAdapterCallback("onRewardedVideoLoadSuccess state=" + this.mState.name());
        this.stopTimer();
        if (this.mState != DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            return;
        }
        this.mState = DemandOnlySmash.SMASH_STATE.LOADED;
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.mListener.onRewardedVideoLoadSuccess(this, elapsedTime);
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoLoadFailed error=" + error.getErrorMessage() + " state=" + this.mState.name());
        this.stopTimer();
        if (this.mState != DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            return;
        }
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        long elapsedTime = new Date().getTime() - this.mLoadStartTime;
        this.mListener.onRewardedVideoAdLoadFailed(error, this, elapsedTime);
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.logAdapterCallback("onRewardedVideoAdOpened");
        this.mListener.onRewardedVideoAdOpened(this);
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        this.logAdapterCallback("onRewardedVideoAdClosed");
        this.mListener.onRewardedVideoAdClosed(this);
    }

    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
    }

    @Override
    public void onRewardedVideoAdStarted() {
    }

    @Override
    public void onRewardedVideoAdEnded() {
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        this.mState = DemandOnlySmash.SMASH_STATE.NOT_LOADED;
        this.logAdapterCallback("onRewardedVideoAdClosed error=" + error);
        this.mListener.onRewardedVideoAdShowFailed(error, this);
    }

    @Override
    public void onRewardedVideoAdClicked() {
        this.logAdapterCallback("onRewardedVideoAdClicked");
        this.mListener.onRewardedVideoAdClicked(this);
    }

    @Override
    public void onRewardedVideoAdVisible() {
        this.logAdapterCallback("onRewardedVideoAdVisible");
        this.mListener.onRewardedVideoAdVisible(this);
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        this.logAdapterCallback("onRewardedVideoAdRewarded");
        this.mListener.onRewardedVideoAdRewarded(this);
    }

    private void logAdapterCallback(String line) {
        String text = "DemandOnlyRewardedVideoSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "DemandOnlyRewardedVideoSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

