/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.os.Handler;
import android.os.Looper;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;

public class BannerCallbackThrottler {
    private static BannerCallbackThrottler sInstance;
    private long mLastInvoked = 0L;
    private boolean mIsWaitingForInvocation = false;
    private int mBNDelayLoadFailureNotificationInSeconds;

    public static synchronized BannerCallbackThrottler getInstance() {
        if (sInstance == null) {
            sInstance = new BannerCallbackThrottler();
        }
        return sInstance;
    }

    private BannerCallbackThrottler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBannerAdLoadFailed(final IronSourceBannerLayout banner, final IronSourceError error) {
        BannerCallbackThrottler bannerCallbackThrottler = this;
        synchronized (bannerCallbackThrottler) {
            if (this.mIsWaitingForInvocation) {
                return;
            }
            long timeSinceLastCallMs = System.currentTimeMillis() - this.mLastInvoked;
            if (timeSinceLastCallMs > (long)(this.mBNDelayLoadFailureNotificationInSeconds * 1000)) {
                this.invokeCallback(banner, error);
                return;
            }
            this.mIsWaitingForInvocation = true;
            long nextCallMs = (long)(this.mBNDelayLoadFailureNotificationInSeconds * 1000) - timeSinceLastCallMs;
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    BannerCallbackThrottler.this.invokeCallback(banner, error);
                }
            }, nextCallMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingInvocation() {
        BannerCallbackThrottler bannerCallbackThrottler = this;
        synchronized (bannerCallbackThrottler) {
            return this.mIsWaitingForInvocation;
        }
    }

    private void invokeCallback(IronSourceBannerLayout banner, IronSourceError error) {
        this.mLastInvoked = System.currentTimeMillis();
        this.mIsWaitingForInvocation = false;
        banner.sendBannerAdLoadFailed(error);
    }

    public void setDelayLoadFailureNotificationInSeconds(int delay) {
        this.mBNDelayLoadFailureNotificationInSeconds = delay;
    }
}

